/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.usages;

import java.io.Closeable;
import java.io.IOException;
import java.net.ProxySelector;
import oracle.dbtools.util.Logger;
import oracle.ide.webbrowser.ProxyOptions;
import oracle.ideimpl.webbrowser.IdeProxySelector;
import org.apache.hc.client5.http.ClientProtocolException;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.classic.methods.HttpUriRequest;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.impl.routing.SystemDefaultRoutePlanner;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.routing.HttpRoutePlanner;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.apache.hc.core5.http.io.SocketConfig;
import org.apache.hc.core5.util.Timeout;

class UsageClient
implements Closeable {
    private CloseableHttpClient mHttpClient;

    static UsageClient createClient() {
        Object object;
        SocketConfig socketConfig = SocketConfig.custom().setSoTimeout(Timeout.ofMilliseconds((long)30000L)).build();
        PoolingHttpClientConnectionManager poolingHttpClientConnectionManager = PoolingHttpClientConnectionManagerBuilder.create().setDefaultSocketConfig(socketConfig).build();
        HttpClientBuilder httpClientBuilder = HttpClients.custom();
        httpClientBuilder.setConnectionManager((HttpClientConnectionManager)poolingHttpClientConnectionManager);
        httpClientBuilder.setUserAgent("SQL Developer Usage Tracker");
        IdeProxySelector ideProxySelector = new IdeProxySelector(ProxySelector.getDefault());
        SystemDefaultRoutePlanner systemDefaultRoutePlanner = new SystemDefaultRoutePlanner((ProxySelector)ideProxySelector);
        httpClientBuilder.setRoutePlanner((HttpRoutePlanner)systemDefaultRoutePlanner);
        ProxyOptions proxyOptions = ProxyOptions.getProxyOptions();
        if (proxyOptions.getUseProxy().booleanValue() && proxyOptions.getUseProxyAuthentication().booleanValue()) {
            object = proxyOptions.getProxyHost();
            Integer n = Integer.valueOf(proxyOptions.getProxyPort());
            String string = proxyOptions.getProxyUserName();
            char[] cArray = proxyOptions.getProxyPassword();
            BasicCredentialsProvider basicCredentialsProvider = new BasicCredentialsProvider();
            basicCredentialsProvider.setCredentials(new AuthScope((String)object, n.intValue()), (Credentials)new UsernamePasswordCredentials(string, cArray));
            httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)basicCredentialsProvider);
        }
        object = httpClientBuilder.build();
        return new UsageClient((CloseableHttpClient)object);
    }

    private UsageClient(CloseableHttpClient closeableHttpClient) {
        this.mHttpClient = closeableHttpClient;
    }

    public CloseableHttpResponse executeRequest(HttpUriRequestBase httpUriRequestBase) throws ClientProtocolException, IOException {
        return this.mHttpClient.execute((ClassicHttpRequest)httpUriRequestBase);
    }

    public <T> T executeRequest(HttpUriRequest httpUriRequest, HttpClientResponseHandler<? extends T> httpClientResponseHandler) throws ClientProtocolException, IOException {
        return (T)this.mHttpClient.execute((ClassicHttpRequest)httpUriRequest, httpClientResponseHandler);
    }

    @Override
    public void close() {
        if (this.mHttpClient == null) {
            Logger.warn(UsageClient.class, (String)"Attempt to close already closed HttpClient");
            return;
        }
        try {
            this.mHttpClient.close();
        }
        catch (IOException iOException) {
            Logger.severe(UsageClient.class, (String)"Unexpected error attempting to close HttpClient", (Throwable)iOException);
        }
        this.mHttpClient = null;
    }
}

