/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.peek;

import javax.swing.JComponent;
import javax.swing.text.BadLocationException;
import oracle.ide.hover.HoverFlavor;
import oracle.ide.peek.Peek;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.Utilities;
import oracle.javatools.ui.ghost.UIConstants;

public final class CodePeek
extends Peek {
    private BasicEditorPane ep = (BasicEditorPane)this.getContentComponent();

    public CodePeek(JComponent comp, String fileName) {
        this(comp, fileName, HoverFlavor.getFlavor((String)"source"));
    }

    public CodePeek(JComponent comp, String fileName, HoverFlavor hoverFlavor) {
        super(comp, (JComponent)new BasicEditorPane(), hoverFlavor);
        this.ep.setOpaque(true);
        this.ep.putClientProperty((Object)UIConstants.VETO_CONVERSION, (Object)Boolean.TRUE);
        if (fileName != null) {
            this.ep.setLanguageSupport(fileName);
        }
    }

    public void setText(String text) {
        text = Utilities.trimCommonWhitespace((String)text);
        this.ep.setEditable(true);
        try {
            if (this.ep.getDocument().getLength() > 0) {
                this.ep.getDocument().remove(0, this.ep.getDocument().getLength());
            }
            this.ep.getDocument().insertString(0, text, null);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        this.ep.setCaretPosition(0);
        this.ep.setEditable(false);
    }

    public BasicEditorPane getEditor() {
        return this.ep;
    }

    @Override
    public void hidePeek() {
        super.hidePeek();
        this.ep.dispose();
    }
}

