/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util;

import java.io.Serializable;

public class Range
implements Serializable {
    private static final long serialVersionUID = 1L;
    public int begin;
    public int end;

    public Range() {
        this.begin = 0;
        this.end = 0;
    }

    public Range(int begin, int end) {
        this.begin = begin;
        this.end = end;
    }

    public Range(Range range) {
        this.begin = range.begin;
        this.end = range.end;
    }

    public Object clone() {
        return new Range(this.begin, this.end);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Range)) {
            return false;
        }
        Range range = (Range)obj;
        return this.begin == range.begin && this.end == range.end;
    }

    public void setBounds(int begin, int end) {
        this.begin = begin;
        this.end = end;
    }

    public boolean contains(Range range) {
        return this.begin < range.begin && this.end > range.end;
    }

    public boolean contains(int intIndex) {
        return intIndex >= this.begin && intIndex <= this.end;
    }

    public int count() {
        return Math.abs(this.end - this.begin) + 1;
    }

    public String toString() {
        return "(" + this.begin + "," + this.end + ")";
    }
}

