/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.xml;

import java.util.Enumeration;
import java.util.Vector;
import oracle.dss.util.persistence.ObjectScope;
import oracle.dss.util.xml.BaseNode;
import oracle.dss.util.xml.NoSuchPropertyException;
import oracle.dss.util.xml.PropertyNode;
import oracle.javatools.annotations.Concealed;
import oracle.xml.parser.v2.XMLCDATA;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLText;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

@Concealed
public abstract class BaseObjectNode
extends BaseNode {
    private static final long serialVersionUID = 1L;
    protected boolean m_closed = false;

    BaseObjectNode(ObjectScope scope, Node node) {
        super(scope, node);
        this.m_name = ((Element)node).getTagName();
    }

    public BaseObjectNode(String name) {
        super(name);
    }

    @Override
    void initBuffer() {
        if (this.m_buffer == null) {
            this.m_buffer = new StringBuffer(150);
            this.m_buffer.append("<");
            this.m_buffer.append(this.m_name);
            if (this.m_post == null) {
                this.initPost();
            }
        }
    }

    void initPost() {
        if (this.m_post == null) {
            this.m_post = new StringBuffer("/>");
        }
    }

    public void addProperty(String name, String value) {
        this.addProperty(name, value, true);
    }

    public void addProperty(String name, String value, boolean attr) {
        this.initBuffer();
        if (attr) {
            if (value == null) {
                value = "";
            }
            this.m_buffer.append(" ");
            this.m_buffer.append(name);
            this.m_buffer.append("=\"");
            this.m_buffer.append(BaseObjectNode.createEscapes(value));
            this.m_buffer.append("\"");
        } else {
            String insertStr = new StringBuffer(20).append("<").append(name).append(">").append(BaseObjectNode.createEscapes(this.createCDATA(value))).append("</").append(name).append(">").toString();
            this.addChild(insertStr);
        }
    }

    public void addProperty(String name, boolean value, boolean attr) {
        this.addProperty(name, new Boolean(value).toString(), attr);
    }

    public void addProperty(String name, boolean value) {
        this.addProperty(name, value, true);
    }

    public void addProperty(String name, int value, boolean attr) {
        this.addProperty(name, new Integer(value).toString(), attr);
    }

    public void addProperty(String name, int value) {
        this.addProperty(name, value, true);
    }

    public void addProperty(String name, double value, boolean attr) {
        this.addProperty(name, new Double(value).toString(), attr);
    }

    public void addProperty(String name, double value) {
        this.addProperty(name, value, true);
    }

    public void addProperty(String name, long value, boolean attr) {
        this.addProperty(name, new Long(value).toString(), attr);
    }

    public void addProperty(String name, long value) {
        this.addProperty(name, value, true);
    }

    public void addProperty(String name, char value, boolean attr) {
        this.addProperty(name, new Character(value).toString(), attr);
    }

    public void addProperty(String name, char value) {
        this.addProperty(name, value, true);
    }

    public void addProperty(PropertyNode propNode) {
        this.addChild(propNode);
    }

    protected void addChild(Object child) {
        this.initVector();
        if (!this.m_closed) {
            this.initPost();
            this.m_post.append(this.m_name).append(">");
            this.m_post.setCharAt(0, '<');
            this.m_post.setCharAt(1, '/');
            this.m_nodes.addElement(child);
            this.m_closed = true;
        } else {
            this.m_nodes.addElement(child);
        }
    }

    public PropertyNode getProperty(String name) {
        Node _node = this.getPropertyValue(name);
        if (_node == null) {
            return null;
        }
        return new PropertyNode(this.m_scope, _node);
    }

    protected Node getPropertyValue(String name, boolean elem) {
        return this.getPropertyValue(name);
    }

    protected Node getPropertyValue(String name) {
        Attr attr = this.getAttributeByName(name);
        if (attr == null) {
            Element elem = (Element)((XMLElement)this.m_node).getChildrenByTagName(name).item(0);
            if (elem == null) {
                return null;
            }
            return elem;
        }
        return attr;
    }

    public Enumeration getPropertyNames() {
        NamedNodeMap list = ((Element)this.m_node).getAttributes();
        Vector<String> _v = new Vector<String>(list.getLength());
        for (int i = 0; i < list.getLength(); ++i) {
            Node _node = list.item(i);
            _v.addElement(_node.getNodeName());
        }
        return _v.elements();
    }

    protected Element getFirstElement() {
        NodeList list = ((Element)this.m_node).getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node _node = list.item(i);
            if (!(_node instanceof Element)) continue;
            return (Element)_node;
        }
        return null;
    }

    public String getPropertyValueAsString(String name) throws NoSuchPropertyException {
        Node prop = this.getPropertyValue(name);
        if (prop != null) {
            if (prop instanceof Attr) {
                String value = ((Attr)prop).getValue();
                return value;
            }
            if (prop instanceof Element) {
                Element elem = (Element)prop;
                Node value = elem.getFirstChild();
                if (elem.getAttributes().getLength() == 0) {
                    if (value instanceof Text) {
                        return ((XMLText)value).getNodeValue();
                    }
                    if (value instanceof CDATASection) {
                        return ((XMLCDATA)value).getNodeValue();
                    }
                }
            }
        }
        throw new NoSuchPropertyException(name);
    }

    public int getPropertyValueAsInteger(String name) throws NoSuchPropertyException {
        String value = this.getPropertyValueAsString(name);
        return Integer.valueOf(value);
    }

    public boolean getPropertyValueAsBoolean(String name) throws NoSuchPropertyException {
        String value = this.getPropertyValueAsString(name);
        return Boolean.valueOf(value);
    }

    public double getPropertyValueAsDouble(String name) throws NoSuchPropertyException {
        String value = this.getPropertyValueAsString(name);
        return Double.valueOf(value);
    }

    public long getPropertyValueAsLong(String name) throws NoSuchPropertyException {
        String value = this.getPropertyValueAsString(name);
        return Long.valueOf(value);
    }

    public char getPropertyValueAsChar(String name) throws NoSuchPropertyException {
        String value = this.getPropertyValueAsString(name);
        return value.charAt(0);
    }

    private Attr getAttributeByName(String propName) {
        return ((Element)this.m_node).getAttributeNode(propName);
    }

    public int getAttributeCount() {
        NamedNodeMap _map = ((XMLElement)this.m_node).getAttributes();
        if (_map != null) {
            return _map.getLength();
        }
        return 0;
    }
}

