/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cmp;

import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1Utils;
import oracle.security.crypto.cmp.attribute.AuthenticatorRegControl;
import oracle.security.crypto.cmp.attribute.CAKeyUpdateInfo;
import oracle.security.crypto.cmp.attribute.CAProtEncCertInfo;
import oracle.security.crypto.cmp.attribute.CertRequestRegInfo;
import oracle.security.crypto.cmp.attribute.ConfirmWaitTimeInfo;
import oracle.security.crypto.cmp.attribute.CurrentCRLInfo;
import oracle.security.crypto.cmp.attribute.EncKeyPairTypesInfo;
import oracle.security.crypto.cmp.attribute.ImplicitConfirmInfo;
import oracle.security.crypto.cmp.attribute.KeyPairParamRepInfo;
import oracle.security.crypto.cmp.attribute.KeyPairParamReqInfo;
import oracle.security.crypto.cmp.attribute.OldCertIDRegControl;
import oracle.security.crypto.cmp.attribute.OrigPKIMessageInfo;
import oracle.security.crypto.cmp.attribute.PKIArchiveOptionRegControl;
import oracle.security.crypto.cmp.attribute.PKIPubInfoRegControl;
import oracle.security.crypto.cmp.attribute.PreferredSymmAlgInfo;
import oracle.security.crypto.cmp.attribute.ProtocolEncrKeyRegControl;
import oracle.security.crypto.cmp.attribute.RegTokenRegControl;
import oracle.security.crypto.cmp.attribute.RevPassphraseInfo;
import oracle.security.crypto.cmp.attribute.SignKeyPairTypesInfo;
import oracle.security.crypto.cmp.attribute.UTF8PairsRegInfo;
import oracle.security.crypto.cmp.attribute.UnsupportedOIDsInfo;
import oracle.security.crypto.core.AlgID;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.util.OIDManager;

public interface CMP {
    public static final int[] id_pkix = new int[]{1, 3, 6, 1, 5, 5, 7};
    public static final ASN1ObjectID id_pkip = new ASN1ObjectID(id_pkix, 5);
    public static final ASN1ObjectID id_regCtrl = new ASN1ObjectID(id_pkip.getValue(), 1);
    public static final ASN1ObjectID id_regCtrl_regToken = new ASN1ObjectID(id_regCtrl.getValue(), 1);
    public static final ASN1ObjectID id_regCtrl_authenticator = new ASN1ObjectID(id_regCtrl.getValue(), 2);
    public static final ASN1ObjectID id_regCtrl_pkiPublicationInfo = new ASN1ObjectID(id_regCtrl.getValue(), 3);
    public static final ASN1ObjectID id_regCtrl_pkiArchiveOptions = new ASN1ObjectID(id_regCtrl.getValue(), 4);
    public static final ASN1ObjectID id_regCtrl_olderCertID = new ASN1ObjectID(id_regCtrl.getValue(), 5);
    public static final ASN1ObjectID id_regCtrl_protocolEncrKey = new ASN1ObjectID(id_regCtrl.getValue(), 6);
    public static final ASN1ObjectID id_regCtrl_altCertTemplate = new ASN1ObjectID(id_regCtrl.getValue(), 7);
    public static final ASN1ObjectID id_regInfo = new ASN1ObjectID(id_pkip.getValue(), 2);
    public static final ASN1ObjectID id_regInfo_asciiPairs;
    public static final ASN1ObjectID id_regInfo_utf8Pairs;
    public static final ASN1ObjectID id_regInfo_certReq;
    public static final ASN1ObjectID id_it;
    public static final ASN1ObjectID id_it_CAProtEncCert;
    public static final ASN1ObjectID id_it_SignKeyPairTypes;
    public static final ASN1ObjectID id_it_EncKeyPairTypes;
    public static final ASN1ObjectID id_it_PreferredSymmAlg;
    public static final ASN1ObjectID id_it_CAKeyUpdateInfo;
    public static final ASN1ObjectID id_it_CurrentCRL;
    public static final ASN1ObjectID id_it_UnsupportedOIDs;
    public static final ASN1ObjectID id_it_KeyPairParamReq;
    public static final ASN1ObjectID id_it_KeyPairParamRep;
    public static final ASN1ObjectID id_it_RevPassphrase;
    public static final ASN1ObjectID id_it_ImplicitConfirm;
    public static final ASN1ObjectID id_it_ConfirmWaitTime;
    public static final ASN1ObjectID id_it_OrigPKIMessage;
    public static final AlgorithmIdentifier sha_1;
    public static final AlgorithmIdentifier md5;
    public static final AlgorithmIdentifier id_dsa_with_sha_1;
    public static final AlgorithmIdentifier dsaWithSHA;
    public static final AlgorithmIdentifier dsaWithSHA1Old;
    public static final AlgorithmIdentifier rsaEncryption;
    public static final AlgorithmIdentifier dh_public_number;
    public static final AlgorithmIdentifier id_alg_ESDH;
    public static final AlgorithmIdentifier id_alg_CMS3DESwrap;
    public static final AlgorithmIdentifier id_alg_CMSRC2wrap;
    public static final AlgorithmIdentifier des_ede3_cbc;
    public static final AlgorithmIdentifier rc2_cbc;
    public static final AlgorithmIdentifier hmac_SHA_1;

    static {
        id_regInfo_utf8Pairs = id_regInfo_asciiPairs = new ASN1ObjectID(id_regInfo.getValue(), 1);
        id_regInfo_certReq = new ASN1ObjectID(id_regInfo.getValue(), 2);
        id_it = new ASN1ObjectID(id_pkix, 4);
        id_it_CAProtEncCert = new ASN1ObjectID(id_it.getValue(), 1);
        id_it_SignKeyPairTypes = new ASN1ObjectID(id_it.getValue(), 2);
        id_it_EncKeyPairTypes = new ASN1ObjectID(id_it.getValue(), 3);
        id_it_PreferredSymmAlg = new ASN1ObjectID(id_it.getValue(), 4);
        id_it_CAKeyUpdateInfo = new ASN1ObjectID(id_it.getValue(), 5);
        id_it_CurrentCRL = new ASN1ObjectID(id_it.getValue(), 6);
        id_it_UnsupportedOIDs = new ASN1ObjectID(id_it.getValue(), 7);
        id_it_KeyPairParamReq = new ASN1ObjectID(id_it.getValue(), 10);
        id_it_KeyPairParamRep = new ASN1ObjectID(id_it.getValue(), 11);
        id_it_RevPassphrase = new ASN1ObjectID(id_it.getValue(), 12);
        id_it_ImplicitConfirm = new ASN1ObjectID(id_it.getValue(), 13);
        id_it_ConfirmWaitTime = new ASN1ObjectID(id_it.getValue(), 14);
        id_it_OrigPKIMessage = new ASN1ObjectID(id_it.getValue(), 15);
        sha_1 = AlgID.sha1;
        md5 = AlgID.md5;
        id_dsa_with_sha_1 = new AlgorithmIdentifier(AlgID.dsaWithSHA1.getOID(), false);
        dsaWithSHA = new AlgorithmIdentifier(AlgID.dsaWithSHA.getOID(), false);
        dsaWithSHA1Old = new AlgorithmIdentifier(AlgID.dsaWithSHA1Old.getOID(), false);
        rsaEncryption = AlgID.rsaEncryption;
        dh_public_number = new AlgorithmIdentifier(new ASN1ObjectID(new int[]{1, 2, 840, 10046, 2, 1}));
        id_alg_ESDH = new AlgorithmIdentifier(new ASN1ObjectID(ASN1Utils.pkcsID, 9, 16, 3, 5));
        id_alg_CMS3DESwrap = new AlgorithmIdentifier(new ASN1ObjectID(ASN1Utils.pkcsID, 9, 16, 3, 6));
        id_alg_CMSRC2wrap = new AlgorithmIdentifier(new ASN1ObjectID(ASN1Utils.pkcsID, 9, 16, 3, 7));
        des_ede3_cbc = AlgID.DES_EDE3_CBC;
        rc2_cbc = AlgID.RC2_CBC;
        hmac_SHA_1 = new AlgorithmIdentifier(new ASN1ObjectID(ASN1Utils.iana, 1, 2));
    }

    public static class OIDRegistrar {
        static {
            OIDManager oidMgr = new OIDManager(OIDManager.getOIDManager());
            oidMgr.setMapping(id_regCtrl_regToken, "registrationControl", RegTokenRegControl.class);
            oidMgr.setMapping(id_regCtrl_authenticator, "registrationControl", AuthenticatorRegControl.class);
            oidMgr.setMapping(id_regCtrl_pkiPublicationInfo, "registrationControl", PKIPubInfoRegControl.class);
            oidMgr.setMapping(id_regCtrl_pkiArchiveOptions, "registrationControl", PKIArchiveOptionRegControl.class);
            oidMgr.setMapping(id_regCtrl_olderCertID, "registrationControl", OldCertIDRegControl.class);
            oidMgr.setMapping(id_regCtrl_protocolEncrKey, "registrationControl", ProtocolEncrKeyRegControl.class);
            oidMgr.setMapping(id_regInfo_utf8Pairs, "registrationInfo", UTF8PairsRegInfo.class);
            oidMgr.setMapping(id_regInfo_certReq, "registrationInfo", CertRequestRegInfo.class);
            oidMgr.setMapping(id_it_CAProtEncCert, "infoTypeAndValue", CAProtEncCertInfo.class);
            oidMgr.setMapping(id_it_SignKeyPairTypes, "infoTypeAndValue", SignKeyPairTypesInfo.class);
            oidMgr.setMapping(id_it_EncKeyPairTypes, "infoTypeAndValue", EncKeyPairTypesInfo.class);
            oidMgr.setMapping(id_it_PreferredSymmAlg, "infoTypeAndValue", PreferredSymmAlgInfo.class);
            oidMgr.setMapping(id_it_CAKeyUpdateInfo, "infoTypeAndValue", CAKeyUpdateInfo.class);
            oidMgr.setMapping(id_it_CurrentCRL, "infoTypeAndValue", CurrentCRLInfo.class);
            oidMgr.setMapping(id_it_UnsupportedOIDs, "infoTypeAndValue", UnsupportedOIDsInfo.class);
            oidMgr.setMapping(id_it_KeyPairParamReq, "infoTypeAndValue", KeyPairParamReqInfo.class);
            oidMgr.setMapping(id_it_KeyPairParamRep, "infoTypeAndValue", KeyPairParamRepInfo.class);
            oidMgr.setMapping(id_it_RevPassphrase, "infoTypeAndValue", RevPassphraseInfo.class);
            oidMgr.setMapping(id_it_ImplicitConfirm, "infoTypeAndValue", ImplicitConfirmInfo.class);
            oidMgr.setMapping(id_it_ConfirmWaitTime, "infoTypeAndValue", ConfirmWaitTimeInfo.class);
            oidMgr.setMapping(id_it_OrigPKIMessage, "infoTypeAndValue", OrigPKIMessageInfo.class);
            OIDManager.setOIDManager((OIDManager)oidMgr);
        }
    }
}

