/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cmp;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import oracle.security.crypto.asn1.ASN1ConstructedInputStream;
import oracle.security.crypto.asn1.ASN1FormatException;
import oracle.security.crypto.asn1.ASN1GenericConstructed;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.cert.X509;
import oracle.security.crypto.cmp.CMPUtils;
import oracle.security.crypto.cmp.EncryptedValue;
import oracle.security.crypto.cmp.attribute.PKIPubInfoRegControl;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.StreamableOutputException;
import oracle.security.crypto.util.Utils;

public class CertifiedKeyPair
implements ASN1Object {
    private X509Certificate cert;
    private EncryptedValue encryptedCert;
    private X509 X509Cert;
    private EncryptedValue privKey;
    private PKIPubInfoRegControl pubInfo;
    private ASN1Object contents;

    public CertifiedKeyPair(X509Certificate cert) throws CertificateEncodingException {
        this(cert, null, null);
    }

    public CertifiedKeyPair(EncryptedValue encryptedCert) {
        this(encryptedCert, null, null);
    }

    public CertifiedKeyPair(X509Certificate cert, PKIPubInfoRegControl pubInfo) throws CertificateEncodingException {
        this(cert, null, pubInfo);
    }

    public CertifiedKeyPair(EncryptedValue encryptedCert, PKIPubInfoRegControl pubInfo) throws CertificateEncodingException {
        this(encryptedCert, null, pubInfo);
    }

    public CertifiedKeyPair(X509Certificate cert, EncryptedValue privKey) throws CertificateEncodingException {
        this(cert, privKey, null);
    }

    public CertifiedKeyPair(EncryptedValue encryptedCert, EncryptedValue privKey) {
        this(encryptedCert, privKey, null);
    }

    public CertifiedKeyPair(X509Certificate cert, EncryptedValue privKey, PKIPubInfoRegControl pubInfo) throws CertificateEncodingException {
        this.cert = cert;
        this.privKey = privKey;
        this.pubInfo = pubInfo;
        this.X509Cert = CMPUtils.convertX509(cert);
    }

    public CertifiedKeyPair(EncryptedValue encryptedCert, EncryptedValue privKey, PKIPubInfoRegControl pubInfo) {
        this.encryptedCert = encryptedCert;
        this.privKey = privKey;
        this.pubInfo = pubInfo;
    }

    public CertifiedKeyPair(InputStream is) throws IOException {
        this.input(is);
    }

    public X509Certificate getCertificate() {
        return this.cert;
    }

    public EncryptedValue getEncryptedCert() {
        return this.encryptedCert;
    }

    public EncryptedValue getPrivateKey() {
        return this.privKey;
    }

    public PKIPubInfoRegControl getPublicationInfo() {
        return this.pubInfo;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("{ ");
        if (this.cert != null) {
            s.append("cert = " + this.cert);
        } else if (this.encryptedCert != null) {
            s.append("encryptedCert = " + this.encryptedCert);
        }
        if (this.privKey != null) {
            s.append(", privKey = " + this.privKey);
        }
        if (this.pubInfo != null) {
            s.append(", pubInfo = " + (Object)((Object)this.pubInfo));
        }
        s.append(" }");
        return s.toString();
    }

    public void input(InputStream is) throws IOException {
        ASN1ConstructedInputStream cis;
        this.update();
        this.contents = new ASN1Sequence(is);
        ASN1SequenceInputStream sis = new ASN1SequenceInputStream(Utils.toStream((Streamable)this.contents));
        if (sis.getCurrentTag() == 0) {
            cis = new ASN1ConstructedInputStream((InputStream)sis, 0);
            try {
                this.X509Cert = new X509((InputStream)cis);
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                this.cert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(this.X509Cert.getEncoded()));
            }
            catch (CertificateException ex) {
                throw new IOException(ex.toString());
            }
            cis.terminate();
        } else if (sis.getCurrentTag() == 1) {
            cis = new ASN1ConstructedInputStream((InputStream)sis, 1);
            this.encryptedCert = new EncryptedValue((InputStream)cis);
            cis.terminate();
        } else {
            throw new ASN1FormatException("Unexpected tag for cert or encrypted cert: " + sis.getCurrentTag());
        }
        if (sis.hasMoreData() && sis.getCurrentTag() == 0) {
            cis = new ASN1ConstructedInputStream((InputStream)sis, 0);
            this.privKey = new EncryptedValue((InputStream)cis);
            cis.terminate();
        } else {
            this.privKey = null;
        }
        if (sis.hasMoreData() && sis.getCurrentTag() == 1) {
            cis = new ASN1ConstructedInputStream((InputStream)sis, 1);
            this.pubInfo = new PKIPubInfoRegControl((InputStream)cis);
            cis.terminate();
        } else {
            this.pubInfo = null;
        }
        sis.terminate();
    }

    public void output(OutputStream os) throws IOException {
        this.toASN1().output(os);
    }

    public int length() {
        return this.toASN1().length();
    }

    private ASN1Object toASN1() {
        if (this.contents == null) {
            ASN1Sequence s = new ASN1Sequence();
            if (this.cert != null) {
                s.addElement((ASN1Object)new ASN1GenericConstructed((ASN1Object)this.X509Cert, 0));
            } else if (this.encryptedCert != null) {
                s.addElement((ASN1Object)new ASN1GenericConstructed((ASN1Object)this.encryptedCert, 1));
            } else {
                throw new StreamableOutputException("Missing certificate or encrypted certificate");
            }
            if (this.privKey != null) {
                s.addElement((ASN1Object)new ASN1GenericConstructed((ASN1Object)this.privKey, 0));
            }
            if (this.pubInfo != null) {
                s.addElement((ASN1Object)new ASN1GenericConstructed((ASN1Object)this.pubInfo, 1));
            }
            this.contents = s;
        }
        return this.contents;
    }

    private void update() {
        this.contents = null;
    }
}

