/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cmp;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.cmp.EncryptedValue;
import oracle.security.crypto.cmp.POPOPrivKey;
import oracle.security.crypto.cmp.ProofOfPossession;

public class KeyAgreementPOP
extends ProofOfPossession {
    private static final ProofOfPossession.Type TYPE = ProofOfPossession.Type.KEY_AGREEMENT;
    private POPOPrivKey popopk;
    private transient ASN1Object contents;

    public KeyAgreementPOP(EncryptedValue encryptedKey) {
        this.popopk = new POPOPrivKey(encryptedKey);
    }

    public KeyAgreementPOP(ProofOfPossession.SubsequentMsg subsequentMsg) {
        this.popopk = new POPOPrivKey(BigInteger.valueOf(subsequentMsg.getValue()));
    }

    public KeyAgreementPOP(byte[] dhMAC) {
        this.popopk = new POPOPrivKey(dhMAC);
    }

    public KeyAgreementPOP(InputStream is) throws IOException {
        this.input(is);
    }

    @Override
    public ProofOfPossession.Type getType() {
        return TYPE;
    }

    public EncryptedValue getEncryptedKey() {
        return this.popopk.getThisMessage();
    }

    public ProofOfPossession.SubsequentMsg getSubsequentMsgType() {
        BigInteger i = this.popopk.getSubsequentMsg();
        if (i == null) {
            return null;
        }
        if (i.equals(BigInteger.valueOf(0L))) {
            return ProofOfPossession.SubsequentMsg.ENCR_CERT;
        }
        if (i.equals(BigInteger.valueOf(1L))) {
            return ProofOfPossession.SubsequentMsg.CHALLENGE_RESP;
        }
        throw new IllegalStateException("Unknown subsequentMessage type: " + i);
    }

    public byte[] getDHMac() {
        return this.popopk.getDHMac();
    }

    public String toString() {
        return TYPE + " " + (this.popopk != null ? this.popopk.toString() : "= null");
    }

    public void input(InputStream is) throws IOException {
        this.popopk = new POPOPrivKey(is);
        this.update();
        this.contents = this.popopk;
    }

    @Override
    ASN1Object toASN1Object() {
        if (this.contents == null) {
            this.contents = this.popopk;
        }
        return this.contents;
    }

    @Override
    void clearCache() {
        this.contents = null;
    }
}

