/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cmp;

import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.cmp.PKIMessage;
import oracle.security.crypto.cmp.PKIMessageBody;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.Utils;

public class NestedMessage
extends PKIMessageBody {
    private static final PKIMessageBody.Type TYPE = PKIMessageBody.Type.NESTED_MESSAGE;
    private Vector pkiMsg = new Vector();
    private transient ASN1Object contents;

    public NestedMessage() {
    }

    public NestedMessage(PKIMessage msg) {
        this.pkiMsg.addElement(msg);
    }

    public NestedMessage(InputStream is) throws IOException {
        this.input(is);
    }

    public void addPKIMessage(PKIMessage msg) {
        this.pkiMsg.addElement(msg);
        this.update();
    }

    public Vector getNestedMessage() {
        return this.pkiMsg;
    }

    @Override
    public PKIMessageBody.Type getType() {
        return TYPE;
    }

    public String toString() {
        return TYPE + " { pkiMsg = " + Utils.toString((Vector)this.pkiMsg) + " }";
    }

    public void input(InputStream is) throws IOException {
        this.update();
        this.contents = new ASN1Sequence(is);
        ASN1SequenceInputStream sis = new ASN1SequenceInputStream(Utils.toStream((Streamable)this.contents));
        this.pkiMsg.removeAllElements();
        while (sis.hasMoreData()) {
            this.pkiMsg.addElement(new PKIMessage((InputStream)sis));
        }
        sis.terminate();
    }

    @Override
    ASN1Object toASN1Object() {
        if (this.contents == null) {
            this.contents = new ASN1Sequence(this.pkiMsg);
        }
        return this.contents;
    }

    @Override
    void clearCache() {
        this.contents = null;
    }
}

