/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cmp.attribute;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.security.crypto.asn1.ASN1FormatException;
import oracle.security.crypto.asn1.ASN1Integer;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.cert.GeneralName;
import oracle.security.crypto.cmp.CMP;
import oracle.security.crypto.cmp.attribute.RegistrationControl;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.StreamableInputException;
import oracle.security.crypto.util.Utils;

public class PKIPubInfoRegControl
extends RegistrationControl {
    private static final ASN1ObjectID TYPE = CMP.id_regCtrl_pkiPublicationInfo;
    private Action action;
    private Vector pubInfos;
    private Hashtable locTable;

    public PKIPubInfoRegControl() {
        super(TYPE, null);
        this.decoded = true;
    }

    public PKIPubInfoRegControl(Action action) {
        this();
        this.action = action;
    }

    public PKIPubInfoRegControl(Action action, Method pubMethod, GeneralName pubLocation) {
        this(action);
        this.addPubInfo(pubMethod, pubLocation);
    }

    public PKIPubInfoRegControl(InputStream is) throws IOException {
        this();
        this.input(is);
    }

    public void addPubInfo(Method pubMethod, GeneralName pubLocation) {
        this.putPubInfo(pubMethod, pubLocation);
        this.encoded = false;
    }

    private void putPubInfo(Method pubMethod, GeneralName pubLocation) {
        if (this.action != Action.PLEASE_PUBLISH) {
            throw new IllegalArgumentException("Action must be PLEASE_PUBLISH");
        }
        if (this.pubInfos == null) {
            this.pubInfos = new Vector();
            this.locTable = new Hashtable();
        }
        this.pubInfos.addElement(new SinglePubInfo(pubMethod, pubLocation));
        Vector<GeneralName> v = (Vector<GeneralName>)this.locTable.get(pubMethod);
        if (v == null) {
            v = new Vector<GeneralName>();
        }
        if (pubLocation != null) {
            v.addElement(pubLocation);
        }
        this.locTable.put(pubMethod, v);
    }

    public Action getAction() {
        this.decodeValue();
        return this.action;
    }

    public boolean hasPubMethod(Method pubMethod) {
        this.decodeValue();
        return this.locTable != null ? this.locTable.containsKey(pubMethod) : false;
    }

    public Enumeration pubMethods() {
        this.decodeValue();
        if (this.locTable != null) {
            return this.locTable.keys();
        }
        return null;
    }

    public Vector getPubLocations(Method pubMethod) {
        this.decodeValue();
        if (this.hasPubMethod(pubMethod)) {
            return (Vector)this.locTable.get(pubMethod);
        }
        return null;
    }

    private void clearTables() {
        if (this.pubInfos != null) {
            this.pubInfos.removeAllElements();
            this.locTable.clear();
        }
    }

    @Override
    protected void encodeValue() {
        if (!this.encoded) {
            ASN1Sequence seq = new ASN1Sequence();
            seq.addElement((ASN1Object)new ASN1Integer((long)this.action.getValue()));
            if (this.pubInfos != null && this.pubInfos.size() > 0) {
                seq.addElement((ASN1Object)new ASN1Sequence(this.pubInfos));
            }
            this.setValue((ASN1Object)seq);
            this.encoded = true;
            this.decoded = true;
        }
    }

    @Override
    protected void decodeValue() {
        if (!this.decoded) {
            try {
                this.clearTables();
                ASN1SequenceInputStream sis = new ASN1SequenceInputStream(Utils.toStream((Streamable)this.getValue()));
                int a = ASN1Integer.inputValue((InputStream)sis).intValue();
                if (a == 0) {
                    this.action = Action.DONT_PUBLISH;
                    if (sis.hasMoreData()) {
                        throw new ASN1FormatException("Publication info not allowed for action 'dontPublish'");
                    }
                } else if (a == 1) {
                    this.action = Action.PLEASE_PUBLISH;
                    if (sis.hasMoreData()) {
                        ASN1SequenceInputStream pub = new ASN1SequenceInputStream((InputStream)sis);
                        while (pub.hasMoreData()) {
                            SinglePubInfo i = new SinglePubInfo((InputStream)pub);
                            this.putPubInfo(i.getPubMethod(), i.getPubLocation());
                        }
                        pub.terminate();
                        if (this.pubInfos.size() == 0) {
                            throw new ASN1FormatException("Invalid empty publication info list");
                        }
                    }
                } else {
                    throw new ASN1FormatException("Unknown publication action: " + a);
                }
                sis.terminate();
            }
            catch (IOException ex) {
                throw new StreamableInputException(ex.toString());
            }
            this.decoded = true;
        }
    }

    private static class SinglePubInfo
    implements ASN1Object {
        private Method pubMethod;
        private GeneralName pubLocation;
        private transient ASN1Object contents = null;

        public SinglePubInfo(Method pubMethod) {
            this.pubMethod = pubMethod;
        }

        public SinglePubInfo(Method pubMethod, GeneralName pubLocation) {
            this.pubMethod = pubMethod;
            this.pubLocation = pubLocation;
        }

        public SinglePubInfo(InputStream is) throws IOException {
            this.input(is);
        }

        public Method getPubMethod() {
            return this.pubMethod;
        }

        public GeneralName getPubLocation() {
            return this.pubLocation;
        }

        public void input(InputStream is) throws IOException {
            ASN1SequenceInputStream sis = new ASN1SequenceInputStream(is);
            int m = ASN1Integer.inputValue((InputStream)sis).intValue();
            switch (m) {
                case 0: {
                    this.pubMethod = Method.DONT_CARE;
                    break;
                }
                case 1: {
                    this.pubMethod = Method.X500;
                    break;
                }
                case 2: {
                    this.pubMethod = Method.WEB;
                    break;
                }
                case 3: {
                    this.pubMethod = Method.LDAP;
                    break;
                }
                default: {
                    throw new ASN1FormatException("Unknown publication method: " + m);
                }
            }
            if (sis.hasMoreData()) {
                this.pubLocation = new GeneralName((InputStream)sis);
            }
            sis.terminate();
            this.update();
        }

        public void output(OutputStream os) throws IOException {
            this.toASN1().output(os);
        }

        public int length() {
            return this.toASN1().length();
        }

        private ASN1Object toASN1() {
            if (this.contents == null) {
                ASN1Sequence seq = new ASN1Sequence();
                seq.addElement((ASN1Object)new ASN1Integer((long)this.pubMethod.getValue()));
                if (this.pubLocation != null) {
                    seq.addElement((ASN1Object)this.pubLocation);
                }
                this.contents = seq;
            }
            return this.contents;
        }

        private void update() {
            this.contents = null;
        }
    }

    public static class Method {
        public static final Method DONT_CARE = new Method(0);
        public static final Method X500 = new Method(1);
        public static final Method WEB = new Method(2);
        public static final Method LDAP = new Method(3);
        private int value;

        private Method(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this == obj) {
                return true;
            }
            return this.value == ((Method)obj).value;
        }

        public int hashCode() {
            return BigInteger.valueOf(this.value).hashCode();
        }
    }

    public static class Action {
        public static final Action DONT_PUBLISH = new Action(0);
        public static final Action PLEASE_PUBLISH = new Action(1);
        private int value;

        private Action(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

