/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.util;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import oracle.spatial.util.ShapefileReaderJGeom;

public class ShapefileHdr {
    public int fileCode;
    public int u1;
    public int u2;
    public int u3;
    public int u4;
    public int u5;
    public int fileLength;
    public int version;
    public int shapeType;
    public double Xmin;
    public double Ymin;
    public double Xmax;
    public double Ymax;
    public double Zmin;
    public double Zmax;
    public double Mmin;
    public double Mmax;
    public static final int size = 100;

    public void fromBuffer(byte[] byArray) throws IOException {
        ShapefileReaderJGeom.swapBytes(byArray, 28, 4);
        ShapefileReaderJGeom.swapBytes(byArray, 32, 4);
        for (int i = 36; i <= 92; i += 8) {
            ShapefileReaderJGeom.swapBytes(byArray, i, 8);
        }
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
        this.fileCode = dataInputStream.readInt();
        for (int i = 0; i < 5; ++i) {
            dataInputStream.readInt();
        }
        this.fileLength = dataInputStream.readInt();
        this.version = dataInputStream.readInt();
        this.shapeType = dataInputStream.readInt();
        this.Xmin = dataInputStream.readDouble();
        this.Ymin = dataInputStream.readDouble();
        this.Xmax = dataInputStream.readDouble();
        this.Ymax = dataInputStream.readDouble();
        this.Zmin = this.validateDouble(dataInputStream.readDouble(), -1.0);
        this.Zmax = this.validateDouble(dataInputStream.readDouble(), 1.0);
        this.Mmin = dataInputStream.readDouble();
        this.Mmax = dataInputStream.readDouble();
    }

    private double validateDouble(double d, double d2) {
        if (d <= -1.0E20 || d >= 1.0E20) {
            return d2;
        }
        return d;
    }

    public int getVersion() {
        return this.version;
    }

    public int getFileCode() {
        return this.fileCode;
    }

    public int getShapeType() {
        return this.shapeType;
    }

    public int getFileLength() {
        return this.fileLength;
    }

    public double getXmin() {
        return this.Xmin;
    }

    public double getXmax() {
        return this.Xmax;
    }

    public double getYmin() {
        return this.Ymin;
    }

    public double getYmax() {
        return this.Ymax;
    }

    public double getZmin() {
        return this.Zmin;
    }

    public double getZmax() {
        return this.Zmax;
    }

    public double getMmin() {
        return this.Mmin;
    }

    public double getMmax() {
        return this.Mmax;
    }
}

