/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.util.jsonproc;

import java.io.IOException;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import java.util.Stack;
import oracle.spatial.util.jsonproc.JsonGenerationException;
import oracle.spatial.util.jsonproc.ObjectMapper;
import oracle.spatial.util.jsonproc.annotation.JsonCreator;
import oracle.spatial.util.jsonproc.annotation.JsonDeserialize;
import oracle.spatial.util.jsonproc.annotation.JsonProperty;
import oracle.spatial.util.jsonproc.annotation.JsonSerialize;

public class JsonGenerator
implements AutoCloseable {
    private Writer writer;
    private int curve_bracket_sum = 0;
    private Stack<Context> contextStack = new Stack();
    private boolean pretty_print = false;

    public void pretty_print() {
        this.pretty_print = true;
    }

    protected JsonGenerator(Writer writer) {
        this.writer = writer;
        this.contextStack.push(Context.INIT);
    }

    public JsonGenerator(int n) {
        this.curve_bracket_sum = n;
    }

    public void flush() throws IOException {
        this.writer.flush();
    }

    public JsonGenerator useDefaultPrettyPrinter() {
        this.pretty_print = true;
        return this;
    }

    private void validateValue() throws IOException {
        switch (this.contextStack.pop()) {
            case INIT: {
                this.contextStack.push(Context.INIT);
                break;
            }
            case START_OBJECT: {
                throw new JsonGenerationException("expecting field name");
            }
            case FIELD_NAME: {
                break;
            }
            case START_ARRAY: {
                this.contextStack.push(Context.START_ARRAY);
                if (!this.pretty_print) break;
                this.writer.append(" ");
                break;
            }
            case VALUE: {
                if (this.pretty_print) {
                    this.writer.append(", ");
                    break;
                }
                this.writer.write(44);
            }
        }
    }

    public void writeNull() throws IOException {
        this.validateValue();
        this.writer.append("null");
        this.contextStack.push(Context.VALUE);
    }

    private static CharSequence scapeJsonString(String string) {
        StringBuilder stringBuilder = new StringBuilder(string);
        block9: for (int i = 0; i < stringBuilder.length(); ++i) {
            switch (stringBuilder.charAt(i)) {
                case '\\': {
                    stringBuilder.replace(i, i + 1, "\\\\");
                    ++i;
                    continue block9;
                }
                case '\n': {
                    stringBuilder.replace(i, i + 1, "\\n");
                    ++i;
                    continue block9;
                }
                case '\t': {
                    stringBuilder.replace(i, i + 1, "\\\t");
                    ++i;
                    continue block9;
                }
                case '\"': {
                    stringBuilder.replace(i, i + 1, "\\\"");
                    ++i;
                    continue block9;
                }
                case '\b': {
                    stringBuilder.replace(i, i + 1, "\\b");
                    ++i;
                    continue block9;
                }
                case '\f': {
                    stringBuilder.replace(i, i + 1, "\\f");
                    ++i;
                    continue block9;
                }
                case '\r': {
                    stringBuilder.replace(i, i + 1, "\\r");
                    ++i;
                    continue block9;
                }
                default: {
                    char c = stringBuilder.charAt(i);
                    if (c < '\u0080') continue block9;
                    stringBuilder.replace(i, i + 1, "\\u" + String.format("%04X", c));
                    i += 5;
                }
            }
        }
        return stringBuilder;
    }

    public void writeString(String string) throws IOException {
        this.validateValue();
        this.writer.append('\"');
        this.writer.append(JsonGenerator.scapeJsonString(string));
        this.writer.append('\"');
        this.contextStack.push(Context.VALUE);
    }

    public void writeStringField(String string, String string2) throws IOException {
        this.writeFieldName(string);
        this.writeString(string2);
    }

    public void writeNumberField(String string, BigDecimal bigDecimal) throws IOException {
        this.writeFieldName(string);
        this.writeNumber(bigDecimal);
    }

    public void writeNumberField(String string, BigInteger bigInteger) throws IOException {
        this.writeFieldName(string);
        this.writeNumber(bigInteger);
    }

    public void writeNumberField(String string, double d) throws IOException {
        this.writeFieldName(string);
        this.writeNumber(d);
    }

    public void writeNumberField(String string, float f) throws IOException {
        this.writeFieldName(string);
        this.writeNumber(f);
    }

    public void writeNumberField(String string, int n) throws IOException {
        this.writeFieldName(string);
        this.writeNumber(n);
    }

    public void writeNumberField(String string, long l) throws IOException {
        this.writeFieldName(string);
        this.writeNumber(l);
    }

    public void writeNumberField(String string, short s) throws IOException {
        this.writeFieldName(string);
        this.writeNumber(s);
    }

    public void writeBoolean(boolean bl) throws IOException {
        this.validateValue();
        this.writer.append(bl ? "true" : "false");
        this.contextStack.push(Context.VALUE);
    }

    public void writeNullField(String string) throws IOException {
        this.writeFieldName(string);
        this.writeNull();
    }

    public void writeRawValue(String string) throws IOException {
        this.validateValue();
        this.writer.append(string);
        this.contextStack.push(Context.VALUE);
    }

    public void writeStartArray() throws IOException {
        this.validateValue();
        this.writer.append("[");
        this.contextStack.push(Context.START_ARRAY);
    }

    public void writeNumber(BigDecimal bigDecimal) throws IOException {
        this.validateValue();
        this.writer.append(bigDecimal.toPlainString());
        this.contextStack.push(Context.VALUE);
    }

    public void writeNumber(BigInteger bigInteger) throws IOException {
        this.validateValue();
        this.writer.append(bigInteger.toString());
        this.contextStack.push(Context.VALUE);
    }

    public void writeNumber(double d) throws IOException {
        this.validateValue();
        this.writer.append(Double.toString(d));
        this.contextStack.push(Context.VALUE);
    }

    public void writeNumber(int n) throws IOException {
        this.validateValue();
        this.writer.append(Integer.toString(n));
        this.contextStack.push(Context.VALUE);
    }

    public void writeNumber(String string) throws IOException {
        this.validateValue();
        this.writer.append(string);
        this.contextStack.push(Context.VALUE);
    }

    public void writeNumber(long l) throws IOException {
        this.validateValue();
        this.writer.append(Long.toString(l));
        this.contextStack.push(Context.VALUE);
    }

    public void writeNumber(float f) throws IOException {
        this.validateValue();
        this.writer.append(Float.toString(f));
        this.contextStack.push(Context.VALUE);
    }

    public void writeNumber(short s) throws IOException {
        this.validateValue();
        this.writer.append(Short.toString(s));
        this.contextStack.push(Context.VALUE);
    }

    public void writeEndArray() throws IOException {
        switch (this.contextStack.pop()) {
            case FIELD_NAME: {
                throw new JsonGenerationException("Can not end an array, expecting value");
            }
            case START_OBJECT: {
                throw new JsonGenerationException("Can not end an array, expecting field name");
            }
            case VALUE: {
                if (this.contextStack.pop() == Context.START_ARRAY) break;
                throw new JsonGenerationException("Can not end an array, expecting field name");
            }
        }
        if (this.pretty_print) {
            this.writer.append(" ");
        }
        this.writer.append("]");
        this.contextStack.push(Context.VALUE);
    }

    public void writeRaw(String string) throws IOException {
        this.writer.append(string);
    }

    public void writeStartObject() throws IOException {
        this.validateValue();
        this.writer.append("{");
        ++this.curve_bracket_sum;
        this.contextStack.push(Context.START_OBJECT);
    }

    public void writeObjectField(String string, Object object) throws IOException {
        this.writeFieldName(string);
        this.writeObject(object);
    }

    public void writeFieldName(String string) throws IOException {
        switch (this.contextStack.peek()) {
            case FIELD_NAME: {
                throw new JsonGenerationException("Can not write a field name, expecting a value");
            }
            case START_OBJECT: {
                break;
            }
            case START_ARRAY: {
                if (!this.pretty_print) break;
                this.writer.append(" ");
                break;
            }
            case VALUE: {
                this.contextStack.pop();
                this.writer.append(",");
            }
        }
        if (this.pretty_print) {
            this.writer.append("\n");
            for (int i = 0; i < this.curve_bracket_sum; ++i) {
                this.writer.append("  ");
            }
        }
        this.writer.append("\"");
        this.writer.append(JsonGenerator.scapeJsonString(string));
        this.writer.append("\"");
        if (this.pretty_print) {
            this.writer.append(" : ");
        } else {
            this.writer.append(":");
        }
        this.contextStack.push(Context.FIELD_NAME);
    }

    public void writeEndObject() throws IOException {
        switch (this.contextStack.pop()) {
            case START_ARRAY: {
                throw new JsonGenerationException("Expecting end of array");
            }
            case FIELD_NAME: {
                throw new JsonGenerationException("Expecting value");
            }
            case START_OBJECT: {
                break;
            }
            case VALUE: {
                if (this.contextStack.pop() != Context.START_ARRAY) break;
                throw new JsonGenerationException("Expecting end of array");
            }
        }
        --this.curve_bracket_sum;
        if (this.pretty_print) {
            this.writer.append('\n');
            for (int i = 0; i < this.curve_bracket_sum; ++i) {
                this.writer.append("  ");
            }
        }
        this.writer.append("}");
        this.contextStack.push(Context.VALUE);
    }

    public void writeObject(Object object) throws IOException {
        Constructor<?>[] constructorArray;
        if (object.getClass().isArray() && object.getClass().getComponentType() == Double.TYPE) {
            this.writeStartArray();
            double[] dArray = (double[])object;
            for (int i = 0; i < dArray.length; ++i) {
                this.writeNumber(dArray[i]);
            }
            this.writeEndArray();
            return;
        }
        if (object.getClass().isArray() || object.getClass().toString().contains("Unmodifiable")) {
            this.writeStartArray();
            List list = (List)object;
            for (int i = 0; i < list.size(); ++i) {
                this.writeObject(list.get(i));
            }
            this.writeEndArray();
            return;
        }
        JsonSerialize jsonSerialize = object.getClass().getAnnotation(JsonSerialize.class);
        if (jsonSerialize instanceof JsonSerialize && jsonSerialize.using().toString().contains("GeometrySerializer")) {
            ObjectMapper.writeValueAsString_help(object, this);
            return;
        }
        Class clazz = object.getClass();
        Constructor<?>[] constructorArray2 = object.getClass().getAnnotation(JsonDeserialize.class);
        if (constructorArray2 instanceof JsonDeserialize && (constructorArray = constructorArray2).as() != Object.class) {
            clazz = constructorArray.as();
        }
        for (Constructor<?> constructor : constructorArray = clazz.getConstructors()) {
            JsonCreator jsonCreator = constructor.getAnnotation(JsonCreator.class);
            if (constructorArray.length != 1 && !(jsonCreator instanceof JsonCreator)) continue;
            Annotation[][] annotationArray = constructor.getParameterAnnotations();
            int n = 0;
            String string = "";
            if (annotationArray[0].length != 0) {
                JsonProperty jsonProperty = (JsonProperty)annotationArray[0][0];
                string = jsonProperty.value();
            }
            if (annotationArray.length != 1 || string != "") {
                this.writeStartObject();
            }
            for (Field field : clazz.getDeclaredFields()) {
                field.setAccessible(true);
                try {
                    if (field.get(object) == null) {
                        continue;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                String string2 = "";
                if (annotationArray[0].length != 0) {
                    JsonProperty jsonProperty = (JsonProperty)annotationArray[n][0];
                    string2 = jsonProperty.value();
                }
                if (annotationArray.length != 1 || string != "") {
                    this.writeFieldName(string2);
                }
                ++n;
                try {
                    if (field.getType().isPrimitive()) {
                        if (field.getType() == Double.TYPE) {
                            this.writeNumber((Double)field.get(object));
                        }
                        if (field.getType() != Integer.TYPE) continue;
                        this.writeNumber((Integer)field.get(object));
                        continue;
                    }
                    this.writeObject(field.get(object));
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new JsonGenerationException(illegalAccessException.getMessage());
                }
            }
            if (annotationArray.length != 1 || string != "") {
                this.writeEndObject();
            }
            return;
        }
        ObjectMapper.writeValueAsString_help(object, this);
    }

    public void writeArrayFieldStart(String string) throws IOException {
        this.writeFieldName(string);
        this.writeStartArray();
    }

    @Override
    public void close() throws IOException {
        this.writer.flush();
    }

    public static enum Feature {
        ESCAPE_NON_ASCII;

    }

    private static enum Context {
        INIT,
        START_OBJECT,
        FIELD_NAME,
        VALUE,
        START_ARRAY;

    }
}

