/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.util.jsonproc;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;
import oracle.spatial.util.jsonproc.DeserializationContext;
import oracle.spatial.util.jsonproc.JsonFactory;
import oracle.spatial.util.jsonproc.JsonGenerator;
import oracle.spatial.util.jsonproc.JsonMappingException;
import oracle.spatial.util.jsonproc.JsonNode;
import oracle.spatial.util.jsonproc.JsonParser;
import oracle.spatial.util.jsonproc.JsonProcessingException;
import oracle.spatial.util.jsonproc.ObjectCodec;
import oracle.spatial.util.jsonproc.SerializationFeature;
import oracle.spatial.util.jsonproc.SerializerProvider;
import oracle.spatial.util.jsonproc.annotation.JsonCreator;
import oracle.spatial.util.jsonproc.annotation.JsonDeserialize;
import oracle.spatial.util.jsonproc.annotation.JsonProperty;
import oracle.spatial.util.jsonproc.annotation.JsonSerialize;
import oracle.spatial.util.jsonproc.annotation.JsonValue;
import oracle.spatial.util.jsonproc.module.SimpleModule;

public class ObjectMapper
extends ObjectCodec {
    private SimpleModule sm;
    private static final Map<Class<?>, Class<?>> WRAPPER_TYPE_MAP = new HashMap(16);
    private boolean indentOutput = false;
    private boolean allowUnquotedFieldNames;

    public static boolean isPrimitiveType(Object object) {
        return WRAPPER_TYPE_MAP.containsKey(object.getClass());
    }

    public static boolean isArrayListType(Object object) {
        return object.getClass() == ArrayList.class;
    }

    public static JsonFactory getFactory() {
        return new JsonFactory();
    }

    private static Object string_to_primitive(String string, Class clazz) {
        if (clazz == Integer.class || clazz == Integer.TYPE) {
            return Integer.valueOf(string);
        }
        if (clazz == Byte.class || clazz == Byte.TYPE) {
            return Byte.valueOf(string);
        }
        if (clazz == Boolean.class || clazz == Boolean.TYPE) {
            return Boolean.valueOf(string);
        }
        if (clazz == Double.TYPE || clazz == Double.class) {
            return Double.valueOf(string);
        }
        if (clazz == Float.class || clazz == Float.TYPE) {
            return Float.valueOf(string);
        }
        if (clazz == Short.class || clazz == Short.TYPE) {
            return Short.valueOf(string);
        }
        if (clazz == String.class) {
            return string;
        }
        throw new IllegalStateException("unsupported class" + clazz.getCanonicalName());
    }

    public static double[] jnode_to_darray(JsonNode jsonNode) {
        double[] dArray = new double[jsonNode.size()];
        int n = 0;
        for (JsonNode jsonNode2 : jsonNode) {
            dArray[n] = jsonNode2.asDouble();
            ++n;
        }
        return dArray;
    }

    public void registerModule(SimpleModule simpleModule) {
        this.sm = simpleModule;
    }

    public <T> T treeToValue(JsonNode jsonNode, Class<T> clazz) throws JsonProcessingException {
        try {
            if (jsonNode == null) {
                return null;
            }
            if (clazz.isArray()) {
                Class<?> clazz2 = clazz.getComponentType();
                Object object = Array.newInstance(clazz2, jsonNode.size());
                int n = 0;
                JsonDeserialize jsonDeserialize = clazz.getComponentType().getAnnotation(JsonDeserialize.class);
                if (jsonDeserialize != null) {
                    if (clazz.getComponentType().getAnnotation(JsonDeserialize.class).using() != Object.class) {
                        Class clazz3 = clazz.getComponentType().getAnnotation(JsonDeserialize.class).using();
                        for (JsonNode jsonNode2 : jsonNode) {
                            DeserializationContext deserializationContext = new DeserializationContext();
                            Constructor constructor = clazz3.getDeclaredConstructor(new Class[0]);
                            constructor.setAccessible(true);
                            Object t = constructor.newInstance(new Object[0]);
                            Method method = clazz3.getDeclaredMethod("deserialize", JsonParser.class, DeserializationContext.class);
                            method.setAccessible(true);
                            Object object2 = method.invoke(clazz3.cast(t), this.createParser(jsonNode2.toString()), deserializationContext);
                            Array.set(object, n, object2);
                            ++n;
                        }
                    } else {
                        Class clazz4 = clazz.getComponentType().getAnnotation(JsonDeserialize.class).as();
                        for (JsonNode jsonNode3 : jsonNode) {
                            T t = this.treeToValue(jsonNode3, clazz4);
                            Array.set(object, n, t);
                            ++n;
                        }
                    }
                } else {
                    for (JsonNode jsonNode4 : jsonNode) {
                        Object obj = this.treeToValueUsingSetters(jsonNode4, clazz.getComponentType());
                        Array.set(object, n, obj);
                        ++n;
                    }
                }
                return (T)object;
            }
            Constructor<?>[] constructorArray = clazz.getConstructors();
            T t = null;
            for (Constructor<?> constructor : constructorArray) {
                constructor.setAccessible(true);
                JsonCreator jsonCreator = constructor.getAnnotation(JsonCreator.class);
                if (constructorArray.length != 1 && !(jsonCreator instanceof JsonCreator)) continue;
                Annotation[][] annotationArray = constructor.getParameterAnnotations();
                Class<?>[] classArray = constructor.getParameterTypes();
                int n = 0;
                Object[] objectArray = new Object[classArray.length];
                for (Class<?> clazz5 : classArray) {
                    String string = "";
                    if (annotationArray[0].length != 0) {
                        JsonProperty jsonProperty = (JsonProperty)annotationArray[n][0];
                        string = jsonProperty.value();
                    }
                    if (WRAPPER_TYPE_MAP.containsKey(clazz5) || clazz5.isPrimitive()) {
                        objectArray[n] = jsonNode.get(string) == null ? null : ObjectMapper.string_to_primitive(jsonNode.get(string).asText(), clazz5);
                    } else if (clazz5.isArray() && clazz5.getComponentType() == Double.TYPE) {
                        objectArray[n] = ObjectMapper.jnode_to_darray(jsonNode);
                    } else if (jsonNode.get(string) == null) {
                        objectArray[n] = null;
                    } else {
                        JsonDeserialize jsonDeserialize = clazz5.getAnnotation(JsonDeserialize.class);
                        Class clazz6 = null;
                        if (jsonDeserialize != null) {
                            clazz6 = jsonDeserialize.as();
                        }
                        objectArray[n] = clazz6 != null ? this.treeToValue(jsonNode.get(string), clazz6) : this.treeToValue(jsonNode.get(string), clazz5);
                    }
                    ++n;
                }
                t = (T)constructor.newInstance(objectArray);
                break;
            }
            if (t == null) {
                return this.treeToValueUsingSetters(jsonNode, clazz);
            }
            return t;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | NullPointerException | SecurityException | InvocationTargetException exception) {
            throw new JsonProcessingException(exception);
        }
    }

    private <T> T treeToValueUsingSetters(JsonNode jsonNode, Class<T> clazz) throws JsonProcessingException {
        try {
            Constructor<T> constructor = clazz.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            T t = constructor.newInstance(new Object[0]);
            Method[] methodArray = clazz.getDeclaredMethods();
            HashMap<String, Method> hashMap = new HashMap<String, Method>();
            for (int i = 0; i < methodArray.length; ++i) {
                if (!methodArray[i].getName().substring(0, 3).matches("set")) continue;
                hashMap.put(methodArray[i].getName().substring(3).toLowerCase(Locale.ROOT), methodArray[i]);
            }
            Iterator<String> iterator = jsonNode.fieldNames();
            while (iterator.hasNext()) {
                String string = iterator.next();
                if (!hashMap.containsKey(string.toLowerCase(Locale.ROOT))) continue;
                Method method = (Method)hashMap.get(string.toLowerCase(Locale.ROOT));
                method.setAccessible(true);
                Class<?> clazz2 = method.getParameterTypes()[0];
                if (jsonNode.get(string).isObject()) {
                    method.invoke(t, this.treeToValue(jsonNode.get(string), clazz2));
                    continue;
                }
                if (jsonNode.get(string).isArray()) {
                    Object object = Array.newInstance(clazz2.getComponentType(), jsonNode.get(string).size());
                    int n = 0;
                    Iterator<JsonNode> iterator2 = jsonNode.get(string).elements();
                    while (iterator2.hasNext()) {
                        JsonNode jsonNode2 = iterator2.next();
                        if (jsonNode2.isObject()) {
                            Array.set(object, n, this.treeToValue(jsonNode2, clazz2.getComponentType()));
                        } else {
                            Array.set(object, n, ObjectMapper.string_to_primitive(jsonNode2.asText(), clazz2.getComponentType()));
                        }
                        ++n;
                    }
                    method.invoke(t, object);
                    continue;
                }
                method.invoke(t, ObjectMapper.string_to_primitive(jsonNode.get(string).asText(), clazz2));
            }
            return t;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            throw new JsonProcessingException(reflectiveOperationException);
        }
    }

    private JsonParser createParser(String string) {
        return this.createParser(new StringReader(string));
    }

    public String writeValueAsString(Object object) throws JsonProcessingException {
        if (object instanceof JsonNode) {
            return ((JsonNode)object).toString();
        }
        StringWriter stringWriter = new StringWriter();
        try (JsonGenerator jsonGenerator = this.createGenerator(stringWriter);){
            ObjectMapper.writeValueAsString_help(object, jsonGenerator);
        }
        catch (IOException iOException) {
            throw new JsonProcessingException(iOException);
        }
        return stringWriter.toString();
    }

    protected static void writeValueAsString_help(Object object, JsonGenerator jsonGenerator) throws JsonProcessingException {
        try {
            if (ObjectMapper.isPrimitiveType(object)) {
                jsonGenerator.writeRawValue(object.toString());
                return;
            }
            if (object instanceof String) {
                jsonGenerator.writeString((String)object);
                return;
            }
            for (Method method : object.getClass().getDeclaredMethods()) {
                if (!method.isAnnotationPresent(JsonValue.class)) continue;
                Object object2 = method.invoke(object, new Object[0]);
                if (object2.getClass().isArray()) {
                    Class<?> clazz = object2.getClass().getComponentType();
                    jsonGenerator.writeStartArray();
                    if (clazz.isPrimitive()) {
                        int n = Array.getLength(object2);
                        for (int i = 0; i < n; ++i) {
                            Object object3 = Array.get(object2, i);
                            jsonGenerator.writeRawValue(object3.toString());
                        }
                    } else {
                        Object[] objectArray;
                        for (Object object4 : objectArray = (Object[])object2) {
                            jsonGenerator.writeRawValue(object4.toString());
                        }
                    }
                    jsonGenerator.writeEndArray();
                } else {
                    jsonGenerator.writeRawValue(object.toString());
                }
                return;
            }
            try {
                Method method;
                Class<?> clazz = object.getClass();
                JsonSerialize jsonSerialize = clazz.getAnnotation(JsonSerialize.class);
                Class<?> clazz2 = clazz;
                if (jsonSerialize != null) {
                    clazz2 = jsonSerialize.using();
                }
                method = clazz2.getDeclaredMethod("serialize", Object.class, JsonGenerator.class, SerializerProvider.class);
                method.setAccessible(true);
                Constructor constructor = clazz2.getDeclaredConstructor(new Class[0]);
                constructor.setAccessible(true);
                Object t = constructor.newInstance(new Object[0]);
                SerializerProvider serializerProvider = new SerializerProvider();
                Object object5 = method.invoke(clazz2.cast(t), object, jsonGenerator, serializerProvider);
                return;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                if (Map.class.isAssignableFrom(object.getClass())) {
                    Map map = (Map)object;
                    jsonGenerator.writeStartObject();
                    for (Map.Entry entry : map.entrySet()) {
                        jsonGenerator.writeFieldName((String)entry.getKey());
                        ObjectMapper.writeValueAsString_help(entry.getValue(), jsonGenerator);
                    }
                    jsonGenerator.writeEndObject();
                    return;
                }
                throw new JsonProcessingException("object type not supported: " + object.getClass().getName());
            }
        }
        catch (IOException | IllegalAccessException | IllegalArgumentException | InstantiationException | NullPointerException | SecurityException | InvocationTargetException exception) {
            throw new JsonProcessingException(exception);
        }
    }

    public void configure(Object object, boolean bl) {
        if (object instanceof SerializationFeature && (SerializationFeature)((Object)object) == SerializationFeature.INDENT_OUTPUT) {
            this.indentOutput = bl;
        }
        if (object instanceof JsonParser.Feature && (JsonParser.Feature)((Object)object) == JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES) {
            this.allowUnquotedFieldNames = bl;
        }
    }

    public JsonNode readTree(String string) throws JsonProcessingException, JsonMappingException {
        JsonParser jsonParser = this.createParser(string);
        try {
            return this.readTree(jsonParser);
        }
        catch (IOException iOException) {
            throw new JsonProcessingException(iOException.getMessage(), iOException);
        }
    }

    public JsonNode readTree(JsonParser jsonParser) throws IOException {
        return jsonParser.readValueAsTree();
    }

    public <T> T readValue(String string, Class<T> clazz) throws IOException {
        return this.readValue(new StringReader(string), clazz);
    }

    public JsonParser createParser(Reader reader) {
        JsonParser jsonParser = new JsonParser(reader);
        jsonParser.setCodec(this);
        if (this.allowUnquotedFieldNames) {
            jsonParser.setAllowUnquotedFieldNames(this.allowUnquotedFieldNames);
        }
        return jsonParser;
    }

    public <T> T readValue(byte[] byArray, Class<T> clazz) throws IOException {
        try (InputStreamReader inputStreamReader = new InputStreamReader(new ByteArrayInputStream(byArray));){
            T t = this.readValue(inputStreamReader, clazz);
            return t;
        }
    }

    public <T> T readValue(Reader reader, Class<T> clazz) throws IOException {
        Object object;
        block26: {
            if (clazz == HashMap.class || clazz == Object.class) {
                JsonParser jsonParser = this.createParser(reader);
                Map map = null;
                boolean bl = true;
                List list = new ArrayList();
                Stack<Object> stack = new Stack<Object>();
                String string = null;
                while (!jsonParser.isClosed()) {
                    switch (jsonParser.nextToken()) {
                        case START_OBJECT: {
                            Object object2 = new LinkedHashMap();
                            if (bl) {
                                list.add(object2);
                                stack.push(list);
                            } else {
                                map.put(string, object2);
                                stack.push(map);
                            }
                            map = (Map)object2;
                            bl = false;
                            break;
                        }
                        case END_OBJECT: 
                        case END_ARRAY: {
                            Object object2 = stack.pop();
                            if (object2 instanceof List) {
                                list = (List)object2;
                                bl = true;
                                break;
                            }
                            map = (Map)object2;
                            bl = false;
                            break;
                        }
                        case START_ARRAY: {
                            Object object2 = new ArrayList();
                            if (bl) {
                                list.add(object2);
                                stack.push(list);
                            } else {
                                map.put(string, object2);
                                stack.push(map);
                            }
                            list = (List)object2;
                            bl = true;
                            break;
                        }
                        case FIELD_NAME: {
                            string = jsonParser.getText();
                            break;
                        }
                        case VALUE_STRING: {
                            if (bl) {
                                list.add(jsonParser.getValueAsString());
                                break;
                            }
                            map.put(string, jsonParser.getValueAsString());
                            break;
                        }
                        case VALUE_TRUE: 
                        case VALUE_FALSE: {
                            if (bl) {
                                list.add(jsonParser.getValueAsBoolean());
                                break;
                            }
                            map.put(string, jsonParser.getValueAsBoolean());
                            break;
                        }
                        case VALUE_NULL: {
                            if (bl) {
                                list.add(null);
                                break;
                            }
                            map.put(string, null);
                            break;
                        }
                        case VALUE_NUMBER_FLOAT: 
                        case VALUE_NUMBER_INT: {
                            if (bl) {
                                list.add(jsonParser.getNumberValue());
                                break;
                            }
                            map.put(string, jsonParser.getNumberValue());
                        }
                    }
                }
                return (T)list.get(0);
            }
            try {
                object = clazz.getAnnotation(JsonDeserialize.class).using();
                if (object != null) {
                    JsonParser jsonParser = this.createParser(reader);
                    DeserializationContext deserializationContext = new DeserializationContext();
                    Constructor constructor = ((Class)object).getDeclaredConstructor(new Class[0]);
                    constructor.setAccessible(true);
                    Object t = constructor.newInstance(new Object[0]);
                    Method method = ((Class)object).getDeclaredMethod("deserialize", JsonParser.class, DeserializationContext.class);
                    method.setAccessible(true);
                    Object object3 = method.invoke(((Class)object).cast(t), jsonParser, deserializationContext);
                    return (T)object3;
                }
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | NullPointerException exception) {
                if (exception instanceof NullPointerException) {
                    JsonNode jsonNode = this.readTree(reader);
                    return this.treeToValue(jsonNode, clazz);
                }
                throw new JsonProcessingException(exception);
            }
            catch (InvocationTargetException invocationTargetException) {
                RuntimeException runtimeException = (RuntimeException)invocationTargetException.getTargetException();
                if (!(runtimeException instanceof IllegalArgumentException)) break block26;
                throw runtimeException;
            }
        }
        object = this.createParser(reader);
        return this.treeToValue(((JsonParser)object).readValueAsTree(), clazz);
    }

    public JsonNode readTree(Reader reader) throws JsonProcessingException, IOException {
        JsonParser jsonParser = this.createParser(reader);
        return jsonParser.readValueAsTree();
    }

    public JsonGenerator createGenerator(Writer writer) throws IOException {
        JsonGenerator jsonGenerator = new JsonGenerator(writer);
        if (this.indentOutput) {
            jsonGenerator.useDefaultPrettyPrinter();
        }
        return jsonGenerator;
    }

    public JsonGenerator createGenerator(OutputStream outputStream) throws IOException {
        return this.createGenerator(new OutputStreamWriter(outputStream));
    }

    static {
        WRAPPER_TYPE_MAP.put(Integer.class, Integer.TYPE);
        WRAPPER_TYPE_MAP.put(Byte.class, Byte.TYPE);
        WRAPPER_TYPE_MAP.put(Character.class, Character.TYPE);
        WRAPPER_TYPE_MAP.put(Boolean.class, Boolean.TYPE);
        WRAPPER_TYPE_MAP.put(Double.class, Double.TYPE);
        WRAPPER_TYPE_MAP.put(Float.class, Float.TYPE);
        WRAPPER_TYPE_MAP.put(Long.class, Long.TYPE);
        WRAPPER_TYPE_MAP.put(Short.class, Short.TYPE);
        WRAPPER_TYPE_MAP.put(Void.class, Void.TYPE);
    }
}

