/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.jr.stree.util;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonStreamContext;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.base.ParserMinimalBase;
import com.fasterxml.jackson.jr.stree.JrsArray;
import com.fasterxml.jackson.jr.stree.JrsNumber;
import com.fasterxml.jackson.jr.stree.JrsObject;
import com.fasterxml.jackson.jr.stree.JrsValue;
import com.fasterxml.jackson.jr.stree.PackageVersion;
import com.fasterxml.jackson.jr.stree.util.JrsValueCursor;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;

public class JrsTreeTraversingParser
extends ParserMinimalBase {
    protected ObjectCodec _objectCodec;
    protected JrsValueCursor _nodeCursor;
    protected JsonToken _nextToken;
    protected boolean _startContainer;
    protected boolean _closed;

    public JrsTreeTraversingParser(JrsValue jrsValue) {
        this(jrsValue, null);
    }

    public JrsTreeTraversingParser(JrsValue jrsValue, ObjectCodec objectCodec) {
        super(0);
        this._objectCodec = objectCodec;
        if (jrsValue.isArray()) {
            this._nextToken = JsonToken.START_ARRAY;
            this._nodeCursor = new JrsValueCursor.ArrayCursor((JrsArray)jrsValue, null);
        } else if (jrsValue.isObject()) {
            this._nextToken = JsonToken.START_OBJECT;
            this._nodeCursor = new JrsValueCursor.ObjectCursor((JrsObject)jrsValue, null);
        } else {
            this._nodeCursor = new JrsValueCursor.RootCursor(jrsValue, null);
        }
    }

    public void setCodec(ObjectCodec objectCodec) {
        this._objectCodec = objectCodec;
    }

    public ObjectCodec getCodec() {
        return this._objectCodec;
    }

    public Version version() {
        return PackageVersion.VERSION;
    }

    public void close() throws IOException {
        if (!this._closed) {
            this._closed = true;
            this._nodeCursor = null;
            this._currToken = null;
        }
    }

    public JsonToken nextToken() throws IOException {
        if (this._nextToken != null) {
            this._currToken = this._nextToken;
            this._nextToken = null;
            return this._currToken;
        }
        if (this._startContainer) {
            this._startContainer = false;
            if (!this._nodeCursor.currentHasChildren()) {
                this._currToken = this._currToken == JsonToken.START_OBJECT ? JsonToken.END_OBJECT : JsonToken.END_ARRAY;
                return this._currToken;
            }
            this._nodeCursor = this._nodeCursor.iterateChildren();
            this._currToken = this._nodeCursor.nextToken();
            if (this._currToken == JsonToken.START_OBJECT || this._currToken == JsonToken.START_ARRAY) {
                this._startContainer = true;
            }
            return this._currToken;
        }
        if (this._nodeCursor == null) {
            this._closed = true;
            return null;
        }
        this._currToken = this._nodeCursor.nextToken();
        if (this._currToken != null) {
            if (this._currToken == JsonToken.START_OBJECT || this._currToken == JsonToken.START_ARRAY) {
                this._startContainer = true;
            }
            return this._currToken;
        }
        this._currToken = this._nodeCursor.endToken();
        this._nodeCursor = this._nodeCursor.getParent();
        return this._currToken;
    }

    public JsonParser skipChildren() throws IOException {
        if (this._currToken == JsonToken.START_OBJECT) {
            this._startContainer = false;
            this._currToken = JsonToken.END_OBJECT;
        } else if (this._currToken == JsonToken.START_ARRAY) {
            this._startContainer = false;
            this._currToken = JsonToken.END_ARRAY;
        }
        return this;
    }

    public boolean isClosed() {
        return this._closed;
    }

    public String getCurrentName() {
        return this._nodeCursor == null ? null : this._nodeCursor.getCurrentName();
    }

    public void overrideCurrentName(String string) {
        if (this._nodeCursor != null) {
            this._nodeCursor.overrideCurrentName(string);
        }
    }

    public JsonStreamContext getParsingContext() {
        return this._nodeCursor;
    }

    public JsonLocation getTokenLocation() {
        return JsonLocation.NA;
    }

    public JsonLocation getCurrentLocation() {
        return JsonLocation.NA;
    }

    public String getText() {
        if (this._closed) {
            return null;
        }
        switch (this._currToken) {
            case FIELD_NAME: {
                return this._nodeCursor.getCurrentName();
            }
            case VALUE_STRING: 
            case VALUE_NUMBER_INT: 
            case VALUE_NUMBER_FLOAT: {
                return this.currentNode().asText();
            }
        }
        return this._currToken == null ? null : this._currToken.asString();
    }

    public char[] getTextCharacters() throws IOException {
        return this.getText().toCharArray();
    }

    public int getTextLength() throws IOException {
        return this.getText().length();
    }

    public int getTextOffset() throws IOException {
        return 0;
    }

    public boolean hasTextCharacters() {
        return false;
    }

    public JsonParser.NumberType getNumberType() throws IOException {
        JrsNumber jrsNumber = this.currentNumericNode();
        return jrsNumber == null ? null : ((JrsValue)jrsNumber).numberType();
    }

    public BigInteger getBigIntegerValue() throws IOException {
        return this.currentNumericNode().asBigInteger();
    }

    public BigDecimal getDecimalValue() throws IOException {
        return this.currentNumericNode().asBigDecimal();
    }

    public double getDoubleValue() throws IOException {
        return this.currentNumericValue().doubleValue();
    }

    public float getFloatValue() throws IOException {
        return (float)this.currentNumericValue().doubleValue();
    }

    public long getLongValue() throws IOException {
        return this.currentNumericValue().longValue();
    }

    public int getIntValue() throws IOException {
        return this.currentNumericValue().intValue();
    }

    public Number getNumberValue() throws IOException {
        return this.currentNumericValue();
    }

    public Object getEmbeddedObject() {
        return null;
    }

    public byte[] getBinaryValue(Base64Variant base64Variant) throws IOException {
        return null;
    }

    public int readBinaryValue(Base64Variant base64Variant, OutputStream outputStream) throws IOException {
        return -1;
    }

    protected JrsValue currentNode() {
        if (this._closed || this._nodeCursor == null) {
            return null;
        }
        return this._nodeCursor.currentNode();
    }

    protected JrsNumber currentNumericNode() throws JsonParseException {
        JrsValue jrsValue = this.currentNode();
        if (jrsValue == null || !(jrsValue instanceof JrsNumber)) {
            JsonToken jsonToken = jrsValue == null ? null : jrsValue.asToken();
            throw this._constructError("Current token (" + jsonToken + ") not numeric, can not use numeric value accessors");
        }
        return (JrsNumber)jrsValue;
    }

    protected Number currentNumericValue() throws JsonParseException {
        return this.currentNumericNode().getValue();
    }

    protected void _handleEOF() throws JsonParseException {
        this._throwInternal();
    }
}

