/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.animation.timing.interpolation;

import java.lang.reflect.Method;
import org.jdesktop.animation.timing.interpolation.KeyValues;

class KeyValuesDouble
extends KeyValues<Double> {
    public KeyValuesDouble(double ... dArray) {
        super(dArray);
        for (double d : dArray) {
            this.values.add(d);
        }
    }

    @Override
    public Class<?> getType() {
        return Double.TYPE;
    }

    @Override
    public void setValue(Object object, Method method, int n, int n2, float f) {
        double d;
        if (n == n2) {
            d = (Double)this.values.get(n);
        } else {
            double d2 = (Double)this.values.get(n);
            double d3 = (Double)this.values.get(n2);
            d = d2 + (d3 - d2) * (double)f;
        }
        try {
            method.invoke(object, d);
        }
        catch (Exception exception) {
            System.out.println("Problem invoking method in KVDouble.setValue:" + exception);
        }
    }

    @Override
    public void setValue(Object object, Method method, int n) {
        try {
            method.invoke(object, this.values.get(n));
        }
        catch (Exception exception) {
            System.out.println("Problem invoking method in KVDouble.setValue:" + exception);
        }
    }
}

