/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.animation.timing.interpolation;

import java.lang.reflect.Method;
import org.jdesktop.animation.timing.TimingTarget;
import org.jdesktop.animation.timing.interpolation.PropertyRange;

public class ObjectModifier
implements TimingTarget {
    private PropertyRange propertyRange;
    private Object object;
    private Method propertySetter;
    private Method propertyGetter;

    public ObjectModifier(Object object, PropertyRange propertyRange) {
        this.object = object;
        this.propertyRange = propertyRange;
        try {
            this.setupMethodInfo();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalArgumentException("Bad property name (" + propertyRange.getPropertyName() + "): could not find an appropriate setter or getter method for that property");
        }
    }

    private void setupMethodInfo() throws NoSuchMethodException {
        String string = this.propertyRange.getPropertyName();
        String string2 = string.substring(0, 1);
        String string3 = string.substring(1);
        Class clazz = this.propertyRange.getType();
        String string4 = "set" + string2.toUpperCase() + string3;
        this.propertySetter = this.object.getClass().getMethod(string4, clazz);
        if (this.propertyRange.isToAnimation()) {
            String string5 = "get" + string2.toUpperCase() + string3;
            this.propertyGetter = this.object.getClass().getMethod(string5, new Class[0]);
        }
    }

    @Override
    public void begin() {
        if (this.propertyRange.isToAnimation()) {
            try {
                this.propertyRange.setStartValue(this.propertyGetter.invoke(this.object, new Object[0]));
            }
            catch (Exception exception) {
                System.out.println("Problem with propertySetter in ObjectModifier");
            }
        }
    }

    @Override
    public void end() {
    }

    @Override
    public void timingEvent(long l, long l2, float f) {
        try {
            this.propertyRange.setValue(this.object, this.propertySetter, f);
        }
        catch (Exception exception) {
            System.out.println("Problem in ObjectModifier.timingEvent: " + exception);
        }
    }
}

