/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.config.setup;

import java.io.Console;
import java.io.File;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import oracle.dbtools.common.config.Configurations;
import oracle.dbtools.common.config.ConfigurationsBuilder;
import oracle.dbtools.common.config.MutableConfigurations;
import oracle.dbtools.common.di.Factory;
import oracle.dbtools.common.util.Iterables;
import oracle.dbtools.common.util.Log;
import oracle.dbtools.common.util.NullOrEmpty;
import oracle.dbtools.plugin.api.cmdline.CommandProvider;
import oracle.dbtools.plugin.api.cmdline.annotations.Command;
import oracle.dbtools.plugin.api.di.annotations.Provides;
import oracle.dbtools.plugin.api.i18n.annotations.TranslatableText;
import oracle.dbtools.rt.config.setup.ConfigurationBuilder;
import oracle.dbtools.rt.config.setup.InstallParams;
import oracle.dbtools.rt.config.setup.SchemaSetup;
import oracle.dbtools.rt.config.setup.Setup;
import oracle.dbtools.rt.config.setup.SetupMessages;
import oracle.dbtools.rt.config.setup.VerifySchema;

@Provides
@Command(name="migrateV2", description=@TranslatableText(type=SetupMessages.class, id=""), documented=false)
public class MigrateV2
implements CommandProvider {
    private final MutableConfigurations confs;
    private final Factory factory;
    private final File war;
    private static final Log LOG = Log.get(MigrateV2.class);
    private boolean resetOrdsPublicPwd;
    private boolean resetSysUser;
    private boolean resetSysdbaPwd;

    @Inject
    MigrateV2(MutableConfigurations confs, @Named(value="war") File war, Factory factory) {
        this.confs = confs;
        this.war = war;
        this.factory = factory;
    }

    public void execute(Map<String, Object> values) throws Exception {
        MutableConfigurations existing = this.confs;
        int totalConfigs = Iterables.size((Iterable)existing);
        if (totalConfigs >= 2) {
            boolean pu_file_exists = false;
            for (String name : existing) {
                if (!name.endsWith("_pu")) continue;
                pu_file_exists = true;
                break;
            }
            if (!pu_file_exists) {
                this.migrate(values);
            }
        } else {
            throw new Exception("Invalid number of config files, total configs=" + totalConfigs);
        }
    }

    private void migrate(Map<String, Object> values) throws Exception {
        Configurations currConfigs;
        Map<String, String> installParams;
        boolean preserveParamFile = false;
        if (values.get("preserveParamFile") != null) {
            preserveParamFile = (Boolean)values.get("preserveParamFile");
        }
        if ((installParams = InstallParams.getInstallParameters(this.war, (String)values.get("installtype"), (String)values.get("paramfile"), (String)values.get("logDir"))) == null) {
            throw new Exception(SetupMessages.getString("ERR_INSTALL_PARAMS"));
        }
        if (InstallParams.simpleInstall(installParams)) {
            this.resetOrdsPublicPwd = NullOrEmpty.nullOrEmpty((CharSequence)installParams.get("user.public.password"));
            this.resetSysUser = NullOrEmpty.nullOrEmpty((CharSequence)installParams.get("sys.user"));
            this.resetSysdbaPwd = NullOrEmpty.nullOrEmpty((CharSequence)installParams.get("sys.password"));
        } else {
            this.resetOrdsPublicPwd = true;
            this.resetSysUser = true;
            this.resetSysdbaPwd = true;
        }
        Console console = System.console();
        LOG.info(SetupMessages.format("MIGRATE_V2", installParams.get("product.name")));
        MutableConfigurations existing = this.confs;
        ConfigurationsBuilder cb = ConfigurationsBuilder.builder((Configurations)existing);
        ConfigurationBuilder defaults = ConfigurationBuilder.defaults((Configurations)existing);
        cb.configuration("defaults", defaults.build());
        for (String name : existing) {
            if (name.equals("defaults")) continue;
            cb.configuration(name, ConfigurationBuilder.builder(defaults, (Configurations)existing, name).build());
        }
        Configurations fullConfigs = currConfigs = cb.build();
        for (String confName : existing) {
            if (confName.equals("defaults") || confName.endsWith("_al") || confName.endsWith("_rt")) continue;
            String connInfo = VerifySchema.getDBConnInfo(fullConfigs, confName);
            LOG.console("\n" + SetupMessages.format("INFO_MIGRATE_CONFIG2", confName, connInfo) + "\n");
            currConfigs = fullConfigs = Setup.restfulServicesConf(console, currConfigs, confName, installParams);
            boolean isInstallSchema = Boolean.valueOf(installParams.get("rest.services.ords.add"));
            if (!isInstallSchema) continue;
            VerifySchema.setInstallParamValues(fullConfigs, confName, installParams);
            SchemaSetup.schemaParams(console, this.war, installParams);
            if (!preserveParamFile) {
                InstallParams.writeInstallProperties(installParams);
            }
            try {
                SchemaSetup.install(installParams, (Class)values.get("installer"), this.factory);
            }
            catch (Exception e) {
                LOG.warning(e.getLocalizedMessage());
            }
            this.resetParamValues(installParams);
        }
        this.confs.update(fullConfigs);
    }

    private void resetParamValues(Map<String, String> params) {
        if (params != null) {
            if (this.resetSysUser) {
                params.put("sys.user", null);
            }
            if (this.resetSysdbaPwd) {
                params.put("sys.password", null);
            }
            if (this.resetOrdsPublicPwd) {
                params.put("user.public.password", null);
            }
        }
    }
}

