/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.config.setup;

import java.io.Console;
import java.io.File;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import oracle.dbtools.common.config.Configurations;
import oracle.dbtools.common.config.MutableConfigurations;
import oracle.dbtools.common.di.Factory;
import oracle.dbtools.common.util.Log;
import oracle.dbtools.common.util.Maps;
import oracle.dbtools.common.util.NullOrEmpty;
import oracle.dbtools.plugin.api.cmdline.CommandProvider;
import oracle.dbtools.plugin.api.cmdline.annotations.Command;
import oracle.dbtools.plugin.api.cmdline.annotations.Option;
import oracle.dbtools.plugin.api.conf.Configuration;
import oracle.dbtools.plugin.api.di.annotations.Provides;
import oracle.dbtools.plugin.api.i18n.annotations.TranslatableText;
import oracle.dbtools.rt.config.setup.InstallParams;
import oracle.dbtools.rt.config.setup.SchemaSetup;
import oracle.dbtools.rt.config.setup.Setting;
import oracle.dbtools.rt.config.setup.SetupMessages;

@Provides
@Command(name="validate", description=@TranslatableText(type=SetupMessages.class, id="VALIDATE_DESCR"), options={@Option(name="database", description=@TranslatableText(type=SetupMessages.class, id="VALIDATE_DB_OPTION")), @Option(name="parameterFile", description=@TranslatableText(type=SetupMessages.class, id="PARAMETERFILE")), @Option(name="logDir", description=@TranslatableText(type=SetupMessages.class, id="INSTALL_LOGDIR")), @Option(name="silent", hasArgument=false, description=@TranslatableText(type=SetupMessages.class, id="SILENT_OPTION"))})
public class Validate
implements CommandProvider {
    private final MutableConfigurations confs;
    private final Factory factory;
    private final File war;
    private static Setting PORT = Setting.setting("DB_SERVER_PORT", "db.port", "1521");
    private static Setting SERVER = Setting.setting("DB_SERVER_NAME", "db.hostname", "localhost");
    private static Setting SERVICE_NAME = Setting.setting("DB_SERVICE_NAME", "db.servicename", null);
    private static final Setting SERVICE_OR_SID = Setting.setting("DB_CHOOSE_SID_OR_SERVICE", null, "1", false, "1", "2");
    private static Setting SID = Setting.setting("DB_SERVICE_ID", "db.sid", "xe");
    private static final Log LOG = Log.get(Validate.class);
    private static boolean isSilentMode;

    @Inject
    Validate(MutableConfigurations confs, @Named(value="war") File war, Factory factory) {
        this.confs = confs;
        this.war = war;
        this.factory = factory;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute(Map<String, Object> values) throws Exception {
        Class type;
        String dbName = (String)values.get("database");
        String paramFile = (String)values.get("parameterFile");
        String promptMode = null;
        if (values.containsKey("silent")) {
            isSilentMode = true;
            promptMode = "simple";
        } else {
            promptMode = "advanced";
        }
        Map<String, String> installParams = InstallParams.getInstallParameters(this.war, promptMode, paramFile, (String)values.get("logDir"));
        if (installParams == null) {
            throw new Exception(SetupMessages.getString("ERR_INSTALL_PARAMS"));
        }
        Console console = System.console();
        MutableConfigurations existing = this.confs;
        if (dbName != null) {
            String confName = dbName.toLowerCase() + "_pu";
            if (existing.get(confName) == null) throw new Exception(SetupMessages.format("ERR_INVALID_DBCONFIG", dbName, confName));
            Validate.setParamValues((Configurations)existing, installParams, confName);
        } else {
            this.databaseInfo(console, installParams);
        }
        String dbUrl = SchemaSetup.getDbUrl(installParams);
        if (!SchemaSetup.getValidateParams(console, installParams, dbUrl) || NullOrEmpty.nullOrEmpty((CharSequence)installParams.get("installer")) || !installParams.get("installer").equals("cdb.validate") && !installParams.get("installer").equals("validate") || (type = (Class)values.get("installer")) == null) return;
        CommandProvider installProvider = (CommandProvider)this.factory.newInstance(type);
        Map requiredValues = (Map)Maps.builder().add((Object)"install.params", installParams).build();
        try {
            installProvider.execute(requiredValues);
            return;
        }
        catch (Exception e) {
            LOG.warning(e.getMessage());
        }
    }

    private void databaseInfo(Console console, Map<String, String> installParams) throws Exception {
        block8: {
            try {
                this.settingValue(console, installParams, "db.hostname", SERVER);
                this.settingValue(console, installParams, "db.port", PORT);
                if (installParams.containsKey("db.servicename")) {
                    this.settingValue(console, installParams, "db.servicename", SERVICE_NAME);
                    break block8;
                }
                if (installParams.containsKey("db.sid")) {
                    this.settingValue(console, installParams, "db.sid", SID);
                    break block8;
                }
                if (console != null) {
                    String choice = SERVICE_OR_SID.prompt(console, new String[0]);
                    if ("1".equals(choice)) {
                        this.settingValue(console, installParams, "db.servicename", SERVICE_NAME);
                    } else {
                        this.settingValue(console, installParams, "db.sid", SID);
                    }
                    break block8;
                }
                if (isSilentMode) {
                    String keys = "db.servicename or db.sid";
                    LOG.warning(SetupMessages.format("ERR_MISSING_VALUE_SIMPLE", keys));
                    return;
                }
                LOG.warning(SetupMessages.getString("ERR_NO_CONSOLE_ADVANCED"));
                return;
            }
            catch (Exception e) {
                LOG.warning(e.getMessage());
                return;
            }
        }
    }

    private String settingValue(Console console, Map<String, String> installParams, String key, Setting setting) throws Exception {
        String val = installParams.get(key);
        if (console != null) {
            if (!isSilentMode || NullOrEmpty.nullOrEmpty((CharSequence)val)) {
                if (!NullOrEmpty.nullOrEmpty((CharSequence)val)) {
                    setting.setDefaultValue(val);
                }
                val = setting.prompt(console, new String[0]);
                installParams.put(key, val);
            }
        } else if (isSilentMode) {
            if (NullOrEmpty.nullOrEmpty((CharSequence)val)) {
                throw new Exception(SetupMessages.format("ERR_MISSING_VALUE_SIMPLE", key));
            }
        } else {
            throw new Exception(SetupMessages.getString("ERR_NO_CONSOLE_ADVANCED"));
        }
        return val;
    }

    public static void setParamValues(Configurations existing, Map<String, String> installParams, String confName) {
        Configuration def = existing.get("defaults");
        Configuration conf = existing.get(confName);
        if (conf != null) {
            String value = !NullOrEmpty.nullOrEmpty((CharSequence)conf.get("db.hostname")) ? conf.get("db.hostname") : def.get("db.hostname");
            installParams.put("db.hostname", value);
            value = !NullOrEmpty.nullOrEmpty((CharSequence)conf.get("db.port")) ? conf.get("db.port") : def.get("db.port");
            installParams.put("db.port", value);
            value = !NullOrEmpty.nullOrEmpty((CharSequence)conf.get("db.servicename")) ? conf.get("db.servicename") : def.get("db.servicename");
            installParams.put("db.servicename", value);
            value = !NullOrEmpty.nullOrEmpty((CharSequence)conf.get("db.sid")) ? conf.get("db.sid") : def.get("db.sid");
            installParams.put("db.sid", value);
        }
    }
}

