/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.lifecycle;

class MetaClass<T> {
    private ClassLoader loader;
    private String className;
    private T instance;

    public MetaClass(T instance) {
        this.instance = instance;
        Class<?> c = instance.getClass();
        this.className = c.getName();
        this.loader = c.getClassLoader();
    }

    public MetaClass(ClassLoader loader, String className) {
        this.loader = loader;
        this.className = className;
        this.instance = null;
    }

    public T getInstance() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (this.instance == null) {
            this.instance = Class.forName(this.className, true, this.loader).newInstance();
        }
        return this.instance;
    }

    public boolean equals(Object obj) {
        if (obj instanceof MetaClass) {
            MetaClass mc = (MetaClass)obj;
            return this.className.equals(mc.className) && this.loader.equals(mc.loader);
        }
        return false;
    }

    public int hashCode() {
        int hash = 42;
        hash = 37 * hash + this.className.hashCode();
        hash = 37 * hash + this.loader.hashCode();
        return hash;
    }

    public String toString() {
        return "MetaClass[" + this.className + ", " + this.loader + "]";
    }
}

