/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.logging;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import oracle.adf.share.codesharing.audit.annotation.CodeSharingSafe;

public class ADFLoggerConstants {
    public static final String ADF_MODEL_COMPONENT = "oracle.adf.model";
    public static final String ADF_CONTROLLER_COMPONENT = "oracle.adf.controller";
    public static final String ADF_VIEW_COMPONENT = "oracle.adf.view";
    public static final String ADF_MDS_COMPONENT = "oracle.adf.mds";
    public static final String ADF_COMMON_COMPONENT = "oracle.adf.common";
    public static final String SHOW_LEVEL_PROPERTY = "oracle.adfdiagnostics.ConsoleFormatter.ShowLevel";
    public static final String SHOW_TIMESTAMP_PROPERTY = "oracle.adfdiagnostics.ConsoleFormatter.ShowTimeStamp";
    public static final String ADF_REQUEST_SINGLE_LOGGER = "oracle.adfdiagnostics";
    public static final String CONTEXT_MAP_STRING_DELIMITER = ";#;";
    public static final String CONTEXT_MAP_COMPONENT_NAME_KEY = "Component";
    public static final String COMPONENT_NAME_MATCHER_REGEX = "Component=";
    public static final String COMPONENT_NAME_MATCHER_REGEX_CASE_1 = "Component=(.*?)$";
    public static final String COMPONENT_NAME_MATCHER_REGEX_CASE_2 = "Component=(.*?);#;";
    @CodeSharingSafe(value="MutableStaticField")
    static final Map<String, String> components = ADFLoggerConstants.setADFComponents();
    @CodeSharingSafe(value="MutableStaticField")
    public static final Set<String> ADF_COMPONENETS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("oracle.adf.model", "oracle.adf.controller", "oracle.adf.view", "oracle.adf.mds", "oracle.adf.common")));
    static final String ADF_MESSAGE_CONTEXT_DATA = "ADF_MESSAGE_CONTEXT_DATA";
    static final String ENTERING_TAG = "begin";
    static final String ADF_MESSAGE_ACTION_NAME = "ADF_MESSAGE_ACTION_NAME";
    static final String ADF_MESSAGE_ACTION_DESC = "ADF_MESSAGE_ACTION_DESC";
    static final String ADF_MESSAGE_STATUS = "ADF_MESSAGE_STATUS";
    static final String ADF_MESSAGE_DEFAULT_CONTEXT_DATA = "ADF_MESSAGE_DEFAULT_CONTEXT_DATA";
    static final String ADF_COMPONENT_NAME = "Component";
    static final String ADD_CONTEXT_DATA_TAG = "add_context_data";
    static final String EXITING_TAG = "end";
    static final String ADD_CONTEXT_DATA = "addContextData";
    static final String PARENT_REQUEST_ECID = "PARENT_REQUEST_ECID";

    public static Map<String, String> getADFComponents() {
        return components;
    }

    private static Map<String, String> setADFComponents() {
        HashMap<String, String> comp = new HashMap<String, String>();
        comp.put(".model", ADF_MODEL_COMPONENT);
        comp.put(".jbo", ADF_MODEL_COMPONENT);
        comp.put(".view", ADF_VIEW_COMPONENT);
        comp.put(".faces", ADF_VIEW_COMPONENT);
        comp.put(".mds", ADF_MDS_COMPONENT);
        comp.put(".share", ADF_COMMON_COMPONENT);
        comp.put(".controller", ADF_CONTROLLER_COMPONENT);
        return Collections.unmodifiableMap(comp);
    }
}

