/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.ecid;

import java.lang.reflect.Method;
import javax.servlet.http.HttpServletRequest;
import oracle.dbtools.common.UnrecoverableException;
import oracle.dbtools.common.ecid.ECID;
import oracle.dbtools.common.ecid.ECIDPrincipal;
import oracle.dbtools.common.util.CharSequenceMixin;
import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.common.util.Identifiers;
import oracle.dbtools.common.util.NullOrEmpty;

public abstract class ECIDPrincipals {
    public static final String ECID_PRINCIPAL = "ECID-Principal";

    public static ECID ecid() {
        ECID ecid = ECIDPrincipals.appServerEcid();
        if (ecid == null) {
            ecid = new RandomECID();
        }
        return ecid;
    }

    public static String ecid(CompoundPrincipal principal) {
        ECIDPrincipal ecid = principal.principal(ECIDPrincipal.class);
        if (ecid == null) {
            throw new IllegalStateException();
        }
        return ecid.getName();
    }

    @Deprecated
    public static CompoundPrincipal ecidPrincipal(CompoundPrincipal principal) {
        ECIDPrincipal ecid = principal.principal(ECIDPrincipal.class);
        if (ecid == null) {
            ecid = ECIDPrincipals.ecidPrincipal();
            return principal.replace(ECIDPrincipal.class, ecid);
        }
        return principal;
    }

    public static ECIDPrincipal ecidPrincipal(HttpServletRequest request, boolean create) {
        ECIDPrincipal ecidPrincipal = (ECIDPrincipal)request.getAttribute(ECID_PRINCIPAL);
        if (ecidPrincipal == null) {
            if (create) {
                ecidPrincipal = ECIDPrincipals.ecidPrincipal();
                request.setAttribute(ECID_PRINCIPAL, (Object)ecidPrincipal);
            } else {
                throw new IllegalStateException();
            }
        }
        return ecidPrincipal;
    }

    static ECIDPrincipal ecidPrincipal() {
        ECID ecid = ECIDPrincipals.ecid();
        return new ECIDPrincipal(ecid);
    }

    private static ECID appServerEcid() {
        return ECIDPrincipals.weblogicEcid();
    }

    private static Object invoke(String className, String methodName) {
        try {
            Class<?> clazz = Class.forName(className);
            Method m = clazz.getMethod(methodName, new Class[0]);
            return m.invoke(null, new Object[0]);
        }
        catch (Throwable t) {
            throw UnrecoverableException.unrecoverable(t);
        }
    }

    private static ECID weblogicEcid() {
        try {
            Object result = ECIDPrincipals.invoke("weblogic.diagnostics.context.DiagnosticContextHelper", "getContextId");
            String text = (String)result;
            if (NullOrEmpty.nullOrEmpty(text)) {
                return null;
            }
            return new WebLogicECID(text);
        }
        catch (UnrecoverableException e) {
            return null;
        }
    }

    private static class WebLogicECID
    extends CharSequenceMixin
    implements ECID {
        private static final long serialVersionUID = -1416353379254613751L;

        public WebLogicECID(String text) {
            super(text);
        }
    }

    private static class RandomECID
    extends CharSequenceMixin
    implements ECID {
        private static final long serialVersionUID = 3593382990853152491L;

        public RandomECID() {
            super(Identifiers.randomIdentifier());
        }
    }
}

