/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.timing;

import java.util.Objects;
import oracle.dbtools.common.timing.ExecutionTimer;
import oracle.dbtools.common.timing.ExecutionTimerReport;
import oracle.dbtools.common.timing.ExecutionTiming;
import oracle.dbtools.common.timing.ExecutionTimingEvent;
import oracle.dbtools.common.timing.TimingPoint;
import oracle.dbtools.common.util.Timestamps;

public class ExecutionTimerImpl
implements ExecutionTimer {
    private final TimingPoint timingPoint;
    private final ExecutionTimerReport report;

    ExecutionTimerImpl(ExecutionTimerReport report, TimingPoint timingPoint) {
        Objects.requireNonNull(report);
        Objects.requireNonNull(timingPoint);
        this.report = report;
        this.timingPoint = timingPoint;
    }

    @Override
    public TimingPoint timingPoint() {
        return this.timingPoint;
    }

    @Override
    public ExecutionTiming start() {
        return new ExecutionTimingImpl(this.report.start(this.timingPoint));
    }

    private class ExecutionTimingImpl
    implements ExecutionTiming {
        private long duration;
        private final ExecutionTimingEvent event;

        ExecutionTimingImpl(ExecutionTimingEvent event) {
            this.event = event;
        }

        @Override
        public long startTime() {
            return this.event.start();
        }

        @Override
        public long stop() {
            this.duration = this.event.stop();
            return this.duration;
        }

        @Override
        public ExecutionTimer timer() {
            return ExecutionTimerImpl.this;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("[");
            builder.append(ExecutionTimerImpl.this.timingPoint);
            builder.append(", ");
            builder.append(Timestamps.toString(this.startTime()));
            if (this.duration != -1L) {
                builder.append(", ");
                builder.append(this.duration);
                builder.append("ms");
            }
            builder.append("]");
            return builder.toString();
        }
    }
}

