/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;

public abstract class HexDump {
    private static final int BYTES_PER_LINE = 16;
    private static final char[] HEX_CHARS = "0123456789ABCDEF".toCharArray();
    private static final int SPACER = 4;

    private HexDump() {
    }

    public static String dump(byte[] bytes) throws IOException {
        return HexDump.dump(new ByteArrayInputStream(bytes));
    }

    public static String dump(InputStream bytes) throws IOException {
        StringBuilder text = new StringBuilder();
        byte[] buf = new byte[16];
        int read = bytes.read(buf);
        while (read != -1) {
            String hex = HexDump.encode(buf);
            text.append(hex);
            text.append(HexDump.ascii(buf));
            Arrays.fill(buf, (byte)0);
            read = bytes.read(buf);
            text.append('\n');
        }
        return text.toString();
    }

    private static String ascii(byte[] bytes) {
        char[] chars = new char[bytes.length];
        Arrays.fill(chars, '.');
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            if (b < 32 || b > 126) continue;
            chars[i] = (char)b;
        }
        return new String(chars);
    }

    private static String encode(byte[] bytes) {
        char[] chars = new char[3 * bytes.length + bytes.length / 4];
        int i = 0;
        int j = 0;
        while (i < bytes.length) {
            chars[j] = HEX_CHARS[(bytes[i] & 0xF0) >>> 4];
            chars[++j] = HEX_CHARS[bytes[i] & 0xF];
            chars[++j] = 32;
            if (HexDump.isDivisible(i + 1, 4)) {
                chars[++j] = 32;
            }
            ++i;
            ++j;
        }
        return new String(chars);
    }

    private static boolean isDivisible(int index, int divsor) {
        return index != 0 && index % divsor == 0;
    }
}

