/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.rdf.server;

import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.LinkedList;
import oracle.spatial.rdf.server.SPARQLBGP;
import oracle.spatial.rdf.server.SQLGenContext;
import oracle.spatial.rdf.server.SelectivityEstimator;
import oracle.spatial.rdf.server.TriplesBlock;

public interface SelectivityOptimizer {
    public Plan optimize(SQLGenContext var1, SPARQLBGP var2) throws SQLException;

    public static interface Op {
        public void accept(OpVisitor var1);

        public static class Join
        implements Op {
            final Type type;
            final Op left;
            final Op right;

            public Join(Type type, Op op, Op op2) {
                this.type = type;
                this.left = op;
                this.right = op2;
            }

            public Type getType() {
                return this.type;
            }

            public Op getLeft() {
                return this.left;
            }

            public Op getRight() {
                return this.right;
            }

            @Override
            public void accept(OpVisitor opVisitor) {
                opVisitor.visit(this);
            }

            public int hashCode() {
                int n = 31;
                int n2 = 17;
                n2 = n2 * n + this.getType().hashCode();
                n2 = n2 * n + this.getLeft().hashCode();
                n2 = n2 * n + this.getRight().hashCode();
                return n2;
            }

            public boolean equals(Object object) {
                if (object == this) {
                    return true;
                }
                if (object instanceof Join) {
                    Join join = (Join)object;
                    return this.getType() == join.getType() && this.getLeft().equals(join.getLeft()) && this.getRight().equals(join.getRight());
                }
                return false;
            }

            public static enum Type {
                HASH("USE_HASH"),
                NL("USE_NL"),
                MERGE("USE_MERGE");

                private final String name;

                private Type(String string2) {
                    this.name = string2;
                }

                public String getName() {
                    return this.name;
                }
            }
        }

        public static class Access
        implements Op {
            private final Type type;
            private final Op data;

            public Access(Type type, Op op) {
                this.type = type;
                this.data = op;
            }

            public Type getType() {
                return this.type;
            }

            public Op getData() {
                return this.data;
            }

            @Override
            public void accept(OpVisitor opVisitor) {
                opVisitor.visit(this);
            }

            public int hashCode() {
                int n = 31;
                int n2 = 17;
                n2 = n2 * n + this.getType().hashCode();
                n2 = n2 * n + this.getData().hashCode();
                return n2;
            }

            public boolean equals(Object object) {
                if (object == this) {
                    return true;
                }
                if (object instanceof Access) {
                    Access access = (Access)object;
                    return this.getType() == access.getType() && this.getData().equals(access.getData());
                }
                return false;
            }

            public static enum Type {
                FULL("FULL"),
                INDEX("INDEX");

                private final String name;

                private Type(String string2) {
                    this.name = string2;
                }

                public String getName() {
                    return this.name;
                }
            }
        }

        public static class Data
        implements Op {
            private final SelectivityEstimator.Stats stats;
            private final TriplesBlock triple;

            public Data(SelectivityEstimator.Stats stats) {
                this.stats = stats;
                this.triple = stats.getTriple();
            }

            public TriplesBlock getTriple() {
                return this.triple;
            }

            public SelectivityEstimator.Stats getStats() {
                return this.stats;
            }

            public BigDecimal getSelectivity() {
                return this.stats.getSelectivity();
            }

            public long getNumMatching() {
                return this.stats.getNumMatching();
            }

            @Override
            public void accept(OpVisitor opVisitor) {
                opVisitor.visit(this);
            }

            public int hashCode() {
                return this.triple.hashCode();
            }

            public boolean equals(Object object) {
                if (object == this) {
                    return true;
                }
                if (object instanceof Data) {
                    Data data = (Data)object;
                    return this.triple.equals(data.getTriple());
                }
                return false;
            }
        }
    }

    public static interface OpVisitor {
        public void visit(Op.Data var1);

        public void visit(Op.Access var1);

        public void visit(Op.Join var1);
    }

    public static class Plan {
        private final Op executionRoot;

        public Plan(Op op) {
            this.executionRoot = op;
        }

        public Op getExecutionRoot() {
            return this.executionRoot;
        }

        public int getNumJoins() {
            LinkedList<Op> linkedList = new LinkedList<Op>();
            linkedList.add(this.executionRoot);
            int n = 0;
            while (!linkedList.isEmpty()) {
                Op op = (Op)linkedList.remove();
                if (op instanceof Op.Access) {
                    linkedList.add(((Op.Access)op).getData());
                    continue;
                }
                if (!(op instanceof Op.Join)) continue;
                linkedList.add(((Op.Join)op).getLeft());
                linkedList.add(((Op.Join)op).getRight());
                ++n;
            }
            return n;
        }
    }
}

