/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.theme;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dms.instrument.PhaseEvent;
import oracle.jdbc.OracleResultSet;
import oracle.mapviewer.share.util.LogFactory;
import oracle.mapviewer.share.util.SensorCreator;
import oracle.ord.im.OrdImage;
import oracle.sdovis.CacheMgr2;
import oracle.sdovis.DataException;
import oracle.sdovis.JSDOGeometry;
import oracle.sdovis.LocalTheme;
import oracle.sdovis.MapMaker;
import oracle.sdovis.RSBundle;
import oracle.sdovis.SRS;
import oracle.sdovis.SRSCache;
import oracle.sdovis.StyledFeatureI;
import oracle.sdovis.Theme;
import oracle.sdovis.Unpickle81;
import oracle.sdovis.VisContext;
import oracle.sdovis.cache.CacheGroup;
import oracle.sdovis.ds.DSManager;
import oracle.sdovis.ds.DSUtil;
import oracle.sdovis.query.SDOBoxFilter;
import oracle.sdovis.theme.ImageThemeDefinition;
import oracle.sdovis.theme.ThemeDataProducer;
import oracle.sdovis.util.JDBCUtil;
import oracle.sdovis.util.TopThemeQueries;
import oracle.sdovis.util.Util;
import oracle.sql.BFILE;
import oracle.sql.BLOB;

public class ImageThemeProducer
implements ThemeDataProducer {
    private static final Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    private static final PhaseEvent imageSensor = SensorCreator.createPhaseEvent(SensorCreator.NounsEnum.THEMEPRODUCER, "Image", "Producer", "Time spent preparing data");
    protected Theme owner;
    private ImageThemeDefinition def;
    private byte[][] images;
    private double[][] mbrs;
    private PreparedStatement pstmt = null;
    private String currentKey = null;
    private long maxFeaturesToBePrepared = -1L;

    public ImageThemeProducer(Theme t) {
        this.owner = t;
        this.def = (ImageThemeDefinition)t.getDefinition();
        if (this.def.predefined) {
            Connection conn = null;
            try {
                conn = DSUtil.getDBConnection(this.def.getDataSourceName(), null);
                this.def.cacheSubRegionName = CacheMgr2.getSubRegionName(conn);
                CacheMgr2.createImageGroup(this.def.cacheSubRegionName, this.def.cacheGroupName);
                this.def.query = this.defineQuery(false);
            }
            catch (Exception ex) {
                log.severe(ex.getMessage());
                throw new IllegalArgumentException(ex.getMessage());
            }
            finally {
                if (conn != null) {
                    try {
                        DSUtil.closeDBConnection(conn, this.def.getDataSourceName());
                    }
                    catch (Exception e) {
                        log.warning(e.getMessage());
                    }
                }
            }
        }
    }

    @Override
    public Theme getTheme() {
        return this.owner;
    }

    @Override
    public int size() {
        return this.images == null ? 0 : this.images.length;
    }

    @Override
    public void setStyledFeatures(StyledFeatureI[] sfs) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int prepareData(Rectangle2D queryWin, VisContext vc) throws DataException {
        long tokenI = 0L;
        try {
            tokenI = imageSensor.start();
            int numimages = 0;
            double xl = queryWin.getMinX();
            double yl = queryWin.getMinY();
            double xh = queryWin.getMaxX();
            double yh = queryWin.getMaxY();
            boolean fullExtent = false;
            if (xl == Double.NEGATIVE_INFINITY || yl == Double.NEGATIVE_INFINITY || xh == Double.POSITIVE_INFINITY || yh == Double.POSITIVE_INFINITY) {
                fullExtent = true;
            }
            Connection conn = null;
            try {
                conn = DSUtil.getDBConnection(this.def.getDataSourceName(), vc);
            }
            catch (Exception e) {
                throw new DataException("cannot obtain a connection to database.");
            }
            double xi = xl;
            double xf = xh;
            double yi = yl;
            double yf = yh;
            double masterScale = vc.getCurrentScale();
            if (vc.getMasterSRID() > 0 && this.def.getSrid() > 0 && this.def.getSrid() != vc.getMasterSRID() && masterScale != Double.POSITIVE_INFINITY && masterScale != Double.NEGATIVE_INFINITY) {
                double[] inmbr = new double[]{xl, yl, xh, yh};
                double[] outmbr = Util.convertMBR(inmbr, vc.getMasterSRID(), this.def.getSrid(), conn);
                if (outmbr != null) {
                    xl = outmbr[0];
                    yl = outmbr[1];
                    xh = outmbr[2];
                    yh = outmbr[3];
                } else {
                    vc.processDataError(null, log, "Conversion of SRIDs returned null.");
                    int n = 0;
                    return n;
                }
            }
            if (masterScale != Double.POSITIVE_INFINITY && masterScale != Double.NEGATIVE_INFINITY) {
                double factor = Math.abs(yh - yl) / Math.abs(yf - yi);
                log.finer("[Master scale] " + masterScale + " [Scale factor for theme " + this.getTheme().getName() + "] " + factor);
                double scale = masterScale * factor;
                if (this.getTheme().getScaleType() == "RATIO") {
                    double centery;
                    double centerx;
                    SRSCache sc = DSManager.getSRSCache(this.def.getDataSourceName());
                    SRS srs = sc.get(this.def.getSrid());
                    if (vc.getMasterSRID() > 0 && this.def.getSrid() > 0 && this.def.getSrid() != vc.getMasterSRID()) {
                        srs = sc.get(vc.getMasterSRID());
                        centerx = (xi + xf) / 2.0;
                        centery = (yi + yf) / 2.0;
                        factor = 1.0;
                    } else {
                        centerx = (xl + xh) / 2.0;
                        centery = (yl + yh) / 2.0;
                    }
                    if (vc.isTileRequest() && srs.isGeodetic()) {
                        centerx = 0.0;
                        centery = 0.0;
                    }
                    if (srs != null) {
                        scale = Math.round(srs.getRatioScale(masterScale * factor, new Point2D.Double(centerx, centery)));
                        log.finer("Ratio scale to compare: " + scale);
                    } else {
                        try {
                            if (conn != null) {
                                DSUtil.closeDBConnection(conn, this.def.getDataSourceName());
                            }
                        }
                        catch (Exception ex) {
                            log.warning(ex.getMessage());
                        }
                        vc.processDataError(null, log, "Theme must have SRS when using ratio scale mode.");
                        int n = 0;
                        return n;
                    }
                }
                if (!this.getTheme().withinRenderScaleLimits(scale)) {
                    log.warning("Scale definition for theme " + this.getTheme().getName() + " is out of range.");
                    try {
                        if (conn != null) {
                            DSUtil.closeDBConnection(conn, this.def.getDataSourceName());
                        }
                    }
                    catch (Exception ex) {
                        log.warning(ex.getMessage());
                    }
                    int n = 0;
                    return n;
                }
            }
            if (this.getTheme().getDecorator().getWorkspaceName() != null) {
                try {
                    if (this.getTheme().getDecorator().getWorkspaceName() != null) {
                        if (this.getTheme().getDecorator().getWorkspaceDate() != null) {
                            Util.gotoWorkspaceDate(conn, this.getTheme().getDecorator().getWorkspaceName(), this.getTheme().getDecorator().getWorkspaceDate(), this.getTheme().getDecorator().getWorkspaceDateFormat(), this.getTheme().getDecorator().getWorkspaceDateNlsParam(), this.getTheme().getDecorator().isWorkspaceDateTsWtz());
                        } else if (this.getTheme().getDecorator().getWorkspaceSavedPoint() != null) {
                            Util.gotoWorkspaceSavedPoint(conn, this.getTheme().getDecorator().getWorkspaceName(), this.getTheme().getDecorator().getWorkspaceSavedPoint());
                        } else {
                            Util.gotoWorkspace(conn, this.getTheme().getDecorator().getWorkspaceName());
                        }
                    }
                }
                catch (Exception e) {
                    String err = "Cannot go to workspace " + this.getTheme().getDecorator().getWorkspaceName();
                    if (this.getTheme().getDecorator().getWorkspaceDate() != null) {
                        err = err + ", Date " + this.getTheme().getDecorator().getWorkspaceDate();
                    } else if (this.getTheme().getDecorator().getWorkspaceSavedPoint() != null) {
                        err = err + ", Saved Point " + this.getTheme().getDecorator().getWorkspaceSavedPoint();
                    }
                    vc.processDataError(e, log, err);
                    int n = 0;
                    imageSensor.stop(tokenI);
                    return n;
                }
            }
            try {
                if (!this.def.passThrough) {
                    if (MapMaker.isSpecial(xl, yl, xh, yh) && vc.getRotation() != 0.0) {
                        log.warning("Rotation is currently ignored for full extent.");
                    } else if (vc.getRotation() != 0.0 && !MapMaker.isSpecial(xl, yl, xh, yh)) {
                        if (vc.getRotation() < -360.0 && vc.getRotation() > 360.0) {
                            log.warning("Rotation value must be in between -360 to 360 degrees. ignored");
                        } else {
                            double[] rmbr = Util.rotateMBR(xl, yl, xh, yh, vc.getRotation());
                            if (rmbr != null) {
                                xl = Math.min(rmbr[0], xl);
                                yl = Math.min(rmbr[1], yl);
                                xh = Math.max(rmbr[2], xh);
                                yh = Math.max(rmbr[3], yh);
                                log.finest("Rotation angle: " + vc.getRotation());
                                log.finest("Search window for rotation: " + xl + "," + yl + "," + xh + "," + yh);
                            } else {
                                log.info("Rotated MBR is null. Rotation ignored.");
                            }
                        }
                    }
                }
                if (!this.def.predefined) {
                    Rectangle2D.Double winQuery = new Rectangle2D.Double(xl, yl, 0.0, 0.0);
                    winQuery.add(xh, yh);
                    String qry = this.rewriteQuery(winQuery, fullExtent);
                    if (!Util.isQueryAllowed(qry)) {
                        vc.processDataError(null, log, "Invalid query!");
                        int n = 0;
                        return n;
                    }
                    log.info("[ImageTheme] query:  " + qry);
                    numimages = this.loadImagesFromDB(qry, xl, yl, xh, yh, conn, vc);
                } else {
                    this.def.query = this.defineQuery(fullExtent);
                    numimages = this.loadImagesFromDBCached(xl, yl, xh, yh, conn, vc, fullExtent);
                }
            }
            catch (Exception e) {
                vc.processDataError(e, log, null);
                numimages = 0;
            }
            finally {
                if (this.getTheme().getDecorator().getWorkspaceName() != null) {
                    try {
                        Util.gotoWorkspace(conn, "LIVE");
                    }
                    catch (Exception ex) {
                        log.warning(ex.getMessage());
                    }
                }
                if (conn != null) {
                    try {
                        DSUtil.closeDBConnection(conn, this.def.getDataSourceName());
                    }
                    catch (Exception ex) {
                        log.warning(ex.getMessage());
                    }
                }
            }
            int n = numimages;
            return n;
        }
        finally {
            imageSensor.stop(tokenI);
        }
    }

    @Override
    public void postPreparation(VisContext vc) {
    }

    @Override
    public StyledFeatureI getStyledFeature(int idx) {
        return null;
    }

    @Override
    public double[] getDataMBR() {
        if (this.mbrs == null || this.mbrs.length == 0) {
            return null;
        }
        RectangularShape r2d = null;
        for (int i = 0; i < this.mbrs.length; ++i) {
            double[] mbr = this.mbrs[i];
            if (r2d == null) {
                r2d = new Rectangle2D.Double(mbr[0], mbr[1], 0.0, 0.0);
            } else {
                ((Rectangle2D)r2d).add(mbr[0], mbr[1]);
            }
            ((Rectangle2D)r2d).add(mbr[2], mbr[3]);
        }
        double[] res = new double[]{r2d.getMinX(), r2d.getMinY(), r2d.getMaxX(), r2d.getMaxY()};
        return res;
    }

    @Override
    public StyledFeatureI[] getStyledFeatures() {
        return null;
    }

    @Override
    public LocalTheme getSelectedFeaturesAsTheme(Rectangle2D window, String name) {
        return null;
    }

    @Override
    public StyledFeatureI[] getSelectedFeatures(Rectangle2D window) {
        return null;
    }

    public byte[][] getImages() {
        return this.images;
    }

    public void setImages(byte[][] imgs) {
        this.images = imgs;
    }

    public double[][] getMBRs() {
        return this.mbrs;
    }

    public void setImageMBRs(double[][] mbrs) {
        this.mbrs = mbrs;
    }

    @Override
    public void destroy() {
        int i;
        if (this.images != null) {
            for (i = 0; i < this.images.length; ++i) {
                this.images[i] = null;
            }
        }
        if (this.mbrs != null) {
            for (i = 0; i < this.mbrs.length; ++i) {
                this.mbrs[i] = null;
            }
        }
        this.images = null;
        this.mbrs = null;
        try {
            if (this.def.predefined && this.pstmt != null) {
                this.pstmt.close();
            }
        }
        catch (Exception ex) {
            log.warning(ex.getMessage());
        }
    }

    @Override
    public void abort() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int loadImagesFromDB(String qry, double x1, double y1, double x2, double y2, Connection conn, VisContext vc) throws SQLException, IOException {
        int n;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        Vector<byte[]> images_ = new Vector<byte[]>(3);
        Vector<double[]> mbrs_ = new Vector<double[]>(3);
        long t1 = 0L;
        long t2 = 0L;
        try {
            stmt = conn.prepareStatement(qry);
            stmt.setFetchSize(this.owner.getFetchSize());
            log.finer("Fetch size: " + stmt.getFetchSize());
            t1 = System.currentTimeMillis();
            rs = stmt.executeQuery();
            t2 = System.currentTimeMillis();
            ResultSetMetaData meta = rs.getMetaData();
            String columnType = meta.getColumnTypeName(1);
            if (columnType.toUpperCase().indexOf("BLOB") < 0 && columnType.toUpperCase().indexOf("ORDIMAGE") < 0) {
                log.severe(RSBundle.getMsg("MAPVIEWER-01042"));
                int n2 = 0;
                return n2;
            }
            while (rs.next() && (this.maxFeaturesToBePrepared <= 0L || (long)mbrs_.size() < this.maxFeaturesToBePrepared)) {
                BLOB blob = null;
                OrdImage imageProxy = null;
                if (columnType.toUpperCase().indexOf("ORDIMAGE") > -1) {
                    imageProxy = (OrdImage)((OracleResultSet)rs).getORAData(1, OrdImage.getORADataFactory());
                    if (imageProxy == null) {
                        log.finest("Image column is null for current row.");
                        continue;
                    }
                } else {
                    blob = JDBCUtil.safeCastBLOB(((OracleResultSet)rs).getBlob(1));
                    if (blob == null) {
                        log.finest("Image column is null for current row.");
                        continue;
                    }
                }
                JSDOGeometry geom = null;
                if (this.getTheme().getDecorator().isFastUnpickle()) {
                    byte[] bytes = ((OracleResultSet)rs).getBytes(2);
                    try {
                        geom = Unpickle81.unpickle(bytes);
                    }
                    catch (Exception ex) {
                        log.severe(ex.getMessage());
                    }
                } else {
                    try {
                        geom = JDBCUtil.loadGeometry(rs, 2, false);
                    }
                    catch (Exception ex) {
                        log.log(Level.WARNING, "cannot load geometry due to exception.", ex);
                    }
                }
                if (geom == null) {
                    log.finest("Null MBR geometry for current row.");
                    continue;
                }
                if (columnType.toUpperCase().indexOf("ORDIMAGE") > -1) {
                    byte[] data = null;
                    if (!imageProxy.isLocal()) {
                        BFILE bfile = imageProxy.getBFILE();
                        long length = bfile.length();
                        bfile.open();
                        InputStream in = bfile.getBinaryStream();
                        data = new byte[(int)length];
                        int byte_read = in.read(data);
                        bfile.close();
                    } else {
                        data = imageProxy.getDataInByteArray();
                    }
                    images_.add(data);
                } else {
                    images_.add(ImageThemeProducer.readBLOB(blob));
                    blob = null;
                }
                if (vc.getMasterSRID() > 0 && this.def.getSrid() > 0 && this.def.getSrid() != vc.getMasterSRID()) {
                    double[] outmbr = Util.convertMBR(geom.getMBR(), this.def.getSrid(), vc.getMasterSRID(), conn);
                    mbrs_.add(outmbr);
                    continue;
                }
                mbrs_.add(geom.getMBR());
            }
            this.images = new byte[images_.size()][];
            this.mbrs = new double[mbrs_.size()][];
            for (int i = 0; i < this.images.length; ++i) {
                this.images[i] = (byte[])images_.get(i);
                this.mbrs[i] = (double[])mbrs_.get(i);
            }
            images_.clear();
            images_ = null;
            mbrs_.clear();
            mbrs_ = null;
            long t3 = System.currentTimeMillis();
            log.info("[ " + this.def.name + " ] sql exec time: " + (t2 - t1) + "ms, loading time for " + this.images.length + " images: " + (t3 - t2) + "ms.");
            TopThemeQueries.add(t3 - t1, this.getTheme().getName(), this.getTheme().getDataSourceName(), qry, "Image objects loaded = " + this.images.length);
            n = this.images.length;
        }
        catch (Exception ee) {
            log.severe(ee.getMessage());
            images_.clear();
            images_ = null;
            mbrs_.clear();
            mbrs_ = null;
            int n3 = 0;
            return n3;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception e) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception e) {}
            }
            if (conn != null) {
                try {
                    DSUtil.closeDBConnection(conn, this.def.getDataSourceName());
                }
                catch (Exception e) {}
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int loadImagesFromDBCached(double x1, double y1, double x2, double y2, Connection conn, VisContext vc, boolean fullExtent) throws SQLException, IOException {
        Statement ps = null;
        ResultSet rs = null;
        Vector<byte[]> images_ = new Vector<byte[]>(3);
        Vector<double[]> mbrs_ = new Vector<double[]>(3);
        long t1 = 0L;
        long t2 = 0L;
        try {
            this.pstmt = this.prepareImageFetchStmt(conn);
            log.finest("[ImageTheme p] query=" + this.def.getImageQuery());
            ps = conn.prepareStatement(this.def.getImageQuery());
            boolean asis = this.def.passThrough;
            if (this.def.mSRule != null) {
                asis = this.def.mSRule.isQueryPassThrough();
            }
            if (!asis && !fullExtent) {
                ps.setDouble(1, x1);
                ps.setDouble(2, y1);
                ps.setDouble(3, x2);
                ps.setDouble(4, y2);
            }
            this.pstmt.setFetchSize(this.owner.getFetchSize());
            ps.setFetchSize(this.owner.getFetchSize());
            log.finer("Fetch size: " + ps.getFetchSize());
            t1 = System.currentTimeMillis();
            rs = ps.executeQuery();
            t2 = System.currentTimeMillis();
            CacheMgr2.createImageGroup(this.def.cacheSubRegionName, this.def.cacheGroupName);
            CacheGroup cg = CacheMgr2.getGroup(this.def.cacheSubRegionName, this.def.cacheGroupName);
            while (rs.next() && (this.maxFeaturesToBePrepared <= 0L || (long)mbrs_.size() < this.maxFeaturesToBePrepared)) {
                byte[] img;
                this.currentKey = rs.getString(1);
                if (this.currentKey == null || this.currentKey.length() == 0) {
                    log.finest("Key column value is empty for current row");
                    continue;
                }
                byte[] byArray = img = cg != null ? (byte[])cg.get(this.currentKey) : null;
                if (img == null && (img = this.loadImageBlock(this.currentKey)) != null && cg != null) {
                    cg.put(this.currentKey, img, img.length);
                }
                if (img == null) {
                    log.warning("cannot load image for key: " + this.currentKey);
                    continue;
                }
                JSDOGeometry geom = null;
                if (this.getTheme().getDecorator().isFastUnpickle()) {
                    byte[] bytes = ((OracleResultSet)rs).getBytes(2);
                    try {
                        geom = Unpickle81.unpickle(bytes);
                    }
                    catch (Exception ex) {
                        log.severe(ex.getMessage());
                    }
                } else {
                    try {
                        geom = JDBCUtil.loadGeometry(rs, 2, false);
                    }
                    catch (Exception ex) {
                        log.severe(ex.getMessage());
                    }
                }
                if (geom == null) {
                    log.warning("null geometry in the current image row.");
                    continue;
                }
                images_.add(img);
                if (vc.getMasterSRID() > 0 && this.def.getSrid() > 0 && this.def.getSrid() != vc.getMasterSRID()) {
                    double[] outmbr = Util.convertMBR(geom.getMBR(), this.def.getSrid(), vc.getMasterSRID(), conn);
                    mbrs_.add(outmbr);
                    continue;
                }
                mbrs_.add(geom.getMBR());
            }
            this.images = new byte[images_.size()][];
            this.mbrs = new double[mbrs_.size()][];
            for (int i = 0; i < this.images.length; ++i) {
                this.images[i] = (byte[])images_.get(i);
                this.mbrs[i] = (double[])mbrs_.get(i);
            }
            images_.clear();
            images_ = null;
            mbrs_.clear();
            mbrs_ = null;
            long t3 = System.currentTimeMillis();
            log.info("[ " + this.def.name + " ] sql exec time: " + (t2 - t1) + "ms, loading time for " + this.images.length + " images: " + (t3 - t2) + "ms.");
            TopThemeQueries.add(t3 - t1, this.getTheme().getName(), this.getTheme().getDataSourceName(), this.def.getImageQuery(), "Image objects loaded = " + this.images.length);
            int n = this.images.length;
            return n;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception e) {}
            }
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Exception e) {}
            }
            if (this.pstmt != null) {
                try {
                    this.pstmt.close();
                }
                catch (Exception e) {}
            }
            if (conn != null) {
                try {
                    DSUtil.closeDBConnection(conn, this.def.getDataSourceName());
                }
                catch (Exception e) {}
            }
        }
    }

    public static byte[] readBLOB(BLOB blob) throws SQLException, IOException {
        if (blob == null) {
            return null;
        }
        long len = blob.length();
        return blob.getBytes(1L, (int)len);
    }

    protected String rewriteQuery(Rectangle2D queryWin, boolean fullExtent) {
        double xl = queryWin.getMinX();
        double yl = queryWin.getMinY();
        double xh = queryWin.getMaxX();
        double yh = queryWin.getMaxY();
        if (this.def.passThrough || fullExtent) {
            return this.def.query;
        }
        String filter = this.getFilter(this.def.imageColumn, this.def.mbrColumn, this.def.getSrid(), xl, yl, xh, yh, this.def.is9i());
        return "SELECT * FROM ( " + this.def.query + " ) WHERE " + filter;
    }

    final String getFilter(String imageColumn, String mbrColumn, int srid, double xl, double yl, double xh, double yh, boolean is9i) {
        StringBuffer sb = new StringBuffer(256);
        boolean geodetic = Util.isGeodetic(srid);
        if (is9i && geodetic) {
            sb.append("MDSYS.SDO_FILTER(" + mbrColumn + ", ");
            sb.append("MDSYS.SDO_CS.VIEWPORT_TRANSFORM(");
            sb.append("MDSYS.SDO_GEOMETRY( 2003, 0, NULL, MDSYS.SDO_ELEM_INFO_ARRAY(1, 1003, 3), MDSYS.SDO_ORDINATE_ARRAY(" + xl + "," + yl + "," + xh + "," + yh + "))" + ", " + srid + " ), " + "'querytype=WINDOW') = 'TRUE'");
            return sb.toString();
        }
        sb.append("MDSYS.SDO_FILTER(" + mbrColumn + ", " + "MDSYS.SDO_GEOMETRY(2003, ");
        if (srid == 0) {
            sb.append("NULL");
        } else {
            sb.append(srid);
        }
        sb.append(", NULL, MDSYS.SDO_ELEM_INFO_ARRAY(1, 1003, 3), MDSYS.SDO_ORDINATE_ARRAY(" + xl + "," + yl + "," + xh + "," + yh + ")), " + "'querytype=WINDOW') = 'TRUE'");
        return sb.toString();
    }

    private String defineQuery(boolean fullExtent) {
        String filter = SDOBoxFilter.getGenericFilterPredicate(this.def.mbrColumn, this.def.srid, this.def.is9i, null);
        String subQuery = "SELECT " + this.def.mKeyColumn + ", " + this.def.mbrColumn + " " + " FROM " + this.def.mBaseTable;
        String cond = this.def.mSRule != null ? this.def.mSRule.getFeatureCond() : null;
        boolean asis = this.def.passThrough;
        if (this.def.mSRule != null) {
            asis = this.def.mSRule.isQueryPassThrough();
        }
        if (filter != null && !asis && !fullExtent) {
            subQuery = subQuery + " WHERE " + filter;
            if (cond != null) {
                subQuery = subQuery + " AND " + cond;
            }
        } else if (cond != null) {
            subQuery = subQuery + " WHERE " + cond;
        }
        return subQuery;
    }

    public PreparedStatement prepareImageFetchStmt(Connection conn) throws SQLException {
        return conn.prepareStatement("select " + this.def.imageColumn + " FROM " + this.def.mBaseTable + " WHERE " + this.def.mKeyColumn + "=?");
    }

    public PreparedStatement getImageFetchStmt() {
        return this.pstmt;
    }

    public String getCurrentKey() {
        return this.currentKey;
    }

    private byte[] loadImageBlock(String key) {
        OracleResultSet ors = null;
        try {
            PreparedStatement ps = this.getImageFetchStmt();
            ps.setString(1, key);
            ors = (OracleResultSet)ps.executeQuery();
            ResultSetMetaData meta = ors.getMetaData();
            String columnType = meta.getColumnTypeName(1);
            if (ors.next()) {
                if (columnType.toUpperCase().indexOf("ORDIMAGE") > -1) {
                    OrdImage imageProxy = (OrdImage)ors.getORAData(1, OrdImage.getORADataFactory());
                    if (imageProxy == null) {
                        return null;
                    }
                    byte[] data = null;
                    if (!imageProxy.isLocal()) {
                        BFILE bfile = imageProxy.getBFILE();
                        long length = bfile.length();
                        bfile.open();
                        InputStream in = bfile.getBinaryStream();
                        data = new byte[(int)length];
                        int byte_read = in.read(data);
                        bfile.close();
                    } else {
                        data = imageProxy.getDataInByteArray();
                    }
                    return data;
                }
                BLOB blob = JDBCUtil.safeCastBLOB(ors.getBlob(1));
                return ImageThemeProducer.readBLOB(blob);
            }
            return null;
        }
        catch (Exception e) {
            log.severe(e.getMessage());
            return null;
        }
    }

    @Override
    public StyledFeatureI getNewStyledFeatureInstance() {
        return null;
    }

    @Override
    public long getMaxFeaturesToBePrepared() {
        return this.maxFeaturesToBePrepared;
    }

    @Override
    public void setMaxFeaturesToBePrepared(long size) {
        this.maxFeaturesToBePrepared = size;
    }
}

