/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webbrowser;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import javax.swing.Icon;
import oracle.ide.config.ChangeEventSource;
import oracle.ideimpl.webbrowser.BrowserArb;
import oracle.ideimpl.webbrowser.BrowserInfo;
import oracle.ideimpl.webbrowser.BrowserRunner;
import oracle.ideimpl.webbrowser.osx.MacBrowserUtil;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.ListStructure;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.Copyable;
import oracle.javatools.util.PlatformUtils;

public final class BrowserOptions
extends ChangeEventSource
implements Copyable {
    public static final String KEY_SETTINGS = "WebBrowserOptions";
    private static final String BROWSER_CMD_LINE = "browserCmdLine";
    private static final String USE_EMBEDDED_BROWSER_FOR_PREVIEW = "useEmbeddedBrowserForPreview";
    private static final String BROWSER_IS_DEFAULT_LIST = "browserIsDefaultList";
    private static final String BROWSER_NAME_LIST = "browserNameList";
    private static final String BROWSER_PATH_LIST = "browserPathList";
    private static final String BROWSER_PARAM_LIST = "browserParamList";
    private static final String BROWSER_ICON_LIST = "browserIconList";
    public static final int EMBEDDED_BROWSER_INDEX = -1;
    static final String IE_DISP_LABEL = BrowserArb.getString(73);
    static final String SAFARI_DISP_LABEL = BrowserArb.getString(74);
    static final String FIREFOX_DISP_LABEL = BrowserArb.getString(75);
    static final String CHROME_DISP_LABEL = BrowserArb.getString(76);
    static final String OPERA_DISP_LABEL = BrowserArb.getString(77);
    static final Object[][] DEFAULT_WINDOWS_BROWSERS = new Object[][]{{true, IE_DISP_LABEL, "C:\\Program Files\\Internet Explorer\\iexplore.exe", "${URL}", BrowserIconId.IE.toString()}};
    static final Object[][] DEFAULT_MAC_BROWSERS = new Object[][]{{true, SAFARI_DISP_LABEL, "/usr/bin/open", "-a safari ${URL}", BrowserIconId.SAFARI.toString()}};
    static final Object[][] DEFAULT_LINUX_BROWSERS = new Object[][]{{true, FIREFOX_DISP_LABEL, "/usr/bin/firefox", "${URL}", BrowserIconId.FIREFOX.toString()}};
    static final Object[][] DEFAULT_OTHER_BROWSERS = new Object[][]{{true, FIREFOX_DISP_LABEL, "firefox", "${URL}", BrowserIconId.FIREFOX.toString()}};

    public BrowserOptions() {
    }

    private BrowserOptions(HashStructure hash) {
        super(hash);
    }

    public static BrowserOptions getInstance(PropertyStorage prefs) {
        BrowserOptions options = new BrowserOptions(BrowserOptions.findOrCreate((PropertyStorage)prefs, (String)KEY_SETTINGS));
        if (options.needToPopulateBrowserList()) {
            options.popuplateBrowserList();
        }
        return options;
    }

    public String getBrowserCmdLine(URL url) {
        String browserCmdLine = this.getBrowserCmdLine();
        return this.substituteURL(browserCmdLine, url);
    }

    public String substituteURL(String input, URL url) {
        if (url == null) {
            return input;
        }
        String quotedUrl = "\"" + BrowserRunner.getPlatformTargetURLString(url) + "\"";
        return BrowserOptions.macroSubstitution(input, "${URL}", quotedUrl);
    }

    public static Icon getOracleIcon(String iconId) {
        if (BrowserIconId.IE.toString().equals(iconId)) {
            return OracleIcons.getIcon((String)"browserie.png");
        }
        if (BrowserIconId.FIREFOX.toString().equals(iconId)) {
            return OracleIcons.getIcon((String)"browserfirefox.png");
        }
        if (BrowserIconId.SAFARI.toString().equals(iconId)) {
            return OracleIcons.getIcon((String)"browsersafari.png");
        }
        if (BrowserIconId.CHROME.toString().equals(iconId)) {
            return OracleIcons.getIcon((String)"browserchrome.png");
        }
        if (BrowserIconId.OPERA.toString().equals(iconId)) {
            return OracleIcons.getIcon((String)"browser-op.png");
        }
        if (BrowserIconId.SEAMONKEY.toString().equals(iconId)) {
            return OracleIcons.getIcon((String)"browser-sm.png");
        }
        if (BrowserIconId.GENERIC.toString().equals(iconId)) {
            return OracleIcons.getIcon((String)"browsergeneric.png");
        }
        if (BrowserIconId.EMBEDDED.toString().equals(iconId)) {
            return OracleIcons.getIcon((String)"browser-em.png");
        }
        return OracleIcons.getIcon((String)"browsergeneric.png");
    }

    public String getBrowserCmdLine() {
        return this._hash.getString(BROWSER_CMD_LINE, "");
    }

    public void setBrowserCmdLine(String cmdLine) {
        this._hash.putString(BROWSER_CMD_LINE, cmdLine.trim());
    }

    public void setBrowserCmdLine(String browserPath, String browserParam) {
        if (browserPath == null || browserPath.isEmpty()) {
            this._hash.putString(BROWSER_CMD_LINE, "");
        } else if (browserParam == null || browserParam.isEmpty()) {
            this._hash.putString(BROWSER_CMD_LINE, browserPath);
        } else {
            this._hash.putString(BROWSER_CMD_LINE, browserPath + " " + browserParam);
        }
    }

    public BrowserInfo getPreviewBrowserInfo() {
        int defaultBrowserIdx = this.getPreviewBrowserIndex();
        if (defaultBrowserIdx == -1) {
            return BrowserInfo.EMBEDDED_BROWSER_INFO;
        }
        return this.getBrowserInfo(defaultBrowserIdx);
    }

    public BrowserInfo getBrowserInfo(int browserIndex) {
        String name = (String)this.getBrowserNameList().get(browserIndex);
        String path = (String)this.getBrowserPathList().get(browserIndex);
        String param = (String)this.getBrowserParamList().get(browserIndex);
        String iconId = (String)this.getBrowserIconList().get(browserIndex);
        return new BrowserInfo(name, path, param, iconId);
    }

    public boolean getUseEmbeddedBrowserForPreview() {
        return this._hash.getBoolean(USE_EMBEDDED_BROWSER_FOR_PREVIEW, false);
    }

    public void setUseEmbeddedBrowserForPreview(boolean useEmbeddedBrowserForPreview) {
        this._hash.putBoolean(USE_EMBEDDED_BROWSER_FOR_PREVIEW, useEmbeddedBrowserForPreview);
    }

    public ListStructure getBrowserIsDefaultList() {
        return this._hash.getListStructure(BROWSER_IS_DEFAULT_LIST);
    }

    public void setBrowserIsDefaultList(ListStructure isDefaultList) {
        this._hash.putListStructure(BROWSER_IS_DEFAULT_LIST, isDefaultList);
    }

    public ListStructure getBrowserNameList() {
        return this._hash.getListStructure(BROWSER_NAME_LIST);
    }

    public void setBrowserNameList(ListStructure nameList) {
        this._hash.putListStructure(BROWSER_NAME_LIST, nameList);
    }

    public ListStructure getBrowserPathList() {
        return this._hash.getListStructure(BROWSER_PATH_LIST);
    }

    public void setBrowserPathList(ListStructure pathList) {
        this._hash.putListStructure(BROWSER_PATH_LIST, pathList);
    }

    public ListStructure getBrowserParamList() {
        return this._hash.getListStructure(BROWSER_PARAM_LIST);
    }

    public void setBrowserParamList(ListStructure paramList) {
        this._hash.putListStructure(BROWSER_PARAM_LIST, paramList);
    }

    public ListStructure getBrowserIconList() {
        return this._hash.getListStructure(BROWSER_ICON_LIST);
    }

    public void setBrowserIconList(ListStructure browserIconList) {
        this._hash.putListStructure(BROWSER_ICON_LIST, browserIconList);
    }

    public int getPreviewBrowserIndex() {
        if (this.getUseEmbeddedBrowserForPreview()) {
            return -1;
        }
        return this.getDefaultBrowserIndex();
    }

    public int getDefaultBrowserIndex() {
        ListStructure isDefaultList = this.getBrowserIsDefaultList();
        if (isDefaultList != null) {
            for (int i = 0; i < isDefaultList.size(); ++i) {
                if (!((Boolean)isDefaultList.get(i)).booleanValue()) continue;
                return i;
            }
        }
        return 0;
    }

    public void setPreviewBrowserIndex(int newDefaultIndex) {
        if (newDefaultIndex == -1) {
            this.setUseEmbeddedBrowserForPreview(true);
        } else {
            ListStructure isDefaultList = this.getBrowserIsDefaultList();
            ListStructure newIsDefaultList = ListStructure.newInstance();
            newIsDefaultList.addAll((Collection)isDefaultList);
            for (int i = 0; i < newIsDefaultList.size(); ++i) {
                newIsDefaultList.set(i, (Object)(newDefaultIndex == i ? 1 : 0));
            }
            this.setBrowserIsDefaultList(newIsDefaultList);
            this.setUseEmbeddedBrowserForPreview(false);
        }
    }

    public static Object[][] getWindowsBrowsers() {
        String[][] BROWSERS_TO_BE_SEARCHED = new String[][]{{IE_DISP_LABEL, "iexplore.exe", "IEXPLORE.EXE", "${URL}", BrowserIconId.IE.toString()}, {FIREFOX_DISP_LABEL, "firefox.exe", "FIREFOX.EXE", "${URL}", BrowserIconId.FIREFOX.toString()}, {CHROME_DISP_LABEL, "chrome.exe", "Google Chrome", "${URL}", BrowserIconId.CHROME.toString()}, {SAFARI_DISP_LABEL, "safari.exe", "Safari.exe", "${URL}", BrowserIconId.SAFARI.toString()}, {OPERA_DISP_LABEL, "opera.exe", "Opera", "${URL}", BrowserIconId.OPERA.toString()}};
        String defaultBrowserPathLowerCase = BrowserRunner.getWindowsDefaultBrowserPath();
        defaultBrowserPathLowerCase = defaultBrowserPathLowerCase == null ? "" : defaultBrowserPathLowerCase.toLowerCase();
        ArrayList<Object[]> foundBrowsers = new ArrayList<Object[]>();
        boolean alreadySetDefaultBrowser = false;
        for (String[] browserCandidate : BROWSERS_TO_BE_SEARCHED) {
            boolean pathExists;
            String browserDispName = browserCandidate[0];
            String appPathName = browserCandidate[1];
            String startMenuInternetName = browserCandidate[2];
            String exeFilePath = BrowserRunner.getWindowsBrowserPath(startMenuInternetName, appPathName);
            String browserParam = browserCandidate[3];
            String browserIconName = browserCandidate[4];
            boolean bl = pathExists = exeFilePath == null ? false : new File(exeFilePath).exists();
            if (!pathExists) continue;
            boolean isDefaultBrowser = false;
            if (!alreadySetDefaultBrowser && defaultBrowserPathLowerCase.contains(appPathName.toLowerCase())) {
                isDefaultBrowser = true;
                alreadySetDefaultBrowser = true;
            }
            Object[] foundBrowser = new Object[]{isDefaultBrowser, browserDispName, exeFilePath, browserParam, browserIconName};
            foundBrowsers.add(foundBrowser);
        }
        if (!alreadySetDefaultBrowser && foundBrowsers.size() > 0) {
            ((Object[])foundBrowsers.get((int)0))[0] = true;
        }
        if (foundBrowsers.size() == 0) {
            return DEFAULT_WINDOWS_BROWSERS;
        }
        return (Object[][])foundBrowsers.toArray((T[])new Object[foundBrowsers.size()][5]);
    }

    public static Object[][] getMacBrowsers() {
        Set<MacBrowserUtil.BrowserName> browserNames = MacBrowserUtil.getWebBrowsers();
        MacBrowserUtil.BrowserName defaultBrowserName = MacBrowserUtil.getDefaultWebBrowser();
        Object[] safariBrowser = null;
        Object[] firefoxBrowser = null;
        Object[] chromeBrowser = null;
        Object[] operaBrowser = null;
        boolean alreadySetDefaultBrowser = false;
        ArrayList<Object[]> foundBrowsers = new ArrayList<Object[]>();
        for (MacBrowserUtil.BrowserName browserName : browserNames) {
            boolean isDefaultBrowser = false;
            if (defaultBrowserName == browserName) {
                alreadySetDefaultBrowser = true;
                isDefaultBrowser = true;
            }
            if (browserName == MacBrowserUtil.BrowserName.Safari) {
                safariBrowser = new Object[]{isDefaultBrowser, SAFARI_DISP_LABEL, "/usr/bin/open", "-a safari ${URL}", BrowserIconId.SAFARI.toString()};
                continue;
            }
            if (browserName == MacBrowserUtil.BrowserName.Firefox) {
                firefoxBrowser = new Object[]{isDefaultBrowser, FIREFOX_DISP_LABEL, "/usr/bin/open", "-a firefox ${URL}", BrowserIconId.FIREFOX.toString()};
                continue;
            }
            if (browserName == MacBrowserUtil.BrowserName.Chrome) {
                chromeBrowser = new Object[]{isDefaultBrowser, CHROME_DISP_LABEL, "/usr/bin/open", "-a \"Google Chrome\" ${URL}", BrowserIconId.CHROME.toString()};
                continue;
            }
            if (browserName != MacBrowserUtil.BrowserName.Opera) continue;
            operaBrowser = new Object[]{isDefaultBrowser, OPERA_DISP_LABEL, "/usr/bin/open", "-a opera ${URL}", BrowserIconId.OPERA.toString()};
        }
        if (safariBrowser != null) {
            foundBrowsers.add(safariBrowser);
        }
        if (firefoxBrowser != null) {
            foundBrowsers.add(firefoxBrowser);
        }
        if (chromeBrowser != null) {
            foundBrowsers.add(chromeBrowser);
        }
        if (operaBrowser != null) {
            foundBrowsers.add(operaBrowser);
        }
        if (!alreadySetDefaultBrowser && foundBrowsers.size() > 0) {
            ((Object[])foundBrowsers.get((int)0))[0] = true;
        }
        if (foundBrowsers.size() == 0) {
            return DEFAULT_MAC_BROWSERS;
        }
        return (Object[][])foundBrowsers.toArray((T[])new Object[foundBrowsers.size()][5]);
    }

    public static Object[][] getLinuxBrowsers() {
        String[][] BROWSERS_TO_BE_SEARCHED = new String[][]{{"Firefox", "firefox", "${URL}", BrowserIconId.FIREFOX.toString()}, {"Chrome", "chromium", "${URL}", BrowserIconId.CHROME.toString()}};
        ArrayList<Object[]> foundBrowsers = new ArrayList<Object[]>();
        for (String[] browserCandidate : BROWSERS_TO_BE_SEARCHED) {
            boolean pathExists;
            String exeFileName = browserCandidate[1];
            String exeFilePath = BrowserOptions.getLinuxBrowserPath(exeFileName);
            boolean bl = pathExists = exeFilePath == null ? false : new File(exeFilePath).exists();
            if (!pathExists) continue;
            Object[] foundBrowser = new Object[]{false, browserCandidate[0], exeFilePath, browserCandidate[2], browserCandidate[3]};
            foundBrowsers.add(foundBrowser);
        }
        if (foundBrowsers.size() > 0) {
            ((Object[])foundBrowsers.get((int)0))[0] = true;
        }
        if (foundBrowsers.size() == 0) {
            return DEFAULT_LINUX_BROWSERS;
        }
        return (Object[][])foundBrowsers.toArray((T[])new Object[foundBrowsers.size()][5]);
    }

    private static String getLinuxBrowserPath(String fileName) {
        String path = null;
        if ("firefox".equalsIgnoreCase(fileName)) {
            File f = new File("/usr/bin/firefox");
            if (f.exists()) {
                path = f.getAbsolutePath();
            }
            if ((f = new File("/usr/bin/mozilla-firefox")).exists()) {
                path = f.getAbsolutePath();
            }
            if ((f = new File("/usr/local/firefox/firefox")).exists()) {
                path = f.getAbsolutePath();
            }
            return path;
        }
        File f = new File("/usr/bin/" + fileName);
        if (f.exists()) {
            path = f.getAbsolutePath();
        }
        return path;
    }

    public boolean needToPopulateBrowserList() {
        return this.getBrowserIsDefaultList() == null || this.getBrowserIsDefaultList().size() == 0 || this.getBrowserNameList() == null || this.getBrowserNameList().size() == 0 || this.getBrowserPathList() == null || this.getBrowserPathList().size() == 0 || this.getBrowserParamList() == null || this.getBrowserParamList().size() == 0 || this.getBrowserIconList() == null || this.getBrowserIconList().size() == 0;
    }

    protected static Object[][] getAvailableBrowserList() {
        Object[][] browsers = null;
        browsers = PlatformUtils.isWindows() ? BrowserOptions.getWindowsBrowsers() : (PlatformUtils.isMac() ? BrowserOptions.getMacBrowsers() : (PlatformUtils.isLinux() ? BrowserOptions.getLinuxBrowsers() : DEFAULT_OTHER_BROWSERS));
        return browsers;
    }

    public void popuplateBrowserList() {
        ListStructure isDefaultList = ListStructure.newInstance();
        ListStructure nameList = ListStructure.newInstance();
        ListStructure pathList = ListStructure.newInstance();
        ListStructure paramList = ListStructure.newInstance();
        ListStructure iconList = ListStructure.newInstance();
        Object[][] browsers = BrowserOptions.getAvailableBrowserList();
        for (int i = 0; i < browsers.length; ++i) {
            isDefaultList.add(browsers[i][0]);
            nameList.add(browsers[i][1]);
            pathList.add(browsers[i][2]);
            paramList.add(browsers[i][3]);
            iconList.add(browsers[i][4]);
        }
        this.setBrowserIsDefaultList(isDefaultList);
        this.setBrowserNameList(nameList);
        this.setBrowserPathList(pathList);
        this.setBrowserParamList(paramList);
        this.setBrowserIconList(iconList);
        this.setUseEmbeddedBrowserForPreview(false);
        int defaultBrowserIndex = this.getDefaultBrowserIndex();
        String defaultBrowserPath = this.getBrowserPathList().get(defaultBrowserIndex).toString();
        String defaultBrowserParam = this.getBrowserParamList().get(defaultBrowserIndex).toString();
        this.setBrowserCmdLine(defaultBrowserPath, defaultBrowserParam);
    }

    private static String macroSubstitution(String str, String macro, String text) {
        int i;
        if (macro.equals(text)) {
            return str;
        }
        int ml = macro.length();
        int tl = text.length();
        while ((i = str.indexOf(macro)) >= 0) {
            int sl = str.length();
            StringBuffer sb = new StringBuffer(sl + tl - ml);
            if (i > 0) {
                sb.append(str.substring(0, i));
            }
            sb.append(text);
            if (i + ml < sl) {
                sb.append(str.substring(i + ml));
            }
            str = sb.toString();
        }
        return str;
    }

    private String handleDoubleQuotes(String s) {
        int length;
        if (s.indexOf(34) == 0) {
            s = s.substring(1);
        }
        if ((length = s.length()) > 0 && s.lastIndexOf(34) == length - 1) {
            s = s.substring(0, length - 1);
        }
        s = s.replace('\"', '\'');
        return s.trim();
    }

    public static enum BrowserIconId {
        IE,
        FIREFOX,
        SAFARI,
        CHROME,
        OPERA,
        SEAMONKEY,
        GENERIC,
        EMBEDDED;

    }
}

