/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.common;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import oracle.help.common.SimpleMap;
import oracle.help.common.TopicNameConvention;

public class ConventionBasedMap
extends SimpleMap {
    private TopicNameConvention _convention;
    private ArrayList _topicPrefixes = new ArrayList(1);
    private Set _misses = new HashSet();

    public ConventionBasedMap(HashMap topicHashMap, HashMap windowHashMap, TopicNameConvention convention, String topicPrefixesString) {
        super(topicHashMap, windowHashMap);
        this._convention = convention;
        if (topicPrefixesString != null) {
            if ((topicPrefixesString = topicPrefixesString.trim()).equals("")) {
                this._topicPrefixes.add(new String(""));
            } else {
                StringTokenizer st = new StringTokenizer(topicPrefixesString, " ");
                while (st.hasMoreTokens()) {
                    String prefix = st.nextToken();
                    this._topicPrefixes.add(prefix);
                }
            }
        } else {
            this._topicPrefixes.add(new String(""));
        }
    }

    @Override
    public URL mapIDToURL(String id) {
        URL found = super.mapIDToURL(id);
        if (found != null) {
            return found;
        }
        if (!this._misses.contains(id)) {
            for (String prefix : this._topicPrefixes) {
                URL proposedURL;
                if (!id.startsWith(prefix) || !this._exists(proposedURL = this._convention.convertToURL(id))) continue;
                this.addIDMapping(id, proposedURL);
                return proposedURL;
            }
            this._misses.add(id);
        }
        return null;
    }

    private boolean _exists(URL url) {
        if (url != null) {
            try {
                InputStream stream = url.openStream();
                if (stream != null) {
                    stream.close();
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }
}

