/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cms;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import javax.crypto.SecretKey;
import oracle.security.crypto.asn1.ASN1ConstructedInputStream;
import oracle.security.crypto.asn1.ASN1Integer;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.cert.AttributeSet;
import oracle.security.crypto.cms.CMS;
import oracle.security.crypto.cms.CMSInputConnector;
import oracle.security.crypto.cms.CMSInputStream;
import oracle.security.crypto.cms.ECIInputStream;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.util.InvalidInputException;
import oracle.security.crypto.util.VersionException;

public class CMSEncryptedDataInputStream
extends CMSInputStream {
    private final boolean readingFromConnector;
    private SecretKey contentEncryptionKey;
    private ASN1ObjectID enclosedContentType;
    private ASN1Integer version;
    private AttributeSet unprotectedAttributes;
    private boolean readInitial = false;
    private boolean terminated = false;
    private ASN1ConstructedInputStream ci_in;
    private ASN1ConstructedInputStream cic_in;
    private ASN1ConstructedInputStream ed_in;
    private ECIInputStream eci_in;

    public CMSEncryptedDataInputStream(InputStream in, SecretKey contentEncryptionKey) {
        super(in);
        this.contentEncryptionKey = contentEncryptionKey;
        this.readingFromConnector = false;
    }

    public CMSEncryptedDataInputStream(CMSInputConnector conn, SecretKey contentEncryptionKey) {
        super(conn.getInputStream());
        this.contentEncryptionKey = contentEncryptionKey;
        this.readingFromConnector = true;
    }

    private void ensureReadInitial() throws IOException {
        if (!this.readInitial) {
            if (!this.readingFromConnector) {
                this.ci_in = new ASN1SequenceInputStream(this.in);
                if (!CMS.id_encryptedData.equals((Object)new ASN1ObjectID((InputStream)this.ci_in))) {
                    throw new InvalidInputException("Content-type 'id-encryptedData' expected.");
                }
                this.cic_in = new ASN1ConstructedInputStream((InputStream)this.ci_in, 0);
                this.ed_in = new ASN1SequenceInputStream((InputStream)this.cic_in);
            } else {
                this.ed_in = new ASN1SequenceInputStream(this.in);
            }
            this.version = new ASN1Integer((InputStream)this.ed_in);
            if (!this.version.equals(0) && !this.version.equals(2)) {
                throw new VersionException("Expected Version 0 or 2 But Got: " + this.version.getValue());
            }
            this.eci_in = new ECIInputStream((InputStream)this.ed_in, this.contentEncryptionKey);
            this.readInitial = true;
        }
    }

    private void ensureTerminated() throws IOException {
        if (!this.terminated) {
            this.unprotectedAttributes = null;
            if (this.ed_in.hasMoreData()) {
                if (this.ed_in.getCurrentTag() == 1) {
                    this.ed_in.setCurrentTag(17);
                    this.unprotectedAttributes = new AttributeSet((InputStream)this.ed_in);
                } else {
                    throw new InvalidInputException("Expected Unauthenticated Attributes");
                }
            }
            this.ed_in.terminate();
            if (!this.readingFromConnector) {
                this.cic_in.terminate();
                this.ci_in.terminate();
            }
            this.terminated = true;
        }
    }

    @Override
    public int read() throws IOException {
        this.ensureReadInitial();
        int ch = this.eci_in.read();
        if (ch == -1) {
            this.ensureTerminated();
        }
        return ch;
    }

    @Override
    public int read(byte[] buffer, int offset, int len) throws IOException {
        this.ensureReadInitial();
        int efflen = this.eci_in.read(buffer, offset, len);
        if (efflen == -1) {
            this.ensureTerminated();
        }
        return efflen;
    }

    @Override
    public int available() throws IOException {
        this.ensureReadInitial();
        return this.eci_in.available();
    }

    @Override
    public long skip(long n) throws IOException {
        this.ensureReadInitial();
        return this.eci_in.skip(n);
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void mark(int readlimit) {
    }

    @Override
    public void reset() throws IOException {
        throw new IOException("mark/reset not supported");
    }

    @Override
    public void terminate() throws IOException {
        this.ensureTerminated();
    }

    public BigInteger getVersionNumber() throws IOException {
        this.ensureReadInitial();
        return this.version.getValue();
    }

    public ASN1Integer getVersion() throws IOException {
        this.ensureReadInitial();
        return this.version;
    }

    @Override
    public ASN1ObjectID getEnclosedContentType() throws IOException {
        this.ensureReadInitial();
        return this.eci_in.getContentType();
    }

    public AlgorithmIdentifier getContentEncryptionAlgID() throws IOException {
        this.ensureReadInitial();
        return this.eci_in.getContentEncryptionAlgID();
    }

    public AttributeSet getUnprotectedAttributes() throws IOException {
        this.ensureTerminated();
        return this.unprotectedAttributes;
    }
}

