/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.actions;

import java.util.Map;
import javax.swing.DefaultListModel;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpression;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBUtil;
import oracle.olap.actions.AWNodeType;
import oracle.olap.actions.AbstractUpdatedObjectGenerator;
import oracle.olap.cube.model.Cube;
import oracle.olap.cube.model.CubeCalculatedMeasure;
import oracle.olap.cube.model.CubeMeasure;
import oracle.olap.db.model.AbstractSchemaObjectWithDesc;
import oracle.olap.db.model.Descriptions;
import oracle.olap.db.model.LanguageDescriptionsHelper;
import oracle.olap.db.model.StatefulDescriptions;
import org.w3c.dom.Node;

public class CubeUpdatedObjectGenerator
extends AbstractUpdatedObjectGenerator {
    private String cubeName;

    public CubeUpdatedObjectGenerator(DefaultListModel defaultListModel, String[] stringArray) {
        super(defaultListModel, stringArray);
    }

    @Override
    protected void traverse(Node node, XPath xPath, Map<String, AbstractSchemaObjectWithDesc> map, Map<String, AbstractSchemaObjectWithDesc> map2) throws Exception {
        if (node != null) {
            Object object;
            AWNodeType aWNodeType = AWNodeType.valueFrom(node.getNodeName());
            if (aWNodeType != null) {
                object = null;
                StatefulDescriptions statefulDescriptions = null;
                switch (aWNodeType) {
                    case CUBE_OBJECT: {
                        XPathExpression xPathExpression = xPath.compile("@name");
                        this.cubeName = xPathExpression.evaluate(node);
                        Cube cube = (Cube)map.get(this.cubeName);
                        Cube cube2 = (Cube)DBUtil.makeTemporaryCopy((DBObject)cube);
                        map2.put(this.cubeName, cube2);
                        object = cube2;
                        statefulDescriptions = cube2;
                        break;
                    }
                    case MEASURE: {
                        XPathExpression xPathExpression = xPath.compile("@name");
                        String string = xPathExpression.evaluate(node);
                        Cube cube2 = (Cube)map2.get(this.cubeName);
                        CubeMeasure cubeMeasure = null;
                        if (cube2 == null) break;
                        cubeMeasure = cube2.findMeasure(string);
                        object = cubeMeasure;
                        statefulDescriptions = cubeMeasure;
                        break;
                    }
                    case CALCULATED_MEASURE: {
                        XPathExpression xPathExpression = xPath.compile("@name");
                        String string = xPathExpression.evaluate(node);
                        Cube cube2 = (Cube)map2.get(this.cubeName);
                        CubeCalculatedMeasure cubeCalculatedMeasure = null;
                        if (cube2 == null) break;
                        cubeCalculatedMeasure = cube2.findCalculatedMeasure(string);
                        object = cubeCalculatedMeasure;
                        statefulDescriptions = cubeCalculatedMeasure;
                    }
                }
                this.setDescriptions(node, xPath, (Descriptions)object, (LanguageDescriptionsHelper)((Object)statefulDescriptions));
            }
            if (node.hasChildNodes()) {
                object = node.getChildNodes();
                for (int i = 0; i < object.getLength(); ++i) {
                    this.traverse(object.item(i), xPath, map, map2);
                }
            }
        }
    }
}

