/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.app.templates.templateview;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import oracle.olap.app.olapmetadata.DimensionHierarchy;
import oracle.olap.app.olapmetadata.DimensionHierarchyLevel;
import oracle.olap.app.olapmetadata.DimensionLevel;
import oracle.olap.app.syntaxparser.ParseNode;
import oracle.olap.app.templates.templateview.TemplateHyperParamCombo;
import oracle.olap.db.IdentifierElement;
import oracle.olap.syntaxbuilder.olapihelpers.Type;

public class TemplateHyperParamHierarchyLevel
extends TemplateHyperParamCombo
implements PropertyChangeListener {
    private static Logger LOG = Logger.getLogger(TemplateHyperParamHierarchyLevel.class.getName());
    private boolean valid;
    public static final String LEVEL_PROPERTY = "level";
    public static final String DIMENSION_PROPERTY = "dimension";
    private static final ParseNode pattern = new ParseNode("hierarchy_level", Type.LEVEL.toString(), ParseNode.PatternType.NONE);

    @Override
    public boolean isValid() {
        return this.valid;
    }

    public TemplateHyperParamHierarchyLevel() {
        final ListCellRenderer listCellRenderer = this.hyperCombo.getRenderer();
        this.hyperCombo.setRenderer(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                return listCellRenderer.getListCellRendererComponent(jList, TemplateHyperParamHierarchyLevel.this.uiValue(object), n, bl, bl2);
            }
        });
    }

    protected String uiValue(Object object) {
        if (object != null) {
            DimensionHierarchyLevel dimensionHierarchyLevel = (DimensionHierarchyLevel)object;
            return dimensionHierarchyLevel.getLevelName();
        }
        return null;
    }

    @Override
    public int getPixelSize(int n) {
        if (this.getSelectedElement() != null) {
            return this.hyperCombo.getFontMetrics(this.hyperCombo.getFont()).stringWidth(this.uiValue(this.getSelectedElement()));
        }
        return 100;
    }

    @Override
    public ParseNode getPattern() {
        return pattern;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getNewValue() instanceof DimensionHierarchy) {
            DimensionHierarchyLevel dimensionHierarchyLevel;
            DimensionHierarchy dimensionHierarchy;
            DimensionHierarchy dimensionHierarchy2 = (DimensionHierarchy)propertyChangeEvent.getNewValue();
            if (this.getSelectedElement() != null && !dimensionHierarchy2.equals(dimensionHierarchy = (dimensionHierarchyLevel = (DimensionHierarchyLevel)this.getSelectedElement()).getHierarchy())) {
                String string = null;
                if (dimensionHierarchy != null) {
                    string = dimensionHierarchy.getName();
                }
            }
            this.setHierarchy(dimensionHierarchy2);
        }
    }

    @Override
    public void init() {
        String string;
        if (this.getParam() != null && (string = this.getParam().getInitialDefault()) != null) {
            this.setValue(string.toUpperCase());
        }
    }

    protected void setHierarchy(DimensionHierarchy dimensionHierarchy) {
        this.removeAllElements();
        boolean bl = this.isValid();
        this.valid = false;
        if (dimensionHierarchy != null) {
            List<DimensionHierarchyLevel> list = dimensionHierarchy.getHierarchyLevels();
            for (DimensionHierarchyLevel dimensionHierarchyLevel : list) {
                this.addElement(dimensionHierarchyLevel);
            }
            if (list.size() > 0) {
                this.valid = true;
                this.setValue(list.get(0));
                this.setVisible(true);
            }
        }
        if (bl != this.isValid()) {
            this.firePropertyChangeEvent(new PropertyChangeEvent(this, "VALID_PROPERTY", bl, this.isValid()));
        }
    }

    private DimensionHierarchyLevel getLevel() {
        return (DimensionHierarchyLevel)this.getSelectedElement();
    }

    @Override
    public Object getValue(String string) {
        DimensionHierarchyLevel dimensionHierarchyLevel = this.getLevel();
        if (dimensionHierarchyLevel != null) {
            DimensionLevel dimensionLevel = dimensionHierarchyLevel.getDimensionLevel();
            if (string.equalsIgnoreCase(this.getName())) {
                return dimensionLevel;
            }
            if (string.equalsIgnoreCase(this.getType().toString())) {
                return dimensionLevel;
            }
            return dimensionLevel.toString();
        }
        return "";
    }

    @Override
    public Object getValue() {
        return this.getLevel();
    }

    @Override
    public String getExpression() {
        if (this.getLevel() == null) {
            return null;
        }
        if (this.getExpressionProperty() != null) {
            if (this.getExpressionProperty().equals(LEVEL_PROPERTY)) {
                return this.getLevel().getDimensionLevel().getID();
            }
            if (this.getExpressionProperty().equals(DIMENSION_PROPERTY)) {
                return this.getLevel().getDimension().getID();
            }
        }
        return this.getLevel().getID();
    }

    @Override
    public String getDefault() {
        return "dimension.level";
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
    }

    @Override
    public boolean setValue(Object object) {
        DimensionHierarchy dimensionHierarchy = null;
        if (this.getSelectedElement() != null) {
            dimensionHierarchy = ((DimensionHierarchyLevel)this.getSelectedElement()).getHierarchy();
        }
        if (object instanceof ParseNode && dimensionHierarchy != null) {
            String string;
            DimensionHierarchyLevel dimensionHierarchyLevel;
            ParseNode parseNode = (ParseNode)object;
            String string2 = dimensionHierarchy.getDimension().getSchema().getName();
            IdentifierElement identifierElement = new IdentifierElement(parseNode.getValue());
            int n = 1;
            if (identifierElement.get(0).equals(string2)) {
                ++n;
            }
            if ((dimensionHierarchyLevel = dimensionHierarchy.findHierarchyLevel(string = identifierElement.get(n))) != null) {
                return super.setValue(dimensionHierarchyLevel);
            }
            return false;
        }
        if (object instanceof String) {
            String string = (String)object;
            if (dimensionHierarchy != null) {
                for (DimensionHierarchyLevel dimensionHierarchyLevel : dimensionHierarchy.getHierarchyLevels()) {
                    if (!dimensionHierarchyLevel.getID().equals(string)) continue;
                    return super.setValue(dimensionHierarchyLevel);
                }
            }
        }
        return super.setValue(object);
    }
}

