/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.dml.parser;

import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import oracle.dbtools.parser.Earley;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parser;
import oracle.dbtools.parser.RuleTuple;
import oracle.dbtools.parser.Token;
import oracle.dbtools.parser.Visual;
import oracle.dbtools.parser.plsql.SqlEarley;
import oracle.dbtools.util.Service;
import oracle.olap.dml.parser.OlapRules;

public class OlapEarley
extends Earley {
    private static Set<RuleTuple> origRules;
    private int xc;
    private static OlapEarley instance;
    private Set<Integer> keywords = new TreeSet<Integer>();

    public static void main(String[] stringArray) throws Exception {
        boolean bl = false;
        OlapEarley.printRules("atom", bl);
        String string = Service.readFile(OlapEarley.class, (String)"test.olap");
        if (stringArray.length > 0 && stringArray[0].startsWith("par")) {
            OlapEarley.parse(string);
            return;
        }
        System.out.println(OlapEarley.getInstance().recognize(string));
    }

    public boolean recognize(String string) {
        List list = LexerToken.parse((String)string);
        Matrix matrix = new Matrix((Parser)instance);
        this.parse(list, matrix);
        for (int i = list.size(); 0 < i; --i) {
            Parser.EarleyCell earleyCell = matrix.get(0, i);
            if (earleyCell == null) continue;
            if (SqlEarley.getInstance().recognize(list) < i) {
                return true;
            }
            for (int j = 0; j < earleyCell.size(); ++j) {
                Parser.Tuple tuple = this.rules[earleyCell.getRule(j)];
                int n = earleyCell.getPosition(j);
                if (this.xc != tuple.head || n != tuple.size()) continue;
                return true;
            }
            return false;
        }
        throw new AssertionError((Object)"all empty cells?");
    }

    private static void parse(String string) {
        List list = LexerToken.parse((String)string);
        Matrix matrix = new Matrix((Parser)OlapEarley.getInstance());
        Visual visual = null;
        visual = new Visual(list, (Parser)OlapEarley.getInstance());
        long l = System.currentTimeMillis();
        OlapEarley.getInstance().parse(list, matrix);
        long l2 = System.currentTimeMillis();
        System.out.println("Earley parse time = " + (l2 - l));
        System.out.println("#tokens=" + list.size());
        if (visual != null) {
            visual.draw(matrix);
        }
        ParseNode parseNode = OlapEarley.getInstance().forest(list, matrix);
        parseNode.printTree();
    }

    private OlapEarley() {
        super(origRules);
        this.initKeywords();
        this.xc = this.getSymbol("xc");
    }

    public static OlapEarley getInstance() {
        if (instance == null) {
            instance = new OlapEarley();
        }
        return instance;
    }

    void initKeywords() {
        try {
            String string = Service.readFile(OlapEarley.class, (String)"keywords");
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\n\r", false);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken().trim();
                int n = this.getSymbol("'" + string2 + "'");
                this.keywords.add(n);
            }
        }
        catch (Exception exception) {
            System.out.println("Failed to init keywords:" + exception.getMessage());
        }
    }

    protected boolean isIdentifier(int n, List<LexerToken> list, int n2, Integer n3) {
        if (n2 != this.identifier) {
            return false;
        }
        if (list.get((int)n).type == Token.OPERATION) {
            return false;
        }
        return n3 == null || !this.keywords.contains(n3);
    }

    protected void initCell00(List<LexerToken> list, Matrix matrix) {
        matrix.initCells(list.size());
        this.initCell(matrix, new int[]{this.xc}, 0);
    }

    private static void printRules(String string, boolean bl) {
        block0: for (RuleTuple ruleTuple : origRules) {
            if (ruleTuple.head.contains(string)) {
                System.out.println(ruleTuple.toString());
                continue;
            }
            if (bl) continue;
            for (int i = 0; i < ruleTuple.rhs.length; ++i) {
                if (!ruleTuple.rhs[i].contains(string)) continue;
                System.out.println(ruleTuple.toString());
                continue block0;
            }
        }
    }

    static {
        try {
            origRules = OlapRules.getRules();
        }
        catch (Exception exception) {
            // empty catch block
        }
        instance = null;
    }
}

