/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.security;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import oracle.dbtools.db.DBUtil;
import oracle.javatools.ui.table.GenericTable;
import oracle.olap.OLAPArb;
import oracle.olap.security.AccessControlEntry;
import oracle.olap.security.AccessControlList;
import oracle.olap.security.ORASUtil;

public class ACEAccessSettingPanel
extends JPanel {
    JPanel m_parentPanel = null;
    public int m_numberOfColumns = 0;
    JScrollPane m_scrollPaneTable;
    public GenericTable m_table;
    public DefaultTableModel m_tableModel;
    GridBagConstraints c = new GridBagConstraints();
    int m_rowClicked = -1;
    boolean m_allowUserToClickOnGrid = true;
    private boolean m_tableInitState;
    private int m_highWater = 0;
    private List<String> m_roleList;
    private Connection m_conn;
    private int m_objectType = 1;
    private static boolean m_isSettingData = false;
    public static final int DIMENSION_TYPE = 1;
    public static final int CUBE_TYPE = 2;
    public static final int USER_ROLE_ROWS = 1;
    public static final int CHILD_DOCUMENT_ROWS = 2;
    private static final String USER_TYPE_STR = "User";
    private static final String ROLE_TYPE_STR = "Role";
    private static final String DOC_TYPE_STR = "OLAP Access Control List";
    public static final String DOC_CHILD_TYPE_STR = "OLAP Access Control Entry";
    private static final int ENTITY_NAME_COLUMN = 0;
    private static final int ENTITY_TYPE_COLUMN = 1;
    private static final int SELECT_PRIV_COLUMN = 2;
    private static final int INSERT_PRIV_COLUMN = 3;
    private static final int UPDATE_PRIV_COLUMN = 4;
    private static final int DELETE_PRIV_COLUMN = 5;
    public static final int CONTROL_TYPE_COLUMN = 6;
    private static final int CONTROL_CHILD_COUNT_COLUMN = 7;
    private static final int CONTROL_EXPAND_STATE_COLUMN = 8;
    private static final int TOTAL_NUMBER_COLUMNS = 9;

    public ACEAccessSettingPanel(JPanel jPanel) {
        this.m_parentPanel = jPanel;
        this.m_numberOfColumns = 9;
        this.m_highWater = 0;
        this.jbInitAdd();
    }

    public void setDimensionOrCubeType(int n) {
        this.m_objectType = n;
        if (n == 2) {
            this.m_table.getColumnModel().getColumn(5).setMaxWidth(0);
            this.m_table.getColumnModel().getColumn(5).setMinWidth(0);
            this.m_table.getColumnModel().getColumn(3).setMaxWidth(0);
            this.m_table.getColumnModel().getColumn(3).setMinWidth(0);
        } else {
            this.m_table.getColumnModel().getColumn(5).setMaxWidth(65);
            this.m_table.getColumnModel().getColumn(5).setMinWidth(65);
            this.m_table.getColumnModel().getColumn(3).setMaxWidth(65);
            this.m_table.getColumnModel().getColumn(3).setMinWidth(65);
        }
    }

    public void initialiseFieldsFast(Connection connection) {
        this.m_tableInitState = false;
        this.m_highWater = 0;
        this.m_conn = connection;
        this.clearAndInitTable();
    }

    public int getActualTableRowCount() {
        int n = this.m_tableModel.getRowCount();
        return n;
    }

    public List<AccessControlEntry> getACEList() {
        LinkedList<AccessControlEntry> linkedList = new LinkedList<AccessControlEntry>();
        String string = null;
        for (int i = 0; i < this.m_tableModel.getRowCount(); ++i) {
            String string2 = (String)this.m_tableModel.getValueAt(i, 0);
            String string3 = (String)this.m_tableModel.getValueAt(i, 6);
            if (string3.equalsIgnoreCase(DOC_TYPE_STR)) {
                string = string2;
                continue;
            }
            AccessControlEntry accessControlEntry = new AccessControlEntry();
            accessControlEntry.setPrincipal(string2);
            if (string3.equalsIgnoreCase(DOC_CHILD_TYPE_STR)) {
                accessControlEntry.setACL(string);
            }
            if (this.m_tableModel.getValueAt(i, 2) == Boolean.TRUE) {
                accessControlEntry.setPrivilege("SELECT");
                linkedList.add(accessControlEntry);
            }
            if (this.m_tableModel.getValueAt(i, 3) == Boolean.TRUE) {
                accessControlEntry.setPrivilege("INSERT");
                linkedList.add(accessControlEntry);
            }
            if (this.m_tableModel.getValueAt(i, 4) == Boolean.TRUE) {
                accessControlEntry.setPrivilege("UPDATE");
                linkedList.add(accessControlEntry);
            }
            if (this.m_tableModel.getValueAt(i, 5) != Boolean.TRUE) continue;
            accessControlEntry.setPrivilege("DELETE");
            linkedList.add(accessControlEntry);
        }
        return linkedList;
    }

    public List<String> getCurrentUsersInTable() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.m_tableModel.getRowCount(); ++i) {
            String string = (String)this.m_tableModel.getValueAt(i, 1);
            if (!string.equalsIgnoreCase(OLAPArb.get("REALM_ACCESS_SETTING_PANEL_USER_LABEL"))) continue;
            arrayList.add((String)this.m_tableModel.getValueAt(i, 0));
        }
        return arrayList;
    }

    public List<String> getCurrentRolesInTable() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.m_tableModel.getRowCount(); ++i) {
            String string = (String)this.m_tableModel.getValueAt(i, 1);
            if (!string.equalsIgnoreCase(OLAPArb.get("REALM_ACCESS_SETTING_PANEL_ROLE_LABEL"))) continue;
            arrayList.add((String)this.m_tableModel.getValueAt(i, 0));
        }
        return arrayList;
    }

    public List<String> getCurrentDSACLsInTable() {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        for (n = 0; n < this.m_tableModel.getRowCount(); ++n) {
            String string = (String)this.m_tableModel.getValueAt(n, 1);
            if (!string.equalsIgnoreCase(OLAPArb.get("REALM_ACCESS_SETTING_PANEL_SECURITY_ROLE_LABEL"))) continue;
            arrayList.add((String)this.m_tableModel.getValueAt(n, 0));
        }
        return arrayList;
    }

    public void updateTableWithSelectedUsers(List<String> list, String string) {
        int n = this.m_highWater;
        String string2 = new String("");
        String string3 = "";
        if (string.equalsIgnoreCase("Users")) {
            string2 = OLAPArb.get("REALM_ACCESS_SETTING_PANEL_USER_LABEL");
            string3 = USER_TYPE_STR;
        } else if (string.equalsIgnoreCase("Roles")) {
            string2 = OLAPArb.get("REALM_ACCESS_SETTING_PANEL_ROLE_LABEL");
            string3 = ROLE_TYPE_STR;
        } else {
            string2 = OLAPArb.get("REALM_ACCESS_SETTING_PANEL_SECURITY_ROLE_LABEL");
            string3 = DOC_TYPE_STR;
        }
        for (String string4 : list) {
            int n2 = this.m_tableModel.getRowCount();
            if (n2 > this.m_highWater) {
                ++n;
                ++this.m_highWater;
            }
            this.m_tableModel.addRow(new Object[]{"", "", false, false, false, false, "", new Integer(0), false});
            this.m_tableModel.setValueAt(string4, n, 0);
            this.m_tableModel.setValueAt(string2, n, 1);
            this.m_tableModel.setValueAt(string3, n, 6);
            if (string2.compareToIgnoreCase("Security Role") != 0) {
                this.m_tableModel.setValueAt(true, n, 2);
                this.m_tableModel.setValueAt(false, n, 3);
                this.m_tableModel.setValueAt(false, n, 4);
                this.m_tableModel.setValueAt(false, n, 5);
                continue;
            }
            int n3 = n;
            ORASUtil oRASUtil = ORASUtil.getInstance();
            AccessControlList accessControlList = oRASUtil.getACLDO(this.m_conn, string4);
            AccessControlEntry[] accessControlEntryArray = accessControlList.getAces();
            Vector<String> vector = new Vector<String>();
            vector.addElement(string4);
            this.m_tableModel.setValueAt(DOC_TYPE_STR, n, 6);
            this.fillGridWithPrivilegeInfo(accessControlEntryArray, 2);
            n = ++this.m_highWater;
            this.m_tableModel.setValueAt(new Integer(n - n3), n3, 7);
            this.m_tableModel.setValueAt(false, n3, 8);
        }
    }

    public void fillGridWithPrivilegeInfo(AccessControlEntry[] accessControlEntryArray, int n) {
        String string = null;
        if (n == 1) {
            this.clearTable();
            this.m_highWater = 0;
        }
        int n2 = this.m_highWater;
        if (accessControlEntryArray != null) {
            DBUtil dBUtil = DBUtil.getInstance((Connection)this.m_conn);
            List list = dBUtil.executeReturnList("select role from dba_roles order by role", null);
            this.m_roleList = new ArrayList<String>();
            for (Map map : list) {
                String string2 = (String)map.get("ROLE");
                this.m_roleList.add(string2);
            }
            for (AccessControlEntry accessControlEntry : accessControlEntryArray) {
                String string3;
                if (string == null) {
                    string = accessControlEntry.getPrincipal();
                } else if (!accessControlEntry.getPrincipal().equals(string)) {
                    string = accessControlEntry.getPrincipal();
                    ++this.m_highWater;
                    ++n2;
                }
                if (this.m_tableModel.getRowCount() <= this.m_highWater) {
                    this.m_tableModel.addRow(new Object[]{"", "", false, false, false, false, "", new Integer(0), false});
                }
                String string4 = accessControlEntry.getPrincipalType();
                String string5 = "";
                if (n == 2) {
                    this.m_tableModel.setValueAt("    " + accessControlEntry.getPrincipal(), n2, 0);
                    string3 = this.m_roleList.contains(string) ? OLAPArb.getString("REALM_ACCESS_SETTING_PANEL_CHILD_ROLE_LABEL") : OLAPArb.getString("REALM_ACCESS_SETTING_PANEL_CHILD_USER_LABEL");
                    this.m_tableModel.setValueAt(string3, n2, 1);
                    this.m_tableModel.setValueAt(DOC_CHILD_TYPE_STR, n2, 6);
                    if (accessControlEntry.getPrivilege().equalsIgnoreCase("SELECT")) {
                        this.m_tableModel.setValueAt(true, n2, 2);
                    }
                    if (accessControlEntry.getPrivilege().equalsIgnoreCase("INSERT")) {
                        this.m_tableModel.setValueAt(true, n2, 3);
                    }
                    if (accessControlEntry.getPrivilege().equalsIgnoreCase("UPDATE")) {
                        this.m_tableModel.setValueAt(true, n2, 4);
                    }
                    if (!accessControlEntry.getPrivilege().equalsIgnoreCase("DELETE")) continue;
                    this.m_tableModel.setValueAt(true, n2, 5);
                    continue;
                }
                this.m_tableModel.setValueAt(accessControlEntry.getPrincipal(), n2, 0);
                if (this.m_roleList.contains(string)) {
                    string3 = OLAPArb.getString("REALM_ACCESS_SETTING_PANEL_ROLE_LABEL");
                    string5 = ROLE_TYPE_STR;
                } else {
                    string3 = OLAPArb.getString("REALM_ACCESS_SETTING_PANEL_USER_LABEL");
                    string5 = USER_TYPE_STR;
                }
                this.m_tableModel.setValueAt(string3, n2, 1);
                this.m_tableModel.setValueAt(string5, n2, 6);
                if (accessControlEntry.getPrivilege().equalsIgnoreCase("SELECT")) {
                    this.m_tableModel.setValueAt(true, n2, 2);
                }
                if (accessControlEntry.getPrivilege().equalsIgnoreCase("INSERT")) {
                    this.m_tableModel.setValueAt(true, n2, 3);
                }
                if (accessControlEntry.getPrivilege().equalsIgnoreCase("UPDATE")) {
                    this.m_tableModel.setValueAt(true, n2, 4);
                }
                if (!accessControlEntry.getPrivilege().equalsIgnoreCase("DELETE")) continue;
                this.m_tableModel.setValueAt(true, n2, 5);
            }
        }
    }

    public void clearTable() {
        DefaultTableModel defaultTableModel = this.m_tableModel;
        defaultTableModel.getDataVector().removeAllElements();
        defaultTableModel.fireTableDataChanged();
    }

    public void clearAndInitTable() {
        if (this.m_tableModel.getRowCount() > 0) {
            this.clearTable();
        }
        this.m_highWater = -1;
    }

    public void addEmptyRowsForCreateDialog() {
        for (int i = 0; i < 15; ++i) {
            this.m_tableModel.addRow(new Object[]{"", "", false, false, false, false, "", new Integer(0), false});
        }
    }

    public void clearEmptyRowsFromTable() {
        if (this.m_tableModel.getRowCount() > 0) {
            this.clearTable();
        }
    }

    public boolean removeRowFromTable() {
        int n = this.m_table.getSelectedRow();
        if (n < 0) {
            return false;
        }
        if (n > this.m_highWater) {
            return false;
        }
        String string = (String)this.m_tableModel.getValueAt(n, 6);
        if (string.equalsIgnoreCase(USER_TYPE_STR) || string.equalsIgnoreCase(ROLE_TYPE_STR)) {
            this.m_tableModel.removeRow(n);
            --this.m_highWater;
        } else if (string.equalsIgnoreCase(DOC_TYPE_STR)) {
            int n2 = (Integer)this.m_tableModel.getValueAt(n, 7);
            for (int i = n + n2; i >= n; --i) {
                this.m_tableModel.removeRow(i);
            }
            this.m_highWater -= n2 + 1;
        } else {
            return false;
        }
        return true;
    }

    public void enableFields() {
    }

    public void registerFieldListeners() {
    }

    public JPanel getPropertyPanel() {
        return this.m_parentPanel;
    }

    public void setColumnWidths(int[] nArray) {
    }

    public void addToButtonBar(Component component) {
    }

    protected void upButtonClicked() {
    }

    protected void downButtonClicked() {
    }

    protected void onFocusCell(int n, int n2) {
        boolean bl = false;
    }

    protected void jbInitAdd() {
        this.setOrderButtons(false);
        Object[] objectArray = new String[]{OLAPArb.get("REALM_ACCESS_SETTING_PANEL_ENTITY_LABEL"), OLAPArb.get("REALM_ACCESS_SETTING_PANEL_ENTITY_TYPE_LABEL"), OLAPArb.get("REALM_ACCESS_SETTING_PANEL_SELECT"), OLAPArb.get("REALM_ACCESS_SETTING_PANEL_INSERT"), OLAPArb.get("REALM_ACCESS_SETTING_PANEL_UPDATE"), OLAPArb.get("REALM_ACCESS_SETTING_PANEL_DELETE"), "hidden1", "hidden2", "hidden3"};
        this.m_tableModel = new CustomTableModel(objectArray, 0);
        this.m_table = new GenericTable(this.m_tableModel){

            public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
                Component component = super.prepareRenderer(tableCellRenderer, n, n2);
                switch (n2) {
                    case 0: 
                    case 1: 
                    case 6: 
                    case 7: 
                    case 8: {
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        String string = (String)this.getModel().getValueAt(n, 6);
                        if (!string.equalsIgnoreCase(ACEAccessSettingPanel.DOC_TYPE_STR) && !string.equalsIgnoreCase(ACEAccessSettingPanel.DOC_CHILD_TYPE_STR)) break;
                        component.setBackground(Color.LIGHT_GRAY);
                        break;
                    }
                }
                return component;
            }
        };
        this.m_table.setFocusable(true);
        this.m_table.getColumnModel().getColumn(0).setMaxWidth(200);
        this.m_table.getColumnModel().getColumn(1).setMaxWidth(125);
        this.m_table.getColumnModel().getColumn(2).setMaxWidth(65);
        this.m_table.getColumnModel().getColumn(3).setMaxWidth(65);
        this.m_table.getColumnModel().getColumn(4).setMaxWidth(65);
        this.m_table.getColumnModel().getColumn(5).setMaxWidth(65);
        this.m_table.setHiddenColumns(new int[]{6, 7, 8});
        this.m_scrollPaneTable = new JScrollPane();
        this.m_scrollPaneTable.getViewport().add((Component)this.m_table);
        this.setLayout(new GridBagLayout());
        this.m_scrollPaneTable.setHorizontalScrollBarPolicy(30);
        this.m_scrollPaneTable.setVerticalScrollBarPolicy(20);
        this.m_scrollPaneTable.setMinimumSize(new Dimension(200, 250));
        this.c.gridx = 0;
        this.c.gridy = 0;
        this.c.gridheight = 1;
        this.c.gridwidth = 1;
        this.c.weightx = 1.0;
        this.c.weighty = 1.0;
        this.c.fill = 1;
        this.add((Component)this.m_scrollPaneTable, this.c);
        this.clearAndInitTable();
    }

    public void setOrderButtons(boolean bl) {
    }

    public void setGridClicks(boolean bl) {
        this.m_allowUserToClickOnGrid = bl;
    }

    public void setFocus() {
    }

    public void cellValueChanged(int n, int n2) {
        if (m_isSettingData) {
            return;
        }
        if (n == 8) {
            return;
        }
        if (n == 0 && this.m_tableModel.getValueAt(n2, 6) != null && ((String)this.m_tableModel.getValueAt(n2, 6)).equalsIgnoreCase(DOC_TYPE_STR)) {
            Boolean bl = (Boolean)this.m_tableModel.getValueAt(n2, 8);
            int n3 = (Integer)this.m_tableModel.getValueAt(n2, 7);
            if (!bl.booleanValue()) {
                for (int i = n2 + 1; i <= n2 + n3; ++i) {
                    int n4 = this.m_table.getRowHeight();
                    this.m_table.setRowHeight(i, n4);
                }
                this.m_tableModel.setValueAt(true, n2, 8);
            } else {
                for (int i = n2 + 1; i <= n2 + n3; ++i) {
                    this.m_table.setRowHeight(i, 0);
                }
                this.m_tableModel.setValueAt(false, n2, 8);
            }
        }
        if (n2 >= this.m_highWater || n < 2 || n <= 5) {
            // empty if block
        }
    }

    public void tableModelClear() {
        if (this.m_tableModel.getRowCount() != 0) {
            this.m_tableModel.setRowCount(0);
        }
    }

    private class CustomTableModel
    extends DefaultTableModel {
        Class[] dataTypes;

        public CustomTableModel(Object[] objectArray, int n) {
            super(objectArray, n);
            this.dataTypes = new Class[]{String.class, String.class, Boolean.class, Boolean.class, Boolean.class, Boolean.class, String.class, Integer.class, Boolean.class};
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return this.dataTypes[n];
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            boolean bl = true;
            switch (n2) {
                case 0: 
                case 1: 
                case 6: 
                case 7: 
                case 8: {
                    bl = false;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    String string = (String)this.getValueAt(n, 6);
                    if (!string.equalsIgnoreCase(ACEAccessSettingPanel.DOC_TYPE_STR) && !string.equalsIgnoreCase(ACEAccessSettingPanel.DOC_CHILD_TYPE_STR)) break;
                    bl = false;
                    break;
                }
            }
            return bl;
        }
    }
}

