/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.compare;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.ide.extension.ElementName;
import javax.ide.util.MetaClass;
import oracle.ide.ExtensionRegistry;
import oracle.ide.config.FileTypesRecognizer;
import oracle.ide.model.Element;
import oracle.ide.model.Recognizer;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.Assert;
import oracle.ide.util.IdeUtil;
import oracle.jdeveloper.compare.Stream;
import oracle.jdeveloper.compare.StreamDecoderHelper;
import oracle.jdeveloper.compare.StreamType;
import oracle.jdevimpl.compare.CompareStreamDecoderHook;

public final class StreamDecoder {
    private static final int ENCODING_SCAN_SIZE = 512;
    private static final Collection _decoderHelpers = new ArrayList();
    private static final Collection<Class<? extends Element>> _xmlNodeClasses = new ArrayList<Class<? extends Element>>();
    private static final Collection<MetaClass<? extends Element>> _xmlNodeMetaClasses = new ArrayList<MetaClass<? extends Element>>();

    @Deprecated
    static final void registerXMLNodeClass(Class<? extends Element> cls) {
        _xmlNodeClasses.add(cls);
    }

    public static final void registerXMLNodeClass(MetaClass<? extends Element> cls) {
        _xmlNodeMetaClasses.add(cls);
    }

    @Deprecated
    public static final void registerDecoderHelper(StreamDecoderHelper decoderHelper) {
        _decoderHelpers.add(decoderHelper);
    }

    @Deprecated
    public static final void deregisterDecoderHelper(StreamDecoderHelper decoderHelper) {
        _decoderHelpers.remove(decoderHelper);
    }

    public static final String getDefaultEncoding(URL url) {
        String suffix = URLFileSystem.getSuffix((URL)url);
        if (suffix != null && suffix.length() > 0 && StreamDecoder.isDocRecordXMLClass(suffix)) {
            return "UTF-8";
        }
        Iterator<StreamDecoderHelper> itr = StreamDecoder.getDecoderHelpers().iterator();
        while (itr.hasNext()) {
            String charsetName = itr.next().getDefaultEncoding(url);
            if (charsetName == null) continue;
            return charsetName;
        }
        return IdeUtil.getIdeEncoding();
    }

    private static final boolean isDocRecordXMLClass(String suffix) {
        return Recognizer.isXmlExtension((String)suffix);
    }

    public static Reader getReader(URL url) throws IOException {
        return StreamDecoder.getReader(URLFileSystem.getSuffix((URL)url), url);
    }

    public static Reader getReader(String suffix, URL url) throws IOException {
        return StreamDecoder.getReader(suffix, url.openStream(), StreamDecoder.getDefaultEncoding(url));
    }

    public static Reader getReader(String suffix, InputStream stream) throws IOException {
        return StreamDecoder.getReader(suffix, stream, IdeUtil.getIdeEncoding());
    }

    public static Reader getReader(String suffix, InputStream stream, String defaultEncoding) throws IOException {
        return StreamDecoder.getStream(suffix, stream, defaultEncoding).getReader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Stream getStream(String suffix, InputStream inputStream, String defaultEncoding) throws IOException {
        Stream stream = new Stream();
        BufferedInputStream bis = new BufferedInputStream(inputStream);
        bis.mark(Integer.MAX_VALUE);
        String xmlEncoding = null;
        try {
            xmlEncoding = StreamDecoder.getXMLEncoding(bis);
        }
        catch (RuntimeException re) {
            re.printStackTrace();
        }
        finally {
            bis.reset();
        }
        try {
            if (StreamDecoder.isXMLFile(suffix) || xmlEncoding != null) {
                stream.setEncoding(xmlEncoding != null ? xmlEncoding : defaultEncoding);
                stream.setType(StreamType.XML);
                stream.setReader(new InputStreamReader((InputStream)bis, stream.getEncoding()));
                return stream;
            }
            if (StreamDecoder.isHTMLFile(suffix) || StreamDecoder.isJSPFile(suffix)) {
                stream.setType(StreamDecoder.isHTMLFile(suffix) ? StreamType.HTML : StreamType.JSP);
                InputStreamReader reader = new InputStreamReader(bis);
                char[] array = new char[512];
                reader.read(array, 0, 512);
                String encoding = StreamDecoder.getEncoding(StreamDecoder.isJSPFile(suffix), array);
                if (encoding == null) {
                    encoding = defaultEncoding;
                }
                Assert.println((String)("Compare encoding is " + encoding));
                bis.reset();
                stream.setEncoding(encoding);
                stream.setReader(new InputStreamReader((InputStream)bis, stream.getEncoding()));
                return stream;
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        stream.setEncoding(defaultEncoding);
        stream.setType(StreamType.OTHER);
        stream.setReader(new InputStreamReader((InputStream)bis, stream.getEncoding()));
        return stream;
    }

    private static String getEncoding(boolean isJSP, char[] array) {
        String fragment = new String(array);
        byte[] bytes = fragment.getBytes();
        return isJSP ? StreamDecoder.scanForJSPEncoding(bytes, 0, bytes.length) : StreamDecoder.scanForEncoding(bytes, 0, bytes.length);
    }

    private static String scanForJSPEncoding(byte[] array, int offset, int length) {
        String encoding = null;
        String tmp = new String(array);
        String PAGENC = "pageEncoding=\"";
        int idx = tmp.indexOf("pageEncoding=\"");
        if (idx != -1 && (encoding = tmp.substring(idx + "pageEncoding=\"".length())) != null && (encoding = (idx = encoding.indexOf(34)) != -1 ? encoding.substring(0, idx) : null) != null) {
            return encoding;
        }
        encoding = StreamDecoder.extractEncoding(tmp);
        if (encoding != null) {
            idx = encoding.indexOf(34);
            encoding = idx != -1 ? encoding.substring(0, idx) : null;
        }
        return encoding;
    }

    private static String extractEncoding(String ct) {
        int idx;
        if (ct != null && (idx = ct.indexOf(59)) != -1 && idx + 1 < ct.length()) {
            ct = ct.substring(idx + 1);
            if ((ct = ct.trim()).startsWith("charset") && (ct = ct.substring(7).trim()).charAt(0) == '=' && (ct = ct.substring(1).trim()).length() > 0) {
                return ct;
            }
        }
        return null;
    }

    private static String getXMLEncoding(InputStream inStream) throws IOException {
        char[] array = new char[512];
        InputStreamReader reader = new InputStreamReader(inStream);
        reader.read(array, 0, 512);
        boolean LESS = true;
        int IN_PI = 2;
        int IN_XML = 5;
        int ENCODING_START = 6;
        int ENCODING_EQ = 7;
        int IN_ENCODING = 8;
        int state = 0;
        StringBuffer encoding = new StringBuffer();
        block9: for (int i = 0; i < array.length; ++i) {
            char c = array[i];
            switch (state) {
                case 0: {
                    if (c != '<') continue block9;
                    state = 1;
                    continue block9;
                }
                case 1: {
                    if (c != '?') continue block9;
                    state = 2;
                    continue block9;
                }
                case 2: {
                    if (c != 'x' || array.length <= i + 2 || array[i + 1] != 'm' || array[i + 2] != 'l') continue block9;
                    i += 2;
                    state = 5;
                    continue block9;
                }
                case 5: {
                    String attrib;
                    if (c != 'e' || array.length <= i + 7 || !"encoding".equals(attrib = new String(array, i, 8))) continue block9;
                    i += 7;
                    state = 6;
                    continue block9;
                }
                case 6: {
                    if (c != '=') continue block9;
                    state = 7;
                    continue block9;
                }
                case 7: {
                    if (Character.isWhitespace(c)) continue block9;
                    state = 8;
                    if (c == '\'' || c == '\"') continue block9;
                    encoding.append(c);
                    continue block9;
                }
                case 8: {
                    if (Character.isWhitespace(c) || c == '\'' || c == '\"') {
                        return encoding.toString();
                    }
                    encoding.append(c);
                }
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static String scanForEncoding(byte[] array, int offset, int length) {
        if (length <= 0) {
            return null;
        }
        String result = null;
        int end = length;
        int encOffset = 0;
        boolean LESS = true;
        int LESS_B = 2;
        int LESS_BO = 3;
        int LESS_BOD = 4;
        int LESS_M = 5;
        int LESS_ME = 6;
        int LESS_MET = 7;
        int IN_META = 8;
        int CHARSET_START = 9;
        int CHARSET_START_BLANK = 10;
        int CHARSET_EQ = 11;
        int IN_ENCODING = 12;
        int state = 0;
        while (offset != end) {
            byte c = array[offset];
            ++offset;
            switch (state) {
                case 0: {
                    if (c != 60) break;
                    state = 1;
                    break;
                }
                case 1: {
                    state = c == 98 || c == 66 ? 2 : (c == 109 || c == 77 ? 5 : 0);
                    break;
                }
                case 2: {
                    state = c == 111 || c == 79 ? 3 : 0;
                    break;
                }
                case 3: {
                    state = c == 100 || c == 68 ? 4 : 0;
                    break;
                }
                case 4: {
                    if (c == 121) return result;
                    if (c == 89) {
                        return result;
                    }
                    state = 0;
                    break;
                }
                case 5: {
                    state = c == 101 || c == 69 ? 6 : 0;
                    break;
                }
                case 6: {
                    state = c == 116 || c == 84 ? 7 : 0;
                    break;
                }
                case 7: {
                    state = c == 97 || c == 65 ? 8 : 0;
                    break;
                }
                case 8: {
                    if (c == 62) {
                        state = 0;
                        break;
                    }
                    if (c != 99 && c != 67) break;
                    if (offset + 6 > end) {
                        return result;
                    }
                    c = array[offset];
                    if (c != 104 && c != 72 || (c = array[offset + 1]) != 97 && c != 65 || (c = array[offset + 2]) != 114 && c != 82 || (c = array[offset + 3]) != 115 && c != 83 || (c = array[offset + 4]) != 101 && c != 69 || (c = array[offset + 5]) != 116 && c != 84) break;
                    offset += 6;
                    state = 9;
                    break;
                }
                case 9: {
                    if (c == 62) {
                        state = 0;
                        break;
                    }
                    if (c == 61) {
                        state = 11;
                        break;
                    }
                    if (StreamDecoder.isWhiteSpace(c)) {
                        state = 10;
                        break;
                    }
                    if (StreamDecoder.isWhiteSpace(c)) break;
                    state = 8;
                    break;
                }
                case 10: {
                    if (c == 62) {
                        state = 0;
                        break;
                    }
                    if (c == 61) {
                        state = 11;
                        break;
                    }
                    if (StreamDecoder.isWhiteSpace(c)) break;
                    state = 0;
                    break;
                }
                case 11: {
                    if (c == 62) {
                        state = 0;
                        break;
                    }
                    if (StreamDecoder.isWhiteSpace(c)) break;
                    state = 12;
                    encOffset = --offset;
                    break;
                }
                case 12: {
                    if (c != 62 && c != 39 && c != 34) break;
                    int encLength = offset - 1 - encOffset;
                    return new String(array, encOffset, encLength);
                }
            }
        }
        return result;
    }

    private static boolean isWhiteSpace(int c) {
        return c == 32 || c == 9 || c == 10 || c == 13 || c == 12;
    }

    private static boolean isXMLFile(String suffix) {
        if (suffix == null || suffix.length() == 0) {
            return false;
        }
        return StreamDecoder.getDocClassName(suffix).indexOf("XML") >= 0;
    }

    private static boolean isHTMLFile(String suffix) {
        if (suffix == null || suffix.length() == 0) {
            return false;
        }
        return StreamDecoder.getDocClassName(suffix).indexOf("Html") >= 0;
    }

    private static boolean isJSPFile(String suffix) {
        if (suffix == null || suffix.length() == 0) {
            return false;
        }
        return StreamDecoder.getDocClassName(suffix).indexOf("Jsp") >= 0;
    }

    private static String getDocClassName(String suffix) {
        String docClassName = FileTypesRecognizer.getClassNameForExtension((String)suffix);
        return docClassName != null ? docClassName : "";
    }

    private static Collection<StreamDecoderHelper> getDecoderHelpers() {
        ArrayList<StreamDecoderHelper> combined = new ArrayList<StreamDecoderHelper>();
        combined.addAll(_decoderHelpers);
        combined.addAll(StreamDecoder.getExtensionHelpers());
        return combined;
    }

    private static Collection<StreamDecoderHelper> getExtensionHelpers() {
        CompareStreamDecoderHook hook = (CompareStreamDecoderHook)ExtensionRegistry.getExtensionRegistry().getHook(new ElementName("http://xmlns.oracle.com/ide/extension", "compare-stream-decoder-hook"));
        return hook.getDecoderHelpers();
    }
}

