/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.dbcart.tools;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.UIManager;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.common.ddl.DDLFormat;
import oracle.dbtools.common.ddl.TargetFormat;
import oracle.dbtools.common.utils.Version;
import oracle.dbtools.dbcart.DbCartAddinArb;
import oracle.dbtools.dbcart.DbCartUtil;
import oracle.dbtools.dbcart.config.DbCartUserExportConfig;
import oracle.dbtools.dbcart.tools.DbCartUtilityTool;
import oracle.dbtools.export.service.ExportService;
import oracle.dbtools.export.service.IExportServiceAddendum;
import oracle.dbtools.extract.models.ExtractDataFormat;
import oracle.dbtools.extract.models.ExtractObject;
import oracle.dbtools.raptor.export.DbCartDeployOptions;
import oracle.dbtools.raptor.export.ExportAPI;
import oracle.dbtools.raptor.export.service.ExportServiceAddendumSD;
import oracle.dbtools.raptor.export.wizard.DataOptionsPanel;
import oracle.dbtools.raptor.export.wizard.ExportDdlOptionsPanel;
import oracle.dbtools.raptor.export.wizard.TargetOptionsPanel;
import oracle.dbtools.raptor.extract.ui.panels.DdlOptionsPanel;
import oracle.dbtools.raptor.images.RaptorImagesArb;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.IdeUtil;
import oracle.javatools.dialogs.MessageDialog;

public class DbCartExportTool
extends DbCartUtilityTool {
    public static final String TYPE = "Export";
    public static int ACTION = Ide.findOrCreateCmdID((String)"cart_export");
    private JEWTDialog _actionDialog;
    private DbCartDeployOptions _deployOptions;
    private ExportDdlOptionsPanel _ddlOptions;
    private DataOptionsPanel _dataOptions;
    private JPanel _ddlPanel;
    private JPanel _dataPanel;
    private JPanel _targetPanel;
    private JPanel _configPanel;
    private JPanel _mainPanel;
    JMultiLineLabel _instructions;
    private DDLFormat _ddlFormat;
    private ExtractDataFormat _dataFormat;
    private TargetFormat _targetFormat;
    private TargetOptionsPanel _targetOptions;
    private DbCartUserExportConfig _config = new DbCartUserExportConfig();
    private ExportAPI _expApi;
    private List<ExtractObject> _eoList;
    boolean _isUniqueWithSchema = true;
    boolean _isUniqueWithoutSchema = true;
    private ItemListener saveAsListener = new ItemListener(){

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                DbCartExportTool.this.saveAsChanged();
            }
        }
    };
    private ItemListener compressionListener = new ItemListener(){

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            ExtractDataFormat extractDataFormat = DbCartExportTool.this._dataOptions.getFormat();
            String string = "sql";
            if (itemEvent.getStateChange() == 1) {
                string = DbCartExportTool.this._targetOptions.getFormat().getCompressionExt();
            } else if ((DbCartExportTool.this._ddlOptions == null || DbCartExportTool.this._ddlOptions != null && !DbCartExportTool.this._ddlOptions.getFormat().isExtractEnabled()) && extractDataFormat != null) {
                string = extractDataFormat.getFileExtension();
            }
            DbCartExportTool.this._targetOptions.saveAsTypeChanged(string);
            DbCartExportTool.this._targetOptions.enableOpen(string, extractDataFormat);
            DbCartExportTool.this._targetOptions.setEncodings(extractDataFormat);
        }
    };
    private ItemListener saveAsImpactListener = new ItemListener(){

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            String string = "sql";
            ExtractDataFormat extractDataFormat = DbCartExportTool.this._dataOptions.getFormat();
            if ((DbCartExportTool.this._ddlOptions == null || DbCartExportTool.this._ddlOptions != null && !DbCartExportTool.this._ddlOptions.getFormat().isExtractEnabled()) && DbCartExportTool.this._dataOptions != null && extractDataFormat != null) {
                string = extractDataFormat.getFileExtension();
            }
            DbCartExportTool.this._targetOptions.adjustSaveAs(string, extractDataFormat);
            DbCartExportTool.this._targetOptions.setEncodings(extractDataFormat);
        }
    };
    ItemListener _formatListener = new ItemListener(){

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                DbCartExportTool.this.removeAll();
                DbCartExportTool.this.addPanels();
            }
        }
    };

    public DbCartExportTool() {
        super(TYPE, 3);
    }

    @Override
    public IdeAction getAction() {
        this._action = IdeAction.get((int)ACTION, null, (String)DbCartAddinArb.getString("EXPORT_LABEL"), null, null, (Icon)RaptorImagesArb.getIcon((String)"EXPORT"), null, (boolean)true);
        this._action.addController((Controller)this);
        return this._action;
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        if (ideAction.getCommandId() == ACTION) {
            if (this.validateObjects()) {
                this.showDialog();
            }
            return true;
        }
        return false;
    }

    public void showDialog() {
        this._eoList = DbCartUtil.getTableModel().getIncludedDBORows();
        boolean bl = this.handleUniqueCartRequired();
        if (bl) {
            ExtractDataFormat extractDataFormat;
            String string = DbCartAddinArb.getString("EXPORT_DIALOG_TITLE");
            this._instructions = new JMultiLineLabel(DbCartAddinArb.getString("EXPORT_INSTRUCTIONS"));
            this._mainPanel = new JPanel();
            this._mainPanel.setLayout(new GridBagLayout());
            HelpSystem.getHelpSystem().registerTopic((JComponent)this._mainPanel, "f1_deployobjects_html");
            boolean bl2 = DbCartUtil.getTableModel().isAnyDDLRows();
            this._ddlFormat = new DDLFormat();
            this._ddlFormat.isExtractEnabled(bl2);
            this._ddlFormat.setShowDDLOptionsEnabled(true);
            this._ddlFormat.setShowAlter(false);
            this._ddlFormat.setShowConstraint(true);
            this._ddlFormat.setShowRefConstraint(true);
            this._ddlFormat.setShowTrigger(true);
            this._ddlOptions = new ExportDdlOptionsPanel(this._ddlFormat);
            this._ddlPanel = this._ddlOptions.getPanel();
            if (this._ddlOptions != null && this._ddlOptions.getExportDDLComponent() != null) {
                this._ddlOptions.getExportDDLComponent().setEnabled(false);
            }
            this._ddlOptions.enableOptions(bl2);
            if (!this._isUniqueWithoutSchema) {
                this._ddlFormat.setSchema(true);
                this._ddlOptions.enableSchema(false);
            }
            this._ddlOptions.setVersionList(DbCartUtil.getHighestVersion(this._eoList));
            this._dataFormat = new ExtractDataFormat(ExtractDataFormat.EXPORT_WIZARD);
            this._targetOptions = new TargetOptionsPanel((Component)this._mainPanel);
            this.initDataPanel();
            this._configPanel = this.getConfigPanel();
            this._targetPanel = this._targetOptions.getPanel();
            String string2 = "sql";
            ExtractDataFormat extractDataFormat2 = extractDataFormat = this._dataOptions != null ? this._dataOptions.getFormat() : null;
            if (this._ddlOptions == null || this._ddlOptions != null && !this._ddlOptions.getFormat().isExtractEnabled()) {
                string2 = extractDataFormat != null ? extractDataFormat.getFileExtension() : "sql";
            }
            this._targetOptions.adjustSaveAs(string2, extractDataFormat);
            this._targetOptions.setEncodings(extractDataFormat);
            this.addPanels();
            this._mainPanel.setBackground(UIManager.getColor("EWTDialog.background"));
            this._actionDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)this._mainPanel, null, (String)string, (int)14);
            this._actionDialog.pack();
            ActionListener actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (actionEvent.getActionCommand().equalsIgnoreCase("apply")) {
                        DbCartExportTool.this._ddlFormat = DbCartExportTool.this._ddlOptions.getFormat();
                        DbCartExportTool.this._dataFormat = DbCartExportTool.this._dataOptions.getFormat();
                        DbCartExportTool.this._dataFormat.setUseConfigOptions(true);
                        DbCartExportTool.this._targetFormat = DbCartExportTool.this._targetOptions.getFormat();
                        ArrayList<ExtractObject> arrayList = DbCartExportTool.this.getClonedExtractObjects();
                        String string = ExportService.validateOptions((DDLFormat)DbCartExportTool.this._ddlFormat, (ExtractDataFormat)DbCartExportTool.this._dataFormat, (TargetFormat)DbCartExportTool.this._targetFormat, null, (Component)Ide.getMainWindow(), (IExportServiceAddendum)new ExportServiceAddendumSD());
                        if (string != null) {
                            if (string.length() > 0) {
                                MessageDialog.error((Component)Ide.getMainWindow(), (Object)string, (String)DbCartAddinArb.getString("EXPORT_LABEL"), (String)"DBCART_FORMAT_ERROR");
                            }
                        } else {
                            DbCartExportTool.this._deployOptions = new DbCartDeployOptions();
                            DbCartExportTool.this._deployOptions.setSourceExtractObjectList(arrayList);
                            DbCartExportTool.this._deployOptions.setTargetFormat(DbCartExportTool.this._targetFormat);
                            DbCartExportTool.this._deployOptions.setDDLFormat(DbCartExportTool.this._ddlFormat);
                            DbCartExportTool.this._deployOptions.setDataFormat(DbCartExportTool.this._dataFormat);
                            DbCartExportTool.this._expApi = new ExportAPI();
                            DbCartExportTool.this._expApi.setDeploy(DbCartExportTool.this._deployOptions);
                            DbCartExportTool.this._expApi.writeExportWithDialog();
                            DbCartExportTool.this._actionDialog.setVisible(false);
                            DbCartExportTool.this._actionDialog.dispose();
                        }
                    }
                }
            };
            this._actionDialog.addActionListener(actionListener);
            Dimension dimension = this._mainPanel.getPreferredSize();
            int n = (int)dimension.getHeight() + 120;
            int n2 = (int)dimension.getWidth() + 28;
            this._actionDialog.setMinimumSize(n2, n);
            IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)this._actionDialog);
            WizardLauncher.runDialog((JDialog)this._actionDialog);
        }
    }

    private void initDataPanel() {
        this._dataOptions = new DataOptionsPanel("4", this._dataFormat);
        this._dataPanel = this._dataOptions.getPanel();
        boolean bl = DbCartUtil.getTableModel().isAnyDataRows();
        this._dataOptions.setExportSelected(bl);
        this._dataOptions.enableOptions(bl);
        if (bl) {
            ((JComboBox)this._dataOptions.getFormatComponent()).addItemListener(this._formatListener);
        }
        if (this._dataOptions != null) {
            if (this._dataOptions.getExportDataComponent() != null) {
                this._dataOptions.isExportCheckboxEnabled(false);
            }
            this._dataOptions.setTargetOptions(this._targetOptions);
            this._dataOptions.setDDLOptions((DdlOptionsPanel)this._ddlOptions);
        }
    }

    private void removeAll() {
        if (this._ddlOptions != null && this._ddlOptions.getExportDDLComponent() != null) {
            this._ddlOptions.getExportDDLComponent().removeItemListener(this.saveAsImpactListener);
        }
        this._targetOptions.getSaveAsTypeComponent().removeItemListener(this.saveAsListener);
        this._targetOptions.getCompressionComponent().removeItemListener(this.compressionListener);
        if (this._dataOptions != null) {
            if (this._dataOptions.getExportDataComponent() != null) {
                this._dataOptions.getExportDataComponent().removeItemListener(this.saveAsImpactListener);
            }
            if (this._dataOptions.getFormatComponent() != null) {
                ((JComboBox)this._dataOptions.getFormatComponent()).removeItemListener(this._formatListener);
            }
        }
        this._mainPanel.removeAll();
    }

    private void addPanels() {
        this._mainPanel.add((Component)this._configPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 23, 0, new Insets(0, 0, 6, 0), 0, 0));
        this._mainPanel.add((Component)this._instructions, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 23, 2, new Insets(0, 0, 16, 0), 0, 0));
        this._mainPanel.add((Component)this._ddlPanel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 23, 2, new Insets(0, 0, 0, 0), 0, 0));
        this._mainPanel.add((Component)this._dataPanel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 23, 2, new Insets(16, 0, 0, 0), 0, 0));
        if (this._ddlOptions != null && this._ddlOptions.getExportDDLComponent() != null) {
            this._ddlOptions.getExportDDLComponent().addItemListener(this.saveAsImpactListener);
        }
        this._targetOptions.getSaveAsTypeComponent().addItemListener(this.saveAsListener);
        this._targetOptions.getCompressionComponent().addItemListener(this.compressionListener);
        if (this._dataOptions != null) {
            if (this._dataOptions.getFormatComponent() != null) {
                ((JComboBox)this._dataOptions.getFormatComponent()).addItemListener(this._formatListener);
            }
            if (this._dataOptions.getExportDataComponent() != null) {
                this._dataOptions.getExportDataComponent().addItemListener(this.saveAsImpactListener);
            }
        }
        this._mainPanel.add((Component)this._targetPanel, new GridBagConstraints(0, 4, 1, 1, 1.0, 1.0, 23, 2, new Insets(16, 0, 0, 0), 0, 0));
        this._mainPanel.validate();
        this._mainPanel.repaint();
    }

    @Override
    public void openConfigOptions() {
        URL uRL = this._chooser.getSelectedURL();
        try {
            this._config = new DbCartUserExportConfig(DbCartUserExportConfig.importFrom(uRL));
            String string = this._config.getString("DbCartConfig");
            if (string == null) {
                string = DbCartAddinArb.getString("XML_FILE_NO_KEY");
            }
            if (!string.equals("export_tool")) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)DbCartAddinArb.format("XML_FILE_ERROR_MESSAGE", uRL.getFile(), "\"export_tool\"", string), (String)DbCartAddinArb.getString("XML_FILE_ERROR_TITLE"), (String)"XML_FILE_ERROR_TITLE");
            } else {
                String string2;
                this.removeAll();
                this._config.copyToDDLFormat(this._ddlFormat);
                this._ddlFormat.isExtractEnabled(DbCartUtil.getTableModel().isAnyDDLRows());
                if (!this._isUniqueWithoutSchema) {
                    this._ddlFormat.setSchema(true);
                }
                this._ddlOptions.setFormat(this._ddlFormat);
                boolean bl = DbCartUtil.getTableModel().isAnyDDLRows();
                this._ddlOptions.getExportDDLComponent().setSelected(bl);
                this._ddlOptions.getExportDDLComponent().setEnabled(false);
                this._ddlOptions.enableOptions(bl);
                if (!this._isUniqueWithoutSchema) {
                    this._ddlOptions.enableSchema(false);
                }
                if (!(string2 = this._ddlFormat.getVersion()).equals(DDLFormat.COMPATIBLE) && !string2.equals(DDLFormat.LATEST)) {
                    Version version = DbCartUtil.getHighestVersion(this._eoList);
                    this._ddlOptions.setVersionList(version);
                    Version version2 = new Version(string2);
                    if (version2.compareTo(version) > 0) {
                        this._ddlFormat.setVersion(DDLFormat.COMPATIBLE);
                        MessageDialog.information((Component)Ide.getMainWindow(), (Object)DbCartAddinArb.format("VERSION_WARNING", version2.toCanonicalString()), (String)DbCartAddinArb.getString("XML_FILE_ERROR_TITLE"), (String)"XML_FILE_ERROR_TITLE");
                    }
                }
                this._ddlOptions.setVersion(this._ddlFormat.getVersion());
                this._targetFormat = this._targetOptions.getFormat();
                this._config.copyToTargetFormat(this._targetFormat);
                this._targetOptions.setFormat(this._targetFormat);
                this._config.copyToDataFormat(this._dataFormat);
                this.initDataPanel();
                this.saveAsChanged();
                this.addPanels();
                this._actionDialog.pack();
                this._actionDialog.repaint();
            }
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    @Override
    public void saveConfigOptions() {
        URL uRL = this.getConfigURL();
        try {
            this._config.putString("DbCartConfig", "export_tool");
            this._config.copyFromDDLFormat(this._ddlOptions.getFormat());
            this._config.copyFromDataFormat(this._dataOptions.getFormat());
            this._config.copyFromTargetFormat(this._targetOptions.getFormat());
            this._config.exportTo(uRL);
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    protected boolean handleUniqueCartRequired() {
        List<ExtractObject> list = DbCartUtil.validateUniqueObjects(this._eoList, true);
        List<ExtractObject> list2 = DbCartUtil.validateUniqueObjects(this._eoList, false);
        boolean bl = true;
        if (!list.isEmpty() || !list2.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder();
            String string = "";
            if (!list.isEmpty()) {
                this._isUniqueWithSchema = false;
                stringBuilder.append(DbCartAddinArb.format("NON_UNIQUE_CART2", DbCartAddinArb.getString("SOURCE_LABEL")) + "\n\n");
                for (ExtractObject extractObject : list) {
                    stringBuilder.append(string + Connections.getDisplayName((String)extractObject.getDBObject().getConnectionName()) + ": " + extractObject.getDBObject().getObjectType() + " " + extractObject.getDBObject().getSchemaName() + "." + extractObject.getDBObject().getObjectName());
                    string = ", ";
                }
                stringBuilder.append("\n\n");
                stringBuilder.append(DbCartAddinArb.format("NOT_SUPPORTED", DbCartAddinArb.getString("EXPORT_LABEL")) + "\n\n");
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)stringBuilder.toString(), (String)DbCartAddinArb.getString("EXPORT_LABEL"), (String)"DBCART_UNIQUE_ERROR");
                bl = false;
            } else if (!list2.isEmpty()) {
                this._isUniqueWithoutSchema = false;
                stringBuilder.append(DbCartAddinArb.format("NON_UNIQUE_CART_NOSCHEMA", DbCartAddinArb.getString("SOURCE_LABEL")) + "\n\n");
                for (ExtractObject extractObject : list) {
                    stringBuilder.append(string + Connections.getDisplayName((String)extractObject.getDBObject().getConnectionName()) + ": " + extractObject.getDBObject().getObjectType() + " " + extractObject.getDBObject().getSchemaName() + "." + extractObject.getDBObject().getObjectName());
                    string = ", ";
                }
                stringBuilder.append("\n");
                stringBuilder.append(DbCartAddinArb.getString("CONTINUE"));
                bl = MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)stringBuilder.toString(), (String)DbCartAddinArb.getString("EXPORT_LABEL"), (String)"DBCART_UNIQUE_WARNING");
            }
        }
        return bl;
    }

    private void saveAsChanged() {
        String string = "sql";
        ExtractDataFormat extractDataFormat = this._dataOptions.getFormat();
        if ((this._ddlOptions == null || this._ddlOptions != null && !this._ddlOptions.getFormat().isExtractEnabled()) && extractDataFormat != null) {
            string = this._dataOptions.getFormat().getFileExtension();
        }
        this._targetOptions.saveAsTypeChanged(string);
        this._targetOptions.enableOpen(string, extractDataFormat);
        this._targetOptions.setEncodings(extractDataFormat);
    }
}

