/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.jdev.undo;

import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.undo.UndoableEdit;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Command;
import oracle.ide.model.Node;
import oracle.ide.model.UpdateMessage;

public class MultiEditUndoableEditCommand
extends Command {
    private boolean _hasBeenUndone = false;
    private final Node[] _nodes;
    private final UndoableEdit[] _edits;
    private static final int _CMD_ID = Ide.findOrCreateCmdID((String)MultiEditUndoableEditCommand.class.getName());
    private static final Logger _LOGGER = Logger.getLogger(MultiEditUndoableEditCommand.class.getName());

    public MultiEditUndoableEditCommand(String name, Collection nodes, Collection edits) {
        super(_CMD_ID, 1, name);
        int numNodes;
        for (UndoableEdit edit : edits) {
            int curType = MultiEditUndoableEditCommand.__getType(edit);
            if (curType == 2) {
                this.type = 2;
                break;
            }
            if (curType != 0 || this.type != 1) continue;
            this.type = 3;
        }
        if ((numNodes = nodes.size()) == 1) {
            this._nodes = null;
            this.setContext(new Context((Node)nodes.iterator().next()));
        } else {
            this._nodes = nodes.toArray(new Node[numNodes]);
            this.setContext(new Context());
        }
        this._edits = edits.toArray(new UndoableEdit[edits.size()]);
    }

    public int doit() throws Exception {
        boolean ok = true;
        if (this._hasBeenUndone) {
            for (int i = 0; i < this._edits.length; ++i) {
                int ret = this._unOrReDo(this._edits[i], false);
                if (ret == 0) continue;
                ok = false;
            }
        } else {
            _LOGGER.log(Level.FINER, "Ignored redo: {0}", this.getName());
        }
        this._notify();
        return ok ? 0 : 1;
    }

    public int undo() throws Exception {
        boolean ok = true;
        for (int i = this._edits.length - 1; i >= 0; --i) {
            int ret = this._unOrReDo(this._edits[i], true);
            if (ret == 0) continue;
            ok = false;
        }
        this._notify();
        return ok ? 0 : 1;
    }

    public boolean enableConfirmation() {
        return false;
    }

    public Node[] getAffectedNodes() {
        return this._nodes;
    }

    private int _unOrReDo(UndoableEdit edit, boolean isUndo) {
        String word = isUndo ? "undo" : "redo";
        this._hasBeenUndone = true;
        if (_LOGGER.isLoggable(Level.FINER)) {
            _LOGGER.finer(word + " " + edit);
        }
        try {
            if (isUndo) {
                edit.undo();
            } else {
                edit.redo();
            }
        }
        catch (Exception e) {
            _LOGGER.log(Level.SEVERE, "Exception in " + word + "!", e);
            return 1;
        }
        return 0;
    }

    static int __getType(UndoableEdit edit) {
        if (edit.canUndo()) {
            if (edit.isSignificant()) {
                return 0;
            }
            return 1;
        }
        return 2;
    }

    private void _notify() {
        Context context = this.getContext();
        if (context != null) {
            MultiEditUndoableEditCommand.__notify(context.getNode());
        }
        if (this._nodes != null) {
            MultiEditUndoableEditCommand.__notify(this._nodes);
        }
    }

    static void __notify(final Node ... nodes) {
        if (SwingUtilities.isEventDispatchThread()) {
            for (Node node : nodes) {
                if (node == null) continue;
                node.notifyObservers((Object)node, new UpdateMessage(UpdateMessage.STRUCTURE_CHANGED, (Object)node));
            }
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MultiEditUndoableEditCommand.__notify(nodes);
                }
            });
        }
    }
}

