/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.jdev.xmlComponent;

import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import net.miginfocom.layout.CC;
import oracle.bali.ewt.help.HelpUtils;
import oracle.bali.xml.gui.XmlGui;
import oracle.bali.xml.gui.base.xmlComponent.XmlComponentLayoutOption;
import oracle.bali.xml.gui.base.xmlComponent.XmlComponentModel;
import oracle.bali.xml.gui.base.xmlComponent.XmlComponentWrapper;
import oracle.bali.xml.gui.jdev.overviewEditor.OverviewEditorPanelLayoutPolicy;
import oracle.bali.xml.gui.jdev.xmlComponent.XmlComponentWrapperImpl;
import oracle.bali.xml.gui.jdev.xmlComponent.XmlComponentWrapperMap;
import oracle.bali.xml.gui.jdev.xmlComponent.XmlHeader;
import oracle.bali.xml.gui.jdev.xmlComponent.XmlHeaderOption;
import oracle.bali.xml.gui.jdev.xmlComponent.XmlPanelGui;
import oracle.bali.xml.gui.jdev.xmlComponent.XmlPanelLayoutPolicy;
import oracle.bali.xml.gui.jdev.xmlComponent.XmlPanelWrapper;
import oracle.bali.xml.gui.jdev.xmlComponent.XmlTabHeader;
import oracle.bali.xml.gui.swing.xmlComponent.XmlLayoutOption;
import oracle.bali.xml.metadata.XmlKey;
import oracle.ide.controls.FlatEditorTransparentPanel;
import oracle.javatools.ui.Colors;
import org.w3c.dom.Node;

public abstract class AbstractXmlPanelWrapper
implements XmlPanelWrapper {
    private int _updateRefCount = 0;
    private boolean _updating = false;
    private XmlHeader _currHeaderSection;
    private XmlPanelGui _xmlGui;
    private boolean _deferCommit;
    private XmlPanelLayoutPolicy _panelLayoutPolicy;
    private XmlComponentWrapperMap _xmlComponentWrapperMap;
    private JPanel _panel;
    private XmlGui _parentXmlGui;
    private XmlKey _xmlPanelRootXmlKey;
    private int _displayOrder;
    private String _label;
    private String _helpTopicId;
    private Stack<XmlHeader> _headerSectionStack = new Stack();
    private List<XmlHeader> _headerSectionList = new ArrayList<XmlHeader>();
    private List<XmlComponentWrapper> _xmlComponentWrapperList = new ArrayList<XmlComponentWrapper>();
    private boolean _xmlComponentsUpdated = false;
    private boolean _useDefaultTabMargin = false;

    public AbstractXmlPanelWrapper(XmlPanelGui xmlGui, XmlKey xmlPanelRootXmlKey, int displayOrder, String label, String helpTopicId) {
        this._xmlGui = xmlGui;
        this._xmlPanelRootXmlKey = xmlPanelRootXmlKey;
        this._helpTopicId = helpTopicId;
        this._displayOrder = displayOrder;
        this._label = label;
        this._deferCommit = false;
        this._xmlComponentsUpdated = false;
    }

    @Override
    public final void createXmlComponents() {
        this.getLayoutPolicy();
        this.createXmlComponentsImpl();
    }

    protected abstract void createXmlComponentsImpl();

    @Override
    public final XmlPanelLayoutPolicy getLayoutPolicy() {
        if (this._panelLayoutPolicy == null) {
            this._panelLayoutPolicy = this.createLayoutPolicy();
        }
        return this._panelLayoutPolicy;
    }

    @Override
    public final JPanel getPanel() {
        if (this._panel == null) {
            this._panel = this.createPanel();
            HelpUtils.setHelpID((JComponent)this._panel, (String)this._helpTopicId);
        }
        return this._panel;
    }

    @Override
    public final XmlGui getParentXmlGui() {
        return this._parentXmlGui;
    }

    @Override
    public final void setParentXmlGui(XmlGui xmlGui) {
        this._parentXmlGui = xmlGui;
    }

    @Override
    public boolean handleSelectionChanged(Object selectedObject) {
        if (this.getXmlComponentWrapperMap().isEmpty()) {
            this.createXmlComponents();
            if (!this.panelContainsSelectedObject((Node)selectedObject)) {
                return false;
            }
        } else if (selectedObject instanceof Node && !this.panelContainsSelectedObject((Node)selectedObject)) {
            return false;
        }
        this.updateXmlComponentsFromModel();
        boolean selectionHandled = false;
        for (XmlComponentWrapper xmlComponentWrapper : this._xmlComponentWrapperList) {
            if (!xmlComponentWrapper.handleSelectionChanged(selectedObject)) continue;
            selectionHandled = true;
        }
        for (XmlHeader xmlHeader : this._headerSectionList) {
            if (!xmlHeader.handleSelectionChanged(selectedObject)) continue;
            selectionHandled = true;
        }
        return selectionHandled;
    }

    public JPanel createPanel() {
        return new FlatEditorTransparentPanel();
    }

    public final XmlPanelWrapper setPanel(JPanel panel) {
        this._panel = panel;
        HelpUtils.setHelpID((JComponent)this._panel, (String)this._helpTopicId);
        return this;
    }

    @Override
    public XmlPanelLayoutPolicy createLayoutPolicy() {
        return new OverviewEditorPanelLayoutPolicy(this);
    }

    @Override
    public XmlComponentWrapperMap getXmlComponentWrapperMap() {
        if (this._xmlComponentWrapperMap == null) {
            this._xmlComponentWrapperMap = new XmlComponentWrapperMap(this, this._parentXmlGui);
        }
        return this._xmlComponentWrapperMap;
    }

    @Override
    public XmlPanelGui getXmlGui() {
        return this._xmlGui;
    }

    @Override
    public int getDisplayOrder() {
        return this._displayOrder;
    }

    @Override
    public String getLabel() {
        return this._label;
    }

    @Override
    public XmlKey getXmlPanelRootXmlKey() {
        return this._xmlPanelRootXmlKey;
    }

    @Override
    public final void updateXmlComponentsFromModel() {
        this._xmlComponentWrapperMap.updateXmlComponentsFromModel();
        this.updateXmlComponentsFromModelHook();
        this._xmlComponentsUpdated = true;
    }

    protected void updateXmlComponentsFromModelHook() {
    }

    @Override
    public final void updateModelFromXmlComponents() {
        this._xmlComponentWrapperMap.updateModelFromXmlComponents();
        this.updateModelFromXmlComponentsHook();
    }

    protected void updateModelFromXmlComponentsHook() {
    }

    @Override
    public final void invalidateXmlComponents() {
        if (this._xmlComponentWrapperMap == null) {
            return;
        }
        this._xmlComponentWrapperMap.invalidateXmlComponents();
        this.invalidateXmlComponentsHook();
    }

    protected void invalidateXmlComponentsHook() {
    }

    public void add(XmlComponentWrapper xmlComponentWrapper) {
        this.add(xmlComponentWrapper, true);
    }

    public void add(XmlComponentWrapper xmlComponentWrapper, boolean addToLayout) {
        this.setupXmlComponentWrapper(xmlComponentWrapper);
        XmlComponentLayoutOption xmlComponentLayoutOption = null;
        if (addToLayout && (xmlComponentLayoutOption = xmlComponentWrapper.getPropertyEditor().getXmlComponentLayoutOption()) == null) {
            xmlComponentLayoutOption = new XmlLayoutOption();
        }
        if (this.getCurrHeaderSection() != null) {
            if (addToLayout) {
                this.getLayoutPolicy().add((JPanel)this.getCurrHeaderSection().getHeaderContainer(), xmlComponentWrapper, xmlComponentLayoutOption);
            }
            this.getCurrHeaderSection().add(xmlComponentWrapper);
        } else {
            if (addToLayout) {
                this.getLayoutPolicy().add(this.getPanel(), xmlComponentWrapper, xmlComponentLayoutOption);
            }
            this._xmlComponentWrapperList.add(xmlComponentWrapper);
        }
    }

    public void add(XmlComponentWrapper xmlComponentWrapper, XmlLayoutOption layoutOption) {
        this.setupXmlComponentWrapper(xmlComponentWrapper);
        if (this.getCurrHeaderSection() != null) {
            this.getLayoutPolicy().add((JPanel)this.getCurrHeaderSection().getHeaderContainer(), xmlComponentWrapper, (XmlComponentLayoutOption)layoutOption);
            this.getCurrHeaderSection().add(xmlComponentWrapper);
        } else {
            this.getLayoutPolicy().add(this.getPanel(), xmlComponentWrapper, (XmlComponentLayoutOption)layoutOption);
            this._xmlComponentWrapperList.add(xmlComponentWrapper);
        }
    }

    public void addPageHeader(XmlHeaderOption headerOption) {
        this.getLayoutPolicy();
        if (headerOption.getHeaderLabel() != null) {
            JComponent headerPanel = headerOption.buildPageHeader();
            if (headerOption.getAlignInstructionalTextWithHeaderLabel()) {
                String headerControlVGap = "8";
                this.getPanel().add((Component)headerPanel, new CC().wrap().gapX("0", "0").gapY("0", headerControlVGap));
                return;
            }
            if (headerOption.getInstructionalText() != null && headerOption.getInstructionalText().length() > 0) {
                JLabel instructionalTextLabel = new JLabel();
                instructionalTextLabel.setText(headerOption.getInstructionalText());
                instructionalTextLabel.setForeground(Colors.HINT_TEXT);
                String headerInstructionVGap = "6";
                String instructionControlVGap = "8";
                this.getPanel().add((Component)headerPanel, new CC().wrap().gapX("0", "0").gapY("0", "0"));
                this.getPanel().add((Component)instructionalTextLabel, new CC().wrap().gapX("0", "0").gapY(headerInstructionVGap, instructionControlVGap));
            } else {
                String headerControlVGap = "8";
                this.getPanel().add((Component)headerPanel, new CC().wrap().gapX("0", "0").gapY("0", headerControlVGap));
            }
        }
    }

    public void addSectionHeader(XmlHeaderOption headerOption) {
        this.addSectionHeader(headerOption, false);
    }

    public void addSectionHeader(XmlHeaderOption headerOption, boolean createChildHeader) {
        if (createChildHeader && this.getCurrHeaderSection() != null) {
            XmlHeader childHeader = this.getLayoutPolicy().addSectionHeader((JPanel)this.getCurrHeaderSection().getHeaderContainer(), headerOption);
            this.getCurrHeaderSection().add(childHeader);
            this._headerSectionStack.push(this.getCurrHeaderSection());
            this._currHeaderSection = childHeader;
        } else {
            this._currHeaderSection = this.getLayoutPolicy().addSectionHeader(this.getPanel(), headerOption);
            this._headerSectionList.add(this._currHeaderSection);
        }
    }

    public void addSectionHeader(XmlHeaderOption headerOption, XmlComponentWrapper parentXmlComponentWrapper) {
        this.addSectionHeader(headerOption, false, parentXmlComponentWrapper);
    }

    public void addSectionHeader(XmlHeaderOption headerOption, boolean createChildHeader, XmlComponentWrapper parentXmlComponentWrapper) {
        this.addSectionHeader(headerOption, createChildHeader);
        if (parentXmlComponentWrapper != null) {
            this.getCurrHeaderSection().getHeaderContainer().setEnabled(false);
            parentXmlComponentWrapper.setChildHeaderComponent((Component)this.getCurrHeaderSection().getHeaderContainer());
        }
    }

    public void addTabHeader(XmlHeaderOption headerOption) {
        this.addTabHeader(headerOption, false);
    }

    public void addTabHeader(XmlHeaderOption headerOption, boolean createChildHeader) {
        if (this.getUseDefaultTabMargin()) {
            headerOption.useDefaultTabMargin();
        }
        if (createChildHeader && this.getCurrHeaderSection() != null) {
            this.getLayoutPolicy().setTabHeader(null);
            XmlHeader childHeader = this.getLayoutPolicy().addTabHeader((JPanel)this.getCurrHeaderSection().getHeaderContainer(), headerOption);
            this.getCurrHeaderSection().add(childHeader);
            this._headerSectionStack.push(this.getCurrHeaderSection());
            this._currHeaderSection = childHeader;
        } else if (this.getCurrHeaderSection() != null && this.getCurrHeaderSection() instanceof XmlTabHeader) {
            XmlHeader childHeader;
            this._currHeaderSection = childHeader = this.getLayoutPolicy().addTabHeader((JPanel)this.getCurrHeaderSection().getHeaderContainer(), headerOption);
        } else {
            this._currHeaderSection = this.getLayoutPolicy().addTabHeader(this.getPanel(), headerOption);
            this._headerSectionList.add(this._currHeaderSection);
        }
    }

    public void addTabHeader(XmlHeaderOption headerOption, XmlComponentWrapper parentXmlComponentWrapper) {
        this.addTabHeader(headerOption, false, parentXmlComponentWrapper);
    }

    public void addTabHeader(XmlHeaderOption headerOption, boolean createChildHeader, XmlComponentWrapper parentXmlComponentWrapper) {
        this.addTabHeader(headerOption, createChildHeader);
        if (parentXmlComponentWrapper != null) {
            this.getTabHeaderTabbedPane().setEnabled(false);
            parentXmlComponentWrapper.setChildHeaderComponent((Component)this.getTabHeaderTabbedPane());
        }
    }

    public JTabbedPane getTabHeaderTabbedPane() {
        return this.getLayoutPolicy().getTabHeaderTabbedPane();
    }

    public void endHeader() {
        if (this._headerSectionStack.empty()) {
            this._currHeaderSection = null;
            this.getLayoutPolicy().setTabHeader(null);
        } else {
            this._currHeaderSection = this._headerSectionStack.pop();
        }
    }

    public XmlHeader getCurrHeaderSection() {
        return this._currHeaderSection;
    }

    public JPanel getCurrHeaderPanel() {
        if (this._currHeaderSection == null) {
            return null;
        }
        return (JPanel)this._currHeaderSection.getHeaderContainer();
    }

    public Container getCurrContainer() {
        return this.getCurrHeaderPanel() != null ? this.getCurrHeaderPanel() : this.getPanel();
    }

    public XmlComponentWrapperImpl createXmlComponentWrapper(XmlKey xmlKey) {
        return XmlComponentWrapperImpl.create(xmlKey, this.getXmlGui(), this, this._xmlPanelRootXmlKey);
    }

    public boolean getDeferCommit() {
        return this._deferCommit;
    }

    public void setDeferCommit(boolean deferCommit) {
        this._deferCommit = deferCommit;
    }

    private void setupXmlComponentWrapper(XmlComponentWrapper xmlComponentWrapper) {
        XmlComponentWrapper parentXmlComponentWrapper = xmlComponentWrapper.getParent();
        XmlComponentModel uiComponentModel = xmlComponentWrapper.getXmlComponentModel();
        if (parentXmlComponentWrapper == null) {
            uiComponentModel.setParentXmlComponentModel(null);
        } else {
            uiComponentModel.setParentXmlComponentModel(parentXmlComponentWrapper.getXmlComponentModel());
        }
        this.getXmlComponentWrapperMap().put(xmlComponentWrapper);
    }

    @Override
    public void dispose() {
        if (this._xmlComponentWrapperMap != null) {
            this._xmlComponentWrapperMap.dispose();
            this._xmlComponentWrapperMap = null;
        }
        if (this._panel != null) {
            this._panel.removeAll();
        }
        this._currHeaderSection = null;
        this._panelLayoutPolicy = null;
    }

    public void beginUpdate() {
        this._updating = true;
        ++this._updateRefCount;
    }

    public void endUpdate() {
        --this._updateRefCount;
        if (this._updateRefCount == 0) {
            this._updating = false;
        }
    }

    public boolean getUpdating() {
        return this._updating;
    }

    public XmlComponentWrapper get(XmlKey xmlKey) {
        return this.getXmlComponentWrapperMap().get(xmlKey);
    }

    public boolean panelContainsSelectedObject(Object selectedObject) {
        if (selectedObject == null) {
            return false;
        }
        Node selectedNode = (Node)selectedObject;
        Map<XmlKey, XmlComponentWrapper> xmlKeyComponentWrapperMap = this.getXmlComponentWrapperMap().getXmlKeyComponentWrapperMap();
        boolean xmlKeyFound = false;
        for (Map.Entry<XmlKey, XmlComponentWrapper> entries : xmlKeyComponentWrapperMap.entrySet()) {
            String elementName = entries.getKey().getLocalName();
            if (entries.getKey().getNodeType() == 2 && entries.getKey().getElementQName() != null) {
                elementName = entries.getKey().getElementQName().getName();
            }
            if (!elementName.equalsIgnoreCase(selectedNode.getLocalName())) continue;
            return true;
        }
        return xmlKeyFound;
    }

    public boolean getUseDefaultTabMargin() {
        return this._useDefaultTabMargin;
    }

    public void setUseDefaultTabMargin(boolean useDefaultTabMargin) {
        this._useDefaultTabMargin = useDefaultTabMargin;
    }
}

