/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.compiler;

import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import oracle.aurora.compiler.ExternalEntity;
import oracle.aurora.compiler.QName;

public class ExternalEntityBytes
extends ExternalEntity {
    int kind;
    char[] chars;
    byte[] bytes;
    String encoding;
    QName name;

    public ExternalEntityBytes(QName name, int kind, byte[] bytes, String encoding) {
        super(kind);
        if (bytes == null) {
            NullPointerException ex = new NullPointerException("ExternalEntityBytes: bytes == null");
            throw ex;
        }
        this.name = name;
        this.kind = kind;
        this.bytes = bytes;
        this.encoding = encoding;
    }

    public ExternalEntityBytes(QName name, int kind, byte[] bytes) {
        this(name, kind, bytes, null);
    }

    public boolean isKind(int rhs) {
        return this.kind == rhs;
    }

    public Reader getReader() throws IOException {
        InputStream in;
        Reader reader = null;
        reader = this.chars != null ? new CharArrayReader(this.chars) : ((in = this.getStream()) != null && this.encoding != null ? new InputStreamReader(in, this.encoding) : new InputStreamReader(in));
        return reader;
    }

    public InputStream getStream() {
        ByteArrayInputStream in = null;
        if (this.bytes != null) {
            in = new ByteArrayInputStream(this.bytes);
        }
        return in;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public QName getQualifiedName() {
        return this.name;
    }

    public String getPath() {
        return "internal array for " + this.name;
    }

    public String getNameForClassFile() {
        return this.name.getName();
    }

    public void setPackage(String pkg) {
    }

    public boolean equals(Object other) {
        return this == other;
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

