/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.udb.v71;

import oracle.dbtools.crest.exports.ddl.udb.AbstractSSBUDB;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.udb.v71.BufferPoolUDBv71;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBBufferPoolUDBv71
extends AbstractSSBUDB {
    public static final String ALL_NODES = "ALL NODES";
    private static final String SIZE = "SIZE";
    private static final String EXCEPT_ON_NODES = "EXCEPT ON NODES";
    private static final String PAGESIZE = "PAGESIZE";
    private static final String EXTENDED_STORAGE = "EXTENDED STORAGE";
    private StorageDesign storageDesign;

    @Override
    public boolean canHandle(Object object) {
        return object instanceof BufferPoolUDBv71 && ((BufferPoolUDBv71)object).isMarkedGenerate();
    }

    @Override
    protected void doAppend(StringBuffer buffer, Object object, boolean prettyPrint) {
        BufferPoolUDBv71 bufferpool = (BufferPoolUDBv71)object;
        this.storageDesign = bufferpool.getStorageDesign();
        this.appendCreate(buffer, bufferpool);
        this.appendNodeGroups(buffer, bufferpool, prettyPrint);
        this.appendSize(buffer, bufferpool, prettyPrint);
        this.appendPageSize(buffer, bufferpool, prettyPrint);
        this.appendExtendedStorage(buffer, bufferpool, prettyPrint);
        SSBBufferPoolUDBv71.appendNewLine(buffer, prettyPrint, 0);
        SSBBufferPoolUDBv71.appendLineFinisher(buffer, prettyPrint);
        DDLFileMaker.incrementCreateBufferPool();
    }

    protected void appendCreate(StringBuffer buffer, BufferPoolUDBv71 bufferpool) {
        this.appendCreate(buffer);
        SSBBufferPoolUDBv71.appendStringWithSpace(buffer, "BUFFERPOOL");
        SSBBufferPoolUDBv71.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(bufferpool.getName()));
    }

    protected void appendNodeGroups(StringBuffer buffer, BufferPoolUDBv71 bufferpool, boolean prettyPrint) {
        if (!bufferpool.getScope().equalsIgnoreCase("")) {
            SSBBufferPoolUDBv71.appendNewLine(buffer, prettyPrint, 1);
            if (bufferpool.getScope().equalsIgnoreCase("")) {
                SSBBufferPoolUDBv71.appendStringWithSpace(buffer, ALL_NODES);
            } else {
                SSBBufferPoolUDBv71.appendStringWithSpace(buffer, "NODEGROUP");
                SSBBufferPoolUDBv71.appendStringWithSpace(buffer, bufferpool.getScope());
            }
        }
    }

    protected void appendSize(StringBuffer buffer, BufferPoolUDBv71 bufferpool, boolean prettyPrint) {
        if (this.storageDesign.getAppView().getSettings().isIncludeStorageInDDL()) {
            SSBBufferPoolUDBv71.appendNewLine(buffer, prettyPrint, 1);
            SSBBufferPoolUDBv71.appendStringWithSpace(buffer, SIZE);
            SSBBufferPoolUDBv71.appendStringWithSpace(buffer, bufferpool.getSize());
            if (!bufferpool.getNodesWithDiffSize().equalsIgnoreCase("")) {
                SSBBufferPoolUDBv71.appendStringWithSpace(buffer, EXCEPT_ON_NODES);
                SSBBufferPoolUDBv71.appendStringWithSpace(buffer, '(');
                SSBBufferPoolUDBv71.appendStringWithSpace(buffer, bufferpool.getNodesWithDiffSize());
                SSBBufferPoolUDBv71.appendStringWithSpace(buffer, ')');
            }
        }
    }

    protected void appendPageSize(StringBuffer buffer, BufferPoolUDBv71 bufferpool, boolean prettyPrint) {
        if (bufferpool.getPageSize() > 0 && this.storageDesign.getAppView().getSettings().isIncludeStorageInDDL()) {
            SSBBufferPoolUDBv71.appendNewLine(buffer, prettyPrint, 1);
            SSBBufferPoolUDBv71.appendStringWithSpace(buffer, PAGESIZE);
            SSBBufferPoolUDBv71.appendStringWithSpace(buffer, bufferpool.getPageSize());
            SSBBufferPoolUDBv71.appendStringWithSpace(buffer, 'K');
        }
    }

    protected void appendExtendedStorage(StringBuffer buffer, BufferPoolUDBv71 bufferpool, boolean prettyPrint) {
        if (bufferpool.getExtendedStorage() && this.storageDesign.getAppView().getSettings().isIncludeStorageInDDL()) {
            SSBBufferPoolUDBv71.appendNewLine(buffer, prettyPrint, 1);
            SSBBufferPoolUDBv71.appendStringWithSpace(buffer, EXTENDED_STORAGE);
        }
    }
}

