/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.oracleaw;

import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.io.FileWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import oracle.AWAction.BuildDatabase;
import oracle.AWAction.Interaction;
import oracle.AWXML.AW;
import oracle.AWXML.AWConnection;
import oracle.AWXML.AggregationArgument;
import oracle.AWXML.AggregationDefinition;
import oracle.AWXML.AggregationHierarchySpecification;
import oracle.AWXML.AggregationOperator;
import oracle.AWXML.AttributeProjection;
import oracle.AWXML.AttributeSourceExpression;
import oracle.AWXML.BaseObject;
import oracle.AWXML.BaseOperator;
import oracle.AWXML.ConfigurationParameters;
import oracle.AWXML.CubeDimRef;
import oracle.AWXML.CubeDimensionSourceExpression;
import oracle.AWXML.CubeMapGroup;
import oracle.AWXML.DerivedMeasure;
import oracle.AWXML.DimensionKeySourceExpression;
import oracle.AWXML.DimensionMapGroup;
import oracle.AWXML.DimensionMemberExpression;
import oracle.AWXML.HierarchicalParentSourceExpression;
import oracle.AWXML.Hierarchy;
import oracle.AWXML.HierarchyLevelAssociation;
import oracle.AWXML.Index;
import oracle.AWXML.Level;
import oracle.AWXML.Measure;
import oracle.AWXML.MeasureSourceExpression;
import oracle.AWXML.OlapMeasure;
import oracle.AWXML.OlapMeasureInput;
import oracle.AWXML.Parameter;
import oracle.AWXML.PermanentCalculatedMember;
import oracle.AWXML.PreComputeClause;
import oracle.AWXML.SolveDefDimRef;
import oracle.AWXML.SolveDefinition;
import oracle.AWXML.SourceColumn;
import oracle.AWXML.WhereClause;
import oracle.dbtools.crest.exports.Messages;
import oracle.dbtools.crest.exports.oracleaw.AWExportOptions;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.AttributeView;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.multidimensional.CalculatedAttribute;
import oracle.dbtools.crest.model.design.multidimensional.Cube;
import oracle.dbtools.crest.model.design.multidimensional.Dimension;
import oracle.dbtools.crest.model.design.multidimensional.Level;
import oracle.dbtools.crest.model.design.multidimensional.Link;
import oracle.dbtools.crest.model.design.multidimensional.Measure;
import oracle.dbtools.crest.model.design.multidimensional.MeasureFolder;
import oracle.dbtools.crest.model.design.multidimensional.MultidimensionalDesign;
import oracle.dbtools.crest.model.design.multidimensional.RollupLink;
import oracle.dbtools.crest.model.design.multidimensional.Slice;
import oracle.dbtools.crest.model.design.multidimensional.SlowChangingAttribute;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.LogReport;
import oracle.dbtools.crest.swingui.ProgressDialog;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.express.spl.SPLExecutor;
import oracle.ide.Ide;
import oracle.jdbc.OracleConnection;

public class OracleAWExporter {
    public static String EXPORT_RECREATE_AW = Messages.getString("OracleAWExporter.0");
    public static String EXPORT_METADATA_TO_FILE = Messages.getString("OracleAWExporter.1");
    public static String EXPORT_NEW_CALC_MEASURES = Messages.getString("OracleAWExporter.2");
    public static String EXPORT_ALL_CALC_MEASURES = Messages.getString("OracleAWExporter.3");
    public static String[] EXPORT_TYPES = new String[]{EXPORT_RECREATE_AW, EXPORT_NEW_CALC_MEASURES, EXPORT_ALL_CALC_MEASURES, EXPORT_METADATA_TO_FILE};
    public static String[] EXPORT_TYPES_11 = new String[]{EXPORT_RECREATE_AW, EXPORT_METADATA_TO_FILE};
    private ApplicationView appView;
    private static final Logger LOGGER = new Logger(OracleAWExporter.class);
    private MultidimensionalDesign mdmDesign;
    private MultidimensionalDesign tmdmDesign;
    private String schema = "CVSAMPLE";
    private String exportType = EXPORT_NEW_CALC_MEASURES;
    private StorageDesign storDesign;
    private RelationalDesign physDesign;
    private RelationalDesign tphysDesign;
    private Connection connection;
    private String connectString = "";
    private String user = null;
    private AWConnection awConnection;
    private String awName = "test1";
    private AW globalAW;
    private Map dimMap;
    private Map hierMap;
    Vector _keys = new Vector(0);
    Vector _cols = new Vector(0);
    Vector _levels = new Vector(0);
    Vector _levColumns = new Vector(0);
    Vector _dimList = new Vector(0);
    Vector _measures = new Vector(0);
    Vector _measCols = new Vector(0);
    private boolean valid = true;
    private boolean warning = false;
    private StringBuffer validationSB;
    private StringBuffer warningsSB;
    private List globMeas = new ArrayList();
    private ProgressDialog monitor;
    private Interaction curInteraction;
    private String fileName;
    private boolean buildAW = true;
    private Map measMap = new TreeMap();
    private boolean validated = false;
    private String LD_NAME = "Long_Description";
    private String SD_NAME = "Short_Description";
    private String END_DATE_NAME = "End_Date";
    private String TIME_SPAN_NAME = "Time_Span";
    private String err;
    private Design design;
    boolean atached = false;
    boolean created = false;
    boolean commited = false;
    List selectedObjects;
    List globLevDesc = new ArrayList();
    boolean validTimeDim = true;
    Map awdimTOdim = new TreeMap();
    Map levMap = new TreeMap();
    private List sortedMeasures = new ArrayList();
    private List tracedMeasures = new ArrayList();
    List measureDependencies;
    boolean cyclicRef = false;
    boolean error = false;
    StringBuffer eb = new StringBuffer();
    private boolean overwrite = false;
    private Map awmeasToMeasure = new TreeMap();
    private Map awmeasMap = new TreeMap();
    private Map additionalAWMeasures = new TreeMap();
    private Map oldNewMap = new TreeMap();
    private List exportedMeasures = new ArrayList();
    private List exportedFolders = new ArrayList();
    private List awMeasureFolders = new ArrayList();

    public OracleAWExporter(ApplicationView appView) {
        this.appView = appView;
        this.design = appView.getCurrentDesign();
    }

    public void export() {
        this.warningsSB = new StringBuffer("  There are warnings generated during validation phase:\n\n");
        this.validationSB = new StringBuffer("  There are errors during validation phase!\n\n");
        this.mdmDesign = this.tmdmDesign = this.design.getMultidimensionalDesign();
        this.physDesign = this.tphysDesign = this.design.getRelationalDesign();
        if (this.design.getMultidimensionalDesigns().size() == 1 && this.design.getRelationalDesigns().size() == 1) {
            this.validate();
        }
        if (this.valid) {
            AWExportOptions cve;
            boolean result;
            if (this.validated && this.warning) {
                LogReport lr = new LogReport(this.appView);
                lr.setName("Validation Log");
                lr.setLog(this.warningsSB.toString());
                lr.showModalDialog(new Dimension(750, 550));
            }
            if (result = (cve = new AWExportOptions(this.getApplicationView())).showDialog()) {
                this.mdmDesign = cve.getMultidimensionalDesign();
                this.schema = cve.getSchema();
                this.storDesign = cve.getStorageDesign();
                this.physDesign = cve.getPhysicalDesign();
                this.connection = cve.getConnection();
                this.awName = cve.getAWName();
                this.buildAW = cve.isPopulateCubes();
                this.exportType = cve.getExportMode();
                this.fileName = cve.getFileName();
                this.selectedObjects = cve.getSelectedObjects();
                if (this.mdmDesign != null) {
                    if (!this.validated) {
                        this.validate();
                    }
                    if (this.valid) {
                        if (this.exportType.equals(EXPORT_METADATA_TO_FILE)) {
                            new Thread(new Runner()).start();
                        } else if (this.validConnection()) {
                            if (this.exportType.equals(EXPORT_ALL_CALC_MEASURES) || this.exportType.equals(EXPORT_NEW_CALC_MEASURES)) {
                                new Thread(new CalcMeasuresRunner()).start();
                            } else {
                                new Thread(new Runner()).start();
                            }
                        }
                    } else {
                        LogReport lr = new LogReport(this.appView);
                        lr.setName("Validation Log");
                        if (this.warning) {
                            lr.setLog(this.validationSB.toString() + "\n\n" + this.warningsSB.toString());
                        } else {
                            lr.setLog(this.validationSB.toString());
                        }
                        lr.setLog(this.validationSB.toString());
                        lr.showDialog(new Dimension(750, 550));
                    }
                }
            }
        } else {
            LogReport lr = new LogReport(this.appView);
            lr.setName("Validation Log");
            if (this.warning) {
                lr.setLog(this.validationSB.toString() + "\n\n" + this.warningsSB.toString());
            } else {
                lr.setLog(this.validationSB.toString());
            }
            lr.showDialog(new Dimension(750, 550));
        }
    }

    private void validate() {
        Iterator it = this.mdmDesign.getLevelSet().iterator();
        while (it.hasNext()) {
            oracle.dbtools.crest.model.design.multidimensional.Level level = (oracle.dbtools.crest.model.design.multidimensional.Level)it.next();
            this.validateLevel(level);
        }
        it = this.mdmDesign.getDimensionSet().iterator();
        while (it.hasNext()) {
            oracle.dbtools.crest.model.design.multidimensional.Dimension dim = (oracle.dbtools.crest.model.design.multidimensional.Dimension)it.next();
            this.validateDimension(dim);
        }
        it = this.mdmDesign.getCubeSet().iterator();
        while (it.hasNext()) {
            Cube cube = (Cube)it.next();
            this.validateCube(cube);
        }
    }

    private void createAW() {
        this.addDimensions();
    }

    private boolean validConnection() {
        try {
            int atIndex = this.connectString.indexOf(64);
            if (atIndex >= 0) {
                this.connectString = this.connectString.substring(atIndex + 1);
            }
            if (!(this.connection instanceof OracleConnection)) {
                throw new Exception();
            }
            this.awConnection = new AWConnection((OracleConnection)this.connection);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("OracleAWExporter.ErrorConnectingTo"), this.connectString) + e.getLocalizedMessage(), Messages.getString("OracleAWExporter.Error"), 0);
            this.closeConnection();
            return false;
        }
        return true;
    }

    private void deleteExistingAW(AWConnection awConnection, String user, String awName) {
        block6: {
            try {
                OracleConnection conn = (OracleConnection)awConnection.getSQLConnection();
                SPLExecutor splExec = new SPLExecutor(conn);
                splExec.initialize();
                try {
                    splExec.executeCommand("aw delete " + user + "." + awName);
                }
                catch (Exception e) {
                    String err = e.toString();
                    String descr = "";
                    if (err.indexOf("ORA-33276") > -1) {
                        descr = MessageFormat.format(Messages.getString("OracleAWExporter.AnalyticWorkspaceAttached"), user, awName);
                        this.atached = true;
                        break block6;
                    }
                    if (err.indexOf("ORA-33262") > -1) {
                        return;
                    }
                    descr = err;
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private boolean readAWDefinitions(AWConnection awConnection, String user, String awName) {
        try {
            this.globalAW = AW.readAWDefinitions((AWConnection)awConnection, (String)awName, (String)"RW");
        }
        catch (Exception e) {
            String err = e.toString();
            String descr = "";
            if (err.indexOf("ORA-33276") > -1) {
                descr = MessageFormat.format(Messages.getString("OracleAWExporter.AnalyticWorkspaceAttached"), user, awName);
                this.atached = true;
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), descr, Messages.getString("OracleAWExporter.Error"), 0);
            } else if (err.indexOf("ORA-33262") > -1) {
                descr = MessageFormat.format(Messages.getString("OracleAWExporter.AnalyticWorkspaceDoesntExist"), user, awName);
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), descr, Messages.getString("OracleAWExporter.Error"), 0);
            } else if (err.indexOf("ORA-34344") > -1) {
                descr = MessageFormat.format(Messages.getString("OracleAWExporter.AnalyticWorkspaceDoesntExistOrAttached"), user, awName);
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), descr, Messages.getString("OracleAWExporter.Error"), 0);
            } else {
                descr = err;
            }
            LOGGER.error("Error in reading Analytic Workspace definitions: ", e);
            return false;
        }
        return true;
    }

    private ModelIDObject getCorrespondentObject(ModelIDObject object) {
        if (this.storDesign != null) {
            ContainedObject column;
            if (object instanceof Entity) {
                Table tab = ((Entity)object).getEngTable(this.physDesign);
                if (tab != null) {
                    TableProxy tp = (TableProxy)this.storDesign.getTableProxySet().getProxy(tab.getObjectID());
                    return tp;
                }
            } else if (object instanceof Attribute && (column = ((Attribute)object).getEngColumn(this.physDesign)) != null) {
                return this.storDesign.getColumnProxySet().getProxy(column.getObjectID());
            }
        } else {
            if (object instanceof Entity) {
                Table tab = ((Entity)object).getEngTable(this.physDesign);
                if (tab == null) {
                    return object;
                }
                return tab;
            }
            if (object instanceof Attribute) {
                ContainedObject column = ((Attribute)object).getEngColumn(this.physDesign);
                if (column == null) {
                    return object;
                }
                return column;
            }
        }
        return object;
    }

    private String getSchema(ModelIDObject object) {
        ModelIDObject cobj;
        String res = null;
        if (object instanceof TableProxy) {
            res = this.getSchemaImplementation((TableProxy)object);
        } else if (object instanceof Entity) {
            ModelIDObject cobj2 = this.getCorrespondentObject(object);
            if (cobj2 instanceof TableProxy) {
                res = this.getSchemaImplementation((TableProxy)cobj2);
            }
        } else if (object instanceof Attribute) {
            ModelIDObject cobj3 = this.getCorrespondentObject(((Attribute)object).getContainerWithKeyObject());
            if (cobj3 instanceof TableProxy) {
                res = this.getSchemaImplementation((TableProxy)cobj3);
            }
        } else if (object instanceof CalculatedAttribute && (cobj = this.getCorrespondentObject(((CalculatedAttribute)object).getLevel().getLevelEntity())) instanceof TableProxy) {
            res = this.getSchemaImplementation((TableProxy)cobj);
        }
        if (res != null && !"".equals(res)) {
            return res;
        }
        return this.schema;
    }

    private String getSchemaImplementation(TableProxy tp) {
        StorageObject sto = tp.getUserSchema();
        if (sto != null) {
            return sto.getName();
        }
        String sch = tp.getSchemaImplementationName();
        if (!"".equals(sch)) {
            return sch;
        }
        return null;
    }

    public void clearCubeMapVectors() {
        this._measures.removeAllElements();
        this._measCols.removeAllElements();
        this._levels.removeAllElements();
        this._cols.removeAllElements();
        this._dimList.removeAllElements();
    }

    public void associateCubeDimensions(oracle.AWXML.Cube _cube, Vector _dimList) {
        for (int i = 0; i < _dimList.size(); ++i) {
            CubeDimRef _cdr = _cube.createCubeDimRef();
            oracle.AWXML.Dimension _dim = (oracle.AWXML.Dimension)_dimList.elementAt(i);
            _cdr.setDimension(_dim);
        }
    }

    public void createCubeMap(oracle.AWXML.Cube _cube, Vector _levels, Vector _columns, Vector _measures, Vector _measCols) {
        CubeMapGroup _cmg = _cube.createSourceCubeMapGroup();
        for (int y = 0; y < _levels.size(); ++y) {
            CubeDimensionSourceExpression _cdse = _cmg.CreateKeyMap();
            Object obj = _levels.elementAt(y);
            if (obj instanceof Level) {
                _cdse.addLevel((Level)obj);
                _cdse.setTargetObject(((Level)obj).getOwner());
            } else if (obj instanceof oracle.AWXML.Dimension) {
                _cdse.setDimension((oracle.AWXML.Dimension)obj);
                _cdse.setTargetObject((BaseObject)obj);
            }
            StringTokenizer _st = new StringTokenizer((String)_columns.elementAt(y), ",");
            while (_st.hasMoreTokens()) {
                SourceColumn _keycol = _cdse.CreateSourceColumn();
                _keycol.setColumn(_st.nextToken());
            }
        }
        for (int x = 0; x < _measures.size(); ++x) {
            Measure curMeasure = (Measure)_measures.elementAt(x);
            curMeasure.setAutoSolve("NO_AUTO_SOLVE");
            String curMeascol = (String)_measCols.elementAt(x);
            MeasureSourceExpression _measMap = _cmg.CreateAttributeMap();
            _measMap.setTargetObject((BaseObject)curMeasure);
            SourceColumn _meascol = _measMap.CreateSourceColumn();
            _meascol.setColumn(curMeascol);
        }
    }

    public void createCubeMap2(oracle.AWXML.Cube awcube, Cube cube, Vector _levels, Vector _measures, Vector _measCols, List whereClauseList) {
        CubeMapGroup _cmg = awcube.createSourceCubeMapGroup();
        for (int y = 0; y < _levels.size(); ++y) {
            CubeDimensionSourceExpression cdse = _cmg.CreateKeyMap();
            LevelDesc ld = (LevelDesc)_levels.elementAt(y);
            if (ld.level != null && ld.level.isValueBasedHierarchy()) {
                cdse.setDimension(ld.odimension);
                cdse.setTargetObject((BaseObject)ld.odimension);
            } else {
                cdse.addLevel(ld.olevel);
                cdse.setTargetObject(ld.olevel.getOwner());
            }
            for (Attribute kattr : cube.getRollUpLink(ld.dim).getChildToParentAttributes()) {
                ModelIDObject corobj = this.getCorrespondentObject(kattr);
                if (corobj == null) continue;
                String colname = this.getSchema(kattr) + "." + corobj.getLongName();
                SourceColumn keycol = cdse.CreateSourceColumn();
                keycol.setColumn(colname.toUpperCase());
            }
        }
        for (int x = 0; x < _measures.size(); ++x) {
            Measure curMeasure = (Measure)_measures.elementAt(x);
            curMeasure.setAutoSolve("NO_AUTO_SOLVE");
            String curMeascol = (String)_measCols.elementAt(x);
            MeasureSourceExpression _measMap = _cmg.CreateAttributeMap();
            _measMap.setTargetObject((BaseObject)curMeasure);
            SourceColumn _meascol = _measMap.CreateSourceColumn();
            _meascol.setColumn(curMeascol);
            String wh_str = (String)whereClauseList.get(x);
            if ("".equals(wh_str)) continue;
            WhereClause wh_cl = _measMap.createRestriction();
            wh_cl.setWhereClause(wh_str);
        }
    }

    private void addDimensions() {
        ArrayList<Measure> mlist = new ArrayList<Measure>();
        Iterator it = this.mdmDesign.getDimensionSet().iterator();
        while (it.hasNext()) {
            oracle.dbtools.crest.model.design.multidimensional.Dimension dim = (oracle.dbtools.crest.model.design.multidimensional.Dimension)it.next();
            this.addDimension(dim);
        }
        for (AWExportOptions.SelObject so : this.selectedObjects) {
            if (so.object instanceof Cube && so.selected) {
                Cube cube = (Cube)so.object;
                if (cube.hasRolePlayingDimensions()) continue;
                this.clearCubeMapVectors();
                oracle.AWXML.Cube awcube = this.globalAW.createCube();
                String cname = cube.getName().replaceAll(" ", "_");
                awcube.setName(cname);
                awcube.setLongName(cube.getOracleLongName());
                awcube.setShortName(cube.getOracleShortName());
                cube.setNameInOracleAW(awcube.getName());
                Vector<oracle.AWXML.Dimension> _dimList = new Vector<oracle.AWXML.Dimension>(cube.getDimensions().size());
                for (oracle.dbtools.crest.model.design.multidimensional.Dimension dim : cube.getDimensions()) {
                    oracle.AWXML.Dimension awdim = (oracle.AWXML.Dimension)this.dimMap.get(dim.getObjectID());
                    _dimList.add(awdim);
                    oracle.dbtools.crest.model.design.multidimensional.Level level = null;
                    if (dim.getBaseLevel() == null) continue;
                    level = dim.getBaseLevel();
                    LevelDesc ldesc = this.getLevelDesc(this.globLevDesc, level, dim);
                    if (level.isValueBasedHierarchy()) {
                        if (ldesc != null) {
                            ldesc.olevel = null;
                        } else {
                            ldesc = new LevelDesc();
                            ldesc.olevel = null;
                        }
                    }
                    if (ldesc == null) continue;
                    ldesc.odimension = awdim;
                    ldesc.dim = dim;
                    ldesc.level = level;
                    this._levels.add(ldesc);
                }
                String sparse = "STANDARD";
                if (cube.isCompressedComposites()) {
                    sparse = "COMPRESSED";
                }
                awcube.setSparseType(sparse);
                awcube.setUseGlobalIndex(Boolean.valueOf(cube.isUseGlobalComposites()));
                if (cube.isPartitioned() && cube.getPartHierarchy() != null && cube.getPartLevel() != null) {
                    Hierarchy awh = (Hierarchy)this.hierMap.get(cube.getPartHierarchy().getObjectID());
                    Level awl = (Level)this.levMap.get(cube.getPartLevel().getObjectID() + cube.getPartDimension().getObjectID());
                    awcube.setPartitionHierarchy(awh);
                    awcube.setPartitionLevel(awl);
                }
                this.associateCubeDimensions(awcube, _dimList);
                this.sortedMeasures.clear();
                this.tracedMeasures.clear();
                this.sortMeasures(cube.getMeasures());
                ArrayList<String> whereClauseList = new ArrayList<String>();
                Iterator itm = this.sortedMeasures.iterator();
                ArrayList<MeasureDesc> cmeas = new ArrayList<MeasureDesc>();
                while (itm.hasNext()) {
                    oracle.dbtools.crest.model.design.multidimensional.Measure meas = (oracle.dbtools.crest.model.design.multidimensional.Measure)itm.next();
                    if (!meas.isFormula() && !meas.isFactDimension()) {
                        ModelIDObject corobj;
                        ContainedObject attr = meas.getMeasureFact();
                        if (attr != null && (corobj = this.getCorrespondentObject(attr)) != null) {
                            String colname = this.getSchema(attr) + "." + corobj.getLongName();
                            this._measCols.add(colname.toUpperCase());
                            whereClauseList.add(meas.getWhereClause().trim());
                        }
                        Measure awmeas = awcube.createMeasure();
                        String mname = meas.getName().replaceAll(" ", "_");
                        mname = mname.replaceAll("[(]", "_");
                        mname = mname.replaceAll("[)]", "_");
                        awmeas.setName(mname);
                        awmeas.setShortName(meas.getOracleShortName());
                        awmeas.setLongName(meas.getOracleLongName());
                        awmeas.setPluralName(meas.getOraclePluralName());
                        meas.setNameInOracleAW(awmeas.getName());
                        this._measures.add(awmeas);
                        mlist.add(awmeas);
                        MeasureDesc mdesc = new MeasureDesc();
                        mdesc.awmeasure = awmeas;
                        mdesc.awmeasureName = mname;
                        mdesc.measure = meas;
                        this.globMeas.add(mdesc);
                        this.measMap.put(meas.getObjectID(), awmeas);
                        cmeas.add(mdesc);
                        continue;
                    }
                    if (meas.isFactDimension()) continue;
                    if (meas.isDefinedAsOracleAWCalculated() && meas.getOracleAWFormulaType().equalsIgnoreCase(oracle.dbtools.crest.model.design.multidimensional.Measure.AW_OLAP_FORMULA)) {
                        this.createOLAPMeasure(awcube, meas, null, null);
                        continue;
                    }
                    this.createDerivedMeasure(awcube, meas, null, null);
                }
                this.createCubeMap2(awcube, cube, this._levels, this._measures, this._measCols, whereClauseList);
                this.precomputeNA(awcube, "AGGMAP_" + cname, cube);
                this.precomputeMeasureForCubeNA(awcube, cube, cmeas);
                continue;
            }
            if (!(so.object instanceof Slice) || !so.selected) continue;
            Slice slice = (Slice)so.object;
            this.createSlice(slice);
        }
        this.addMeasureFolders();
    }

    private void addMeasureFolder(MeasureFolder folder, oracle.AWXML.MeasureFolder awparent, boolean export) {
        oracle.AWXML.MeasureFolder awMeasureFolder = null;
        awMeasureFolder = awparent != null ? awparent.createMeasureFolder() : this.globalAW.createMeasureFolder();
        awMeasureFolder.setName(folder.getName().toUpperCase().replaceAll(" ", "_"));
        awMeasureFolder.setShortName(folder.getOracleShortName());
        awMeasureFolder.setLongName(folder.getOracleLongName());
        awMeasureFolder.setPluralName(folder.getOraclePluralName());
        folder.setNameInOracleAW(awMeasureFolder.getName());
        for (int i = 0; i < folder.getMeasures().size(); ++i) {
            Measure awmeas;
            MeasureFolder.MFElement mfel = (MeasureFolder.MFElement)folder.getMeasures().get(i);
            if (mfel.isMeasureWrapper()) {
                Slice.MeasureWrapper mw = (Slice.MeasureWrapper)mfel.getMeasure();
                awmeas = (Measure)this.measMap.get(this.makeMeasureID((Slice)mfel.getParent(), mw));
            } else {
                oracle.dbtools.crest.model.design.multidimensional.Measure meas = (oracle.dbtools.crest.model.design.multidimensional.Measure)mfel.getMeasure();
                awmeas = (Measure)this.measMap.get(meas.getObjectID());
            }
            if (awmeas == null) continue;
            awMeasureFolder.addMeasure(awmeas);
        }
        Iterator it = this.mdmDesign.getMeasureFolderSet().iterator();
        while (it.hasNext()) {
            MeasureFolder mf = (MeasureFolder)it.next();
            if (mf.getParentFolder() != folder) continue;
            this.addMeasureFolder(mf, awMeasureFolder, export);
        }
        if (export && awparent == null) {
            awMeasureFolder.Create(this.awConnection);
            this.exportedFolders.add(awMeasureFolder);
        }
    }

    private void addMeasureFolders() {
        Iterator it = this.mdmDesign.getMeasureFolderSet().iterator();
        while (it.hasNext()) {
            MeasureFolder mf = (MeasureFolder)it.next();
            if (mf.getParentFolder() != null) continue;
            this.addMeasureFolder(mf, null, false);
        }
    }

    private boolean sliceContainsDimension(Slice slice, oracle.dbtools.crest.model.design.multidimensional.Dimension dim) {
        for (Slice.SelectedLevel sl : slice.getSelectedLevels()) {
            if (sl.getDimension() != dim) continue;
            return true;
        }
        return false;
    }

    private String makeMeasureID(Slice slice, Slice.MeasureWrapper mw) {
        String id = slice.getObjectID() + mw.getMeasure().getObjectID() + String.valueOf(mw.getAggrFunction().getObjectID());
        return id;
    }

    private void createSlice(Slice slice) {
        Cube cube = slice.getCube();
        boolean err = false;
        this.clearCubeMapVectors();
        oracle.AWXML.Cube awcube = this.globalAW.createCube();
        String cname = slice.getName().replaceAll(" ", "_");
        awcube.setName(cname);
        awcube.setLongName(slice.getName() + " - generated from Oracle SQL Developer Modeling Slice in Cube: " + slice.getCube().getName());
        slice.setNameInOracleAW(awcube.getName());
        Vector<oracle.AWXML.Dimension> _dimList = new Vector<oracle.AWXML.Dimension>(slice.getSelectedLevels().size());
        for (Slice.SelectedLevel sl : slice.getSelectedLevels()) {
            oracle.dbtools.crest.model.design.multidimensional.Dimension dim = sl.getDimension();
            oracle.AWXML.Dimension awdim = (oracle.AWXML.Dimension)this.dimMap.get(dim.getObjectID());
            _dimList.add(awdim);
            oracle.dbtools.crest.model.design.multidimensional.Level level = null;
            if (dim.getBaseLevel() == null) continue;
            level = dim.getBaseLevel();
            LevelDesc ldesc = this.getLevelDesc(this.globLevDesc, level, dim);
            if (level.isValueBasedHierarchy()) {
                if (ldesc != null) {
                    ldesc.olevel = null;
                } else {
                    ldesc = new LevelDesc();
                    ldesc.olevel = null;
                }
            }
            ldesc.odimension = awdim;
            ldesc.dim = dim;
            ldesc.level = level;
            this._levels.add(ldesc);
        }
        this.associateCubeDimensions(awcube, _dimList);
        if (cube.isPartitioned() && cube.getPartHierarchy() != null && cube.getPartLevel() != null && this.sliceContainsDimension(slice, cube.getPartDimension())) {
            Hierarchy awh = (Hierarchy)this.hierMap.get(cube.getPartHierarchy().getObjectID());
            Level awl = (Level)this.levMap.get(cube.getPartLevel().getObjectID() + cube.getPartDimension().getObjectID());
            awcube.setPartitionHierarchy(awh);
            awcube.setPartitionLevel(awl);
        }
        ArrayList<MeasureDesc> cmeas = new ArrayList<MeasureDesc>();
        slice.verifyMeasureWrappers();
        this.sortedMeasures.clear();
        this.tracedMeasures.clear();
        this.sortMeasures(slice.getCube().getMeasures());
        ArrayList<String> whereClauseList = new ArrayList<String>();
        for (Slice.MeasureWrapper mw : this.sortSliceMeasureWrappers(this.sortedMeasures, slice.getSelectedMeasureWrappers())) {
            oracle.dbtools.crest.model.design.multidimensional.Measure meas = mw.getMeasure();
            if (!meas.isFormula() && !meas.isFactDimension()) {
                ModelIDObject corobj;
                ContainedObject attr = meas.getMeasureFact();
                if (attr != null && (corobj = this.getCorrespondentObject(attr)) != null) {
                    String colname = this.getSchema(attr) + "." + corobj.getLongName();
                    this._measCols.add(colname.toUpperCase());
                    whereClauseList.add(slice.getWhereClauseFor(mw));
                }
                Measure awmeas = awcube.createMeasure();
                Object mname = meas.getName().replaceAll(" ", "_");
                mname = ((String)mname).replaceAll("[(]", "_");
                if (this.existsMeasureName((String)(mname = ((String)mname).replaceAll("[)]", "_")))) {
                    Object tname = mw.getAggrFunction().measureAlias;
                    mname = this.existsMeasureName((String)tname) ? (this.existsMeasureName((String)(tname = (String)mname + "_" + cname)) ? this.produceUniqueMeasureName((String)mname) : tname) : tname;
                }
                awmeas.setName((String)mname);
                awmeas.setShortName(meas.getOracleShortName());
                awmeas.setLongName(meas.getOracleLongName());
                awmeas.setPluralName(meas.getOraclePluralName());
                meas.setNameInOracleAW(awmeas.getName());
                this._measures.add(awmeas);
                MeasureDesc mdesc = new MeasureDesc();
                mdesc.awmeasure = awmeas;
                mdesc.awmeasureName = mname;
                mdesc.measure = null;
                mdesc.mwrapper = mw;
                this.globMeas.add(mdesc);
                this.measMap.put(this.makeMeasureID(slice, mw), awmeas);
                cmeas.add(mdesc);
                continue;
            }
            if (meas.isDefinedAsOracleAWCalculated() && meas.getOracleAWFormulaType().equalsIgnoreCase(oracle.dbtools.crest.model.design.multidimensional.Measure.AW_OLAP_FORMULA)) {
                this.createOLAPMeasure(awcube, meas, slice, mw);
                continue;
            }
            this.createDerivedMeasure(awcube, meas, slice, mw);
        }
        if (!err) {
            this.createCubeMap2(awcube, slice.getCube(), this._levels, this._measures, this._measCols, whereClauseList);
            this.precomputeNA(awcube, "AGGMAP_" + cname, slice.getCube());
            this.precomputeMeasureForSliceNA(awcube, slice, cmeas);
        }
    }

    private List sortSliceMeasureWrappers(List sortedMeasures, List mwList) {
        ArrayList<Slice.MeasureWrapper> list = new ArrayList<Slice.MeasureWrapper>();
        Object[] mwarray = mwList.toArray();
        int size = mwList.size();
        Iterator it = sortedMeasures.iterator();
        while (size > 0 && it.hasNext()) {
            oracle.dbtools.crest.model.design.multidimensional.Measure measure = (oracle.dbtools.crest.model.design.multidimensional.Measure)it.next();
            for (int i = 0; i < mwarray.length; ++i) {
                if (size > 0) {
                    Slice.MeasureWrapper mw = (Slice.MeasureWrapper)mwarray[i];
                    if (mw == null || mw.getMeasure() != measure) continue;
                    list.add(mw);
                    mwarray[i] = null;
                    --size;
                    continue;
                }
                return list;
            }
        }
        return list;
    }

    private boolean existsMeasureName(String name) {
        for (MeasureDesc mdesc : this.globMeas) {
            if (!mdesc.awmeasure.getName().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    private String produceUniqueMeasureName(String basename) {
        int i = 0;
        if (this.existsMeasureName(basename)) {
            String name;
            while (this.existsMeasureName(name = basename + "_" + Integer.toString(++i))) {
            }
            return name;
        }
        return basename;
    }

    private boolean getSparseFor(Cube cube, oracle.dbtools.crest.model.design.multidimensional.Dimension dimension) {
        RollupLink rl = cube.getRollUpLink(dimension);
        if (rl != null) {
            return rl.isSparseDimension();
        }
        return false;
    }

    private String getOperatorFor(Cube cube, oracle.dbtools.crest.model.design.multidimensional.Dimension dimension) {
        RollupLink rl = cube.getRollUpLink(dimension);
        if (rl != null) {
            return rl.getDefaultAggregationOperator();
        }
        return "SUM";
    }

    private void precomputeNA(oracle.AWXML.Cube _cube, String _aggdef_name, Cube cube) {
        AggregationDefinition _aggdef = _cube.getDefaultAggregationDefinition();
        if (_aggdef == null) {
            _aggdef = _cube.createAggregationDefinition();
            _cube.setDefaultAggregationDefinition(_aggdef);
        }
        _aggdef.setName(_aggdef_name);
        _aggdef.getCalculationSpecification().clear();
        Vector _dimrefs = _cube.getCubeDimRefs();
        for (CubeDimRef _dimref : _dimrefs) {
            BaseOperator op;
            oracle.AWXML.Dimension _dim = _dimref.getDimension();
            SolveDefDimRef sdr = _aggdef.createSolveDefDimRef();
            sdr.setDimension(_dim);
            oracle.dbtools.crest.model.design.multidimensional.Dimension dim = (oracle.dbtools.crest.model.design.multidimensional.Dimension)this.awdimTOdim.get(_dim.getName());
            _dimref.setSparse(Boolean.valueOf(this.getSparseFor(cube, dim)));
            String defOperator = this.getOperatorFor(cube, dim);
            AggregationHierarchySpecification _aggHierSpec = _aggdef.createAggregationHierarchySpecification();
            _aggHierSpec.setDimension(_dim);
            ConfigurationParameters agrarg = new ConfigurationParameters((BaseObject)_aggHierSpec);
            this.setConfigurationParams(agrarg, true);
            _aggHierSpec.setAggregationArgument((AggregationArgument)agrarg);
            if (dim.getBaseLevel() != null && !dim.getBaseLevel().isValueBasedHierarchy()) {
                PreComputeClause _precompute_clause = _aggHierSpec.createPreComputeClause();
                DimensionMemberExpression _dimMemExp = _precompute_clause.createDimensionMemberExpression();
                _dimMemExp.setExpression("ALL");
                _dimMemExp.setExpressionType("EXCLUDE");
            }
            if ((op = (BaseOperator)_aggHierSpec.getAggregationOperator()) != null) {
                op.setOpcode(defOperator);
                continue;
            }
            op = new BaseOperator((BaseObject)_aggHierSpec);
            op.setOpcode(defOperator);
            _aggHierSpec.setAggregationOperator((AggregationOperator)op);
        }
    }

    private boolean validForDimension(oracle.dbtools.crest.model.design.multidimensional.Measure meas, oracle.dbtools.crest.model.design.multidimensional.Dimension dim) {
        Measure.AggregateFunction af;
        return meas.getAdditivity().equalsIgnoreCase(oracle.dbtools.crest.model.design.multidimensional.Measure.SEMI_ADDITIVE) && (af = meas.getDefaultAggregationFunction()) != null && af.dimensions.indexOf(dim) > -1;
    }

    private CubeDimRef getDimRefFor(oracle.AWXML.Cube awcube, oracle.AWXML.Dimension awdim) {
        for (CubeDimRef cr : awcube.getCubeDimRefs()) {
            if (cr.getDimension() != awdim) continue;
            return cr;
        }
        return null;
    }

    public void precomputeMeasureForCubeNA(oracle.AWXML.Cube _cube, Cube cube, List measures) {
        Iterator it = measures.iterator();
        while (it.hasNext()) {
            AggregationDefinition aggdef = _cube.createAggregationDefinition();
            MeasureDesc mdesc = (MeasureDesc)it.next();
            oracle.dbtools.crest.model.design.multidimensional.Measure meas = mdesc.measure;
            if (meas.isFactDimension()) continue;
            aggdef.setName(_cube.getName() + "_" + mdesc.awmeasure.getName());
            Measure.AggregateFunction af = meas.getDefaultAggregationFunction();
            String agfunc = "NOAGG";
            if (af != null && !"".equals(af.name)) {
                agfunc = af.name;
            }
            List levels = af != null ? af.levels : null;
            for (oracle.dbtools.crest.model.design.multidimensional.Dimension dim : cube.getDimensions()) {
                BaseOperator op;
                oracle.AWXML.Dimension awdim;
                CubeDimRef cr;
                List dimlevels = dim.getAllLevels();
                String func = agfunc;
                if (meas.getAdditivity().equalsIgnoreCase(oracle.dbtools.crest.model.design.multidimensional.Measure.SEMI_ADDITIVE)) {
                    if (!this.validForDimension(meas, dim)) {
                        func = "NOAGG";
                    }
                } else if (meas.getAdditivity().equalsIgnoreCase(oracle.dbtools.crest.model.design.multidimensional.Measure.NON_ADDITIVE)) {
                    func = "NOAGG";
                }
                if ((cr = this.getDimRefFor(_cube, awdim = (oracle.AWXML.Dimension)this.dimMap.get(dim.getObjectID()))) != null) {
                    cr.setSparse(Boolean.valueOf(this.getSparseFor(cube, dim)));
                }
                SolveDefDimRef sdr = aggdef.createSolveDefDimRef();
                sdr.setDimension(awdim);
                AggregationHierarchySpecification aggHierSpec = aggdef.createAggregationHierarchySpecification();
                aggHierSpec.setDimension(awdim);
                ConfigurationParameters agrarg = new ConfigurationParameters((BaseObject)aggHierSpec);
                this.setConfigurationParams(agrarg, true);
                aggHierSpec.setAggregationArgument((AggregationArgument)agrarg);
                PreComputeClause _precompute_clause = aggHierSpec.createPreComputeClause();
                DimensionMemberExpression dimMemExp = _precompute_clause.createDimensionMemberExpression();
                dimMemExp.setExpression("ALL");
                dimMemExp.setExpressionType("EXCLUDE");
                if (dim.getBaseLevel() != null && !dim.getBaseLevel().isValueBasedHierarchy() && levels != null) {
                    for (int k = 0; k < levels.size(); ++k) {
                        oracle.dbtools.crest.model.design.multidimensional.Level level = (oracle.dbtools.crest.model.design.multidimensional.Level)levels.get(k);
                        if (dimlevels.indexOf(level) <= -1) continue;
                        dimMemExp = _precompute_clause.createDimensionMemberExpression();
                        dimMemExp.setExpressionType("INCLUDE");
                        Level oralev = (Level)this.levMap.get(level.getObjectID() + dim.getObjectID());
                        dimMemExp.setLevel(oralev);
                    }
                }
                if ((op = (BaseOperator)aggHierSpec.getAggregationOperator()) != null) {
                    op.setOpcode(func);
                    continue;
                }
                op = new BaseOperator((BaseObject)aggHierSpec);
                op.setOpcode(func);
                aggHierSpec.setAggregationOperator((AggregationOperator)op);
            }
            aggdef.setName(mdesc.awmeasure.getName() + "_AGGM");
            mdesc.awmeasure.setSolveDefinition((SolveDefinition)aggdef);
        }
    }

    public void precomputeMeasureForSliceNA(oracle.AWXML.Cube _cube, Slice slice, List measures) {
        Cube cube = slice.getCube();
        Iterator it = measures.iterator();
        while (it.hasNext()) {
            AggregationDefinition aggdef = _cube.createAggregationDefinition();
            MeasureDesc mdesc = (MeasureDesc)it.next();
            Slice.MeasureWrapper mw = mdesc.mwrapper;
            oracle.dbtools.crest.model.design.multidimensional.Measure meas = mw.getMeasure();
            if (meas.isFactDimension()) continue;
            Object name = _cube.getName() + "_" + mdesc.awmeasure.getName();
            if (((String)name).length() > 30) {
                name = ((String)name).substring(0, 30);
            }
            aggdef.setName(_cube.getName() + "_" + mdesc.awmeasure.getName());
            Measure.AggregateFunction af = mw.getAggrFunction();
            String agfunc = "NOAGG";
            if (af != null && !"".equals(af.name)) {
                agfunc = af.name;
            }
            List levels = af != null ? af.levels : null;
            for (Slice.SelectedLevel sl : slice.getSelectedLevels()) {
                BaseOperator op;
                oracle.AWXML.Dimension awdim;
                CubeDimRef cr;
                oracle.dbtools.crest.model.design.multidimensional.Dimension dim = sl.getDimension();
                List dimlevels = dim.getAllLevels();
                String func = agfunc;
                if (meas.getAdditivity().equalsIgnoreCase(oracle.dbtools.crest.model.design.multidimensional.Measure.SEMI_ADDITIVE)) {
                    if (!this.validForDimension(meas, dim)) {
                        func = "NOAGG";
                    }
                } else if (meas.getAdditivity().equalsIgnoreCase(oracle.dbtools.crest.model.design.multidimensional.Measure.NON_ADDITIVE)) {
                    func = "NOAGG";
                }
                if ((cr = this.getDimRefFor(_cube, awdim = (oracle.AWXML.Dimension)this.dimMap.get(dim.getObjectID()))) != null) {
                    cr.setSparse(Boolean.valueOf(this.getSparseFor(cube, dim)));
                }
                SolveDefDimRef sdr = aggdef.createSolveDefDimRef();
                sdr.setDimension(awdim);
                AggregationHierarchySpecification aggHierSpec = aggdef.createAggregationHierarchySpecification();
                aggHierSpec.setDimension(awdim);
                ConfigurationParameters agrarg = new ConfigurationParameters((BaseObject)aggHierSpec);
                this.setConfigurationParams(agrarg, true);
                aggHierSpec.setAggregationArgument((AggregationArgument)agrarg);
                PreComputeClause _precompute_clause = aggHierSpec.createPreComputeClause();
                DimensionMemberExpression dimMemExp = _precompute_clause.createDimensionMemberExpression();
                dimMemExp.setExpression("ALL");
                dimMemExp.setExpressionType("EXCLUDE");
                if (dim.getBaseLevel() != null && !dim.getBaseLevel().isValueBasedHierarchy() && levels != null) {
                    for (int k = 0; k < levels.size(); ++k) {
                        oracle.dbtools.crest.model.design.multidimensional.Level level = (oracle.dbtools.crest.model.design.multidimensional.Level)levels.get(k);
                        if (dimlevels.indexOf(level) <= -1) continue;
                        dimMemExp = _precompute_clause.createDimensionMemberExpression();
                        dimMemExp.setExpressionType("INCLUDE");
                        Level oralev = (Level)this.levMap.get(level.getObjectID() + dim.getObjectID());
                        dimMemExp.setLevel(oralev);
                    }
                }
                if ((op = (BaseOperator)aggHierSpec.getAggregationOperator()) != null) {
                    op.setOpcode(func);
                    continue;
                }
                op = new BaseOperator((BaseObject)aggHierSpec);
                op.setOpcode(func);
                aggHierSpec.setAggregationOperator((AggregationOperator)op);
            }
            aggdef.setName(mdesc.awmeasure.getName() + "_AGGM");
            mdesc.awmeasure.setSolveDefinition((SolveDefinition)aggdef);
        }
    }

    private void setConfigurationParams(ConfigurationParameters cp, boolean naskip) {
        if (naskip) {
            Parameter par = cp.createParameter();
            par.setKeyWord("NASKIP");
            par.setValue("YES");
        }
    }

    private void addDimension(oracle.dbtools.crest.model.design.multidimensional.Dimension dimension) {
        oracle.AWXML.Attribute timeSpan = null;
        oracle.AWXML.Attribute endDate = null;
        ArrayList attrs = new ArrayList();
        ArrayList<LevelDesc> levels = new ArrayList<LevelDesc>();
        TreeMap<String, oracle.AWXML.Attribute> attrMap = new TreeMap<String, oracle.AWXML.Attribute>();
        String name = dimension.getName();
        oracle.AWXML.Dimension awdim = this.globalAW.createDimension();
        this.dimMap.put(dimension.getObjectID(), awdim);
        awdim.setName(name.replaceAll(" ", "_"));
        awdim.setShortName(dimension.getOracleShortName());
        awdim.setLongName(dimension.getOracleLongName());
        awdim.setPluralName(dimension.getOraclePluralName());
        dimension.setNameInOracleAW(awdim.getName());
        if (dimension.getBaseLevel() != null && dimension.getBaseLevel().isValueBasedHierarchy()) {
            awdim.setUseNativeKey(true);
        } else {
            awdim.setUseNativeKey(true);
        }
        this.awdimTOdim.put(awdim.getName(), dimension);
        boolean timeDim = false;
        if (this.validTimeDim && dimension.isTimeDimension()) {
            awdim.setIsTime(true);
            timeDim = true;
            timeSpan = awdim.createAttribute();
            endDate = awdim.createAttribute();
            endDate.setName(this.END_DATE_NAME);
            endDate.setClassification("END_DATE");
            timeSpan.setName(this.TIME_SPAN_NAME);
            timeSpan.setClassification("TIME_SPAN");
        }
        for (Dimension.PermanentCalcMember pcm : dimension.getPermanentCalcMembers()) {
            if ("".equals(pcm.getExpression().trim())) continue;
            PermanentCalculatedMember awpcm = awdim.createPermanentCalculatedMember();
            awpcm.setName(pcm.getName().replaceAll(" ", "_"));
            awpcm.setExpressionText(pcm.getExpression());
        }
        oracle.AWXML.Attribute sdAttr = this.createShortDescAttr(awdim);
        oracle.AWXML.Attribute ldAttr = this.createLongDescAttr(awdim);
        Iterator itl = dimension.getAllLevels().iterator();
        while (itl.hasNext()) {
            this.clearLevelMapVectors();
            oracle.dbtools.crest.model.design.multidimensional.Level level = (oracle.dbtools.crest.model.design.multidimensional.Level)itl.next();
            if (level.isValueBasedHierarchy()) continue;
            Level oralev = awdim.createLevel();
            this.levMap.put(level.getObjectID() + dimension.getObjectID(), oralev);
            LevelDesc ldesc = new LevelDesc();
            ldesc.level = level;
            ldesc.olevel = oralev;
            ldesc.dim = dimension;
            ldesc.odimension = awdim;
            if (level.getLevelKey().size() > 0) {
                ldesc.attribute = (Attribute)level.getLevelKey().get(0);
                for (Attribute kattr : level.getLevelKey()) {
                    ModelIDObject corobj = this.getCorrespondentObject(kattr);
                    if (corobj == null) continue;
                    String colname = this.getSchema(kattr) + "." + corobj.getLongName();
                    this._keys.add(colname);
                }
            }
            oralev.setName(level.getName().replaceAll(" ", "_"));
            oralev.setShortName(level.getOracleShortName());
            oralev.setLongName(level.getOracleLongName());
            oralev.setPluralName(level.getOraclePluralName());
            level.setNameInOracleAW(oralev.getName());
            attrs.clear();
            attrs.addAll(level.getDescriptiveAttributes());
            this.createSD_LD_TS_ED_Map(attrs, level, timeDim, oralev, awdim);
            attrs.clear();
            attrs.addAll(level.getSlowChangingAttributes());
            for (SlowChangingAttribute sca : attrs) {
                ContainedObject attr = sca.getAttribute();
                oracle.AWXML.Attribute awattr = (oracle.AWXML.Attribute)attrMap.get(attr.getObjectID());
                if (awattr == null) {
                    awattr = awdim.createAttribute();
                    awattr.setName(sca.getName().replaceAll(" ", "_"));
                    attrMap.put(attr.getObjectID(), awattr);
                }
                if (sca.isIndexed()) {
                    Index index = awdim.createIndex();
                    index.setAttribute(awattr);
                }
                this.setupAttributeProjection(oralev, awattr.getName(), awattr);
                awattr.setClassification("USER");
                ModelIDObject corobj = this.getCorrespondentObject(attr);
                if (corobj == null) continue;
                String colname = this.getSchema(attr) + "." + corobj.getLongName();
                this._cols.add(colname);
            }
            this.createLevelMap(oralev, this._keys, this._cols, dimension.getWhereClauseFor(level));
            levels.add(ldesc);
            this.globLevDesc.add(ldesc);
        }
        for (oracle.dbtools.crest.model.design.multidimensional.Hierarchy hier : dimension.getHierarchies()) {
            this.clearHierarchyMapVectors();
            Hierarchy awhier = awdim.createHierarchy();
            awhier.setName(hier.getName().replaceAll(" ", "_"));
            hier.setNameInOracleAW(awhier.getName());
            this.hierMap.put(hier.getObjectID(), awhier);
            awhier.setShortName(hier.getOracleShortName());
            awhier.setLongName(hier.getOracleLongName());
            awhier.setPluralName(hier.getOraclePluralName());
            awhier.setIsDefault(hier.isDefaultHierarchy());
            for (int i = hier.getLevels().size() - 1; i > -1; --i) {
                oracle.dbtools.crest.model.design.multidimensional.Level level = (oracle.dbtools.crest.model.design.multidimensional.Level)hier.getLevels().get(i);
                LevelDesc ldesc = this.getLevelDesc(levels, level, dimension);
                if (ldesc == null) continue;
                this._levels.add(ldesc);
                ModelIDObject corobj = this.getCorrespondentObject(ldesc.attribute);
                if (corobj == null) continue;
                String colname = this.getSchema(ldesc.attribute) + "." + corobj.getLongName();
                this._levColumns.add(colname);
            }
            if (hier.isValueBasedHierarchy()) {
                this.createValubasedHierarchy(awdim, awhier, hier, this._levColumns, ldAttr, sdAttr, attrMap);
                continue;
            }
            this.createHierarchyMap2(awhier, this._levels, this._levColumns);
        }
    }

    private void createSD_LD_TS_ED_Map(List attrs, oracle.dbtools.crest.model.design.multidimensional.Level level, boolean timeDim, Level oralev, oracle.AWXML.Dimension awdim) {
        ModelIDObject corobj;
        oracle.AWXML.Attribute awattr;
        Level.OraAWAttributes oa = level.getOraAWAttributes();
        ArrayList<ContainedObject> processed = new ArrayList<ContainedObject>();
        ContainedObject attr = oa.shortDesc;
        if (attr != null) {
            awattr = awdim.FindAttribute(this.SD_NAME);
            if (awattr != null) {
                this.setupAttributeProjection(oralev, "Short Description", awattr);
            }
            processed.add(attr);
            corobj = this.getCorrespondentObject(attr);
            if (corobj != null) {
                String string = this.getSchema(attr) + "." + corobj.getLongName();
                this._cols.add(string);
            }
        }
        if ((attr = oa.longDesc) != null) {
            awattr = awdim.FindAttribute(this.LD_NAME);
            if (awattr != null) {
                this.setupAttributeProjection(oralev, "Long Description", awattr);
            }
            processed.add(attr);
            corobj = this.getCorrespondentObject(attr);
            if (corobj != null) {
                String string = this.getSchema(attr) + "." + corobj.getLongName();
                this._cols.add(string);
            }
        }
        if (this.validTimeDim && timeDim) {
            attr = oa.timeEnd;
            if (attr != null) {
                awattr = awdim.FindAttribute(this.END_DATE_NAME);
                if (awattr != null) {
                    this.setupAttributeProjection(oralev, "END_DATE", awattr);
                }
                processed.add(attr);
                corobj = this.getCorrespondentObject(attr);
                if (corobj != null) {
                    String string = this.getSchema(attr) + "." + corobj.getLongName();
                    this._cols.add(string);
                }
            }
            if ((attr = oa.timeSpan) != null) {
                awattr = awdim.FindAttribute(this.TIME_SPAN_NAME);
                if (awattr != null) {
                    this.setupAttributeProjection(oralev, "TIME_SPAN", awattr);
                }
                processed.add(attr);
                corobj = this.getCorrespondentObject(attr);
                if (corobj != null) {
                    String string = this.getSchema(attr) + "." + corobj.getLongName();
                    this._cols.add(string);
                }
            }
        }
        for (Attribute attribute : processed) {
            attrs.remove(attribute);
        }
    }

    public void createValubasedHierarchy(oracle.AWXML.Dimension awdim, Hierarchy _hier, oracle.dbtools.crest.model.design.multidimensional.Hierarchy hier, Vector columns, oracle.AWXML.Attribute ldAttr, oracle.AWXML.Attribute sdAttr, Map attrMap) {
        SourceColumn _attrCol;
        AttributeSourceExpression _attrMap;
        String colname;
        ModelIDObject corobj;
        oracle.AWXML.Attribute awattr;
        if (hier.getLevels().size() == 0) {
            return;
        }
        DimensionMapGroup _dmg = _hier.createSourceDimensionMapGroup();
        oracle.dbtools.crest.model.design.multidimensional.Level level = (oracle.dbtools.crest.model.design.multidimensional.Level)hier.getLevels().get(0);
        ArrayList attrs = new ArrayList();
        attrs.addAll(level.getDescriptiveAttributes());
        Level.OraAWAttributes oa = level.getOraAWAttributes();
        ContainedObject attr = oa.shortDesc;
        AttributeProjection ap = null;
        if (attr != null) {
            awattr = awdim.FindAttribute(this.SD_NAME);
            if (awattr == null) {
                awattr = awdim.createAttribute();
                awattr.setName(this.SD_NAME);
            }
            if (awattr != null) {
                ap = this.setupHierAttributeProjection(_hier, "Short Description", awattr);
            }
            attrs.remove(attr);
            corobj = this.getCorrespondentObject(attr);
            if (corobj != null) {
                colname = this.getSchema(attr) + "." + corobj.getLongName();
                this._cols.add(colname);
                _attrMap = _dmg.CreateAttributeMap();
                _attrMap.setTargetObject((BaseObject)ap);
                _attrCol = _attrMap.CreateSourceColumn();
                _attrCol.setColumn(colname.toUpperCase());
            }
        }
        if ((attr = oa.longDesc) != null) {
            awattr = awdim.FindAttribute(this.LD_NAME);
            if (awattr == null) {
                awattr = awdim.createAttribute();
                awattr.setName(this.LD_NAME);
            }
            if (awattr != null) {
                ap = this.setupHierAttributeProjection(_hier, "Long Description", awattr);
            }
            attrs.remove(attr);
            corobj = this.getCorrespondentObject(attr);
            if (corobj != null) {
                colname = this.getSchema(attr) + "." + corobj.getLongName();
                this._cols.add(colname);
                _attrMap = _dmg.CreateAttributeMap();
                _attrMap.setTargetObject((BaseObject)ap);
                _attrCol = _attrMap.CreateSourceColumn();
                _attrCol.setColumn(colname.toUpperCase());
            }
        }
        attrs.clear();
        attrs.addAll(level.getSlowChangingAttributes());
        for (SlowChangingAttribute sattr : attrs) {
            attr = sattr.getAttribute();
            awattr = (oracle.AWXML.Attribute)attrMap.get(attr.getObjectID());
            if (awattr == null) {
                awattr = awdim.createAttribute();
                awattr.setName(sattr.getName());
                attrMap.put(attr.getObjectID(), awattr);
            }
            ap = this.setupHierAttributeProjection(_hier, awattr.getName(), awattr);
            awattr.setClassification("USER");
            ModelIDObject corobj2 = this.getCorrespondentObject(attr);
            if (corobj2 == null) continue;
            String colname2 = this.getSchema(attr) + "." + corobj2.getLongName();
            this._cols.add(colname2);
            AttributeSourceExpression _attrMap2 = _dmg.CreateAttributeMap();
            _attrMap2.setTargetObject((BaseObject)ap);
            SourceColumn _attrCol2 = _attrMap2.CreateSourceColumn();
            _attrCol2.setColumn(colname2.toUpperCase());
        }
        _hier.setType("VALUE");
        DimensionKeySourceExpression _dkse = _dmg.CreateKeyMap();
        for (Attribute kattr : level.getLevelKey()) {
            ModelIDObject corobj3 = this.getCorrespondentObject(kattr);
            if (corobj3 == null) continue;
            String colname3 = this.getSchema(kattr) + "." + corobj3.getLongName();
            SourceColumn _levColumn = _dkse.CreateSourceColumn();
            _levColumn.setColumn(colname3.toUpperCase());
        }
        HierarchicalParentSourceExpression _hpse = _dmg.CreateParentMap();
        for (Attribute kattr : level.getParentKey()) {
            ModelIDObject corobj4 = this.getCorrespondentObject(kattr);
            if (corobj4 == null) continue;
            String colname4 = this.getSchema(kattr) + "." + corobj4.getLongName();
            SourceColumn _hpsesc = _hpse.CreateSourceColumn();
            _hpsesc.setColumn(colname4.toUpperCase());
        }
    }

    private void createHierarchyMap2(Hierarchy _hier, Vector _levels, Vector columns) {
        oracle.dbtools.crest.model.design.multidimensional.Level prevLevel = null;
        oracle.dbtools.crest.model.design.multidimensional.Level level = null;
        int i = 0;
        for (LevelDesc ldes : _levels) {
            Level _curLev = ldes.olevel;
            level = ldes.level;
            HierarchyLevelAssociation _hla = _hier.createHierarchyLevelAssociation();
            _hla.setLevel(_curLev);
            DimensionMapGroup _dmg = _hla.createSourceDimensionMapGroup();
            DimensionKeySourceExpression _dkse = _dmg.CreateKeyMap();
            for (Attribute kattr : level.getLevelKey()) {
                ModelIDObject corobj = this.getCorrespondentObject(kattr);
                if (corobj == null) continue;
                String colname = this.getSchema(kattr) + "." + corobj.getLongName();
                SourceColumn _levColumn = _dkse.CreateSourceColumn();
                _levColumn.setColumn(colname.toUpperCase());
            }
            if (i > 0) {
                HierarchicalParentSourceExpression _hpse = _dmg.CreateParentMap();
                if (prevLevel != null) {
                    Link link = level.getFirstLinkToTarget(prevLevel);
                    Iterator itk = link != null ? (link.getRollupLink().getChildToParentAttributes().size() > 0 ? link.getRollupLink().getChildToParentAttributes().iterator() : prevLevel.getLevelKey().iterator()) : prevLevel.getLevelKey().iterator();
                    while (itk.hasNext()) {
                        Attribute kattr = (Attribute)itk.next();
                        ModelIDObject corobj = this.getCorrespondentObject(kattr);
                        if (corobj == null) continue;
                        String colname = this.getSchema(kattr) + "." + corobj.getLongName();
                        SourceColumn _hpsesc = _hpse.CreateSourceColumn();
                        _hpsesc.setColumn(colname.toUpperCase());
                    }
                }
            }
            ++i;
            prevLevel = level;
        }
    }

    public oracle.AWXML.Attribute createLongDescAttr(oracle.AWXML.Dimension dim) {
        oracle.AWXML.Attribute ldAttr = dim.createAttribute();
        ldAttr.setName(this.LD_NAME);
        ldAttr.setClassification("MEMBER_LONG_DESCRIPTION");
        return ldAttr;
    }

    public oracle.AWXML.Attribute createShortDescAttr(oracle.AWXML.Dimension dim) {
        oracle.AWXML.Attribute sdAttr = dim.createAttribute();
        sdAttr.setName(this.SD_NAME);
        sdAttr.setClassification("MEMBER_SHORT_DESCRIPTION");
        return sdAttr;
    }

    public void createHierarchyMap(Hierarchy _hier, Vector _levels, Vector columns) {
        int i = 0;
        for (Level _curLev : _levels) {
            HierarchyLevelAssociation _hla = _hier.createHierarchyLevelAssociation();
            _hla.setLevel(_curLev);
            DimensionMapGroup _dmg = _hla.createSourceDimensionMapGroup();
            DimensionKeySourceExpression _dkse = _dmg.CreateKeyMap();
            SourceColumn _levColumn = _dkse.CreateSourceColumn();
            _levColumn.setColumn(((String)columns.elementAt(i)).toUpperCase());
            if (i > 0) {
                HierarchicalParentSourceExpression _hpse = _dmg.CreateParentMap();
                SourceColumn _hpsesc = _hpse.CreateSourceColumn();
                _hpsesc.setColumn(((String)columns.elementAt(i - 1)).toUpperCase());
            }
            ++i;
        }
    }

    private LevelDesc getLevelDesc(List list, oracle.dbtools.crest.model.design.multidimensional.Level level, oracle.dbtools.crest.model.design.multidimensional.Dimension dim) {
        for (LevelDesc ldes : list) {
            if (ldes.level != level || ldes.dim != dim) continue;
            return ldes;
        }
        return null;
    }

    public void createLevelMap(Level _lev, Vector _keys, Vector _columns, String whereClause) {
        DimensionMapGroup _dmg = _lev.createSourceDimensionMapGroup();
        DimensionKeySourceExpression _key = _dmg.CreateKeyMap();
        for (int y = 0; y < _keys.size(); ++y) {
            SourceColumn _keycol = _key.CreateSourceColumn();
            _keycol.setColumn(((String)_keys.elementAt(y)).toUpperCase());
        }
        if (!"".equals(whereClause)) {
            WhereClause wh_cl = _key.createRestriction();
            wh_cl.setWhereClause(whereClause);
        }
        int i = 0;
        for (AttributeProjection _curAttr : _lev.getAttributes()) {
            AttributeSourceExpression _attrMap = _dmg.CreateAttributeMap();
            _attrMap.setTargetObject((BaseObject)_curAttr);
            SourceColumn _attrCol = _attrMap.CreateSourceColumn();
            _attrCol.setColumn(((String)_columns.elementAt(i)).toUpperCase());
            ++i;
        }
    }

    public AttributeProjection setupHierAttributeProjection(Hierarchy _hier, String _name, oracle.AWXML.Attribute _attr) {
        AttributeProjection _ap = _hier.createAttributeProjection();
        _ap.setAttribute(_attr);
        return _ap;
    }

    public AttributeProjection setupAttributeProjection(Level _lev, String _name, oracle.AWXML.Attribute _attr) {
        AttributeProjection _ap = _lev.createAttributeProjection();
        _ap.setAttribute(_attr);
        return _ap;
    }

    public void clearLevelMapVectors() {
        this._keys.removeAllElements();
        this._cols.removeAllElements();
    }

    public void clearHierarchyMapVectors() {
        this._levels.removeAllElements();
        this._levColumns.removeAllElements();
    }

    private ApplicationView getApplicationView() {
        return this.appView;
    }

    public void setTempStatusMessage(String message) {
        this.appView.setTempStatusMessage(message);
    }

    public GUIConfiguration getConfiguration() {
        return GUIConfiguration.getInstance();
    }

    private void validateLevel(oracle.dbtools.crest.model.design.multidimensional.Level level) {
        ColumnProxy cp;
        ContainerObject obj = level.getLevelEntity();
        Entity ent = null;
        if (obj != null && obj instanceof Entity) {
            ent = (Entity)obj;
        }
        if (ent != null) {
            if (this.storDesign != null) {
                TableProxy tp = this.getTableProxy(ent);
                if (tp == null) {
                    this.valid = false;
                    this.validationSB.append("\n There is no corresponding table for entity ").append(ent.getName());
                }
            } else if (ent.getEngTable(this.physDesign) == null) {
                this.valid = false;
                this.validationSB.append("\n There is no corresponding table for entity ").append(ent.getName());
            }
        }
        if (ent == null) {
            this.valid = false;
            this.validationSB.append("\nLevel Entity is not defined for " + level.getName());
        } else if (level.getLevelKey().size() == 0) {
            this.valid = false;
            this.validationSB.append("\nLevel key attributes are not defined for " + level.getName());
        }
        for (ContainedObject attr : level.getLevelKey()) {
            if (!(attr instanceof Attribute)) continue;
            if (this.storDesign != null) {
                cp = this.getColumnProxy((Attribute)attr);
                if (cp != null) continue;
                this.valid = false;
                this.validationSB.append("\n There is no corresponding column for attribute ").append(attr.getLongName());
                continue;
            }
            if (((Attribute)attr).getEngColumn(this.physDesign) != null) continue;
            this.valid = false;
            this.validationSB.append("\n There is no corresponding column for attribute ").append(attr.getLongName());
        }
        for (ContainedObject attr : level.getDescriptiveAttributes()) {
            if (!(attr instanceof Attribute)) continue;
            if (this.storDesign != null) {
                cp = this.getColumnProxy((Attribute)attr);
                if (cp != null) continue;
                this.valid = false;
                this.validationSB.append("\n There is no corresponding column for attribute ").append(attr.getLongName());
                continue;
            }
            if (((Attribute)attr).getEngColumn(this.physDesign) != null) continue;
            this.valid = false;
            this.validationSB.append("\n There is no corresponding column for attribute ").append(attr.getLongName());
        }
    }

    private ColumnProxy getColumnProxy(Attribute attribute) {
        ContainedObject column = attribute.getEngColumn(this.physDesign);
        if (column != null && this.storDesign != null) {
            ColumnProxy cp = (ColumnProxy)this.storDesign.getColumnProxySet().getProxy(column.getObjectID());
            return cp;
        }
        return null;
    }

    private TableProxy getTableProxy(Entity entity) {
        Table table = entity.getEngTable(this.physDesign);
        if (table != null && this.storDesign != null) {
            TableProxy tp = (TableProxy)this.storDesign.getTableProxySet().getProxy(table.getObjectID());
            return tp;
        }
        if (table == null) {
            // empty if block
        }
        return null;
    }

    public void xml_build_global_aw(String awName) {
        this.curInteraction = new Interaction();
        this.curInteraction.setConnection(this.awConnection);
        BuildDatabase myBuild = (BuildDatabase)this.curInteraction.createAction("BUILDDATABASE");
        myBuild.setAWName(awName);
        myBuild.setRunSolve(false);
        myBuild.Execute();
    }

    private Measure createDerivedMeasure(oracle.AWXML.Cube awcube, oracle.dbtools.crest.model.design.multidimensional.Measure meas, Slice slice, Slice.MeasureWrapper mw) {
        String mname = meas.getName().replaceAll(" ", "_");
        mname = mname.replaceAll("[(]", "_");
        if (this.existsMeasureName(mname = mname.replaceAll("[)]", "_"))) {
            String tname = mname;
            mname = this.existsMeasureName(tname) ? this.produceUniqueMeasureName(mname) : tname;
        }
        DerivedMeasure derivedMeasure = awcube.createDerivedMeasure();
        derivedMeasure.setName(mname);
        derivedMeasure.setLongName(meas.getOracleLongName());
        derivedMeasure.setShortName(meas.getOracleShortName());
        derivedMeasure.setPluralName(meas.getOraclePluralName());
        meas.setNameInOracleAW(derivedMeasure.getName());
        String expr = meas.getFormula();
        if (meas.isCustomFormula()) {
            derivedMeasure.setExpressionText(expr);
        } else {
            expr = mw == null ? this.getMeasureExpression(meas) : this.getMeasureExpression(slice, mw);
            derivedMeasure.setExpressionText(expr);
        }
        if (slice == null || mw == null) {
            this.measMap.put(meas.getObjectID(), derivedMeasure);
        } else {
            this.measMap.put(this.makeMeasureID(slice, mw), derivedMeasure);
        }
        return derivedMeasure;
    }

    private Measure createOLAPMeasure(oracle.AWXML.Cube awcube, oracle.dbtools.crest.model.design.multidimensional.Measure meas, Slice slice, Slice.MeasureWrapper mw) {
        Measure baseMeasureObj;
        oracle.AWXML.Dimension dimensionObj = null;
        OlapMeasureInput inputMeasure = null;
        String operator = this.getOperatorID(meas.getOLAPOperator());
        oracle.dbtools.crest.model.design.multidimensional.Measure usedMeasure = meas.getUsedOLAPMeasure();
        if (usedMeasure == null) {
            return null;
        }
        String usedMeasureID = usedMeasure.getObjectID();
        if (slice == null) {
            baseMeasureObj = (Measure)this.measMap.get(usedMeasureID);
        } else {
            String id = slice.getObjectID() + usedMeasureID + String.valueOf(mw.getAggrFunction().getObjectID());
            baseMeasureObj = (Measure)this.measMap.get(id);
        }
        if (baseMeasureObj == null) {
            return null;
        }
        String mname = meas.getName().replaceAll(" ", "_");
        mname = mname.replaceAll("[(]", "_");
        if (this.existsMeasureName(mname = mname.replaceAll("[)]", "_"))) {
            String tname = mname;
            mname = this.existsMeasureName(tname) ? this.produceUniqueMeasureName(mname) : tname;
        }
        OlapMeasure olapMeasure = awcube.createOlapMeasure();
        olapMeasure.setName(mname);
        olapMeasure.setLongName(meas.getOracleLongName());
        olapMeasure.setShortName(meas.getOracleShortName());
        olapMeasure.setPluralName(meas.getOraclePluralName());
        meas.setNameInOracleAW(olapMeasure.getName());
        if (slice == null || mw == null) {
            this.measMap.put(meas.getObjectID(), olapMeasure);
        } else {
            this.measMap.put(this.makeMeasureID(slice, mw), olapMeasure);
        }
        olapMeasure.setOlapOperator(operator);
        inputMeasure = olapMeasure.createOlapMeasureInput();
        inputMeasure.setKeyWord("MEASURE");
        inputMeasure.setReferencedObj((BaseObject)baseMeasureObj);
        OlapMeasureInput inputDimension = olapMeasure.createOlapMeasureInput();
        inputDimension.setKeyWord("DIMENSION");
        oracle.dbtools.crest.model.design.multidimensional.Dimension dim = meas.getOLAPDimension();
        dimensionObj = (oracle.AWXML.Dimension)this.dimMap.get(dim.getObjectID());
        if (dimensionObj == null) {
            awcube.removeOlapMeasure(olapMeasure);
            return null;
        }
        inputDimension.setReferencedObj((BaseObject)dimensionObj);
        if (operator.indexOf("PRIOR_PERIOD") > -1 || operator.indexOf("FUTURE_PERIOD") > -1 || operator.indexOf("PERIOD_TO_DATE") > -1 || operator.indexOf("SAME_PERIOD_ANCESTORS") > -1 || operator.indexOf("SHARE_TO") > -1 || operator.indexOf("RANK_") > -1 || operator.indexOf("CUMULATIVE_TOTAL") > -1) {
            OlapMeasureInput inputHierarchy = olapMeasure.createOlapMeasureInput();
            inputHierarchy.setKeyWord("HIERARCHY");
            oracle.dbtools.crest.model.design.multidimensional.Hierarchy hier = meas.getOLAPHierarchy();
            Hierarchy awhier = (Hierarchy)this.hierMap.get(hier.getObjectID());
            if (awhier == null) {
                awcube.removeOlapMeasure(olapMeasure);
                return null;
            }
            inputHierarchy.setReferencedObj((BaseObject)awhier);
        }
        if (operator.indexOf("PERIOD_TO_DATE") > -1 || operator.indexOf("SHARE_TO_LEVEL") > -1) {
            OlapMeasureInput inputLevel = olapMeasure.createOlapMeasureInput();
            inputLevel.setKeyWord("LEVEL");
            oracle.dbtools.crest.model.design.multidimensional.Level level = meas.getOLAPLevel();
            Level awlevel = (Level)this.levMap.get(level.getObjectID() + dim.getObjectID());
            if (awlevel == null) {
                awcube.removeOlapMeasure(olapMeasure);
                return null;
            }
            inputLevel.setReferencedObj((BaseObject)awlevel);
        }
        if (operator.indexOf("LEAD") > -1 || operator.indexOf("LAG") > -1 || operator.indexOf("PRIOR_PERIOD") > -1 || operator.indexOf("FUTURE_PERIOD") > -1 || operator.indexOf("SAME_PERIOD_ANCESTORS") > -1) {
            OlapMeasureInput inputOffset = olapMeasure.createOlapMeasureInput();
            inputOffset.setKeyWord("OFFSET");
            inputOffset.setScalarValue(String.valueOf(meas.getOLAPOffset()));
        }
        if (operator.indexOf("MOVING") > -1) {
            OlapMeasureInput inputStart = olapMeasure.createOlapMeasureInput();
            inputStart.setKeyWord("START");
            inputStart.setScalarValue(String.valueOf(meas.getOLAPStart()));
            OlapMeasureInput inputStop = olapMeasure.createOlapMeasureInput();
            inputStop.setKeyWord("STOP");
            inputStop.setScalarValue(String.valueOf(meas.getOLAPStop()));
            OlapMeasureInput inputStep = olapMeasure.createOlapMeasureInput();
            inputStep.setKeyWord("STEP");
            inputStep.setScalarValue(String.valueOf(meas.getOLAPStep()));
        }
        if (operator.indexOf("PERIOD_TO_DATE") > -1) {
            OlapMeasureInput inputOper = olapMeasure.createOlapMeasureInput();
            inputOper.setKeyWord("OPERATION");
            inputOper.setScalarValue(meas.getOLAPPeriodToDateOperation());
        }
        if (operator.indexOf("RANK_") > -1) {
            OlapMeasureInput inputDirection = olapMeasure.createOlapMeasureInput();
            inputDirection.setKeyWord("DIRECTION");
            inputDirection.setScalarValue(meas.getRankDirectionCode());
        }
        return olapMeasure;
    }

    private String getOperatorID(String objectName) {
        String invalidChars = "[^A-Z0-9_]";
        String newID = objectName.toUpperCase();
        newID = newID.replaceAll(invalidChars, "_");
        return newID;
    }

    private List getMeasureDependencies(List measures) {
        ArrayList<MeasureDependence> list = new ArrayList<MeasureDependence>();
        for (oracle.dbtools.crest.model.design.multidimensional.Measure measure : measures) {
            MeasureDependence md = new MeasureDependence(measure);
            if (!measure.isFormula()) {
                list.add(md);
                continue;
            }
            if (measure.getOracleAWFormulaType().equalsIgnoreCase(oracle.dbtools.crest.model.design.multidimensional.Measure.AW_OLAP_FORMULA)) {
                oracle.dbtools.crest.model.design.multidimensional.Measure usedMeasure = measure.getUsedOLAPMeasure();
                if (usedMeasure != null) {
                    md.dependOn.add(usedMeasure);
                }
            } else if (!measure.isCustomFormula()) {
                String formula = measure.getFormula().toUpperCase();
                for (oracle.dbtools.crest.model.design.multidimensional.Measure measn : measures) {
                    String namedq;
                    if (measn == measure || formula.indexOf(namedq = "\"" + measn.getName().toUpperCase().trim() + "\"") <= -1) continue;
                    md.dependOn.add(measn);
                }
            }
            list.add(md);
        }
        return list;
    }

    private void sortMeasures(List measures) {
        this.sortedMeasures.clear();
        this.tracedMeasures.clear();
        this.cyclicRef = false;
        this.measureDependencies = this.getMeasureDependencies(measures);
        for (oracle.dbtools.crest.model.design.multidimensional.Measure measure : measures) {
            this.addToSorted(measure);
            if (!this.cyclicRef) continue;
            return;
        }
    }

    private void addToSorted(oracle.dbtools.crest.model.design.multidimensional.Measure measure) {
        if (this.sortedMeasures.contains(measure)) {
            return;
        }
        MeasureDependence md = this.getMeasureDependence(measure, this.measureDependencies);
        if (md == null) {
            this.sortedMeasures.add(measure);
            this.tracedMeasures.add(measure);
            return;
        }
        if (md.dependOn.size() == 0) {
            this.sortedMeasures.add(measure);
            this.tracedMeasures.add(measure);
            return;
        }
        this.tracedMeasures.add(measure);
        for (oracle.dbtools.crest.model.design.multidimensional.Measure meas : md.dependOn) {
            if (this.tracedMeasures.contains(meas) && !this.sortedMeasures.contains(meas)) {
                this.cyclicRef = true;
                String mname = "\"" + meas.getCube().getName() + "\".\"" + meas.getName() + "\"";
                JOptionPane.showOptionDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("OracleAWExporter.ThereIsCyclicFeferenceForMeasure"), mname), Messages.getString("OracleAWExporter.CyclicRference"), 0, 0, null, new String[]{Messages.getString("OracleAWExporter.Ok")}, Messages.getString("OracleAWExporter.Ok"));
                this.error = true;
                this.valid = false;
                this.eb.append("\nCyclic reference for measure ").append(mname);
                return;
            }
            if (this.sortedMeasures.contains(meas)) continue;
            this.addToSorted(meas);
            if (!this.cyclicRef) continue;
            return;
        }
        this.sortedMeasures.add(measure);
    }

    private MeasureDependence getMeasureDependence(oracle.dbtools.crest.model.design.multidimensional.Measure measure, List measureDependencies) {
        for (MeasureDependence md : measureDependencies) {
            if (md.measure != measure) continue;
            return md;
        }
        return null;
    }

    public String getMeasureExpression(oracle.dbtools.crest.model.design.multidimensional.Measure measure) {
        Cube cube = measure.getCube();
        String func = measure.getFormula();
        for (oracle.dbtools.crest.model.design.multidimensional.Measure obj : cube.getMeasures()) {
            Measure awmeas;
            String obname;
            if (obj == measure || func.indexOf(obname = "\"" + obj.getName().trim() + "\"") <= -1 || (awmeas = (Measure)this.measMap.get(obj.getObjectID())) == null) continue;
            String measID = awmeas.getId();
            func = this.replace(func, obname, measID);
        }
        return func;
    }

    public String getMeasureExpression(Slice slice, Slice.MeasureWrapper mw) {
        oracle.dbtools.crest.model.design.multidimensional.Measure measure = mw.getMeasure();
        Cube cube = measure.getCube();
        String func = measure.getFormula();
        for (oracle.dbtools.crest.model.design.multidimensional.Measure obj : cube.getMeasures()) {
            String id;
            Measure awmeas;
            String obname;
            if (obj == measure || func.indexOf(obname = "\"" + obj.getName().trim() + "\"") <= -1 || (awmeas = (Measure)this.measMap.get(id = slice.getObjectID() + obj.getObjectID() + obj.getDefaultAggregationFunction().getObjectID())) == null) continue;
            String measID = awmeas.getId();
            func = this.replace(func, obname, measID);
        }
        return func;
    }

    private String replace(String origin, String str1, String str2) {
        String temp = str1.trim();
        Object result = origin;
        int ind = ((String)result).indexOf(temp);
        int lstr1 = temp.length();
        while (ind > -1) {
            String tresult = ind == 0 ? "" : ((String)result).substring(0, ind);
            int k = tresult.length() + str2.length();
            result = tresult + str2 + ((String)result).substring(ind + lstr1);
            ind = ((String)result).indexOf(temp, k);
        }
        return result;
    }

    private void validateCube(Cube cube) {
        this.sortedMeasures.clear();
        this.tracedMeasures.clear();
        this.eb.setLength(0);
        this.sortMeasures(cube.getMeasures());
        if (this.cyclicRef) {
            this.valid = false;
            this.validationSB.append("\n\nCube " + cube.getName() + " has measures with cyclic references").append(this.eb.toString());
        }
        if (cube.getFactEntities().size() == 0) {
            this.valid = false;
            this.validationSB.append("\nThere is no Fact Entity defined for Cube " + cube.getName());
        }
        if (cube.hasRolePlayingDimensions()) {
            this.warning = true;
            this.warningsSB.append("\nCube " + cube.getName() + " has Role Playing Dimensions and will not be generated. Use Slice to create cube.");
        }
        if (cube.getDimensions().size() == 0) {
            this.valid = false;
            this.validationSB.append("\nThere is no dimension usage for cube " + cube.getName());
        }
        for (oracle.dbtools.crest.model.design.multidimensional.Dimension dim : cube.getDimensions()) {
            oracle.dbtools.crest.model.design.multidimensional.Level level = dim.getBaseLevel();
            RollupLink rl = cube.getRollUpLink(dim);
            if (rl.getChildToParentAttributes().size() == 0) {
                this.valid = false;
                this.validationSB.append("\nThere are no reference attributes defined for dimenson " + dim.getName() + " in Cube " + cube.getName());
                continue;
            }
            if (level == null || rl.getChildToParentAttributes().size() == level.getLevelKey().size()) continue;
            this.valid = false;
            this.validationSB.append("\nThe number of reference attributes for dimenson " + dim.getName() + " in cube " + cube.getName());
            this.validationSB.append(" differ from number of key attributes for level " + level.getName());
        }
        for (oracle.dbtools.crest.model.design.multidimensional.Measure measure : cube.getMeasures()) {
            this.validateMeasure(measure);
        }
        for (Slice slice : cube.getPrecalculatedSlices()) {
            this.validateSlice(slice);
        }
    }

    private void validateMeasure(oracle.dbtools.crest.model.design.multidimensional.Measure measure) {
        if (!measure.isFormula()) {
            ContainedObject attr = measure.getMeasureFact();
            if (attr == null) {
                this.valid = false;
                this.validationSB.append("\nThere is no fact attribute defined for measure " + measure.getName() + "in Cube " + measure.getCube().getName());
            } else if (this.storDesign != null) {
                if (attr instanceof Attribute) {
                    ColumnProxy cp = this.getColumnProxy((Attribute)attr);
                    if (cp == null) {
                        this.valid = false;
                        this.validationSB.append("\n There is no corresponding column for attribute ").append(attr.getLongName());
                    }
                } else if (((AttributeView)attr).getEngColumnView(this.physDesign) == null) {
                    this.valid = false;
                    this.validationSB.append("\n There is no corresponding columnView for attributeView ").append(attr.getLongName());
                }
            } else if (attr instanceof Attribute) {
                if (((Attribute)attr).getEngColumn(this.physDesign) == null) {
                    this.valid = false;
                    this.validationSB.append("\n There is no corresponding column for attribute ").append(attr.getLongName());
                }
            } else if (((AttributeView)attr).getEngColumnView(this.physDesign) == null) {
                this.valid = false;
                this.validationSB.append("\n There is no corresponding columnView for attributeView ").append(attr.getLongName());
            }
        } else {
            this.validateAndSetOLAPMeasure((MultidimensionalDesign)measure.getDesignPart(), measure);
        }
    }

    private void validateAndSetOLAPMeasure(MultidimensionalDesign mdm, oracle.dbtools.crest.model.design.multidimensional.Measure meas) {
        if (meas.isFormula() && meas.getOracleAWFormulaType().equalsIgnoreCase(oracle.dbtools.crest.model.design.multidimensional.Measure.AW_OLAP_FORMULA)) {
            String operator;
            oracle.dbtools.crest.model.design.multidimensional.Dimension dim;
            oracle.dbtools.crest.model.design.multidimensional.Measure usedMeasure = meas.getUsedOLAPMeasure();
            if (usedMeasure != null) {
                usedMeasure = (oracle.dbtools.crest.model.design.multidimensional.Measure)mdm.getMeasureSet().getObjectByID(usedMeasure.getObjectID());
            }
            if (usedMeasure == null) {
                this.valid = false;
                meas.setUsedOLAPMeasure(null);
                this.validationSB.append("\nBase measure is not set for OLAP calcilated measure " + meas.getName());
            }
            if ((dim = meas.getOLAPDimension()) != null) {
                dim = (oracle.dbtools.crest.model.design.multidimensional.Dimension)mdm.getDimensionSet().getObjectByID(dim.getObjectID());
            }
            if (dim == null) {
                this.valid = false;
                meas.setOLAPDimension(null);
                meas.setOLAPHierarchy(null);
                meas.setOLAPLevel(null);
                this.validationSB.append("\nDimension is not set for OLAP calcilated measure " + meas.getName());
            }
            if ((operator = this.getOperatorID(meas.getOLAPOperator())).indexOf("PRIOR_PERIOD") > -1 || operator.indexOf("FUTURE_PERIOD") > -1 || operator.indexOf("PERIOD_TO_DATE") > -1 || operator.indexOf("SAME_PERIOD_ANCESTORS") > -1 || operator.indexOf("SHARE_TO") > -1 || operator.indexOf("RANK_") > -1 || operator.indexOf("CUMULATIVE_TOTAL") > -1) {
                oracle.dbtools.crest.model.design.multidimensional.Hierarchy hier = meas.getOLAPHierarchy();
                if (hier != null) {
                    hier = (oracle.dbtools.crest.model.design.multidimensional.Hierarchy)mdm.getHierarchySet().getObjectByID(hier.getObjectID());
                }
                if (hier == null) {
                    this.valid = false;
                    meas.setOLAPHierarchy(null);
                    meas.setOLAPLevel(null);
                    this.validationSB.append("\nHierarchy is not set for OLAP calcilated measure " + meas.getName());
                }
            }
            if (operator.indexOf("PERIOD_TO_DATE") > -1 || operator.indexOf("SHARE_TO_LEVEL") > -1) {
                oracle.dbtools.crest.model.design.multidimensional.Level level = meas.getOLAPLevel();
                if (level != null) {
                    level = (oracle.dbtools.crest.model.design.multidimensional.Level)mdm.getLevelSet().getObjectByID(level.getObjectID());
                }
                if (level == null) {
                    this.valid = false;
                    meas.setOLAPLevel(null);
                    this.validationSB.append("\nLevel is not set for OLAP calcilated measure " + meas.getName());
                }
            }
        }
    }

    private void validateDimension(oracle.dbtools.crest.model.design.multidimensional.Dimension dim) {
        oracle.dbtools.crest.model.design.multidimensional.Level blevel = dim.getBaseLevel();
        if (blevel == null) {
            this.valid = false;
            this.validationSB.append("\nThere is no base level for dimension " + dim.getName());
        }
        for (oracle.dbtools.crest.model.design.multidimensional.Hierarchy hier : dim.getHierarchies()) {
            this.validateHierachy(hier);
        }
        for (oracle.dbtools.crest.model.design.multidimensional.Level level : dim.getAllLevels()) {
            this.validateAWAttributes(level, dim.isTimeDimension());
        }
    }

    private void validateHierachy(oracle.dbtools.crest.model.design.multidimensional.Hierarchy hier) {
        block4: {
            Object[] levels;
            block2: {
                oracle.dbtools.crest.model.design.multidimensional.Level level;
                block7: {
                    block6: {
                        block5: {
                            block3: {
                                levels = hier.getLevels().toArray();
                                if (!hier.isValueBasedHierarchy()) break block2;
                                level = (oracle.dbtools.crest.model.design.multidimensional.Level)levels[0];
                                if (levels.length <= 1) break block3;
                                this.valid = false;
                                this.validationSB.append("\nValue based hierachy " + hier.getName() + " has levels connected to its defintition level " + level.getName());
                                break block4;
                            }
                            if (level.getLevelEntity() != null) break block5;
                            this.valid = false;
                            this.validationSB.append("\nLevel Entity is not defined for " + level.getName());
                            break block4;
                        }
                        if (level.getLevelKey().size() != 0) break block6;
                        this.valid = false;
                        this.validationSB.append("\nLevel key attributes are not defined for " + level.getName());
                        break block4;
                    }
                    if (level.getParentKey().size() != 0) break block7;
                    this.valid = false;
                    this.validationSB.append("\nParent key attributes are nod defined for Value Based Hierarchy in level " + level.getName());
                    break block4;
                }
                if (level.getParentKey().size() == level.getLevelKey().size()) break block4;
                this.valid = false;
                this.validationSB.append("\nThe number of parent key attributes for Value Based Hierarchy in level " + level.getName());
                this.validationSB.append(" differ from number of key attributes ");
                break block4;
            }
            for (int i = 0; i < levels.length - 1; ++i) {
                oracle.dbtools.crest.model.design.multidimensional.Level level = (oracle.dbtools.crest.model.design.multidimensional.Level)levels[i];
                oracle.dbtools.crest.model.design.multidimensional.Level uplevel = (oracle.dbtools.crest.model.design.multidimensional.Level)levels[i + 1];
                Link link = level.getFirstLinkToTarget(uplevel);
                if (level.getLevelKey().size() == 0) {
                    this.valid = false;
                    this.validationSB.append("\nLevel key attributes are not defined for " + level.getName());
                    continue;
                }
                if (link == null) continue;
                RollupLink rl = link.getRollupLink();
                if (level.getLevelEntity() == uplevel.getLevelEntity() || rl.getChildToParentAttributes().size() == uplevel.getLevelKey().size()) continue;
                this.valid = false;
                this.validationSB.append("\nThe number of reference attributes from level " + level.getName() + " ito level " + uplevel.getName());
                this.validationSB.append(" differ from number of key attributes for level " + uplevel.getName());
            }
        }
    }

    private void validateAWAttributes(oracle.dbtools.crest.model.design.multidimensional.Level level, boolean isTimeDimeansion) {
        Level.OraAWAttributes awa = level.getOraAWAttributes();
        if (awa.shortDesc == null) {
            this.warning = true;
            this.warningsSB.append("\nSHORT_DESCRIPTION attribute is not defined for " + level.getName());
        }
        if (awa.longDesc == null) {
            this.warning = true;
            this.warningsSB.append("\nLONG_DESCRIPTION attribute is not defined for " + level.getName());
        }
        if (isTimeDimeansion) {
            if (awa.timeSpan == null) {
                this.warning = true;
                this.warningsSB.append("\nTIME_SPAN attribute is not defined for " + level.getName());
            }
            if (awa.timeEnd == null) {
                this.warning = true;
                this.warningsSB.append("\nTIME_END attribute is not defined for " + level.getName());
            }
        }
    }

    private void validateSlice(Slice slice) {
        slice.verifyMeasureWrappers();
        if (slice.getSelectedLevels().size() == 0) {
            this.valid = false;
            this.validationSB.append("\nThere is no dimension usage for slice " + slice.getName());
        }
        for (Slice.MeasureWrapper mw : slice.getSelectedMeasureWrappers()) {
            List list = this.getMeasureDependenciesFor(mw.getMeasure(), slice.getCube().getMeasures());
            Object mnames = "";
            boolean first = true;
            for (int i = 0; i < list.size(); ++i) {
                oracle.dbtools.crest.model.design.multidimensional.Measure meas = (oracle.dbtools.crest.model.design.multidimensional.Measure)list.get(i);
                Slice.MeasureWrapper tmw = this.findMWrapperFor(meas, meas.getDefaultAggregationFunction(), slice.getSelectedMeasureWrappers());
                if (tmw != null) continue;
                if (first) {
                    first = false;
                    mnames = meas.getName() + " - " + meas.getDefaultAggregationFunction().name;
                    continue;
                }
                mnames = (String)mnames + " ," + meas.getName() + " - " + meas.getDefaultAggregationFunction().name;
            }
            if ("".equals(mnames)) continue;
            this.valid = false;
            this.validationSB.append("\nDependence error in Slice - " + slice.getName() + "measure " + mw.getMeasure().getName() + "depends on measures: " + (String)mnames);
        }
    }

    private List getMeasureDependenciesFor(oracle.dbtools.crest.model.design.multidimensional.Measure inmeasure, List measures) {
        ArrayList<oracle.dbtools.crest.model.design.multidimensional.Measure> list = new ArrayList<oracle.dbtools.crest.model.design.multidimensional.Measure>();
        if (!inmeasure.isFormula()) {
            return list;
        }
        oracle.dbtools.crest.model.design.multidimensional.Measure usedMeasure = inmeasure.getUsedOLAPMeasure();
        String formula = inmeasure.getFormula().toUpperCase();
        for (oracle.dbtools.crest.model.design.multidimensional.Measure measure : measures) {
            String namedq;
            if (measure == inmeasure || !inmeasure.isFormula()) continue;
            if (inmeasure.getOracleAWFormulaType().equalsIgnoreCase(oracle.dbtools.crest.model.design.multidimensional.Measure.AW_OLAP_FORMULA)) {
                if (usedMeasure == null || usedMeasure != measure) continue;
                list.add(usedMeasure);
                continue;
            }
            if (measure.isCustomFormula() || formula.indexOf(namedq = "\"" + measure.getName().toUpperCase().trim() + "\"") <= -1) continue;
            list.add(measure);
        }
        return list;
    }

    private Slice.MeasureWrapper findMWrapperFor(oracle.dbtools.crest.model.design.multidimensional.Measure measure, Measure.AggregateFunction af, List wrappers) {
        for (Slice.MeasureWrapper mw : wrappers) {
            if (mw.getMeasure() != measure || af != mw.getAggrFunction()) continue;
            return mw;
        }
        return null;
    }

    private void exportCalcMeasures() {
        this.overwrite = this.exportType.equals(EXPORT_ALL_CALC_MEASURES);
        this.captureDimensions();
        this.captureFolders();
        for (AWExportOptions.SelObject so : this.selectedObjects) {
            if (so.object instanceof Cube && so.selected) {
                Cube cube = (Cube)so.object;
                if (cube.hasRolePlayingDimensions()) continue;
                this.exportCubeCalcMeasures(cube);
                continue;
            }
            if (!(so.object instanceof Slice) || !so.selected) continue;
            Slice slice = (Slice)so.object;
            this.exportSliceCalcMeasures(slice);
        }
        this.exportMeasureFolders();
        this.globalAW.Commit(this.awConnection);
    }

    private void captureAWCubeMeasures(Cube cube, oracle.AWXML.Cube awcube) {
        Vector vm = awcube.getMeasures();
        Vector vmder = awcube.getDerivedMeasures();
        ArrayList awmlist = new ArrayList(vm);
        ArrayList awmderlist = new ArrayList(vmder);
        for (oracle.dbtools.crest.model.design.multidimensional.Measure meas : cube.getMeasures()) {
            Measure awmeas = awcube.findMeasure(meas.getNameInOracleAW());
            if (awmeas != null) {
                this.measMap.put(meas.getObjectID(), awmeas);
                this.awmeasToMeasure.put(awmeas.getId(), meas);
                this.awmeasMap.put(awmeas.getId(), awmeas);
                awmlist.remove(awmeas);
                continue;
            }
            awmeas = awcube.findDerivedMeasure(meas.getNameInOracleAW());
            if (awmeas == null) continue;
            this.measMap.put(meas.getObjectID(), awmeas);
            this.awmeasToMeasure.put(awmeas.getId(), meas);
            this.awmeasMap.put(awmeas.getId(), awmeas);
            awmderlist.remove(awmeas);
        }
        awmlist.addAll(awmderlist);
        for (Measure awmeas : awmlist) {
            this.additionalAWMeasures.put(awmeas.getId(), awmeas);
            this.awmeasMap.put(awmeas.getId(), awmeas);
        }
    }

    private void deleteAWMeasures(List measures, oracle.AWXML.Cube awcube) {
        for (int i = measures.size() - 1; i > -1; --i) {
            oracle.dbtools.crest.model.design.multidimensional.Measure meas = (oracle.dbtools.crest.model.design.multidimensional.Measure)measures.get(i);
            Measure awmeas = (Measure)this.measMap.get(meas.getObjectID());
            if (awmeas == null || !(awmeas instanceof DerivedMeasure)) continue;
            awmeas.Delete(this.awConnection);
            awcube.removeDerivedMeasure((DerivedMeasure)awmeas);
        }
    }

    private void exportCubeCalcMeasures(Cube cube) {
        oracle.AWXML.Cube awcube = this.globalAW.findCube(cube.getNameInOracleAW());
        if (awcube != null) {
            this.captureAWCubeMeasures(cube, awcube);
            this.sortedMeasures.clear();
            this.tracedMeasures.clear();
            this.sortMeasures(cube.getMeasures());
            this.deleteAWMeasures(this.sortedMeasures, awcube);
            for (oracle.dbtools.crest.model.design.multidimensional.Measure meas : this.sortedMeasures) {
                Measure newawmeas;
                if (!meas.isFormula() && !meas.isFactDimension() || meas.isFactDimension() || !this.isValidMeasure(meas, this.sortedMeasures)) continue;
                Measure awmeas = (Measure)this.measMap.get(meas.getObjectID());
                if (awmeas != null && this.overwrite && !(awmeas instanceof DerivedMeasure)) {
                    if (awmeas instanceof OlapMeasure) {
                        awcube.removeOlapMeasure((OlapMeasure)awmeas);
                    } else {
                        awmeas.Delete(this.awConnection);
                        awcube.removeMeasure(awmeas);
                    }
                }
                if (awmeas != null && !this.overwrite) continue;
                if (meas.isDefinedAsOracleAWCalculated() && meas.getOracleAWFormulaType().equalsIgnoreCase(oracle.dbtools.crest.model.design.multidimensional.Measure.AW_OLAP_FORMULA)) {
                    newawmeas = this.createOLAPMeasure(awcube, meas, null, null);
                    newawmeas.Alter(this.awConnection);
                } else {
                    newawmeas = this.createDerivedMeasure(awcube, meas, null, null);
                }
                if (newawmeas == null) continue;
                if (awmeas != null) {
                    this.oldNewMap.put(awmeas.getId(), newawmeas);
                    this.awmeasMap.put(awmeas.getId(), newawmeas);
                    this.awmeasToMeasure.put(awmeas.getId(), meas);
                }
                if (!(newawmeas instanceof OlapMeasure)) {
                    newawmeas.Create(this.awConnection);
                }
                this.exportedMeasures.add(newawmeas);
            }
        }
    }

    private void exportSliceCalcMeasures(Slice slice) {
    }

    private boolean isValidMeasure(oracle.dbtools.crest.model.design.multidimensional.Measure measure, List measures) {
        List list = this.getMeasureDependencies(measure, measures);
        if (list.size() == 0) {
            return true;
        }
        boolean result = true;
        for (oracle.dbtools.crest.model.design.multidimensional.Measure meas : list) {
            Measure awmeas;
            if (meas.isFormula() || (awmeas = (Measure)this.measMap.get(meas.getObjectID())) != null) continue;
            result = false;
        }
        return result;
    }

    private List getMeasureDependencies(oracle.dbtools.crest.model.design.multidimensional.Measure measure, List measures) {
        ArrayList<oracle.dbtools.crest.model.design.multidimensional.Measure> list = new ArrayList<oracle.dbtools.crest.model.design.multidimensional.Measure>();
        if (!measure.isFormula()) {
            return list;
        }
        if (measure.getOracleAWFormulaType().equalsIgnoreCase(oracle.dbtools.crest.model.design.multidimensional.Measure.AW_OLAP_FORMULA)) {
            oracle.dbtools.crest.model.design.multidimensional.Measure usedMeasure = measure.getUsedOLAPMeasure();
            if (usedMeasure != null) {
                list.add(usedMeasure);
            }
        } else if (!measure.isCustomFormula()) {
            String formula = measure.getFormula().toUpperCase();
            for (oracle.dbtools.crest.model.design.multidimensional.Measure measn : measures) {
                String namedq;
                if (measn == measure || formula.indexOf(namedq = "\"" + measn.getName().toUpperCase().trim() + "\"") <= -1) continue;
                list.add(measn);
            }
        }
        return list;
    }

    private void captureFolders() {
        Vector folders = this.globalAW.getMeasureFolders();
        for (oracle.AWXML.MeasureFolder mf : folders) {
            MeasFolder measFolder = this.captureFolder(mf);
            this.awMeasureFolders.add(measFolder);
        }
    }

    private MeasFolder captureFolder(oracle.AWXML.MeasureFolder measureFolder) {
        MeasFolder mf = new MeasFolder(measureFolder.getName());
        mf.awfolder = measureFolder;
        for (oracle.AWXML.MeasureFolder subfolder : measureFolder.getMeasureFolders()) {
            MeasFolder measFolder = this.captureFolder(subfolder);
            mf.folders.add(measFolder);
        }
        for (Measure meas : measureFolder.getMeasures()) {
            mf.measures.add(meas.getId());
            this.awmeasMap.put(meas.getId(), meas);
        }
        return mf;
    }

    private void captureDimensions() {
        ArrayList dimlist = new ArrayList(this.globalAW.getDimensions());
        Iterator it = this.mdmDesign.getDimensionSet().iterator();
        while (it.hasNext()) {
            oracle.dbtools.crest.model.design.multidimensional.Dimension dim = (oracle.dbtools.crest.model.design.multidimensional.Dimension)it.next();
            oracle.AWXML.Dimension awdim = this.findDimension(dimlist, dim.getNameInOracleAW());
            if (awdim == null) continue;
            this.dimMap.put(dim.getObjectID(), awdim);
            this.captureDimension(awdim, dim);
        }
    }

    private void captureDimension(oracle.AWXML.Dimension awdim, oracle.dbtools.crest.model.design.multidimensional.Dimension dim) {
        ArrayList awlevels = new ArrayList(awdim.getLevels());
        for (oracle.dbtools.crest.model.design.multidimensional.Level level : dim.getAllLevels()) {
            Level awlevel = this.findLevel(awlevels, level.getNameInOracleAW());
            if (awlevel == null) continue;
            this.levMap.put(level.getObjectID() + dim.getObjectID(), awlevel);
        }
        ArrayList awhiers = new ArrayList(awdim.getHierarchies());
        for (oracle.dbtools.crest.model.design.multidimensional.Hierarchy hier : dim.getHierarchies()) {
            Hierarchy awhier = this.findHierarchy(awhiers, hier.getNameInOracleAW());
            if (awhier == null) continue;
            this.hierMap.put(hier.getObjectID(), awhier);
        }
    }

    private Level findLevel(List awlevels, String name) {
        for (Level awlevel : awlevels) {
            if (!name.equalsIgnoreCase(awlevel.getName())) continue;
            return awlevel;
        }
        return null;
    }

    private Hierarchy findHierarchy(List awhiers, String name) {
        for (Hierarchy awhier : awhiers) {
            if (!name.equalsIgnoreCase(awhier.getName())) continue;
            return awhier;
        }
        return null;
    }

    private oracle.AWXML.Dimension findDimension(List awdims, String name) {
        for (oracle.AWXML.Dimension awdim : awdims) {
            if (!name.equalsIgnoreCase(awdim.getName())) continue;
            return awdim;
        }
        return null;
    }

    private void exportMeasureFolders() {
        for (MeasFolder mfolder : this.awMeasureFolders) {
            mfolder.awfolder.Delete(this.awConnection);
            this.globalAW.removeMeasureFolder(mfolder.awfolder);
        }
        Iterator it = this.mdmDesign.getMeasureFolderSet().iterator();
        while (it.hasNext()) {
            MeasureFolder mf = (MeasureFolder)it.next();
            if (mf.getParentFolder() != null) continue;
            this.addMeasureFolder(mf, null, true);
            MeasFolder mfolder = this.findMeasFolder(mf.getNameInOracleAW(), this.awMeasureFolders);
            if (mfolder == null) continue;
            this.awMeasureFolders.remove(mfolder);
        }
        for (MeasFolder mfolder : this.awMeasureFolders) {
            this.restoreMeasureFolder(mfolder, null);
        }
    }

    private MeasFolder findMeasFolder(String name, List list) {
        for (MeasFolder mf : list) {
            if (!mf.name.equalsIgnoreCase(name)) continue;
            return mf;
        }
        return null;
    }

    private void restoreMeasureFolder(MeasFolder measFolder, oracle.AWXML.MeasureFolder awparent) {
        oracle.AWXML.MeasureFolder awMeasureFolder = null;
        awMeasureFolder = awparent != null ? awparent.createMeasureFolder() : this.globalAW.createMeasureFolder();
        awMeasureFolder.Create(this.awConnection);
        awMeasureFolder.setName(measFolder.awfolder.getName());
        awMeasureFolder.setShortName(measFolder.awfolder.getShortName());
        awMeasureFolder.setLongName(measFolder.awfolder.getLongName());
        awMeasureFolder.setPluralName(measFolder.awfolder.getPluralName());
        for (String id : measFolder.measures) {
            Measure meas = (Measure)this.awmeasMap.get(id);
            if (meas == null) continue;
            awMeasureFolder.addMeasure(meas);
        }
        for (MeasFolder mf : measFolder.folders) {
            this.restoreMeasureFolder(mf, awMeasureFolder);
        }
    }

    private String getExportedXML() {
        Object expXML = "";
        for (Measure meas : this.exportedMeasures) {
            expXML = (String)expXML + meas.WriteToXML();
        }
        for (oracle.AWXML.MeasureFolder measf : this.exportedFolders) {
            expXML = (String)expXML + measf.WriteToXML();
        }
        return expXML;
    }

    private void closeConnection() {
        if (this.awConnection != null) {
            try {
                this.awConnection.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.awConnection = null;
        }
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.connection = null;
        }
    }

    class MeasFolder {
        String name = "";
        oracle.AWXML.MeasureFolder awfolder;
        List measures = new ArrayList();
        List folders = new ArrayList();

        MeasFolder(String name) {
            this.name = name;
        }
    }

    class MeasureDependence {
        oracle.dbtools.crest.model.design.multidimensional.Measure measure;
        List dependOn = new ArrayList();

        MeasureDependence(oracle.dbtools.crest.model.design.multidimensional.Measure measure) {
            this.measure = measure;
        }
    }

    private class CalcMeasuresRunner
    implements Runnable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            try {
                try {
                    OracleAWExporter.this.monitor = new ProgressDialog(OracleAWExporter.this.appView, "", 0, 100);
                    try {
                        if (OracleAWExporter.this.exportType.equals(EXPORT_ALL_CALC_MEASURES) || OracleAWExporter.this.exportType.equals(EXPORT_NEW_CALC_MEASURES)) {
                            OracleAWExporter.this.atached = false;
                            OracleAWExporter.this.monitor.setProgress(5);
                            OracleAWExporter.this.monitor.setNote(Messages.getString("OracleAWExporter.ReadDefinitions"));
                            boolean ok = OracleAWExporter.this.readAWDefinitions(OracleAWExporter.this.awConnection, OracleAWExporter.this.user, OracleAWExporter.this.awName);
                            if (ok) {
                                int result;
                                File xmlFile;
                                OracleAWExporter.this.dimMap = new TreeMap();
                                OracleAWExporter.this.hierMap = new TreeMap();
                                OracleAWExporter.this.monitor.setProgress(40);
                                OracleAWExporter.this.atached = true;
                                OracleAWExporter.this.monitor.setNote(Messages.getString("OracleAWExporter.ExportCalculatedMeasures"));
                                OracleAWExporter.this.exportCalcMeasures();
                                OracleAWExporter.this.commited = false;
                                OracleAWExporter.this.globalAW.Commit(OracleAWExporter.this.awConnection);
                                OracleAWExporter.this.commited = true;
                                ok = true;
                                if ("".equals(OracleAWExporter.this.fileName.trim())) {
                                    ok = false;
                                }
                                if (OracleAWExporter.this.fileName.indexOf(46) == -1) {
                                    OracleAWExporter.this.fileName = OracleAWExporter.this.fileName + ".xml";
                                }
                                if ((xmlFile = new File(OracleAWExporter.this.fileName)).exists() && (result = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), Messages.getString("OracleAWExporter.FileExists") + "\"" + xmlFile.getAbsolutePath() + "\" already exists.\nDo you want to overwrite it?", Messages.getString("OracleAWExporter.Warning"), 0, 3, OracleAWExporter.this.getConfiguration().getIcon("SAVE_ICON", 32))) == 1) {
                                    ok = false;
                                }
                                if (ok) {
                                    String XML = OracleAWExporter.this.getExportedXML();
                                    try {
                                        if (ok) {
                                            OracleAWExporter.this.monitor.setProgress(95);
                                            OracleAWExporter.this.monitor.setNote(Messages.getString("OracleAWExporter.WriteExportedMetadataToFile"));
                                            FileWriter xmlout = new FileWriter(xmlFile);
                                            xmlout.write(XML);
                                            xmlout.write("\n");
                                            xmlout.close();
                                            OracleAWExporter.this.monitor.setProgress(100);
                                            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), Messages.getString("OracleAWExporter.ExportedOk"));
                                        }
                                    }
                                    catch (Exception e) {
                                        String error = e.toString();
                                        LOGGER.error("Failure to write XML string to file: " + OracleAWExporter.this.fileName + "\n", e);
                                    }
                                }
                            }
                        }
                        OracleAWExporter.this.monitor.close();
                        if (OracleAWExporter.this.commited) return;
                    }
                    catch (Throwable throwable) {
                        OracleAWExporter.this.monitor.close();
                        if (OracleAWExporter.this.commited) throw throwable;
                        JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("OracleAWExporter.ErrorDuringExportToAnlyticalWorkspace"), OracleAWExporter.this.awName), Messages.getString("OracleAWExporter.Error"), 0);
                        throw throwable;
                    }
                    JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("OracleAWExporter.ErrorDuringExportToAnlyticalWorkspace"), OracleAWExporter.this.awName), Messages.getString("OracleAWExporter.Error"), 0);
                    return;
                }
                finally {
                    if (OracleAWExporter.this.atached && OracleAWExporter.this.globalAW != null) {
                        OracleAWExporter.this.globalAW.Detach(OracleAWExporter.this.awConnection);
                        OracleAWExporter.this.atached = false;
                    }
                }
            }
            catch (Exception e) {
                OracleAWExporter.this.err = e.toString();
                LOGGER.error("Error Generate Analytical Workspace: ", e);
                if (OracleAWExporter.this.atached && OracleAWExporter.this.globalAW != null) {
                    OracleAWExporter.this.globalAW.Detach(OracleAWExporter.this.awConnection);
                    OracleAWExporter.this.atached = false;
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        LogReport lr2 = new LogReport(OracleAWExporter.this.mdmDesign.getAppView());
                        lr2.setName("Error Log");
                        lr2.setLog(OracleAWExporter.this.err);
                        lr2.showDialog(new Dimension(750, 550));
                    }
                });
                return;
            }
            finally {
                OracleAWExporter.this.closeConnection();
                AW.setCurAW(null);
                System.gc();
            }
        }
    }

    private class Runner
    implements Runnable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            try {
                block37: {
                    OracleAWExporter.this.monitor = new ProgressDialog(OracleAWExporter.this.appView, "", 0, 100);
                    OracleAWExporter.this.monitor.setProgress(1);
                    OracleAWExporter.this.monitor.setNote(" ");
                    try {
                        int result;
                        File xmlFile;
                        if (!OracleAWExporter.this.exportType.equals(EXPORT_METADATA_TO_FILE)) break block37;
                        boolean ok = true;
                        if ("".equals(OracleAWExporter.this.fileName.trim())) {
                            OracleAWExporter.this.fileName = OracleAWExporter.this.awName.trim() + ".xml";
                        }
                        if (OracleAWExporter.this.fileName.indexOf(46) == -1) {
                            OracleAWExporter.this.fileName = OracleAWExporter.this.fileName + ".xml";
                        }
                        if ((xmlFile = new File(OracleAWExporter.this.fileName)).exists() && (result = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("OracleAWExporter.FileExists"), xmlFile.getAbsolutePath()), Messages.getString("OracleAWExporter.Warning"), 0, 3, OracleAWExporter.this.getConfiguration().getIcon("SAVE_ICON", 32))) == 1) {
                            ok = false;
                        }
                        if (!ok) break block37;
                        OracleAWExporter.this.dimMap = new TreeMap();
                        OracleAWExporter.this.hierMap = new TreeMap();
                        OracleAWExporter.this.globalAW = new AW();
                        OracleAWExporter.this.globalAW.setName(OracleAWExporter.this.awName);
                        OracleAWExporter.this.monitor.setProgress(5);
                        OracleAWExporter.this.monitor.setNote(Messages.getString("OracleAWExporter.BuildAnalyticWorkspace"));
                        OracleAWExporter.this.createAW();
                        String XML = OracleAWExporter.this.globalAW.WriteToXML();
                        try {
                            if (ok) {
                                OracleAWExporter.this.monitor.setProgress(55);
                                OracleAWExporter.this.monitor.setNote(Messages.getString("OracleAWExporter.WriteAWMetadataToFile"));
                                FileWriter xmlout = new FileWriter(xmlFile);
                                xmlout.write(XML);
                                xmlout.write("\n");
                                xmlout.close();
                            }
                        }
                        catch (Exception e) {
                            String error = e.toString();
                            LOGGER.error("Failure to write XML string to file: " + OracleAWExporter.this.fileName + "\n", e);
                        }
                        OracleAWExporter.this.monitor.close();
                        if (OracleAWExporter.this.commited || OracleAWExporter.this.exportType.equals(EXPORT_METADATA_TO_FILE)) return;
                    }
                    catch (Throwable throwable) {
                        OracleAWExporter.this.monitor.close();
                        if (OracleAWExporter.this.commited || OracleAWExporter.this.exportType.equals(EXPORT_METADATA_TO_FILE)) throw throwable;
                        JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("OracleAWExporter.ErrorCreatingAnlyticalWorkspace"), OracleAWExporter.this.awName), Messages.getString("OracleAWExporter.Error"), 0);
                        throw throwable;
                    }
                    JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("OracleAWExporter.ErrorCreatingAnlyticalWorkspace"), OracleAWExporter.this.awName), Messages.getString("OracleAWExporter.Error"), 0);
                    return;
                }
                OracleAWExporter.this.monitor.setProgress(5);
                OracleAWExporter.this.atached = false;
                OracleAWExporter.this.monitor.setNote(Messages.getString("OracleAWExporter.DeleteExistingAnalyticWorkspace"));
                OracleAWExporter.this.deleteExistingAW(OracleAWExporter.this.awConnection, OracleAWExporter.this.user, OracleAWExporter.this.awName);
                OracleAWExporter.this.monitor.setProgress(20);
                if (OracleAWExporter.this.atached) {
                    JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("OracleAWExporter.AnalyticWorkspaceAttached"), OracleAWExporter.this.user, OracleAWExporter.this.awName), Messages.getString("OracleAWExporter.Error"), 0);
                } else {
                    OracleAWExporter.this.dimMap = new TreeMap();
                    OracleAWExporter.this.hierMap = new TreeMap();
                    OracleAWExporter.this.globalAW = new AW();
                    OracleAWExporter.this.globalAW.setName(OracleAWExporter.this.awName);
                    try {
                        OracleAWExporter.this.monitor.setNote(Messages.getString("OracleAWExporter.BuildAnalyticWorkspace"));
                        OracleAWExporter.this.createAW();
                        String XML = OracleAWExporter.this.globalAW.WriteToXML();
                        try {
                            boolean ok = true;
                            if ("".equals(OracleAWExporter.this.fileName.trim())) {
                                ok = false;
                            }
                            File xmlFile = null;
                            if (ok) {
                                int result;
                                if (OracleAWExporter.this.fileName.indexOf(46) == -1) {
                                    OracleAWExporter.this.fileName = OracleAWExporter.this.fileName + ".xml";
                                }
                                if ((xmlFile = new File(OracleAWExporter.this.fileName)).exists() && (result = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), Messages.getString("OracleAWExporter.FileExists") + "\"" + xmlFile.getAbsolutePath() + "\" already exists.\nDo you want to overwrite it?", Messages.getString("OracleAWExporter.Warning"), 0, 3, OracleAWExporter.this.getConfiguration().getIcon("SAVE_ICON", 32))) == 1) {
                                    ok = false;
                                }
                            }
                            if (ok) {
                                FileWriter xmlout = new FileWriter(xmlFile);
                                xmlout.write(XML);
                                xmlout.write("\n");
                                xmlout.close();
                            }
                        }
                        catch (Exception e) {
                            String error = e.toString();
                            LOGGER.error("Failure to write XML string to file: " + OracleAWExporter.this.fileName + "\n", e);
                        }
                        if (OracleAWExporter.this.buildAW) {
                            OracleAWExporter.this.monitor.setProgress(25);
                        } else {
                            OracleAWExporter.this.monitor.setProgress(40);
                        }
                        OracleAWExporter.this.monitor.setNote(Messages.getString("OracleAWExporter.CreateAnalyticWorkspace"));
                        OracleAWExporter.this.atached = true;
                        OracleAWExporter.this.globalAW.Create(OracleAWExporter.this.awConnection);
                        if (OracleAWExporter.this.buildAW) {
                            OracleAWExporter.this.monitor.setProgress(50);
                        } else {
                            OracleAWExporter.this.monitor.setProgress(75);
                        }
                        OracleAWExporter.this.created = true;
                        OracleAWExporter.this.monitor.setNote(Messages.getString("OracleAWExporter.CommitAnalyticWorkspace"));
                        OracleAWExporter.this.globalAW.Commit(OracleAWExporter.this.awConnection);
                        OracleAWExporter.this.commited = true;
                        if (OracleAWExporter.this.buildAW) {
                            try {
                                OracleAWExporter.this.monitor.setProgress(70);
                                OracleAWExporter.this.monitor.setNote(Messages.getString("OracleAWExporter.PopulatingAalyticWorkspace"));
                                OracleAWExporter.this.xml_build_global_aw(OracleAWExporter.this.awName);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                    finally {
                        if (OracleAWExporter.this.created) {
                            OracleAWExporter.this.monitor.setProgress(95);
                            OracleAWExporter.this.monitor.setNote(Messages.getString("OracleAWExporter.DetachAnalyticWorkspace"));
                            OracleAWExporter.this.globalAW.Detach(OracleAWExporter.this.awConnection);
                            OracleAWExporter.this.atached = false;
                        }
                    }
                    OracleAWExporter.this.monitor.setProgress(100);
                    JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), Messages.getString("OracleAWExporter.ExportedOk"));
                }
                OracleAWExporter.this.monitor.close();
                if (OracleAWExporter.this.commited || OracleAWExporter.this.exportType.equals(EXPORT_METADATA_TO_FILE)) return;
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("OracleAWExporter.ErrorCreatingAnlyticalWorkspace"), OracleAWExporter.this.awName), Messages.getString("OracleAWExporter.Error"), 0);
                return;
            }
            catch (Exception e) {
                OracleAWExporter.this.err = e.toString();
                e.printStackTrace();
                LOGGER.error("Error Generate Analytical Workspace: ", e);
                if (OracleAWExporter.this.atached) {
                    OracleAWExporter.this.globalAW.Detach(OracleAWExporter.this.awConnection);
                    OracleAWExporter.this.atached = false;
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        LogReport lr2 = new LogReport(OracleAWExporter.this.mdmDesign.getAppView());
                        lr2.setName("Error Log");
                        lr2.setLog(OracleAWExporter.this.err);
                        lr2.showDialog(new Dimension(750, 550));
                    }
                });
                return;
            }
            finally {
                OracleAWExporter.this.closeConnection();
                AW.setCurAW(null);
                System.gc();
            }
        }
    }

    class MeasureDesc {
        Measure awmeasure;
        oracle.dbtools.crest.model.design.multidimensional.Measure measure;
        String awmeasureName;
        Slice.MeasureWrapper mwrapper;

        MeasureDesc() {
        }
    }

    class LevelDesc {
        oracle.dbtools.crest.model.design.multidimensional.Level level;
        oracle.dbtools.crest.model.design.multidimensional.Dimension dim;
        Level olevel;
        oracle.AWXML.Dimension odimension;
        Attribute attribute;

        LevelDesc() {
        }
    }
}

