/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.util.GUID;

public class RSFKeysDependantColumnsConstrsaint
extends RSGeneral {
    public static void export(Design design, Map map, Connection connection, FKIndexAssociation index) throws Exception {
        String query = "INSERT INTO DMRS_FK_CD_CONSTRAINTS (Fk_OVID, Constraint_OVID, Constraint_Name, Model_OVID, Design_OVID)VALUES (?, ?, ?, ?, ?)";
        PreparedStatement stmt = connection.prepareStatement(query);
        String queryC = "INSERT INTO DMRS_FK_CD_CONSTRAINTS_COLS (Constraint_OVID, Column_OVID, Depend_As_Mandatory, Depend, Model_OVID, Design_OVID)VALUES (?, ?, ?, ?, ?, ?)";
        PreparedStatement stmtC = connection.prepareStatement(queryC);
        if (!index.getColumnDependencyConstraintGenerateName().equals("") && index.getColumnDependencyConstraintGenerateName() != null) {
            String ovid = new GUID().toString();
            stmt.setString(1, (String)map.get(index.getObjectID()));
            stmt.setString(2, ovid);
            stmt.setString(3, index.getColumnDependencyConstraintGenerateName());
            stmt.setString(4, (String)map.get(index.getModelID()));
            stmt.setString(5, (String)map.get(design.getObjectID()));
            stmt.execute();
            ArrayList<Column> dependantColumnsList = new ArrayList<Column>();
            for (Column column : Arrays.asList(index.getTable().getElements())) {
                if (Arrays.asList(index.getColumns()).contains(column)) continue;
                dependantColumnsList.add(column);
            }
            for (Column c : dependantColumnsList) {
                if (c.getDependOnForeignKey() == null && !c.isDependOnFK_AsMandatory()) continue;
                stmtC.setString(1, ovid);
                stmtC.setString(2, (String)map.get(c.getObjectID()));
                stmtC.setString(3, c.isDependOnFK_AsMandatory() ? "Y" : "N");
                stmtC.setString(4, c.getDependOnForeignKey() != null ? "Y" : "N");
                stmtC.setString(5, (String)map.get(index.getModelID()));
                stmtC.setString(6, (String)map.get(design.getObjectID()));
                stmtC.execute();
            }
        }
        stmtC.close();
        stmtC = null;
        stmt.close();
        stmt = null;
    }
}

