/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.Map;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.model.NamingOptionsHolder;
import oracle.dbtools.crest.model.design.DesignPart;

public class RSModelNamingOptions
extends RSGeneral {
    public static void export(Map map, Connection connection, DesignPart dp, String modelOVID, String type) throws Exception {
        int count = 0;
        String query = "INSERT INTO DMRS_Model_Naming_Options (Object_type, Max_Name_Length, Character_Case, Valid_Characters, Model_ID, Model_OVID, Model_Name, Model_Type, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement stmt = connection.prepareStatement(query);
        for (NamingOptionsHolder holder : dp.getNamingOptionsHolderList()) {
            stmt.setString(1, holder.getClassName().getSimpleName());
            stmt.setInt(2, holder.getMaxNameLength());
            switch (holder.getCaseType()) {
                case 0: {
                    stmt.setString(3, "Upper Case");
                    break;
                }
                case 1: {
                    stmt.setString(3, "Lower Case");
                    break;
                }
                case 2: {
                    stmt.setString(3, "Mixed Case");
                }
            }
            if (holder.getIsValid() || holder.getValidChars() == null || "".equalsIgnoreCase(holder.getValidChars())) {
                stmt.setString(4, "All Valid");
            } else {
                stmt.setString(4, holder.getValidChars());
            }
            stmt.setString(5, dp.getObjectID());
            stmt.setString(6, modelOVID);
            stmt.setString(7, dp.getName());
            stmt.setString(8, type);
            stmt.setString(9, (String)map.get(dp.getDesign().getObjectID()));
            stmt.addBatch();
            if (++count != 1000) continue;
            count = 0;
            stmt.executeBatch();
        }
        if (count > 0) {
            count = 0;
            stmt.executeBatch();
        }
        stmt.close();
        stmt = null;
    }
}

