/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.extension;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.imports.metadata.DBMOConstants;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.imports.metadata.sqlserver.DBUserSqlServer;
import oracle.dbtools.crest.imports.metadata.sqlserver.MOHForeignKeySQLServer;
import oracle.dbtools.crest.imports.metadata.sqlserver.MOHProcedureSqlServer;
import oracle.dbtools.crest.imports.metadata.sqlserver.MOHTableSQLServer;
import oracle.dbtools.crest.imports.metadata.sqlserver.MOHUserSqlServer;
import oracle.dbtools.crest.imports.metadata.sqlserver.MOHViewSqlServer;
import oracle.dbtools.crest.imports.metadata.sqlserver.MOHandlerSqlServer;
import oracle.dbtools.crest.imports.metadata.sqlserver.v2k12.MOHSequenceSqlServerv2k12;
import oracle.dbtools.crest.imports.metadata.sqlserver.v2k12.MOHTableSQLServerv2k12;
import oracle.dbtools.crest.imports.metadata.sqlserver.v2k12.MOHUserSqlServerv2k12;
import oracle.dbtools.crest.imports.metadata.sqlserver.v2k5.MOHForeignKeySQLServerv2k5;
import oracle.dbtools.crest.imports.metadata.sqlserver.v2k5.MOHPartitionColumnSqlServerv2k5;
import oracle.dbtools.crest.imports.metadata.sqlserver.v2k5.MOHProcedureSqlServerv2k5;
import oracle.dbtools.crest.imports.metadata.sqlserver.v2k5.MOHTableSQLServerv2k5;
import oracle.dbtools.crest.imports.metadata.sqlserver.v2k5.MOHUserSqlServerv2k5;
import oracle.dbtools.crest.imports.metadata.sqlserver.v2k5.MOHViewSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k.StorageDesignSqlServerv2k;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k12.StorageDesignSqlServerv2k12;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.StorageDesignSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k8.StorageDesignSqlServerv2k8;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ProgressDialog;
import oracle.dbtools.crest.util.JDBCUtils;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class ExtractionHandlerSQLServer
extends AbstractDBMExtractionHandler
implements DBMOConstants {
    private static final String SQL_SERVER_V2K = "Microsoft SQL Server 2000";
    private static final String SQL_SERVER_V2K5 = "Microsoft SQL Server 2005";
    private static final String SQL_SERVER_V2K8 = "Microsoft SQL Server 2008";
    private static final String SQL_SERVER_V2K12 = "Microsoft SQL Server 2012";
    private List mohObjects = null;
    private List mohObjectsv2k5 = null;
    private List mohObjectsv2k12 = null;
    private ApplicationView view;
    private static final Logger LOGGER = new Logger(ExtractionHandlerSQLServer.class);

    public ExtractionHandlerSQLServer(ApplicationView view) {
        super(null);
        this.view = view;
    }

    @Override
    public void init(Connection connection) {
        try {
            DatabaseMetaData dbmd = connection.getMetaData();
            try {
                this.dbProductName = dbmd.getDatabaseProductName();
                this.dbProductVersion = dbmd.getDatabaseProductVersion();
                this.dbMajorVersion = this.getDatabaseMajorVersion(connection);
                this.dbMinorVersion = dbmd.getDatabaseMinorVersion();
            }
            catch (Throwable e) {
                LOGGER.error(e);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private int getDatabaseMajorVersion(Connection sqlConnection) throws Exception {
        int vers = 2;
        try {
            Statement statement = sqlConnection.createStatement();
            ResultSet rs = statement.executeQuery("SELECT @@VERSION");
            if (rs != null) {
                while (rs.next()) {
                    String version = rs.getString(1);
                    if (Token.hasString(version, SQL_SERVER_V2K)) {
                        vers = 0;
                        continue;
                    }
                    if (Token.hasString(version, SQL_SERVER_V2K5)) {
                        vers = 1;
                        continue;
                    }
                    if (Token.hasString(version, SQL_SERVER_V2K8)) {
                        vers = 2;
                        continue;
                    }
                    if (!Token.hasString(version, SQL_SERVER_V2K12)) continue;
                    vers = 3;
                }
            }
            if (statement != null) {
                statement.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error("ExtractionHandlerSQLServer.getDatabaseMajorVersion(): " + e.getMessage());
        }
        return vers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<DBObject> getUsers(String dbName, Connection conn) throws Exception {
        ArrayList<DBObject> list = new ArrayList<DBObject>();
        Statement statement = conn.createStatement();
        ResultSet rs = null;
        try {
            try {
                StringBuffer buffer = new StringBuffer();
                buffer.append("SELECT").append(' ');
                buffer.append("NAME").append(' ').append(',');
                buffer.append("UID").append(' ').append(',');
                buffer.append("sid").append(' ');
                buffer.append("FROM").append(' ');
                buffer.append(MOHandlerSqlServer.getFormattedName(dbName)).append(".dbo.sysusers").append(' ');
                buffer.append("WHERE").append(' ');
                buffer.append("sid").append(' ').append("IS").append(' ').append("NOT").append(' ').append("NULL");
                rs = statement.executeQuery(buffer.toString());
            }
            catch (SQLException e) {
                LOGGER.error("DBMExtractionHandlerSQLServer.getUsers(): " + e.getMessage());
            }
            if (rs != null) {
                while (rs.next()) {
                    String userName = rs.getString(1);
                    String uid = rs.getString(2);
                    String sid = "0x" + rs.getString(3);
                    String login = this.getLogin(sid, conn);
                    String user = login + " / " + userName;
                    if (login == null && !userName.equalsIgnoreCase("guest")) {
                        user = "BUILTIN\\Admin / " + userName;
                    }
                    DBUserSqlServer dboUser = new DBUserSqlServer(false, user, "Login / User");
                    dboUser.setUid(uid);
                    dboUser.setDb(dbName);
                    list.add(dboUser);
                }
            }
        }
        catch (Throwable throwable) {
            JDBCUtils.close(rs, statement);
            throw throwable;
        }
        JDBCUtils.close(rs, statement);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getLogin(String sid, Connection conn) throws Exception {
        String string;
        ResultSet resultSet = null;
        Statement statement = conn.createStatement();
        try {
            try {
                StringBuffer buffer = new StringBuffer();
                buffer.append("SELECT").append(' ');
                buffer.append("loginname").append(' ');
                buffer.append("FROM").append(' ');
                buffer.append("master.dbo.syslogins").append(' ');
                buffer.append("WHERE").append(' ');
                buffer.append("sid").append('=').append(sid);
                resultSet = statement.executeQuery(buffer.toString());
            }
            catch (SQLException e) {
                LOGGER.error("DBMExtractionHandlerSQLServer.getLogin(): " + e.getMessage());
            }
            String loginName = null;
            if (resultSet != null) {
                while (resultSet.next()) {
                    loginName = resultSet.getString(1);
                }
            }
            string = loginName;
        }
        catch (Throwable throwable) {
            JDBCUtils.close(resultSet, statement);
            throw throwable;
        }
        JDBCUtils.close(resultSet, statement);
        return string;
    }

    @Override
    public List getMOHObjects(Connection conn) {
        if (conn != null) {
            this.init(conn);
        }
        switch (this.dbMajorVersion) {
            case 0: {
                return this.getMOHObjectsv2k();
            }
            case 1: {
                return this.getMOHObjectsv2k5();
            }
            case 2: {
                return this.getMOHObjectsv2k8();
            }
            case 3: {
                return this.getMOHObjectsv2k12();
            }
        }
        return this.getMOHObjectsv2k8();
    }

    private List getMOHObjectsv2k5() {
        if (this.mohObjectsv2k5 == null) {
            this.mohObjectsv2k5 = new ArrayList();
            this.mohObjectsv2k5.add(new MOHUserSqlServerv2k5(this));
            this.mohObjectsv2k5.add(new MOHTableSQLServerv2k5(this));
            this.mohObjectsv2k5.add(new MOHForeignKeySQLServerv2k5(this));
            this.mohObjectsv2k5.add(new MOHPartitionColumnSqlServerv2k5(this));
            this.mohObjectsv2k5.add(new MOHViewSqlServerv2k5(this));
            this.mohObjectsv2k5.add(new MOHProcedureSqlServerv2k5(this));
        }
        return this.mohObjectsv2k5;
    }

    private List getMOHObjectsv2k8() {
        return this.getMOHObjectsv2k5();
    }

    private List getMOHObjectsv2k12() {
        if (this.mohObjectsv2k12 == null) {
            this.mohObjectsv2k12 = new ArrayList();
            this.mohObjectsv2k12.add(new MOHUserSqlServerv2k12(this));
            this.mohObjectsv2k12.add(new MOHTableSQLServerv2k12(this));
            this.mohObjectsv2k12.add(new MOHForeignKeySQLServerv2k5(this));
            this.mohObjectsv2k12.add(new MOHPartitionColumnSqlServerv2k5(this));
            this.mohObjectsv2k12.add(new MOHViewSqlServerv2k5(this));
            this.mohObjectsv2k12.add(new MOHProcedureSqlServerv2k5(this));
            this.mohObjectsv2k12.add(new MOHSequenceSqlServerv2k12(this));
        }
        return this.mohObjectsv2k12;
    }

    public List getMOHObjectsv2k() {
        if (this.mohObjects == null) {
            this.mohObjects = new ArrayList();
            this.mohObjects.add(new MOHUserSqlServer(this));
            this.mohObjects.add(new MOHTableSQLServer(this));
            this.mohObjects.add(new MOHForeignKeySQLServer(this));
            this.mohObjects.add(new MOHViewSqlServer(this));
            this.mohObjects.add(new MOHProcedureSqlServer(this));
        }
        return this.mohObjects;
    }

    @Override
    public RDBMSSite getRDBMSSite() {
        switch (this.dbMajorVersion) {
            case 0: {
                return this.view.getCurrentDesign().getRDBMSSiteSet().get(StorageDesignSqlServerv2k.RDBMS_TYPE);
            }
            case 1: {
                return this.view.getCurrentDesign().getRDBMSSiteSet().get(StorageDesignSqlServerv2k5.RDBMS_TYPE);
            }
            case 2: {
                return this.view.getCurrentDesign().getRDBMSSiteSet().get(StorageDesignSqlServerv2k8.RDBMS_TYPE);
            }
            case 3: {
                return this.view.getCurrentDesign().getRDBMSSiteSet().get(StorageDesignSqlServerv2k12.RDBMS_TYPE);
            }
        }
        return this.view.getCurrentDesign().getRDBMSSiteSet().get(StorageDesignSqlServerv2k8.RDBMS_TYPE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generateDesign(Connection conn, List selectedObjects, ImportLogger importLog, ProgressDialog monitor) throws Exception {
        List mhoList = this.getMOHObjects(conn);
        if (this.storageDesign == null) {
            this.storageDesign = this.view.getCurrentDesign().getRelationalDesign().getStorageDesign();
        }
        if (selectedObjects.size() > 0 && mhoList.size() > 0 && conn != null && !this.isNullStorageDesign(this.storageDesign)) {
            try {
                double step = 10.0;
                int size = mhoList.size();
                for (AbstractMOHandler moHandler : mhoList) {
                    moHandler.generate(conn, selectedObjects, importLog);
                    moHandler.clearHandledObjects(selectedObjects);
                    monitor.setProgress((int)(step += 75.0 / (double)size));
                }
                for (AbstractMOHandler moHandler : mhoList) {
                    moHandler.postGenerateProcessing(conn);
                }
            }
            catch (Exception e) {
                importLog.addError(e.getMessage());
            }
        }
    }
}

