/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.vcs.svn.commands;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JOptionPane;
import oracle.dbtools.crest.fcp.DataModelerAddin;
import oracle.dbtools.crest.fcp.Messages;
import oracle.dbtools.crest.fcp.vcs.VersioningTreeNode;
import oracle.dbtools.crest.fcp.vcs.svn.SVNChangeListWindow;
import oracle.dbtools.crest.fcp.vcs.svn.SVNClientHelper;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.util.Extension;
import oracle.ide.controller.IdeAction;
import oracle.jdeveloper.vcs.generic.VCSActionInfo;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.generic.VCSProfiles;
import oracle.jdevimpl.vcs.svn.op.SVNOperationRevert;

public class SVNRevertCommand
extends SVNOperationRevert {
    public static final String COMMAND_ID = Extension.isDataModeler() ? "oracle.jdeveloper.subversion.revert" : SVNRevertCommand.class.getName();
    private static final IdeAction ACTION = DataModelerAddin.overrideAction("oracle.jdeveloper.subversion.revert", SVNRevertCommand.class.getName());
    private static final SVNClientHelper SVN_CLIENT_HELPER = SVNClientHelper.getInstance();

    public SVNRevertCommand() {
        super(COMMAND_ID);
        this.setProfile(VCSProfiles.getInstance().getProfile("oracle.jdeveloper.subversion"));
    }

    public static IdeAction getAction() {
        return ACTION;
    }

    protected VCSActionInfo getActionInfo() {
        return this.getProfile().getActionInfo("oracle.jdeveloper.subversion.revert");
    }

    public boolean isAvailableImpl() {
        return SVN_CLIENT_HELPER.actionsEnabled(SVNChangeListWindow.getSVNOutgoingChangesChangeList(), null, false, true, false, false, true, true, false, false);
    }

    protected int doitImpl(VCSProfile vcsProfile) throws Exception {
        int reply;
        ArrayList<VersioningTreeNode> treeNodesForRefreshing = new ArrayList<VersioningTreeNode>();
        List<File> filePaths = this.collectFilePaths(treeNodesForRefreshing);
        filePaths = this.getOrderredFiles(treeNodesForRefreshing);
        if (!filePaths.isEmpty() && (reply = JOptionPane.showConfirmDialog(null, Messages.getString("SVNRevertCommand.DiscardChanges"), Messages.getString("SVNRevertCommand.Warning"), 0)) == 0) {
            SVN_CLIENT_HELPER.doRevert(filePaths.toArray(new File[0]), true);
            VersioningTreeNode.refresh(treeNodesForRefreshing, true);
            SVNChangeListWindow.getSVNOutgoingChangesChangeList().refresh();
        }
        return 0;
    }

    private List<File> getOrderredFiles(List<VersioningTreeNode> nodes) {
        ArrayList<File> deleted = new ArrayList<File>();
        ArrayList<File> newItems = new ArrayList<File>();
        ArrayList<File> res = new ArrayList<File>();
        for (VersioningTreeNode node : nodes) {
            if (node.getStorableObjectStatus().getTextStatus().equalsIgnoreCase("A")) {
                newItems.add(node.getFilePath());
                if (node.getObjectClass() != RelationalDesign.class && (node.getObjectClass() == null || !node.getObjectClass().isAssignableFrom(StorageDesign.class)) || node.getDependantFilePath() == null) continue;
                newItems.add(node.getDependantFilePath());
                continue;
            }
            deleted.add(node.getFilePath());
            if (node.getObjectClass() != RelationalDesign.class && (node.getObjectClass() == null || !node.getObjectClass().isAssignableFrom(StorageDesign.class)) || node.getDependantFilePath() == null) continue;
            deleted.add(node.getDependantFilePath());
        }
        Collections.sort(deleted);
        Collections.sort(newItems);
        Collections.reverse(newItems);
        res.addAll(newItems);
        res.addAll(deleted);
        return res;
    }

    protected List<File> collectFilePaths(List<VersioningTreeNode> treeNodesForRefreshing) {
        return SVNChangeListWindow.getSVNOutgoingChangesChangeList().getPanel().getSelectedFilePaths(treeNodesForRefreshing, false, true);
    }
}

