/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.db2;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.db2.AUXTableDB2;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.BufferPoolDB2;
import oracle.dbtools.crest.model.design.storage.db2.DataBaseDB2;
import oracle.dbtools.crest.model.design.storage.db2.Owner;
import oracle.dbtools.crest.model.design.storage.db2.OwnerSet;
import oracle.dbtools.crest.model.design.storage.db2.PermissionsDB2;
import oracle.dbtools.crest.model.design.storage.db2.PrivilegesDB2;
import oracle.dbtools.crest.model.design.storage.db2.StorageGroupDB2;
import oracle.dbtools.crest.model.design.storage.db2.StoredProcedureDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableProxySetDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableSpaceDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableViewProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableViewProxySetDB2;

public class SHGrant
extends DDLStatementHandler {
    private PermissionsDB2 permissions;
    private AbstractStorageDesignDB2 storageDesign;
    private TableProxyDB2 table = null;
    private TableViewProxyDB2 view = null;
    private AUXTableDB2 auxTable = null;

    public SHGrant(Design design) {
        super(design);
    }

    @Override
    public void handle(String line) {
        String statement = SHGrant.clearCR(line);
        if (Token.startsWithString(statement, "grant execute on procedure")) {
            try {
                this.parseGrantExecuteOnProcedure(statement.replaceAll("\"", ""));
                this.importLog.incrementImportedStatements();
            }
            catch (Exception e) {
                this.importLog.addFailedStatement(SHGrant.FormatCR(line, "\n"));
            }
        } else if (Token.startsWithString(statement, "grant use of")) {
            try {
                this.parseGrantUseOf(statement.replaceAll("\"", ""));
                this.importLog.incrementImportedStatements();
            }
            catch (Exception e) {
                this.importLog.addFailedStatement(SHGrant.FormatCR(line, "\n"));
            }
        } else if (Token.startsWithString(statement, "grant") && statement.toUpperCase().indexOf("ON DATABASE") > -1) {
            try {
                this.parseGrantDatabase(statement.replaceAll("\"", ""));
                this.importLog.incrementImportedStatements();
                this.importLog.addFailedStatement(statement);
            }
            catch (Exception e) {
                this.importLog.addFailedStatement(SHGrant.FormatCR(line, "\n"));
            }
        } else if (Token.startsWithString(statement, "grant") && (Token.hasToken(statement, "ARCHIVE") || Token.hasToken(statement, "BINDADD") || Token.hasToken(statement, "BINDAGENT") || Token.hasToken(statement, "BSDS") || Token.hasToken(statement, "CREATEALIAS") || Token.hasToken(statement, "CREATEDBA") || Token.hasToken(statement, "CREATEDBC") || Token.hasToken(statement, "CREATEMTAB") || Token.hasToken(statement, "CREATESG") || Token.hasToken(statement, "DISPLAY") || Token.hasToken(statement, "MONITOR1") || Token.hasToken(statement, "MONITOR2") || Token.hasToken(statement, "RECOVER") || Token.hasToken(statement, "STOPALL") || Token.hasToken(statement, "STOSPACE") || Token.hasToken(statement, "SYSADMIN") || Token.hasToken(statement, "SYSCTRL") || Token.hasToken(statement, "SYSOPR") || Token.hasToken(statement, "TRACE"))) {
            try {
                this.parseSystemPrivileges(statement);
                this.importLog.incrementImportedStatements();
            }
            catch (Exception e) {
                this.importLog.addFailedStatement(SHGrant.FormatCR(line, "\n"));
            }
        } else if (Token.startsWithString(statement, "grant") && Token.hasToken(statement, "ON") && Token.hasToken(statement, "TO")) {
            try {
                this.grantPermissions(statement);
                this.importLog.incrementImportedStatements();
            }
            catch (Exception e) {
                this.importLog.addFailedStatement(SHGrant.FormatCR(line, "\n"));
            }
        } else {
            this.nextHandler(line);
        }
    }

    private void parseGrantUseOf(String statement) {
        block18: {
            String object;
            AbstractStorageDesignDB2 storageDesign;
            block20: {
                block19: {
                    block17: {
                        RDBMSSite site = this.design.getSelectedRDBMSSite();
                        storageDesign = (AbstractStorageDesignDB2)this.design.getStorageDesign(site);
                        object = Token.getTokenAfter(statement, "OF");
                        if (!object.equalsIgnoreCase("BUFFERPOOL")) break block17;
                        String bp = Token.getStringAfterToken(statement, "BUFFERPOOL");
                        bp = Token.getStringBeforeToken(bp, "TO");
                        String users = Token.getStringAfterToken(statement, "TO");
                        boolean grantOption = false;
                        if (Token.hasToken(users, "GRANT")) {
                            users = Token.getStringBeforeToken(users, "WITH");
                            grantOption = true;
                        }
                        StringTokenizer tokenizer = new StringTokenizer(bp, ",");
                        while (tokenizer.hasMoreTokens()) {
                            BufferPoolDB2 bufferPool = (BufferPoolDB2)storageDesign.getBufferPoolSet().getByName(tokenizer.nextToken().trim());
                            StringTokenizer usersTokenizer = new StringTokenizer(users, ",");
                            while (usersTokenizer.hasMoreTokens()) {
                                String user = usersTokenizer.nextToken().trim();
                                if (storageDesign.getOwnerSet().getByName(user) == null) {
                                    Owner owner = (Owner)storageDesign.getOwnerSet().createElement(null);
                                    owner.setName(user);
                                    this.design.getRelationalDesign().stampModelObjectDDL(owner);
                                }
                                bufferPool.setUsers(user);
                            }
                            if (!grantOption) continue;
                            bufferPool.setGrantOption("YES");
                        }
                        break block18;
                    }
                    if (!object.equalsIgnoreCase("ALL")) break block19;
                    String users = Token.getStringAfterToken(statement, "TO");
                    boolean grantOption = false;
                    if (Token.hasToken(users, "GRANT")) {
                        users = Token.getStringBeforeToken(users, "WITH");
                        grantOption = true;
                    }
                    for (BufferPoolDB2 bp : storageDesign.getBufferPoolSet()) {
                        StringTokenizer usersTokenizer = new StringTokenizer(users, ",");
                        while (usersTokenizer.hasMoreTokens()) {
                            String user = usersTokenizer.nextToken().trim();
                            if (storageDesign.getOwnerSet().getByName(user) == null) {
                                Owner owner = (Owner)storageDesign.getOwnerSet().createElement(null);
                                owner.setName(user);
                                this.design.getRelationalDesign().stampModelObjectDDL(owner);
                            }
                            bp.setUsers(user);
                        }
                        if (grantOption) {
                            bp.setGrantOption("YES");
                        }
                        bp.setAllBufferpools("YES");
                    }
                    break block18;
                }
                if (!object.equalsIgnoreCase("STOGROUP")) break block20;
                String stogroup = Token.getStringAfterToken(statement, "STOGROUP");
                stogroup = Token.getStringBeforeToken(stogroup, "TO");
                String users = Token.getStringAfterToken(statement, "TO");
                boolean grantOption = false;
                if (Token.hasToken(users, "GRANT")) {
                    users = Token.getStringBeforeToken(users, "WITH");
                    grantOption = true;
                }
                StringTokenizer tokenizer = new StringTokenizer(stogroup, ",");
                while (tokenizer.hasMoreTokens()) {
                    StorageGroupDB2 group = storageDesign.getStorageGroupSet().getOrCreateStorageGroup(tokenizer.nextToken().trim());
                    StringTokenizer usersTokenizer = new StringTokenizer(users, ",");
                    while (usersTokenizer.hasMoreTokens()) {
                        String user = usersTokenizer.nextToken().trim();
                        Owner owner = (Owner)storageDesign.getOwnerSet().getByName(user);
                        if (owner == null) {
                            owner = (Owner)storageDesign.getOwnerSet().createElement(null);
                            owner.setName(user);
                            this.design.getRelationalDesign().stampModelObjectDDL(owner);
                        }
                        group.setUsers(owner.getName());
                    }
                    if (!grantOption) continue;
                    group.setGrantOption("YES");
                }
                break block18;
            }
            if (!object.equalsIgnoreCase("TABLESPACE")) break block18;
            String ts = Token.getStringAfterToken(statement, "TABLESPACE");
            ts = Token.getStringBeforeToken(ts, "TO");
            String users = Token.getStringAfterToken(statement, "TO");
            boolean grantOption = false;
            if (Token.hasToken(users, "GRANT")) {
                users = Token.getStringBeforeToken(users, "WITH");
                grantOption = true;
            }
            StringTokenizer tokenizer = new StringTokenizer(ts, ",");
            while (tokenizer.hasMoreTokens()) {
                String t = tokenizer.nextToken().trim();
                TableSpaceDB2 tablespace = (TableSpaceDB2)storageDesign.getTableSpaceSet().getByName(t);
                StringTokenizer usersTokenizer = new StringTokenizer(users, ",");
                while (usersTokenizer.hasMoreTokens()) {
                    String user = usersTokenizer.nextToken().trim();
                    if (storageDesign.getOwnerSet().getByName(user) == null) {
                        Owner owner = (Owner)storageDesign.getOwnerSet().createElement(null);
                        owner.setName(user);
                        this.design.getRelationalDesign().stampModelObjectDDL(owner);
                    }
                    tablespace.setUsers(user);
                }
                if (!grantOption) continue;
                tablespace.setGrantOption("YES");
            }
        }
    }

    private void parseGrantExecuteOnProcedure(String statement) {
        String procedures = Token.getStringAfterToken(statement, "PROCEDURE");
        procedures = Token.getStringBeforeToken(procedures, "TO");
        String users = Token.getStringAfterToken(statement, "TO");
        boolean grantOption = false;
        if (Token.hasToken(users, "GRANT")) {
            users = Token.getStringBeforeToken(users, "WITH");
            grantOption = true;
        }
        RDBMSSite site = this.design.getSelectedRDBMSSite();
        AbstractStorageDesignDB2 storageDesign = (AbstractStorageDesignDB2)this.design.getStorageDesign(site);
        StringTokenizer tokenizer = new StringTokenizer(procedures, ",");
        while (tokenizer.hasMoreTokens()) {
            StoredProcedureDB2 proc = (StoredProcedureDB2)storageDesign.getStoredProcedureSet().getByName(tokenizer.nextToken().trim());
            StringTokenizer usersTokenizer = new StringTokenizer(users, ",");
            while (usersTokenizer.hasMoreTokens()) {
                String user = usersTokenizer.nextToken().trim();
                if (storageDesign.getOwnerSet().getByName(user) == null) {
                    Owner owner = (Owner)storageDesign.getOwnerSet().createElement(null);
                    owner.setName(user);
                    this.design.getRelationalDesign().stampModelObjectDDL(owner);
                }
                proc.setUsers(user);
            }
            if (!grantOption) continue;
            proc.setGrantOption("YES");
        }
    }

    private void parseGrantDatabase(String statement) {
        String privileges = Token.getStringAfterToken(statement, "GRANT");
        privileges = Token.getStringBeforeToken(privileges, "ON");
        String db = Token.getStringAfterToken(statement, "DATABASE");
        db = Token.getStringBeforeToken(db, "TO");
        String users = Token.getStringAfterToken(statement, "TO");
        boolean grantOption = false;
        if (Token.hasToken(users, "GRANT")) {
            users = Token.getStringBeforeToken(users, "WITH");
            grantOption = true;
        }
        RDBMSSite site = this.design.getSelectedRDBMSSite();
        AbstractStorageDesignDB2 storageDesign = (AbstractStorageDesignDB2)this.design.getStorageDesign(site);
        StringTokenizer tokenizer = new StringTokenizer(db, ",");
        while (tokenizer.hasMoreTokens()) {
            String dbName = tokenizer.nextToken();
            DataBaseDB2 database = (DataBaseDB2)storageDesign.getDataBaseSet().getByName(dbName);
            StringTokenizer usersTokenizer = new StringTokenizer(users, ",");
            while (usersTokenizer.hasMoreTokens()) {
                Owner owner;
                String user = usersTokenizer.nextToken().trim();
                PrivilegesDB2 priv = this.getPrivileges(database, user);
                if (storageDesign.getOwnerSet().getByName(user) == null) {
                    owner = (Owner)storageDesign.getOwnerSet().createElement(null);
                    owner.setName(user);
                    this.design.getRelationalDesign().stampModelObjectDDL(owner);
                } else {
                    owner = (Owner)storageDesign.getOwnerSet().getByName(user);
                }
                priv.setUser(owner);
                StringTokenizer privTokenizer = new StringTokenizer(privileges, ",");
                while (privTokenizer.hasMoreTokens()) {
                    priv.setSystemPrivileges(privTokenizer.nextToken().trim());
                }
                if (!grantOption) continue;
                priv.setGrantOption("YES");
            }
        }
    }

    private void parseSystemPrivileges(String statement) {
        String privileges = Token.getStringAfterToken(statement, "GRANT");
        privileges = Token.getStringBeforeToken(privileges, "TO");
        String users = Token.getStringAfterToken(statement, "TO");
        boolean grantOption = false;
        if (Token.hasToken(users, "GRANT")) {
            users = Token.getStringBeforeToken(users, "WITH");
            grantOption = true;
        }
        RDBMSSite site = this.design.getSelectedRDBMSSite();
        AbstractStorageDesignDB2 storageDesign = (AbstractStorageDesignDB2)this.design.getStorageDesign(site);
        StringTokenizer usersTokenizer = new StringTokenizer(users, ",");
        while (usersTokenizer.hasMoreTokens()) {
            Owner owner;
            String user = usersTokenizer.nextToken().trim();
            if (storageDesign.getOwnerSet().getByName(user) == null) {
                owner = (Owner)storageDesign.getOwnerSet().createElement(null);
                owner.setName(user);
                this.design.getRelationalDesign().stampModelObjectDDL(owner);
            } else {
                owner = (Owner)storageDesign.getOwnerSet().getByName(user);
            }
            StringTokenizer tokenizer = new StringTokenizer(privileges, ",");
            while (tokenizer.hasMoreTokens()) {
                owner.setSystemPrivileges(tokenizer.nextToken().trim());
            }
            if (!grantOption) continue;
            owner.setGrantOption("YES");
        }
    }

    private PrivilegesDB2 getPrivileges(DataBaseDB2 db, Object user) {
        PrivilegesDB2 priv2;
        RDBMSSite site = this.design.getSelectedRDBMSSite();
        AbstractStorageDesignDB2 storageDesign = (AbstractStorageDesignDB2)this.design.getStorageDesign(site);
        for (PrivilegesDB2 priv2 : storageDesign.getPrivilegesSet()) {
            if (priv2.getDb() != db || priv2.getUser() != user) continue;
            return priv2;
        }
        priv2 = storageDesign.getPrivilegesSet().createPriv();
        priv2.setDb(db);
        return priv2;
    }

    private void grantPermissions(String statement) {
        this.statement = statement.replaceAll("\"", "");
        RDBMSSite site = this.design.getSelectedRDBMSSite();
        this.storageDesign = (AbstractStorageDesignDB2)this.design.getStorageDesign(site);
        if (this.storageDesign != null) {
            ArrayList users = this.initUsers();
            StorageObject proxy = this.initOn();
            if (proxy != null) {
                for (int i = 0; i < users.size(); ++i) {
                    this.permissions = this.getPermissionForUser((StorageObject)users.get(i), proxy) != null ? this.getPermissionForUser((StorageObject)users.get(i), proxy) : this.storageDesign.getPermissionsSet().createPermissions();
                    if (this.permissions == null) continue;
                    this.initPrivileges();
                    this.initOnObject(proxy);
                    this.initTo(users.get(i));
                }
            }
        }
    }

    private PermissionsDB2 getPermissionForUser(StorageObject user, StorageObject proxy) {
        Iterator it = this.storageDesign.getPermissionsSet().iterator();
        PermissionsDB2 perm = null;
        while (it.hasNext()) {
            perm = (PermissionsDB2)it.next();
            if (perm.getUser() != user || perm.getTable() != proxy && perm.getView() != proxy && perm.getAuxTable() != proxy) continue;
            return perm;
        }
        return null;
    }

    private ArrayList initUsers() {
        ArrayList<Owner> list = new ArrayList<Owner>();
        String to = Token.getStringAfter(this.statement, "TO").trim();
        if (Token.hasToken(to, "WITH")) {
            to = Token.getStringBeforeToken(to, "WITH");
        }
        if (!to.equalsIgnoreCase("")) {
            StringTokenizer tokenizer = new StringTokenizer(to, ",");
            String user = null;
            while (tokenizer.hasMoreTokens()) {
                Owner owner;
                user = tokenizer.nextToken().trim();
                OwnerSet users = this.storageDesign.getOwnerSet();
                if (users.getByName(user) == null) {
                    owner = (Owner)this.storageDesign.getOwnerSet().createElement(null);
                    owner.setName(user);
                    this.design.getRelationalDesign().stampModelObjectDDL(owner);
                } else {
                    owner = (Owner)users.getByName(user);
                }
                list.add(owner);
            }
        }
        return list;
    }

    private void initPrivileges() {
        StringTokenizer tokenizer;
        String priv = Token.getStringAfter(this.statement.toUpperCase(), "GRANT").trim();
        if (Token.hasCloseAndOpenBrackets(priv = Token.getStringBeforeToken(priv, "ON"))) {
            String columns = Token.getValBetweenBrackets(priv).trim();
            priv = Token.getStringBefore(priv, "(").trim();
            this.initColumns(columns, priv);
        }
        if (this.statement.toUpperCase().indexOf("WITH GRANT OPTION") > -1) {
            tokenizer = new StringTokenizer(priv, ",");
            String pr = null;
            while (tokenizer.hasMoreTokens()) {
                pr = tokenizer.nextToken().trim();
                this.permissions.setPrivilegesWithGrantOption(pr);
            }
        } else {
            tokenizer = new StringTokenizer(priv, ",");
            String pr = null;
            while (tokenizer.hasMoreTokens()) {
                pr = tokenizer.nextToken().trim();
                this.permissions.setPrivileges(pr);
            }
        }
    }

    private void initColumns(String columns, String priv) {
        StringTokenizer tokenizer = new StringTokenizer(columns, ",");
        Object column = null;
        while (tokenizer.hasMoreTokens()) {
            column = tokenizer.nextToken().trim();
            if (((String)column).equalsIgnoreCase("") || this.table == null || this.table.getColumn((String)column) == null) continue;
            column = (String)column + ", " + priv;
            this.permissions.setColumnList((String)column);
        }
    }

    private StorageObject initOn() {
        String on = Token.getStringAfterToken(this.statement, "ON").trim();
        if (on.toUpperCase().startsWith("TABLE")) {
            on = Token.cutFirstToken(on);
        }
        if ((on = Token.getStringBeforeToken(on, "TO")).indexOf(46) > -1) {
            on = on.substring(on.indexOf(46) + 1);
        }
        if (!(on = Token.getValBetweenSquareBrackets(on)).equalsIgnoreCase("")) {
            this.table = ((TableProxySetDB2)this.storageDesign.getTableProxySet()).getByName(on);
            if (this.table != null) {
                return this.table;
            }
            this.view = ((TableViewProxySetDB2)this.storageDesign.getTableViewProxySet()).getByName(on);
            if (this.view != null) {
                return this.view;
            }
            this.auxTable = (AUXTableDB2)this.storageDesign.getAUXTableSet().getByName(on);
            if (this.auxTable != null) {
                return this.auxTable;
            }
        }
        this.importLog.addError("Error in setting object of permission " + this.statement);
        return null;
    }

    private void initOnObject(StorageObject proxy) {
        if (proxy instanceof TableProxyDB2) {
            this.permissions.setTable((TableProxyDB2)proxy);
        } else if (proxy instanceof TableViewProxyDB2) {
            this.permissions.setView((TableViewProxyDB2)proxy);
        } else if (proxy instanceof AUXTableDB2) {
            this.permissions.setAuxTable((AUXTableDB2)proxy);
        }
    }

    private void initTo(Object object) {
        String to = Token.getStringAfter(this.statement.toUpperCase(), "TO").trim();
        if (Token.hasToken(to, "WITH")) {
            to = Token.getStringBeforeToken(to, "WITH");
        }
        if (!to.equalsIgnoreCase("")) {
            if (object instanceof Owner) {
                this.permissions.setUser((Owner)object);
            }
        } else {
            this.importLog.addError("Error in setting TO objects of permission " + this.statement);
        }
    }
}

