/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.oracle;

import java.sql.PreparedStatement;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.imports.metadata.oracle.MOHPlSqlStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.FunctionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHFunctionOracle
extends MOHPlSqlStorageObjectOracle<FunctionOracle> {
    public static final String OBJECT_TYPE = "FUNCTION";
    private static final Logger LOGGER = new Logger(MOHFunctionOracle.class);

    public MOHFunctionOracle(AbstractDBMExtractionHandler dbmeHandler) {
        super(dbmeHandler);
    }

    public MOHFunctionOracle(AbstractDBMExtractionHandler dbmeHandler, boolean dbaUser) {
        super(dbmeHandler, dbaUser);
    }

    @Override
    public Logger getLogger() {
        return LOGGER;
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    protected FunctionOracle generate(PreparedStatement statement, DBObject dbObject, ImportLogger importLog) throws Exception {
        FunctionOracle functionOracle = (FunctionOracle)super.generate(statement, dbObject, importLog);
        if (functionOracle != null) {
            this.stampModelObject(functionOracle, dbObject);
        }
        return functionOracle;
    }

    @Override
    public FunctionOracle generateObject(StorageDesignOracle storageDesignOracle, DBObject dbObject, String source) {
        FunctionOracle functionOracle = (FunctionOracle)storageDesignOracle.getFunctionSet().createElement(null);
        UserOracle user = (UserOracle)storageDesignOracle.getUserSet().getByName(dbObject.getSchema());
        functionOracle.setOwner(user);
        functionOracle.setName(dbObject.getName());
        functionOracle.setSource("CREATE OR REPLACE " + source);
        this.stampModelObject(functionOracle, dbObject);
        return functionOracle;
    }
}

