/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.udb.v81;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.imports.MappingDatatypeNameLogicalDataType;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.imports.metadata.MOHTable;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.datatype.StandardDatatypeNames;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.constraint.CheckConstraint;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraint;
import oracle.dbtools.crest.model.design.datatypes.DistinctType;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.RDBMSType;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StructuredTypeProxy;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.Trigger;
import oracle.dbtools.crest.model.design.storage.udb.ColumnProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.StorageObjectConstantsUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.TriggerUDB;
import oracle.dbtools.crest.model.design.storage.udb.v81.ColumnProxyUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.IndexProxyUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.SchemaUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.StorageDesignUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.TableCheckConstraintProxyUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.TableProxyUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.TableSpaceUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.TriggerUDBv81;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHTableUDBv81
extends MOHTable {
    private static final Logger LOGGER = new Logger(MOHTableUDBv81.class);
    private Map scopedColumns;

    public MOHTableUDBv81(AbstractDBMExtractionHandler dbmeHandler) {
        super(dbmeHandler);
    }

    @Override
    public List extract(Connection sqlConnection, List schemas) throws Exception {
        ArrayList<DBObject> list = new ArrayList<DBObject>();
        for (DBObject dboNext : schemas) {
            if (!dboNext.isSelected()) continue;
            Statement statement = sqlConnection.createStatement();
            ResultSet rs = null;
            try {
                StringBuffer buffer = new StringBuffer();
                buffer.append("SELECT TABNAME from SYSCAT.TABLES t").append(' ');
                buffer.append("WHERE TYPE = 'T' and TABSCHEMA = '");
                buffer.append(dboNext.getName()).append("'");
                buffer.append(" AND NOT EXISTS ");
                buffer.append("(SELECT 1 FROM SYSCAT.VIEWS v ");
                buffer.append("WHERE ");
                buffer.append("v.VIEWNAME = t.TABNAME ");
                buffer.append("AND v.VIEWSCHEMA = t.TABSCHEMA)");
                rs = statement.executeQuery(buffer.toString());
            }
            catch (SQLException e) {
                LOGGER.error("MOHTableUDBv81.extract(): ", e);
            }
            if (rs != null) {
                while (rs.next()) {
                    String tablename = rs.getString(1);
                    DBObject dboTable = new DBObject(AbstractDBMExtractionHandler.isAllSelected(), tablename, "TABLE", dboNext.getName());
                    list.add(dboTable);
                }
                rs.close();
            }
            statement.close();
        }
        return list;
    }

    @Override
    public void generate(Connection sqlConnection, List selectedObjects, ImportLogger importLog) throws Exception {
        this.scopedColumns = new TreeMap();
        for (int i = 0; i < selectedObjects.size(); ++i) {
            DBObject dbo = (DBObject)selectedObjects.get(i);
            if (!"TABLE".equalsIgnoreCase(dbo.getType())) continue;
            Statement statement = sqlConnection.createStatement();
            ResultSet rs = null;
            try {
                StringBuffer buffer = new StringBuffer();
                buffer.append("SELECT").append(' ');
                buffer.append("TABSCHEMA").append(',');
                buffer.append("TABNAME").append(',');
                buffer.append("DEFINER").append(',');
                buffer.append("TYPE").append(',');
                buffer.append("ROWTYPESCHEMA").append(',');
                buffer.append("ROWTYPENAME").append(',');
                buffer.append("TABLEID").append(',');
                buffer.append("KEYINDEXID").append(',');
                buffer.append("TBSPACE").append(',');
                buffer.append("INDEX_TBSPACE").append(',');
                buffer.append("LONG_TBSPACE").append(',');
                buffer.append("PARTITION_MODE").append(',');
                buffer.append("DATACAPTURE").append(',');
                buffer.append("LOG_ATTRIBUTE").append(',');
                buffer.append("REMARKS").append(',');
                buffer.append("REFRESH").append(',');
                buffer.append("COMPRESSION").append(',');
                buffer.append("CLUSTERED").append(' ');
                buffer.append("FROM").append(' ');
                buffer.append("SYSCAT").append('.').append("TABLES").append(' ').append("t ");
                buffer.append("WHERE").append(' ');
                buffer.append("TABSCHEMA").append('=').append('\'');
                buffer.append(dbo.getSchema()).append('\'').append(' ');
                buffer.append("AND").append(' ');
                buffer.append("TABNAME").append('=').append('\'');
                buffer.append(dbo.getName()).append('\'').append(' ');
                buffer.append("AND").append(' ');
                buffer.append("TYPE").append('=').append('\'');
                buffer.append("T").append('\'').append(' ');
                buffer.append("AND").append(' ');
                buffer.append("NOT").append(' ').append("EXISTS");
                buffer.append('(').append("SELECT").append(' ').append("1").append(' ');
                buffer.append("FROM").append(' ');
                buffer.append("SYSCAT").append('.').append("VIEWS").append(' ').append("v ");
                buffer.append("WHERE").append(' ');
                buffer.append("v").append('.').append("VIEWNAME").append('=');
                buffer.append("t").append('.').append("TABNAME").append(' ');
                buffer.append("AND").append(' ');
                buffer.append("v").append('.').append("VIEWSCHEMA").append('=');
                buffer.append("t").append('.').append("TABSCHEMA").append(')');
                rs = statement.executeQuery(buffer.toString());
            }
            catch (SQLException e) {
                LOGGER.error("MOHTableUDBv81.generate():", e);
            }
            Table table = null;
            TableProxyUDBv81 tableProxy = null;
            StorageDesign storageDesign = null;
            if (rs != null) {
                if (rs.next()) {
                    table = this.getRelationalDesign().createTable();
                    table.setSchema(dbo.getSchema());
                    table.setName(dbo.getName());
                    this.stampModelObject(table, dbo);
                    String tbspace = rs.getString("TBSPACE");
                    String schemaname = rs.getString("TABSCHEMA");
                    String indextspacename = rs.getString("INDEX_TBSPACE");
                    String longtspacename = rs.getString("LONG_TBSPACE");
                    TableSpaceUDBv81 ts = null;
                    TableSpaceUDBv81 indextspace = null;
                    TableSpaceUDBv81 longtspace = null;
                    SchemaUDBv81 schema = null;
                    storageDesign = this.getStorageDesign();
                    if (storageDesign != null && storageDesign instanceof StorageDesignUDBv81) {
                        tableProxy = (TableProxyUDBv81)((StorageDesignUDBv81)storageDesign).getTableProxySet().getProxy(table.getObjectID());
                        if (tableProxy != null) {
                            tableProxy.setName(dbo.getName());
                            ts = this.getTableSpace(storageDesign, tbspace);
                            if (ts != null) {
                                tableProxy.setTableSpace(ts);
                            }
                            if ((indextspace = this.getTableSpace(storageDesign, indextspacename)) != null) {
                                tableProxy.setIndexInTableSpace(indextspace);
                            }
                            if ((longtspace = this.getTableSpace(storageDesign, longtspacename)) != null) {
                                tableProxy.setLongInTableSpace(longtspace);
                            }
                            if ((schema = (SchemaUDBv81)((StorageDesignUDBv81)storageDesign).getSchemaSet().getByName(schemaname.trim())) != null) {
                                tableProxy.setSchema(schema);
                                tableProxy.setOwner(schema.getOwner());
                            }
                            this.initTriggers(sqlConnection, tableProxy);
                            this.setProperties(tableProxy, (StorageDesignUDBv81)storageDesign, rs);
                        } else {
                            LOGGER.error("Unable to find TableProxy for table ID: " + table.getObjectID());
                        }
                    } else {
                        LOGGER.error("Unable to find Storage Design!");
                    }
                    this.initColumns(sqlConnection, tableProxy, dbo);
                    this.initColumnConstraints(sqlConnection, table, schemaname);
                    this.initTableConstraints(sqlConnection, table, schemaname);
                    this.initUniqueConstraints(sqlConnection, table, schemaname);
                    this.initIndexes(sqlConnection, table, schemaname);
                    this.initDimensions(sqlConnection, tableProxy, dbo);
                }
                rs.close();
            }
            statement.close();
            importLog.incrementImportedStatements();
            this.addToHandledObjects(dbo);
        }
    }

    private void initDimensions(Connection sqlConnection, TableProxyUDBv81 tableProxy, DBObject dbo) throws SQLException {
        Statement statement = sqlConnection.createStatement();
        ResultSet rs = null;
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT tabschema,tabname,colname,dimension,colseq ");
            buffer.append("from sysibm.syscoluse ");
            buffer.append("where tabname = '").append(tableProxy.getName()).append("'");
            buffer.append(" and tabschema = '").append(dbo.getSchema()).append("'");
            buffer.append(" order by dimension,colseq ");
            rs = statement.executeQuery(buffer.toString());
        }
        catch (SQLException e) {
            LOGGER.error("MOHTableUDBv81.initDimensions():", e);
        }
        if (rs != null) {
            ArrayList<DimObject> list = new ArrayList<DimObject>();
            while (rs.next()) {
                String colname = rs.getString(3);
                int dimensionId = rs.getInt(4);
                DimObject dimObj = new DimObject(colname, dimensionId);
                list.add(dimObj);
            }
            rs.close();
            if (!list.isEmpty()) {
                String dimString = this.getDimString(list);
                tableProxy.setDimensions(dimString);
            }
        }
        statement.close();
    }

    private String getDimString(List list) {
        StringBuffer buffer = new StringBuffer();
        DimObject dbobj = (DimObject)list.get(list.size() - 1);
        buffer.append(dbobj.getColName());
        DimObject prevObj = dbobj;
        boolean openBracket = false;
        boolean closeBracket = false;
        for (int i = list.size() - 2; i > -1; --i) {
            DimObject currObj = (DimObject)list.get(i);
            if (prevObj.getDimensionId() == currObj.getDimensionId()) {
                if (!closeBracket) {
                    buffer.append(")");
                    closeBracket = true;
                }
                if (!openBracket) {
                    int index = buffer.lastIndexOf(",");
                    buffer.insert(index + 1, "(" + currObj.getColName() + ",");
                    openBracket = true;
                    continue;
                }
                int ind = buffer.lastIndexOf("(");
                buffer.insert(ind + 1, currObj.getColName() + ",");
                continue;
            }
            openBracket = false;
            closeBracket = false;
            buffer.append("," + currObj.getColName());
            prevObj = currObj;
        }
        return buffer.toString();
    }

    protected TableSpaceUDBv81 getTableSpace(StorageDesign storageDesign, String tbspace) {
        if (tbspace != null && !tbspace.equalsIgnoreCase("")) {
            TableSpaceUDBv81 ts = (TableSpaceUDBv81)((StorageDesignUDBv81)storageDesign).getTableSpaceSet().getByName(tbspace);
            return ts;
        }
        return null;
    }

    protected void setProperties(TableProxyUDBv81 tableProxy, StorageDesignUDBv81 storageDesign, ResultSet rs) throws SQLException {
        String partiotion_mode = rs.getString("PARTITION_MODE");
        String comment = rs.getString("REMARKS");
        String logged = rs.getString("LOG_ATTRIBUTE");
        String datacapture = rs.getString("DATACAPTURE");
        String compression = rs.getString("COMPRESSION");
        if ("H".equalsIgnoreCase(partiotion_mode)) {
            tableProxy.setPartKeyHashing(true);
        }
        if ("1".equalsIgnoreCase(logged)) {
            tableProxy.setInitialLogging(false);
        }
        if (!"N".equalsIgnoreCase(datacapture)) {
            tableProxy.setDataCapture(TableProxyUDB.getAvailableDataCaptureValues()[1]);
        }
        if ("Y".equalsIgnoreCase(compression)) {
            tableProxy.setValueCompression(StorageObjectConstantsUDB.YES_NO[0]);
        }
        if (comment != null && !"".equalsIgnoreCase(comment)) {
            tableProxy.setCommentInRDBMS(comment);
            tableProxy.setCommentInRDBMSChanged(true);
        }
    }

    protected void initColumns(Connection sqlConnection, TableProxyUDBv81 tableProxy, DBObject dbo) throws Exception {
        Statement statement = sqlConnection.createStatement();
        ResultSet rs = null;
        int ind = 0;
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT").append(' ');
            buffer.append("TABSCHEMA").append(',');
            buffer.append("TABNAME").append(',');
            buffer.append("COLNAME").append(',');
            buffer.append("COLNO").append(',');
            buffer.append("TYPESCHEMA").append(',');
            buffer.append("TYPENAME").append(',');
            buffer.append("LENGTH").append(',');
            buffer.append("scale").append(',');
            buffer.append("DEFAULT").append(',');
            buffer.append("NULLS").append(',');
            buffer.append("LOGGED").append(',');
            buffer.append("COMPACT").append(',');
            buffer.append("CODEPAGE").append(',');
            buffer.append("TARGET_TYPESCHEMA").append(',');
            buffer.append("TARGET_TYPENAME").append(',');
            buffer.append("SCOPE_TABSCHEMA").append(',');
            buffer.append("SCOPE_TABNAME").append(',');
            buffer.append("IDENTITY").append(',');
            buffer.append("GENERATED").append(',');
            buffer.append("TEXT").append(',');
            buffer.append("REMARKS").append(',');
            buffer.append("SPECIAL_PROPS").append(',');
            buffer.append("DL_FEATURES").append(',');
            buffer.append("PARTKEYSEQ").append(',');
            buffer.append("COMPRESS").append(' ');
            buffer.append("FROM").append(' ');
            buffer.append("SYSCAT").append('.').append("COLUMNS").append(' ');
            buffer.append("WHERE").append(' ');
            buffer.append("TABSCHEMA").append('=');
            buffer.append('\'').append(dbo.getSchema()).append('\'');
            buffer.append("AND").append(' ');
            buffer.append("TABNAME").append('=');
            buffer.append('\'').append(dbo.getName()).append('\'');
            buffer.append("ORDER BY").append(' ').append("COLNO");
            rs = statement.executeQuery(buffer.toString());
        }
        catch (SQLException e) {
            LOGGER.error("MOHTableUDBv81.initColumns():", e);
        }
        Table table = (Table)tableProxy.getObject();
        if (rs != null) {
            while (rs.next()) {
                StorageDesignUDBv81 storage;
                ColumnProxyUDBv81 columnProxy;
                String colName = rs.getString("COLNAME");
                String colDatatype = rs.getString("TYPENAME");
                int colSize = rs.getInt("LENGTH");
                int colScale = rs.getInt("scale");
                Integer partkeyseq = (Integer)rs.getObject("PARTKEYSEQ");
                String allowNull = rs.getString("NULLS");
                String colDefault = rs.getString("DEFAULT");
                String logged = rs.getString("LOGGED");
                String compact = rs.getString("COMPACT");
                String identity = rs.getString("IDENTITY");
                String generated = rs.getString("GENERATED");
                String remarks = rs.getString("REMARKS");
                String compress = rs.getString("COMPRESS");
                String dlOptions = rs.getString("DL_FEATURES");
                String targetTypeSchema = rs.getString("TARGET_TYPESCHEMA");
                String targetTypeName = rs.getString("TARGET_TYPENAME");
                String scopeTabSchemaName = rs.getString("SCOPE_TABSCHEMA");
                String scopeTableName = rs.getString("SCOPE_TABNAME");
                Column column = null;
                if (ind == 0 && table.isBST()) {
                    Column oid = (Column)table.getOidElement();
                    if (oid != null) {
                        oid.setName(colName);
                    }
                    ++ind;
                    continue;
                }
                column = (Column)table.getElementByName(colName);
                if (column == null) {
                    column = table.createColumn(colName);
                    this.stampModelObject((ModelObject)column, table.getName(), colName);
                    if ("REFERENCE".equalsIgnoreCase(colDatatype)) {
                        StructuredType st;
                        column.setReference(true);
                        StructuredTypeProxy stp = this.getStorageDesign().getStructuredTypeProxySet().getBySchemaAndName(targetTypeSchema, targetTypeName);
                        if (stp == null) {
                            stp = this.getStorageDesign().getStructuredTypeProxySet().getByName(targetTypeName);
                        }
                        if ((st = stp != null ? stp.getStructuredType() : (StructuredType)this.getDesign().getDataTypesDesign().getStructuredTypeSet().getByName(targetTypeName)) != null) {
                            column.setUse((short)3);
                            column.setStructuredType(st);
                        } else {
                            DistinctType ct = (DistinctType)this.getDesign().getDataTypesDesign().getCollectionTypeSet().getByName(colDatatype);
                            if (ct != null) {
                                column.setUse((short)2);
                                column.setDistinctType(ct);
                            }
                        }
                        ScoppedNames sn = new ScoppedNames();
                        sn.schema = scopeTabSchemaName;
                        sn.name = scopeTableName;
                        this.scopedColumns.put(column.getObjectID(), sn);
                    } else {
                        String usedDatatype = StandardDatatypeNames.getUsedDatatypeName(colDatatype);
                        LogicalDatatype logDatatype = MappingDatatypeNameLogicalDataType.getLogicalDatatype(this.getStorageDesign().getRDBMSType(), usedDatatype);
                        if (logDatatype == null) {
                            logDatatype = this.getDesign().getLogicalDatatypeSet().getLogTypeByNativeType(colDatatype, this.getDbmeHandler().getRDBMSSite().getType().getName());
                        }
                        if (logDatatype != null && !"UNKNOWN".equalsIgnoreCase(usedDatatype)) {
                            column.setUse((short)1);
                            column.setLogicalDatatype(logDatatype);
                            if (colDatatype.startsWith("CHAR") || colDatatype.startsWith("VAR")) {
                                column.setDataTypeSize(String.valueOf(colSize));
                            } else if (colDatatype.startsWith("DEC") || colDatatype.startsWith("NUM")) {
                                column.setDataTypePrecision(String.valueOf(colSize));
                                column.setDataTypeScale(String.valueOf(colScale));
                            } else if (colDatatype.startsWith("FLOAT")) {
                                column.setDataTypePrecision(String.valueOf(colSize));
                            }
                        } else {
                            StructuredType st = (StructuredType)this.getDesign().getDataTypesDesign().getStructuredTypeSet().getByName(colDatatype);
                            if (st != null) {
                                column.setUse((short)3);
                                column.setStructuredType(st);
                            } else {
                                DistinctType ct = (DistinctType)this.getDesign().getDataTypesDesign().getCollectionTypeSet().getByName(colDatatype);
                                if (ct != null) {
                                    column.setUse((short)2);
                                    column.setDistinctType(ct);
                                }
                            }
                        }
                        if ("Y".equalsIgnoreCase(allowNull)) {
                            column.setNullsAllowed(true);
                        } else {
                            column.setNullsAllowed(false);
                        }
                        if (colDefault != null) {
                            column.setDefaultValue(colDefault);
                        }
                        if (partkeyseq != null && partkeyseq > 0) {
                            tableProxy.setPartitioningKey(column.getName());
                        }
                    }
                }
                ++ind;
                StorageDesign storageDesign = this.getStorageDesign();
                if (storageDesign == null || !(storageDesign instanceof StorageDesignUDBv81) || (columnProxy = (ColumnProxyUDBv81)(storage = (StorageDesignUDBv81)storageDesign).getColumnProxySet().getProxy(column.getObjectID())) == null) continue;
                if ("Y".equalsIgnoreCase(logged)) {
                    columnProxy.setLogging("LOGGED");
                }
                if ("Y".equalsIgnoreCase(compact)) {
                    columnProxy.setCompact(ColumnProxyUDB.getCompactChoices()[0]);
                }
                if ("Y".equalsIgnoreCase(identity)) {
                    columnProxy.setUseIdentity(true);
                    column.setIdentityColumn(true);
                    column.setAutoIncrementColumn(true);
                    this.initIdentityColumn(sqlConnection, table, columnProxy);
                    if ("D".equalsIgnoreCase(generated)) {
                        columnProxy.setGenerate(ColumnProxyUDB.getGenerateValues()[1]);
                    }
                }
                if ("S".equalsIgnoreCase(compress)) {
                    columnProxy.setCompressSystemDefault("YES");
                }
                if (dlOptions != null && dlOptions.equals("")) {
                    this.initDatalinkOptions(columnProxy, dlOptions);
                }
                columnProxy.setCommentInRDBMS(remarks);
                columnProxy.setCommentInRDBMSChanged(true);
            }
            rs.close();
        }
        statement.close();
    }

    private void initIdentityColumn(Connection sqlConnection, Table table, ColumnProxyUDBv81 columnProxy) throws Exception {
        Statement statement = sqlConnection.createStatement();
        ResultSet rs = null;
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT").append(' ');
            buffer.append("s").append('.').append("INCREMENT").append(',');
            buffer.append("s").append('.').append("START").append(',');
            buffer.append("s").append('.').append("MAXVALUE").append(',');
            buffer.append("s").append('.').append("MINVALUE").append(',');
            buffer.append("s").append('.').append("CYCLE").append(',');
            buffer.append("s").append('.').append("CACHE").append(',');
            buffer.append("s").append('.').append("ORDER").append(' ');
            buffer.append("FROM").append(' ');
            buffer.append("sysibm.SYSSEQUENCES s").append(',');
            buffer.append("sysibm.SYSDEPENDENCIES d").append(' ');
            buffer.append("WHERE").append(' ');
            buffer.append("d").append('.').append("dschema");
            buffer.append('=').append('\'').append(table.getSchema()).append('\'');
            buffer.append(' ').append("AND").append(' ');
            buffer.append("d").append('.').append("dname");
            buffer.append('=').append('\'').append(table.getName()).append('\'');
            buffer.append(' ').append("AND").append(' ');
            buffer.append("s").append('.').append("seqtype ");
            buffer.append('=').append('\'').append("I").append('\'');
            buffer.append(' ').append("AND").append(' ');
            buffer.append("s").append('.').append("seqschema");
            buffer.append('=').append("d.bschema");
            buffer.append(' ').append("AND").append(' ');
            buffer.append("s").append('.').append("seqname");
            buffer.append('=').append("d.bname");
            rs = statement.executeQuery(buffer.toString());
        }
        catch (Exception e) {
            LOGGER.error("MOHTableUDBv81.initIdentityColumn():", e);
        }
        if (rs != null) {
            if (rs.next()) {
                int increment = rs.getInt(1);
                String start = rs.getString(2);
                String maxvalue = rs.getString(3);
                String minvalue = rs.getString(4);
                String cycle = rs.getString(5);
                int cache = rs.getInt(6);
                String order = rs.getString(7);
                Column col = columnProxy.getColumn();
                columnProxy.setIncrementBy(increment);
                col.setAutoIncrementIncrementBy(increment);
                columnProxy.setStartWith(start);
                col.setAutoIncrementStartWith(start);
                columnProxy.setMaxValue(String.valueOf(maxvalue));
                col.setAutoIncrementMaxValue(maxvalue);
                columnProxy.setMinValue(String.valueOf(minvalue));
                col.setAutoIncrementMinValue(minvalue);
                columnProxy.setCycle(cycle);
                boolean cyc = false;
                try {
                    cyc = Boolean.valueOf(cycle);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                col.setAutoIncrementCycle(cyc);
                columnProxy.setCache(String.valueOf(cache));
                col.setAutoIncrementCache(cache);
                columnProxy.setOrder(order);
                boolean ord = false;
                try {
                    ord = Boolean.valueOf(order);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                col.setAutoIncrementOrder(ord);
            }
            rs.close();
        }
        statement.close();
    }

    protected void initColumnConstraints(Connection sqlConnection, Table table, String shemaName) throws Exception {
        Statement statement = sqlConnection.createStatement();
        ResultSet rs = null;
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("select a.constname,a.definition, b.enforced, b.enablequeryopt,d.colname ");
            buffer.append("from (select c.constname,c.text definition,c.tabschema,c.tabname ");
            buffer.append("from syscat.CHECKS c where c.tabschema = '");
            buffer.append(shemaName.trim()).append("' and ");
            buffer.append("c.tabname = '");
            buffer.append(table.getName()).append("' and c.type = 'C' and 1 = (select count(*) ");
            buffer.append("from syscat.COLCHECKS ch where c.constname = ch.constname and ");
            buffer.append("c.tabschema = ch.tabschema and c.tabname = ch.tabname))a, syscat.TABCONST b, syscat.colchecks d ");
            buffer.append("where a.tabname = b.tabname and a.tabschema = b.tabschema and a.constname = b.constname and ");
            buffer.append("a.tabname = d.tabname and a.tabschema = d.tabschema and a.constname = d.constname ");
            rs = statement.executeQuery(buffer.toString());
        }
        catch (SQLException e) {
            LOGGER.error("MOHTableUDBv81.initColumnConstraints():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                String constrName = rs.getString(1);
                String definition = rs.getString(2);
                String enforced = rs.getString(3);
                String enablequeryopt = rs.getString(4);
                String colName = rs.getString(5);
                CheckConstraint constraint = new CheckConstraint();
                constraint.setDesign(table.getDesign());
                constraint.setName(constrName);
                RDBMSType rdbmsType = StorageDesignUDBv81.RDBMS_TYPE;
                if (this.getStorageDesign() != null) {
                    rdbmsType = this.getStorageDesign().getRDBMSType();
                }
                constraint.add(rdbmsType, definition);
                Column col = (Column)table.getElementByName(colName);
                if (col == null) continue;
                col.setUseDomainConstraints(false);
                col.setCheck(constraint);
                StorageDesign storageDesign = this.getStorageDesign();
                if (storageDesign == null || !(storageDesign instanceof StorageDesignUDBv81)) continue;
                StorageDesignUDBv81 storage = (StorageDesignUDBv81)storageDesign;
                ColumnProxyUDBv81 columnProxy = (ColumnProxyUDBv81)storage.getColumnProxySet().getProxy(col.getObjectID());
                if ("N".equalsIgnoreCase(enforced)) {
                    columnProxy.setValidation("NOT ENFORCED");
                }
                if (!"N".equalsIgnoreCase(enablequeryopt)) continue;
                columnProxy.setQueryOptimization("DISABLE");
            }
            rs.close();
        }
        statement.close();
    }

    protected void initTableConstraints(Connection sqlConnection, Table table, String schemaName) throws Exception {
        Statement statement = sqlConnection.createStatement();
        ResultSet rs = null;
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("select a.constname,a.definition, b.enforced, b.enablequeryopt ");
            buffer.append("from (select c.constname,c.text definition,c.tabschema,c.tabname ");
            buffer.append("from syscat.CHECKS c where ");
            buffer.append("c.tabschema =  '");
            buffer.append(schemaName.trim()).append("' and ");
            buffer.append("c.tabname = '");
            buffer.append(table.getName()).append("' and ");
            buffer.append(" c.type = 'C' and ");
            buffer.append("1<( ");
            buffer.append("select count(*) ");
            buffer.append("from syscat.COLCHECKS ch  ");
            buffer.append("where ");
            buffer.append("c.constname = ch.constname and ");
            buffer.append("c.tabschema = ch.tabschema and ");
            buffer.append("c.tabname = ch.tabname)) a, syscat.TABCONST b ");
            buffer.append("where ");
            buffer.append("a.tabname = b.tabname and ");
            buffer.append("a.tabschema = b.tabschema and ");
            buffer.append("a.constname = b.constname ");
            rs = statement.executeQuery(buffer.toString());
        }
        catch (SQLException e) {
            LOGGER.error("MOHTableUDBv81.initTableConstraints:", e);
        }
        if (rs != null) {
            while (rs.next()) {
                StorageDesignUDBv81 storage;
                TableCheckConstraintProxyUDBv81 tcc;
                String constrName = rs.getString(1);
                String definition = rs.getString(2);
                String enforced = rs.getString(3);
                String enablequeryopt = rs.getString(4);
                TableLevelConstraint constraint = table.createCheckConstraint(constrName, definition);
                this.stampModelObject((ModelObject)constraint, schemaName.trim(), constrName);
                table.addCheckConstraint(constraint);
                StorageDesign storageDesign = this.getStorageDesign();
                if (storageDesign == null || !(storageDesign instanceof StorageDesignUDBv81) || (tcc = (TableCheckConstraintProxyUDBv81)(storage = (StorageDesignUDBv81)storageDesign).getTableCheckConstraintSet().getByName(constrName)) == null) continue;
                if ("N".equalsIgnoreCase(enforced)) {
                    tcc.setValidation("NOT ENFORCED");
                }
                if (!"N".equalsIgnoreCase(enablequeryopt)) continue;
                tcc.setQueryOptimization("DISABLE");
            }
            rs.close();
        }
        statement.close();
    }

    protected void initUniqueConstraints(Connection sqlConnection, Table table, String ownerName) throws Exception {
        Statement statement = sqlConnection.createStatement();
        ResultSet rs = null;
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT  constname,type, enforced, ");
            buffer.append("enablequeryopt, remarks comment ");
            buffer.append("FROM  syscat.TABCONST ");
            buffer.append("WHERE tabschema  = '");
            buffer.append(ownerName.trim()).append("'");
            buffer.append(" AND tabname  = '");
            buffer.append(table.getName()).append("'");
            buffer.append(" AND type in ('P','U')");
            rs = statement.executeQuery(buffer.toString());
        }
        catch (SQLException e) {
            LOGGER.error("MOHTableUDBv81.initUniqueConstraints():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                String constrName = rs.getString(1);
                String type = rs.getString(2);
                Index index = table.createIndex();
                index.setContainerObject(table);
                index.setName(constrName);
                this.stampModelObject((ModelObject)index, ownerName.trim(), constrName);
                this.initKeyColumns(sqlConnection, index, constrName, table);
                if ("U".equalsIgnoreCase(type)) {
                    index.setIndexState("Unique Constraint");
                    continue;
                }
                if ("P".equalsIgnoreCase(type) && !table.isBST()) {
                    index.setIndexState("Primary Constraint");
                    continue;
                }
                if (!"P".equalsIgnoreCase(type) || !table.isBST()) continue;
                if (index.getElementsCollection().size() > 0) {
                    table.getOidPKColumns().addAll(index.getElementsCollection());
                    table.setOidIsPK(true);
                }
                index.remove();
                index = (Index)table.getPK();
                index.setName(constrName);
            }
            rs.close();
        }
        statement.close();
    }

    private void initKeyColumns(Connection sqlConnection, Index index, String indName, Table table) throws Exception {
        Statement statement = sqlConnection.createStatement();
        ResultSet rs = null;
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT COLNAME, COLSEQ ");
            buffer.append("from syscat.keycoluse ");
            buffer.append("WHERE tabschema  = '");
            buffer.append(table.getSchema()).append("'");
            buffer.append(" AND tabname = '");
            buffer.append(table.getName()).append("' and ");
            buffer.append("constname = '").append(index.getName());
            buffer.append("' order by colseq");
            rs = statement.executeQuery(buffer.toString());
        }
        catch (SQLException e) {
            LOGGER.error("MOHTableUDBv81.initKeyColumns():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                String colName = rs.getString(1);
                Column col = (Column)table.getElementByName(colName);
                if (col == null) continue;
                index.add(col);
            }
            rs.close();
        }
        statement.close();
    }

    protected void initIndexes(Connection sqlConnection, Table table, String ownerName) throws Exception {
        Statement statement = sqlConnection.createStatement();
        ResultSet rs = null;
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT  indname,indschema,colnames, uniquerule, ");
            buffer.append("colcount,unique_colcount,indextype, ");
            buffer.append("pctfree,minpctused,reverse_scans,remarks comment ");
            buffer.append("from syscat.indexes  ");
            buffer.append("WHERE  tabname  =  '");
            buffer.append(table.getName()).append("'");
            buffer.append(" AND tabschema  = '");
            buffer.append(ownerName.trim()).append("'");
            buffer.append(" AND entrytype <>'H' ");
            rs = statement.executeQuery(buffer.toString());
        }
        catch (SQLException e) {
            LOGGER.error("MOHTableUDBv81.initIndexes():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                StorageDesignUDBv81 storage;
                String name = rs.getString(1);
                String schemaName = rs.getString(2);
                String type = rs.getString(4);
                String indexTyue = rs.getString(7);
                int pctfree = rs.getInt(8);
                int minpctused = rs.getInt(9);
                String reverseScan = rs.getString(10);
                String remark = rs.getString(11);
                if (!"CLUS".equalsIgnoreCase(indexTyue) && !"REG".equalsIgnoreCase(indexTyue)) continue;
                Index index = table.createIndex();
                index.setName(name);
                index.setCommentInRDBMS(remark);
                this.stampModelObject((ModelObject)index, ownerName.trim(), name);
                if ("U".equalsIgnoreCase(type)) {
                    index.setIndexState("Unique Plain Index");
                } else if ("P".equalsIgnoreCase(type) && !table.isBST()) {
                    index.setIndexState("Unique Plain Index");
                } else if ("P".equalsIgnoreCase(type) && table.isBST()) {
                    if (index.getElementsCollection().size() > 0) {
                        table.getOidPKColumns().addAll(index.getElementsCollection());
                        table.setOidIsPK(true);
                    }
                    index.remove();
                    index = (Index)table.getPK();
                    index.setName(name);
                }
                IndexProxyUDBv81 indexProxy = null;
                SchemaUDBv81 schema = null;
                StorageDesign storageDesign = this.getStorageDesign();
                if (storageDesign == null || !(storageDesign instanceof StorageDesignUDBv81) || (indexProxy = (IndexProxyUDBv81)(storage = (StorageDesignUDBv81)storageDesign).getIndexProxySet().getObjectGeneratedBy(index)) == null) continue;
                schema = (SchemaUDBv81)storage.getSchemaSet().getByName(schemaName);
                if (schema != null) {
                    indexProxy.setSchema(schema);
                    indexProxy.setOwner(schema.getOwner());
                }
                indexProxy.setPercentageFree(pctfree);
                indexProxy.setMinimumPercentageUsed(minpctused);
                if ("CLUS".equalsIgnoreCase(indexTyue)) {
                    indexProxy.setCluster(true);
                }
                if ("Y".equalsIgnoreCase(reverseScan)) {
                    indexProxy.setReverseScanSupport(true);
                }
                this.initIndexPrivileges(sqlConnection, indexProxy);
                this.initIndexColumns(sqlConnection, indexProxy, name, table);
            }
            rs.close();
        }
        statement.close();
    }

    private void initIndexPrivileges(Connection sqlConnection, IndexProxyUDBv81 indexProxy) throws Exception {
        Statement statement = sqlConnection.createStatement();
        ResultSet rs = null;
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT grantee,granteetype,controlauth ");
            buffer.append("from syscat.indexauth ");
            buffer.append("WHERE INDNAME = '");
            buffer.append(indexProxy.getName()).append("'");
            buffer.append(" AND INDSCHEMA = '");
            buffer.append(indexProxy.getSchema()).append("'");
            rs = statement.executeQuery(buffer.toString());
        }
        catch (SQLException e) {
            LOGGER.error("MOHTableUDBv81.initIndexColumns():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                String grantee = rs.getString(1);
                String type = rs.getString(2);
                String controlauth = rs.getString(3);
                if (!"Y".equalsIgnoreCase(controlauth)) continue;
                if ("U".equalsIgnoreCase(type)) {
                    indexProxy.setUsers(grantee.trim());
                    continue;
                }
                indexProxy.setGroups(grantee.trim());
            }
            rs.close();
        }
        statement.close();
    }

    private void initIndexColumns(Connection sqlConnection, IndexProxyUDBv81 indexProxy, String indName, Table table) throws Exception {
        Statement statement = sqlConnection.createStatement();
        ResultSet rs = null;
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT colname, colseq, colorder ");
            buffer.append("from syscat.INDEXCOLUSE ");
            buffer.append("WHERE INDNAME = '");
            buffer.append(indName).append("'");
            buffer.append(" AND INDSCHEMA = '");
            buffer.append(table.getSchema()).append("'");
            buffer.append(" ORDER BY COLSEQ ");
            rs = statement.executeQuery(buffer.toString());
        }
        catch (SQLException e) {
            LOGGER.error("MOHTableUDBv81.initIndexColumns():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                String colName = rs.getString(1);
                String order = rs.getString(2);
                Column col = (Column)table.getElementByName(colName);
                Index index = indexProxy.getIndex();
                if (col == null) continue;
                index.add(col);
                if ("A".equals(order)) {
                    index.setColumnSortOrder(col, "ASC");
                } else {
                    index.setColumnSortOrder(col, "DESC");
                }
                indexProxy.setColumnList(col.getName());
            }
            rs.close();
        }
        statement.close();
    }

    protected void initTriggers(Connection sqlConnection, TableProxyUDBv81 tableProxy) throws Exception {
        Statement statement = sqlConnection.createStatement();
        ResultSet rs = null;
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT TRIGSCHEMA,TRIGNAME,TRIGTIME, ");
            buffer.append("TRIGEVENT,GRANULARITY,TEXT definition,REMARKS comment ");
            buffer.append("from syscat.triggers ");
            buffer.append("WHERE tabname = '");
            buffer.append(tableProxy.getName()).append("'");
            buffer.append(" AND tabschema = '");
            buffer.append(tableProxy.getSchema()).append("'");
            buffer.append(" ORDER BY TRIGEVENT,TRIGTIME,create_time ");
            rs = statement.executeQuery(buffer.toString());
        }
        catch (SQLException e) {
            LOGGER.error("MOHTableUDBv81.initIndexColumns():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                String schemaName = rs.getString(1);
                String name = rs.getString(2);
                String triggerTime = rs.getString(3);
                String action = rs.getString(4);
                String scope = rs.getString(5);
                String triggerBody = rs.getString(6);
                String comments = rs.getString(7);
                SchemaUDBv81 schema = null;
                StorageDesign storageDesign = this.getStorageDesign();
                if (storageDesign == null || !(storageDesign instanceof StorageDesignUDBv81)) continue;
                StorageDesignUDBv81 storage = (StorageDesignUDBv81)storageDesign;
                TriggerUDBv81 trigger = (TriggerUDBv81)storage.getTriggerSet().createTrigger();
                trigger.setName(name);
                trigger.setTable(tableProxy);
                trigger.setSchema(tableProxy.getSchema());
                this.stampModelObject((ModelObject)trigger, schemaName, name);
                schema = (SchemaUDBv81)storage.getSchemaSet().getByName(schemaName);
                if (schema != null) {
                    trigger.setOwner(schema.getOwner());
                }
                if ("U".equalsIgnoreCase(action)) {
                    trigger.setActions(Trigger.ACTION_TYPES[1]);
                } else if ("D".equalsIgnoreCase(action)) {
                    trigger.setActions(Trigger.ACTION_TYPES[2]);
                }
                if ("A".equalsIgnoreCase(triggerTime)) {
                    trigger.setTriggerTime(TriggerUDB.TRIGGER_TIMES[1]);
                } else if ("B".equalsIgnoreCase(triggerTime)) {
                    trigger.setTriggerTime(TriggerUDB.TRIGGER_TIMES[0]);
                }
                if ("S".equalsIgnoreCase(scope)) {
                    trigger.setScope(TriggerUDB.SCOPE_TYPES[1]);
                }
                trigger.setBody(triggerBody);
                trigger.setCommentInRDBMS(comments);
            }
            rs.close();
        }
        statement.close();
    }

    private void initDatalinkOptions(ColumnProxyUDBv81 columnProxy, String dlOptions) {
        String linkControl = String.valueOf(dlOptions.charAt(2));
        String readPermission = String.valueOf(dlOptions.charAt(4));
        String writePermission = String.valueOf(dlOptions.charAt(5));
        String recovery = String.valueOf(dlOptions.charAt(6));
        String onUnlink = String.valueOf(dlOptions.charAt(7));
        if ("F".equalsIgnoreCase(linkControl)) {
            columnProxy.setLinkControl(ColumnProxyUDB.getLinkControlChoices()[1]);
        }
        if ("D".equalsIgnoreCase(readPermission)) {
            columnProxy.setReadPermission(ColumnProxyUDB.getReadPermissionChoices()[1]);
        }
        if ("B".equalsIgnoreCase(writePermission)) {
            columnProxy.setWritePermission(ColumnProxyUDB.getWritePermissionChoices()[1]);
        }
        if ("N".equalsIgnoreCase(recovery)) {
            columnProxy.setRecovery(ColumnProxyUDB.getRecoveryChoices()[1]);
        }
        if ("D".equalsIgnoreCase(onUnlink)) {
            columnProxy.setOnUnlink(ColumnProxyUDB.getOnUnlinkChoices()[1]);
        }
    }

    @Override
    public void postGenerateProcessing(Connection sqlConnection) {
        if (this.scopedColumns != null) {
            for (String id : this.scopedColumns.keySet()) {
                TableProxy tp;
                Column column = (Column)this.getDesign().getDesignObject(id);
                ScoppedNames sn = (ScoppedNames)this.scopedColumns.get(id);
                if (sn == null || column == null || (tp = this.getStorageDesign().getTableProxySet().getByUserSchemaAndName(sn.schema, sn.name)) == null) continue;
                column.setScopeId(tp.getObject().getObjectID());
            }
        }
    }

    class ScoppedNames {
        String schema = "";
        String name = "";

        ScoppedNames() {
        }
    }

    public class DimObject {
        private String colName = "";
        private int dimensionId = 0;

        public DimObject(String colName, int dimensionId) {
            this.colName = colName;
            this.dimensionId = dimensionId;
        }

        public String getColName() {
            return this.colName;
        }

        public int getDimensionId() {
            return this.dimensionId;
        }
    }
}

