/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.var;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.imports.var.Fields;
import oracle.dbtools.crest.imports.var.RowHandler;
import oracle.dbtools.crest.imports.var.VarFileLine;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.db2.BufferPoolDB2;
import oracle.dbtools.crest.model.design.storage.db2.DataBaseDB2;
import oracle.dbtools.crest.model.design.storage.db2.DataBaseSetDB2;
import oracle.dbtools.crest.model.design.storage.db2.StorageGroupDB2;
import oracle.dbtools.crest.model.design.storage.db2.v70.StorageDesignDB2v70;

public class RHDataBase
extends RowHandler {
    public static final String OBJECT_TYPE = "DATABASES";
    public static final String OBJECT_TYPE_COOL = "DATABASE";

    public RHDataBase(Design design, Fields constants, List allSelectedLines, Map allCreatedObjects, List allForeignKeyLines, List allPrimaryKeyLines, Map allReferences, List allColumnLines, List allCommentLines) {
        super(design, constants, allSelectedLines, allCreatedObjects, allForeignKeyLines, allPrimaryKeyLines, allReferences, allColumnLines, allCommentLines);
    }

    @Override
    public void read(VarFileLine line) {
        if (line.getType().equalsIgnoreCase(OBJECT_TYPE) || line.getType().equalsIgnoreCase(OBJECT_TYPE_COOL)) {
            this.addSelectedLine(line);
        } else {
            this.nextRead(line);
        }
    }

    @Override
    public List getAllTypes() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(OBJECT_TYPE);
        list.add(OBJECT_TYPE_COOL);
        return list;
    }

    @Override
    public void handle(VarFileLine line, boolean hasMapping) {
        if (line.getType().equalsIgnoreCase(OBJECT_TYPE) || line.getType().equalsIgnoreCase(OBJECT_TYPE_COOL)) {
            this.createDataBase(line);
        } else {
            this.nextHandler(line, hasMapping);
        }
    }

    private void createDataBase(VarFileLine line) {
        String storageGroupID = this.getField(line, "DATABASE_STORAGE_GROUPS");
        StorageGroupDB2 storagegroup = (StorageGroupDB2)this.getCreatedObject(storageGroupID);
        RDBMSSite site = this.getDesign().getSelectedRDBMSSite();
        StorageDesignDB2v70 storageDesign = (StorageDesignDB2v70)this.getDesign().getStorageDesign(site);
        String databaseName = this.getField(line, "DATABASE_NAME");
        if (!databaseName.equalsIgnoreCase("DSNDB04") && !this.getField(line, "DATABASE_NAME").equalsIgnoreCase("DSNDB07")) {
            DataBaseDB2 database = storageDesign.getDataBaseSet().createDataBase();
            database.setName(this.getField(line, "DATABASE_NAME"));
            database.setComment(this.getComment(line));
            database.setStorageGroup(storagegroup);
            this.fillCommontOn(line, database);
            String bufPoolKey = this.getField(line, "DATABASE_BUFFERPOOL");
            BufferPoolDB2 bufPool = (BufferPoolDB2)this.getCreatedObject(bufPoolKey);
            if (bufPool != null) {
                database.setBufferPool(bufPool);
            }
            this.addCreatedObject(this.getField(line, "general_id"), database);
            this.removeSelectedLine(line);
        } else {
            DataBaseSetDB2 databaseSet = storageDesign.getDataBaseSet();
            for (DataBaseDB2 database : databaseSet) {
                if (!database.getName().equalsIgnoreCase(databaseName)) continue;
                this.addCreatedObject(this.getField(line, "general_id"), database);
                this.removeSelectedLine(line);
            }
        }
    }

    private void fillCommontOn(VarFileLine line, DataBaseDB2 database) {
        String commentKey = this.getField(line, "DATABASE_TEXT");
        for (VarFileLine selectedLine : this.getAllSelectedLines()) {
            if (!selectedLine.getType().equalsIgnoreCase("TEXT") || !this.getField(selectedLine, "general_id").equalsIgnoreCase(commentKey)) continue;
            String comment = this.getField(selectedLine, "text_comment");
            database.setCommentInRDBMS(comment);
        }
    }

    private String getComment(VarFileLine line) {
        String comment = null;
        if (!this.getField(line, "DATABASE_TEXT_ID").equalsIgnoreCase("0")) {
            VarFileLine commentLine = this.getCommentLine(this.getField(line, "DATABASE_TEXT_ID"), "TEXT");
            if (commentLine != null) {
                comment = this.getField(commentLine, "text_comment");
            }
        } else {
            comment = "";
        }
        return comment;
    }
}

