/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.datatype.oracle;

import oracle.dbtools.crest.model.datatype.AbstractDataType;
import oracle.dbtools.crest.model.datatype.MDDataType;
import oracle.dbtools.crest.model.datatype.MDVarSized;
import oracle.dbtools.crest.util.options.Settings;

public class MDVarChar2Oracle
extends MDVarSized {
    String name = "VARCHAR2";
    Settings settings;

    public MDVarChar2Oracle() {
    }

    public MDVarChar2Oracle(Settings settings) {
        this.settings = settings;
    }

    @Override
    public String getMaxSize() {
        return "4000";
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public MDDataType deepCopy() {
        MDVarChar2Oracle copy = new MDVarChar2Oracle(this.settings);
        copy.setSize(this.getSize());
        return copy;
    }

    @Override
    public int getByteSize() {
        return AbstractDataType.parseSize(this.getSize()) + 2;
    }

    @Override
    public void appendTo(StringBuffer buffer) {
        String numeric = this.size;
        if (numeric != null && numeric.indexOf(32) > 0) {
            String[] parts_n = numeric.split(" ");
            if (parts_n.length == 2 && (parts_n[1].equalsIgnoreCase("BYTE") || parts_n[1].equalsIgnoreCase("CHAR"))) {
                buffer.append(this.getName());
                buffer.append(" (");
                if (this.settings != null && this.settings.isShowByteCharInDDL()) {
                    buffer.append(numeric);
                } else {
                    buffer.append(parts_n[0]);
                }
                buffer.append(')');
                return;
            }
            numeric = parts_n[0];
        }
        if (numeric == null || "".equalsIgnoreCase(numeric) || "0".equalsIgnoreCase(numeric)) {
            buffer.append(this.getName());
        } else {
            buffer.append(this.getName());
            buffer.append(" (");
            String s = this.getSize();
            s = s.replaceFirst("max", this.getMaxSize());
            s = s.replaceFirst("MAX", this.getMaxSize());
            buffer.append(s);
            buffer.append(')');
        }
    }

    public void setVarcharSynonym() {
        this.name = "VARCHAR";
    }
}

