/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.ddl.oracle.v10g;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.exports.ddl.DDLAdvancedGenerator;
import oracle.dbtools.crest.exports.ddl.SQLStatementBuilder;
import oracle.dbtools.crest.exports.ddl.oracle.SSBAutoIncrementColumnOracle;
import oracle.dbtools.crest.exports.ddl.oracle.v10g.SSBCreateBitmapJoinIndexOraclev10g;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelIdObjectSelection;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.compare.ColumnComparator;
import oracle.dbtools.crest.model.design.compare.CompareObjectSelection;
import oracle.dbtools.crest.model.design.compare.PropertiesComparator;
import oracle.dbtools.crest.model.design.compare.TableComparator;
import oracle.dbtools.crest.model.design.compare.TableSelection;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.CSSBArcConstraintOracle;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.CSSBTriggerOracle;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.v10g.AbstractCSSBOraclev10g;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.v10g.CSSBCreateTableOraclev10g;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.v10g.CSSBIndexOraclev10g;
import oracle.dbtools.crest.model.design.compare.storage.StoragePropertiesComparator;
import oracle.dbtools.crest.model.design.compare.storage.oracle.TableComparatorOracle;
import oracle.dbtools.crest.model.design.constraint.CheckConstraint;
import oracle.dbtools.crest.model.design.constraint.ConstraintEnumeration;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraint;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.Datatype;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.engineering.EngPropertiesComparator;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.SpatialColumnDefObject;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.ValidTimeDimension;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.RDBMSType;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ColumnProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.IndexProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.LobStorageOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PermissionsSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SegmentOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StructuredTypeProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableCheckConstraintOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TemporaryTablespaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.BitmapJoinIndexOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.ClusterOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.ColumnProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.HashPartitionLobItemOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.HashPartitionLobItemSetOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.HashPartitionOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.IndexGlobalPartitionOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.IndexGlobalPartitionSetOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.IndexGlobalPartitionsListOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.IndexHashPartitionLobItemOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.IndexHashPartitionLobItemSetOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.IndexHashPartitionOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.IndexHashPartitionSetOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.ListPartitionOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.ListStorageTemplatePartitionOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.LobStorageOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.PKProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.PartitionListOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.PartitionOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.PermissionsOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.SegmentOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TableProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.UniqueOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.LobStorageOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.PartitionOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.StorageDesignOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.TableProxyOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v12c.ColumnProxyOraclev12c;
import oracle.dbtools.crest.model.design.storage.oracle.v12c.StorageDesignOraclev12c;
import oracle.dbtools.crest.model.design.storage.oracle.v12c.TableProxyOraclev12c;
import oracle.dbtools.crest.swingui.compare.ddl.CDDLFileMaker;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class CSSBCreateRenameTableOraclev10g
extends AbstractCSSBOraclev10g {
    private CSSBIndexOraclev10g cssbIndex = null;
    private CSSBArcConstraintOracle cssbArcConstraintOracle = null;
    private TableProxyOraclev10g tableProxy = null;
    private boolean isRenamed = false;
    private TableSelection tableObj;
    private TableSelection targetObject;
    private SSBCreateBitmapJoinIndexOraclev10g ssbBJIndex = null;
    private CSSBTriggerOracle cssbTriggerOracle = null;
    private String directoryName;

    @Override
    public boolean canHandle(Object object) {
        return ((CompareObjectSelection)object).canBeCreate() && ((CompareObjectSelection)object).getObject() instanceof Table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doAppend(StringBuffer oldbuffer, Object object, boolean prettyPrint) {
        if (object == null) {
            this.tableObj = null;
            return;
        }
        StringBuffer buffer = new StringBuffer();
        String advancedComment = "";
        Table table = null;
        TableProxyOraclev10g ttp = null;
        this.tableObj = (TableSelection)object;
        this.targetObject = (TableSelection)this.tableObj.getCorrespondentNode();
        if (this.tableObj.getObject() instanceof Table) {
            table = (Table)this.tableObj.getObject();
            Design design = table.getDesign();
            RDBMSSite site = table.getSelectedRDBMSSite();
            this.storageDesign = (StorageDesignOracle)design.getStorageDesign(site, table);
            this.tableProxy = (TableProxyOraclev10g)this.storageDesign.getTableProxySet().getProxy(table.getObjectID());
            StoragePropertiesComparator pc = this.tableObj.getPropertiesComparator().getPhysicalPropertiesComparator();
            if (pc instanceof TableComparatorOracle) {
                ttp = (TableProxyOraclev10g)((TableComparatorOracle)pc).getTargetTableProxy();
            }
        } else {
            return;
        }
        if (table.getTypeSubstitution() == null) {
            int validTimeDimsIndex;
            if (this.tableProxy != null && this.tableProxy.isCommentChanged()) {
                this.appendComment(oldbuffer, this.tableProxy);
            } else {
                this.appendComment(oldbuffer, table);
            }
            if (this.tableProxy != null && this.tableProxy.getName().length() > this.tableProxy.getMaxNameLength()) {
                CSSBCreateRenameTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(oldbuffer, "--  ERROR: Table name length exceeds maximum allowed length(" + this.tableProxy.getMaxNameLength() + ")");
                CSSBCreateRenameTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
                CDDLFileMaker.incrementErrors();
            }
            this.appendBeforeCreateScript(oldbuffer, prettyPrint, table);
            List columnList = this.tableObj.getObjectsForRestore(0);
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "CREATE");
            if (this.tableProxy == null) {
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "TABLE");
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, CSSBCreateRenameTableOraclev10g.getFormattedTableName(this.tableObj, this.storageDesign));
                advancedComment = buffer.toString();
                this.appendElementList(buffer, this.tableObj, prettyPrint, columnList);
                this.appendOid(buffer, table, null, prettyPrint);
            } else {
                if ("YES".equalsIgnoreCase(this.tableProxy.getTemporary())) {
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "GLOBAL");
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "TEMPORARY");
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "TABLE");
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, CSSBCreateRenameTableOraclev10g.getFormattedTableName(this.tableObj, this.storageDesign));
                    advancedComment = buffer.toString();
                    this.appendElementList(buffer, this.tableObj, prettyPrint, columnList);
                    CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "ON");
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "COMMIT");
                    if ("YES".equalsIgnoreCase(this.tableProxy.getTempPreserveRows())) {
                        CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "PRESERVE ROWS");
                    } else {
                        CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "DELETE ROWS");
                    }
                    this.appendOid(buffer, table, null, prettyPrint);
                    TemporaryTablespaceOracle tablespace = this.tableProxy.getTemporaryTablespace();
                    if (tablespace != null && this.storageDesign instanceof StorageDesignOraclev11g && this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
                        CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                        CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "TABLESPACE");
                        CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(tablespace));
                    }
                    if ("YES".equalsIgnoreCase(this.tableProxy.getCache())) {
                        CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                        CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "CACHE");
                    } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                        CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                        CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "NOCACHE");
                    }
                } else {
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "TABLE");
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, CSSBCreateRenameTableOraclev10g.getFormattedTableName(this.tableObj, this.storageDesign));
                    advancedComment = buffer.toString();
                    this.appendElementList(buffer, this.tableObj, prettyPrint, columnList);
                    this.appendOid(buffer, table, this.tableProxy, prettyPrint);
                    this.appendCluster(buffer, this.tableProxy, prettyPrint);
                    this.appendColumnProperties(buffer, table, this.tableProxy, prettyPrint);
                    this.appendPartitionList(buffer, this.tableProxy, prettyPrint);
                    if (this.tableProxy.getCluster() == null) {
                        if (!"INDEX".equals(this.tableProxy.getOrganization())) {
                            if ("YES".equalsIgnoreCase(this.tableProxy.getCache())) {
                                CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "CACHE");
                            } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                                CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "NOCACHE");
                            }
                        }
                        if ("YES".equalsIgnoreCase(this.tableProxy.getParallel())) {
                            CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "PARALLEL");
                            if (!"".equals(this.tableProxy.getDegree())) {
                                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, this.tableProxy.getDegree());
                            }
                        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                            CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "NOPARALLEL");
                        }
                    }
                }
                this.appendRowDependency(buffer, this.tableProxy, prettyPrint);
                this.appendRowMovement(buffer, this.tableProxy, prettyPrint);
            }
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            CSSBCreateRenameTableOraclev10g.appendLineFinisher(buffer, prettyPrint);
            CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            CDDLFileMaker.incrementCreateTable();
            this.appendAfterCreateScript(oldbuffer, prettyPrint, table);
            if (this.storageDesign instanceof StorageDesignOraclev12c && (validTimeDimsIndex = this.tableObj.getChildIndex(ModelIdObjectSelection.VALID_TIME_DIMENSIONS)) > -1) {
                for (CompareObjectSelection timeSel : this.tableObj.getChildObjects(validTimeDimsIndex)) {
                    this.appendValidTime(oldbuffer, timeSel, prettyPrint);
                }
            }
            this.appendColumnCheckConstraints(oldbuffer, this.tableProxy, prettyPrint);
            this.appendTableLevelCheckConstraints(oldbuffer, this.tableObj, prettyPrint);
            int arcsIndex = this.tableObj.getChildIndex(ModelIdObjectSelection.ARCS);
            if (arcsIndex > -1) {
                for (CompareObjectSelection arcSel : this.tableObj.getChildObjects(arcsIndex)) {
                    if (arcSel.canBeCreate() && !arcSel.isSelected() || arcSel.canBeDrop() && arcSel.isSelected()) continue;
                    if (this.cssbArcConstraintOracle == null) {
                        this.cssbArcConstraintOracle = new CSSBArcConstraintOracle();
                    }
                    this.cssbArcConstraintOracle.appendArcConstraint(oldbuffer, arcSel, prettyPrint);
                }
            }
            if (table.getDesign().getAppView().getSettings().isGenerateCommentsInRDBMS()) {
                this.appendTableCommentOn(oldbuffer, this.tableObj, this.tableProxy, this.storageDesign, prettyPrint);
            }
            if (this.tableProxy != null) {
                DDLAdvancedGenerator oldg = DDLFileMaker.getddlAdvancedGenenerator();
                try {
                    DDLFileMaker.setddlAdvancedGenenerator(CDDLFileMaker.getddlAdvancedGenenerator());
                    this.appendAutoIncTriggers(oldbuffer, this.tableProxy, prettyPrint);
                }
                finally {
                    DDLFileMaker.setddlAdvancedGenenerator(oldg);
                }
            }
            if (this.targetObject.getScriptExecuteOption().equals(TableSelection.STOP_AFTER_RECREATE)) {
                this.appendScriptExecution(oldbuffer, this.storageDesign.getFormatedName(this.targetObject.getName()));
            }
            if (this.isRenamed() && !TableSelection.NONE.equals(this.targetObject.getBackupOption()) && !TableSelection.NONE.equals(this.targetObject.getRestoreOption())) {
                Object ext_name;
                int maxTableNameLength = this.tableProxy.getMaxNameLength();
                if (TableSelection.BACKUP_RENAME.equals(this.targetObject.getBackupOption())) {
                    this.insertIntoTable(oldbuffer, this.tableProxy, this.tableObj, "", prettyPrint);
                } else if (TableSelection.BACKUP_UNLOAD.equals(this.targetObject.getBackupOption())) {
                    ext_name = "EXT_" + this.tableProxy.getName();
                    if (((String)ext_name).length() > maxTableNameLength) {
                        ext_name = ((String)ext_name).substring(0, maxTableNameLength);
                    }
                    ext_name = this.storageDesign.getFormatedName((String)ext_name);
                    this.createExtDirectory(oldbuffer, this.tableObj, prettyPrint);
                    this.createExtTable(oldbuffer, (String)ext_name, this.tableObj, this.targetObject.getName(), prettyPrint);
                    this.insertIntoTable(oldbuffer, this.tableProxy, this.tableObj, (String)ext_name, prettyPrint);
                    this.dropExtTable(oldbuffer, (String)ext_name, prettyPrint);
                    this.dropExtDir(oldbuffer, prettyPrint);
                } else if (TableSelection.BACKUP_UNLOAD_PARTITION.equals(this.targetObject.getBackupOption())) {
                    ext_name = "EXT_" + this.tableProxy.getName();
                    if (((String)ext_name).length() > maxTableNameLength) {
                        ext_name = ((String)ext_name).substring(0, maxTableNameLength);
                    }
                    ext_name = this.storageDesign.getFormatedName((String)ext_name);
                    this.createExtDirectory(oldbuffer, this.tableObj, prettyPrint);
                    TableComparator comp = (TableComparator)this.targetObject.getPropertiesComparator();
                    TableProxyOracle targetProxy = (TableProxyOracle)comp.getTargetTableProxy();
                    for (PartitionOracle partition : targetProxy.getPartitions()) {
                        String fileName = this.storageDesign.getFormatedName(this.targetObject.getName() + "_" + partition.getName());
                        this.createExtTable(oldbuffer, (String)ext_name, this.tableObj, fileName, prettyPrint);
                        this.insertIntoTable(oldbuffer, this.tableProxy, this.tableObj, (String)ext_name, prettyPrint);
                        this.dropExtTable(oldbuffer, (String)ext_name, prettyPrint);
                    }
                    this.dropExtDir(oldbuffer, prettyPrint);
                }
            }
            if (this.tableProxy != null) {
                this.appendIndexes(oldbuffer, this.tableProxy, this.tableObj, prettyPrint);
                DDLAdvancedGenerator oldg = DDLFileMaker.getddlAdvancedGenenerator();
                try {
                    DDLFileMaker.setddlAdvancedGenenerator(CDDLFileMaker.getddlAdvancedGenenerator());
                    this.appendBitmapJoinIndexes(oldbuffer, this.tableProxy, prettyPrint);
                }
                finally {
                    DDLFileMaker.setddlAdvancedGenenerator(oldg);
                }
                CSSBCreateTableOraclev10g.appendLogGroups(oldbuffer, this.tableProxy, prettyPrint);
                CSSBCreateTableOraclev10g.appendLogIDKeys(oldbuffer, this.tableProxy, prettyPrint);
                this.appendTriggers(oldbuffer, prettyPrint);
                this.appendPermissions(oldbuffer, this.tableProxy, prettyPrint);
            }
            CSSBCreateRenameTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
            CSSBCreateRenameTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
            if (table.isSpatialTable()) {
                for (SpatialColumnDefObject spObjects : table.getSpatialDefinitions()) {
                    if (spObjects.getSpatialColumn() == null && !spObjects.isFunction()) continue;
                    this.appendRegisterSpatialTable(buffer, table, spObjects, prettyPrint);
                }
            }
        } else {
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(oldbuffer, "-- table " + table.getName() + ": is a part of type substitution hierarchy");
            CSSBCreateRenameTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
        }
        this.tableProxy = null;
    }

    private void appendValidTime(StringBuffer oldbuffer, CompareObjectSelection timeSel, boolean prettyPrint) {
        ValidTimeDimension timeDim = (ValidTimeDimension)timeSel.getObject();
        if (!(timeDim != null && timeDim.isSelected() || (timeDim = (ValidTimeDimension)timeSel.getCorrespondentNode().getObject()) == null)) {
            CSSBCreateRenameTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
            StringBuffer buffer = new StringBuffer();
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "ALTER");
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "TABLE");
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, CSSBCreateRenameTableOraclev10g.getFormattedTableName(this.tableObj, this.storageDesign));
            String advancedComment = buffer + "ADD period for " + timeDim.getName();
            CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "ADD");
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, '(');
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "PERIOD FOR");
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, timeDim.getName());
            Column startCol = timeDim.getStartTimeColumn();
            Column endCol = timeDim.getEndTimeColumn();
            if (startCol != null && endCol != null) {
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, '(');
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(startCol));
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, ',');
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(endCol));
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, ')');
            }
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, ')');
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            buffer.append(';');
            CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            DDLFileMaker.incrementAlterTable();
        }
    }

    private void insertIntoTable(StringBuffer oldbuffer, TableProxyOraclev10g tableProxy, CompareObjectSelection object, String extTable, boolean prettyPrint) {
        TableComparator tableComp = (TableComparator)object.getPropertiesComparator();
        TableProxyOracle targetTableProxy = (TableProxyOracle)tableComp.getTargetTableProxy();
        StringBuffer buffer = new StringBuffer();
        String advancedComment = "";
        CSSBCreateRenameTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
        CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "INSERT");
        CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "INTO");
        CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, CSSBCreateRenameTableOraclev10g.getFormattedTableName(this.tableObj, this.storageDesign));
        advancedComment = buffer.toString();
        CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
        CSSBCreateRenameTableOraclev10g.appendString(buffer, '(');
        ArrayList<CompareObjectSelection> appendedColumn = new ArrayList<CompareObjectSelection>();
        boolean first = true;
        CompareObjectSelection columns = (CompareObjectSelection)object.getChild(0);
        if (!columns.isLeaf()) {
            for (int i = 0; i < columns.getNumberOfChildren(); ++i) {
                CompareObjectSelection column = (CompareObjectSelection)columns.getChild(i);
                if (column.canBeCreate() || column.canBeDrop() && column.isSelected() || this.isVirtualColumn(column)) continue;
                if (first) {
                    first = false;
                } else {
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, ',');
                }
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, this.getFormattedColumnName(column));
                appendedColumn.add(column);
            }
        }
        CSSBCreateRenameTableOraclev10g.appendString(buffer, ')');
        CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 0);
        CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "SELECT");
        if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "ALL");
        }
        CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
        first = true;
        for (CompareObjectSelection columnNode : appendedColumn) {
            ColumnComparator comp;
            ModelIDObject columnOrProxy;
            String dataTypeConversion = columnNode.getDataTypeConversion();
            if ("".equals(dataTypeConversion) && columnNode.getCorrespondentNode() != null) {
                dataTypeConversion = columnNode.getCorrespondentNode().getDataTypeConversion();
            }
            if ((columnOrProxy = (comp = (ColumnComparator)columnNode.getPropertiesComparator()).getTargetColumnProxy()) == null) {
                columnOrProxy = comp.getTargetColumn();
            }
            Object columnName = ((ModelObject)columnOrProxy).getName();
            if (this.isNotEmpty(dataTypeConversion) && Token.hasString(dataTypeConversion.toUpperCase(), ((String)columnName).toUpperCase())) {
                columnName = dataTypeConversion;
            } else {
                columnName = this.storageDesign.getFormatedName(columnOrProxy);
                if (!TableSelection.BACKUP_RENAME.equals(this.targetObject.getBackupOption())) {
                    String ndata_type = columnNode.getChoosedPropertyValue(PropertiesComparator.DATA_TYPE);
                    if (ndata_type.equalsIgnoreCase("XMLTYPE")) {
                        columnName = "XMLType.createXML(" + (String)columnName + ")";
                    } else if (ndata_type.equalsIgnoreCase("BFILE")) {
                        columnName = "nvl2(" + (String)columnName + ", bfilename(substr(" + (String)columnName + ", 1, instr(" + (String)columnName + ", ',') -1), substr(" + (String)columnName + ", instr(" + (String)columnName + ", ',') +2)), '')";
                    }
                }
            }
            if (first) {
                first = false;
            } else {
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, ',');
            }
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, (String)columnName);
        }
        CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 0);
        CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "FROM");
        CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
        if ("".equals(extTable)) {
            ModelIDObject user;
            int maxTableNameLength = targetTableProxy.getMaxNameLength();
            Object name = "bcp_" + targetTableProxy.getName();
            if (((String)name).length() > maxTableNameLength) {
                name = ((String)name).substring(0, maxTableNameLength);
            }
            if (this.storageDesign.getAppView().getSettings().isIncludeSchemaInDDL() && (user = targetTableProxy.getSchemaImplementingObject()) != null) {
                CSSBCreateRenameTableOraclev10g.appendString(buffer, this.storageDesign.getFormatedName(user) + ".");
            }
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName((String)name));
        } else {
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, extTable);
        }
        this.appendToBuffer(oldbuffer, buffer, advancedComment);
        CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 0);
        CSSBCreateRenameTableOraclev10g.appendLineFinisher(buffer, prettyPrint);
        this.appendToBuffer(oldbuffer, buffer, advancedComment);
    }

    protected boolean isVirtualColumn(CompareObjectSelection columnSelection) {
        return false;
    }

    private void appendColumnProperties(StringBuffer buffer, Table table, TableProxyOraclev10g tableProxy, boolean prettyPrint) {
        Column[] cols = (Column[])table.getElements();
        for (int i = 0; i < cols.length; ++i) {
            Column column = cols[i];
            ColumnProxyOraclev10g columnProxy = (ColumnProxyOraclev10g)tableProxy.getColumnProxy(column.getObjectID());
            Datatype datatype = columnProxy.getDataType();
            if (datatype.toString().equals("XMLTYPE")) {
                this.appendXMLTypeColumnProps(buffer, columnProxy, prettyPrint);
                continue;
            }
            if (datatype instanceof CollectionType) {
                CollectionType cdatatype = (CollectionType)datatype;
                if (cdatatype.isArrayType()) {
                    this.appendVarrayColumnProp(buffer, columnProxy, prettyPrint);
                    continue;
                }
                this.appendNestedTableColumnProp(buffer, columnProxy, prettyPrint);
                continue;
            }
            if (!(datatype instanceof StructuredType)) continue;
            this.appendSubstitutableColumnClause(buffer, columnProxy, prettyPrint, true);
        }
    }

    private void appendOid(StringBuffer buffer, Table table, TableProxyOracle tableProxy, boolean prettyPrint) {
        if (table.isRoot()) {
            if (table.isOidIsPK() && table.getOidPKColumns().size() > 0) {
                CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "OBJECT");
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "IDENTIFIER");
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "IS");
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "PRIMARY KEY");
            }
            if (!(tableProxy == null || tableProxy.getOidIndexSegment() == null && "".equalsIgnoreCase(tableProxy.getOidIndexName()))) {
                CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "OIDINDEX");
                if (!"".equalsIgnoreCase(tableProxy.getOidIndexName())) {
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(tableProxy.getOidIndexName()));
                }
                if (tableProxy.getOidIndexSegment() != null) {
                    CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, '(');
                    this.appendSegment(buffer, (SegmentOraclev10g)tableProxy.getOidIndexSegment(), false, prettyPrint, null, "");
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, ')');
                }
            }
        }
    }

    private void appendElementList(StringBuffer buffer, CompareObjectSelection object, boolean prettyPrint, List restoreColumns) {
        TableComparator tableComp = (TableComparator)object.getPropertiesComparator();
        Table sourceTable = tableComp.getSourceTable();
        TableProxyOraclev10g sourceProxy = (TableProxyOraclev10g)tableComp.getSourceTableProxy();
        TableProxyOraclev10g targetProxy = (TableProxyOraclev10g)tableComp.getTargetTableProxy();
        List columns = object.getChildObjects(0);
        Column column = null;
        ColumnProxyOraclev10g columnProxy = null;
        CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
        if (sourceTable.getBasedOnStructuredType() != null) {
            StructuredTypeProxyOracle typeProxy;
            StructuredType type;
            ModelIDObject typeOrProxy = type = sourceTable.getBasedOnStructuredType();
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "OF");
            if (sourceProxy != null && (typeProxy = (StructuredTypeProxyOracle)sourceProxy.getStorageDesign().getProxy(type)) != null) {
                if (typeProxy.getOwner() != null && this.storageDesign.getAppView().getSettings().isIncludeSchemaInDDL()) {
                    CSSBCreateRenameTableOraclev10g.appendString(buffer, this.storageDesign.getFormatedName(typeProxy.getOwner()));
                    CSSBCreateRenameTableOraclev10g.appendString(buffer, '.');
                }
                typeOrProxy = typeProxy;
            }
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(typeOrProxy));
            String typeName = ((ModelObject)typeOrProxy).getName();
            if (typeName.equalsIgnoreCase("XMLTYPE")) {
                this.appendObjectTypeColProperties(buffer, sourceTable, sourceProxy, prettyPrint);
                if (sourceProxy != null) {
                    boolean storeAsBinaryXml = false;
                    String allowAnySchema = "";
                    String allowNonSchema = "";
                    CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "XMLTYPE");
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "STORE AS");
                    if (sourceProxy.getStoreAs().equalsIgnoreCase("OBJECT RELATIONAL")) {
                        CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "OBJECT RELATIONAL");
                    } else {
                        if (sourceProxy instanceof TableProxyOraclev11g) {
                            if (((TableProxyOraclev11g)sourceProxy).getLobStorageType().equalsIgnoreCase("SECUREFILE")) {
                                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "SECUREFILE");
                            } else if (((TableProxyOraclev11g)sourceProxy).getLobStorageType().equalsIgnoreCase("BASICFILE")) {
                                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "BASICFILE");
                            }
                            allowAnySchema = ((TableProxyOraclev11g)sourceProxy).getAllowAnySchema();
                            allowNonSchema = ((TableProxyOraclev11g)sourceProxy).getAllowNonSchema();
                            storeAsBinaryXml = sourceProxy.getStoreAs().equalsIgnoreCase("BINARY XML");
                        }
                        if (storeAsBinaryXml) {
                            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "BINARY XML");
                        } else {
                            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "CLOB");
                        }
                        String lobSegmentName = sourceProxy.getLobSegmentName();
                        if (lobSegmentName != null && lobSegmentName.length() > 0) {
                            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(lobSegmentName));
                        }
                        CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                        CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, '(');
                        CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                        if (sourceProxy.getXmlTypeTableSpace() != null && this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
                            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "TABLESPACE");
                            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(sourceProxy.getXmlTypeTableSpace()));
                            CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                        }
                        if (sourceProxy.getChunk() > 0) {
                            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "CHUNK");
                            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, sourceProxy.getChunk());
                            CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                        }
                        if (sourceProxy.getOldVersions().equalsIgnoreCase("RETENTION")) {
                            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "RETENTION");
                        } else {
                            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "PCTVERSION");
                            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, sourceProxy.getPCTVersion());
                        }
                        if (sourceProxy.getFreepools() > 0) {
                            CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "FREEPOOLS");
                            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, sourceProxy.getFreepools());
                        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                            CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "FREEPOOLS");
                            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "1");
                        }
                        CSSBCreateRenameTableOraclev10g.appendStorageInRow(buffer, sourceProxy, sourceProxy.getStorageInRow(), prettyPrint);
                        CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                        CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, sourceProxy.getXmlTypeCache());
                        if (this.storageDesign.getAppView().getSettings().isIncludeLoggingInDDL() && (!"CACHE".equalsIgnoreCase(sourceProxy.getXmlTypeCache()) || this.storageDesign instanceof StorageDesignOraclev12c)) {
                            String logging = sourceProxy.getXmlTypeLogging();
                            if (logging.equalsIgnoreCase("YES")) {
                                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "LOGGING");
                            } else if (logging.equalsIgnoreCase("NO")) {
                                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "NOLOGGING");
                            } else if (logging.equalsIgnoreCase("FILESYSTEM_LIKE_LOGGING") && CSSBCreateRenameTableOraclev10g.isSecureFile(((TableProxyOraclev11g)sourceProxy).getLobStorageType(), this.storageDesign)) {
                                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "FILESYSTEM_LIKE_LOGGING");
                            }
                        }
                        CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                        CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, ')');
                    }
                    this.appendXMLSchemaSpec(buffer, sourceProxy.getXmlSchemaUrl(), sourceProxy.getXmlSchemaElement(), storeAsBinaryXml, allowAnySchema, allowNonSchema, prettyPrint);
                }
            } else {
                if (!sourceTable.isSubstitutable()) {
                    CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "NOT");
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "SUBSTITUTABLE");
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "AT");
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "ALL");
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "LEVELS");
                } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                    CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "SUBSTITUTABLE");
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "AT");
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "ALL");
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "LEVELS");
                }
                this.appendObjectTypeColProperties(buffer, sourceTable, sourceProxy, prettyPrint);
            }
        } else if (columns.size() <= 0) {
            CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "--  ERROR: No Columns");
            CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CDDLFileMaker.incrementErrors();
        } else {
            boolean first = true;
            boolean merge = true;
            Iterator it = columns.iterator();
            while (it.hasNext()) {
                Object d_type;
                boolean targetSelected = false;
                CompareObjectSelection obj = (CompareObjectSelection)it.next();
                columnProxy = null;
                column = (Column)obj.getObject();
                merge = obj.isSelected();
                if (column == null || !merge) {
                    column = (Column)obj.getCorrespondentNode().getObject();
                    if (column == null) continue;
                    targetSelected = true;
                    columnProxy = (ColumnProxyOraclev10g)targetProxy.getColumnProxy(column.getObjectID());
                } else {
                    columnProxy = (ColumnProxyOraclev10g)sourceProxy.getColumnProxy(column.getObjectID());
                }
                if (!merge && !this.isRenamed() || column.isOid() || obj.canBeCreate() && !obj.isSelected() || obj.canBeDrop() && obj.isSelected()) continue;
                if (first) {
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, '(');
                    first = false;
                } else {
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, ',');
                }
                CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                String formattedColName = targetSelected ? this.storageDesign.getFormatedName(columnProxy) : CSSBCreateRenameTableOraclev10g.getFormattedSelectedName(obj, this.storageDesign);
                int colNameLength = formattedColName.length();
                if (formattedColName.startsWith("\"")) {
                    colNameLength -= 2;
                }
                if (colNameLength > columnProxy.getMaxNameLength()) {
                    CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "--  ERROR: Column name length exceeds maximum allowed length(" + columnProxy.getMaxNameLength() + ")");
                    CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                    CDDLFileMaker.incrementErrors();
                }
                if (columnProxy.isCommentChanged() && !"".equalsIgnoreCase(columnProxy.getComment())) {
                    this.appendComment(buffer, columnProxy);
                } else if (!"".equalsIgnoreCase(columnProxy.getObject().getComment())) {
                    this.appendComment(buffer, columnProxy.getObject());
                }
                CSSBCreateRenameTableOraclev10g.appendString(buffer, ' ');
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, formattedColName);
                if (targetSelected && columnProxy != null) {
                    d_type = column.getDatatypeString(columnProxy.getStorageDesign().getRDBMSType().getName());
                    if (((String)d_type).equals("UROWID") && this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                        d_type = (String)d_type + " (4000)";
                    }
                } else {
                    d_type = obj.getChoosedPropertyValue(PropertiesComparator.DATA_TYPE);
                }
                this.appendDatatype(buffer, (String)d_type, obj, prettyPrint);
                if (sourceProxy == null && targetProxy == null) continue;
                this.appendColumnOptions(buffer, column, columnProxy, prettyPrint, obj, merge);
                this.appendInlineRefConstraint(buffer, column, columnProxy, prettyPrint);
                if (!this.storageDesign.getAppView().getSettings().isGenerateInlineColumnCC()) continue;
                CSSBCreateRenameTableOraclev10g.appendColumnConstraints(buffer, column, columnProxy, prettyPrint, obj);
            }
            if ("INDEX".equalsIgnoreCase(sourceProxy.getOrganization())) {
                this.appendPKDefinitionConstraint(buffer, sourceProxy, prettyPrint);
            }
            this.appendRefPartitionFK(buffer, sourceProxy, prettyPrint);
            this.appendSupplementalLoggings(buffer, sourceProxy, prettyPrint);
            CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, ')');
        }
    }

    protected void appendRefPartitionFK(StringBuffer buffer, TableProxyOracle tableProxy, boolean prettyPrint) {
    }

    protected void appendDatatype(StringBuffer buffer, String datatype, CompareObjectSelection columnSelection, boolean prettyPrint) {
        CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, datatype);
        if (datatype.equalsIgnoreCase("unknown")) {
            CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "--  ERROR: Datatype UNKNOWN is not allowed");
            CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 5);
            CDDLFileMaker.incrementErrors();
        } else if (datatype.equals("VARCHAR2") || datatype.equals("NVARCHAR2") || datatype.equals("RAW")) {
            CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "--  ERROR: " + datatype + " size not specified");
            CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 5);
            CDDLFileMaker.incrementErrors();
        } else if (datatype.equals("CHAR") || datatype.equals("NCHAR")) {
            CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "--  WARNING: CHAR size not specified");
            CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 5);
            CDDLFileMaker.incrementWarnings();
        }
    }

    private boolean hasNoMergeColumns(ContainedObject[] objects) {
        if (this.isRenamed()) {
            return false;
        }
        int count = 0;
        for (int i = 0; i < objects.length; ++i) {
            Column col = (Column)objects[i];
            if (col.shouldBeMerge()) continue;
            ++count;
        }
        return objects.length == count;
    }

    protected void appendColumnOptions(StringBuffer buffer, Column column, ColumnProxyOraclev10g columnProxy, boolean prettyPrint, CompareObjectSelection obj, boolean merge) {
        this.appendWithDefaultDefinition(buffer, columnProxy, obj, merge);
        String mandatory = obj.getChoosedPropertyValue(PropertiesComparator.MANDATORY);
        boolean nn = Boolean.valueOf(mandatory);
        if (nn) {
            ColumnComparator comp = (ColumnComparator)obj.getPropertiesComparator();
            ColumnProxy targetColumnProxy = comp.getTargetColumnProxy();
            if (!column.getNullsAllowed()) {
                this.appendNotNullDefinition(buffer, columnProxy, prettyPrint);
            } else if (targetColumnProxy != null) {
                this.appendNotNullDefinition(buffer, (ColumnProxyOraclev10g)targetColumnProxy, prettyPrint);
            } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                CSSBCreateRenameTableOraclev10g.appendString(buffer, ' ');
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "NULL");
            }
        }
    }

    protected void appendWithDefaultDefinition(StringBuffer buffer, ColumnProxyOraclev10g columnProxy, CompareObjectSelection object, boolean merge) {
        String dt;
        Column column = columnProxy.getColumn();
        if (column.isIdentityColumn() && columnProxy.getDDLTypeForAutoIncCol().equalsIgnoreCase("IDENTITY_CLAUSE") && (dt = object.getChoosedPropertyValue(PropertiesComparator.DATA_TYPE)).toUpperCase().indexOf("CHAR") <= -1) {
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "GENERATED");
            if (column.isAutoIncrementGenerateAlways()) {
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "ALWAYS");
            } else {
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "BY");
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "DEFAULT");
                if (((ColumnProxyOraclev12c)columnProxy).getDefaultOnNull().equalsIgnoreCase("YES")) {
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "ON");
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "NULL");
                }
            }
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "AS");
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "IDENTITY");
            this.appendIdentityOptions(buffer, column);
            return;
        }
        Object defaultValue = merge ? object.getChoosedPropertyValue(PropertiesComparator.DEFAULT_VALUE) : columnProxy.getDefaultValue();
        if (column.isAutoIncrementColumn() && columnProxy.getDDLTypeForAutoIncCol().equalsIgnoreCase("DEFAULT_CLAUSE")) {
            if (this.ssbAutoIncCol == null) {
                this.ssbAutoIncCol = new SSBAutoIncrementColumnOracle(this.storageDesign);
            }
            defaultValue = this.ssbAutoIncCol.generateSequenceName(null, column, false) + ".NEXTVAL";
        }
        if (defaultValue != null && !"".equalsIgnoreCase((String)defaultValue)) {
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "DEFAULT");
            if (columnProxy instanceof ColumnProxyOraclev12c && ((ColumnProxyOraclev12c)columnProxy).getDefaultOnNull().equalsIgnoreCase("YES")) {
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "ON");
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "NULL");
            }
            String dt2 = object.getChoosedPropertyValue(PropertiesComparator.DATA_TYPE);
            String df = this.addQuotesToDefault(dt2, (String)defaultValue);
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, df);
        }
    }

    public static void appendColumnConstraints(StringBuffer buffer, Column column, ColumnProxyOracle columnProxy, boolean prettyPrint, CompareObjectSelection obj) {
        if (column.isGenerateConstraintInDDL()) {
            ConstraintEnumeration valueList;
            RDBMSType type;
            String checkText;
            CheckConstraint check;
            PropertiesComparator columnComparator = obj.getPropertiesComparator();
            boolean newColumn = obj.canBeCreate();
            boolean sourceColumnSelected = obj.isSelected();
            String columnName = sourceColumnSelected ? CSSBCreateRenameTableOraclev10g.getFormattedSelectedName(obj, columnProxy.getStorageDesign()) : columnProxy.getStorageDesign().getFormatedName(columnProxy);
            EngPropertyHolder ph = columnComparator.getPropertyHolderByName(PropertiesComparator.CHECK_CONSTRAINT);
            Column checkColumn = newColumn || sourceColumnSelected && ph != null && ph.isSelected() ? (Column)obj.getObject() : (Column)obj.getCorrespondentNode().getObject();
            ph = columnComparator.getPropertyHolderByName(PropertiesComparator.RANGE_CONSTRAINT);
            Column rangeColumn = newColumn || sourceColumnSelected && ph != null && ph.isSelected() ? (Column)obj.getObject() : (Column)obj.getCorrespondentNode().getObject();
            ph = columnComparator.getPropertyHolderByName(PropertiesComparator.LOV_CONSTRAINT);
            Column lovColumn = newColumn || sourceColumnSelected && ph != null && ph.isSelected() ? (Column)obj.getObject() : (Column)obj.getCorrespondentNode().getObject();
            StringBuffer checkBuffer = new StringBuffer();
            if (checkColumn != null && (check = checkColumn.getCheck()) != null && !check.isEmpty() && (checkText = check.getImplementation(type = columnProxy.getStorageDesign().getSelectedRDBMSType()).trim()).length() > 0) {
                checkText = checkText.replaceAll("%COLUMN%", columnName);
                checkText = checkText.replaceAll("%column%", columnName);
                checkBuffer.append(checkText);
            }
            if (rangeColumn != null && !rangeColumn.getAVTs().isEmpty() && columnProxy.getAppView().getSettings().isGenerateValidValueCC()) {
                if (checkBuffer.length() > 0) {
                    checkBuffer.append(" OR ");
                }
                rangeColumn.appendAVTs(checkBuffer, columnName);
                if (checkBuffer.charAt(checkBuffer.length() - 1) == ' ') {
                    checkBuffer.deleteCharAt(checkBuffer.length() - 1);
                }
            }
            if (lovColumn != null && columnProxy.getAppView().getSettings().isGenerateValidValueCC() && (valueList = lovColumn.getValueList()) != null && !valueList.isEmpty()) {
                if (checkBuffer.length() > 0) {
                    checkBuffer.append(" OR ");
                }
                lovColumn.appendStringEnumeration(checkBuffer, columnName);
            }
            if (checkBuffer.length() > 0) {
                String cname = sourceColumnSelected ? obj.getChoosedPropertyValue(PropertiesComparator.CHECK_CONSTRAINT_NAME) : column.getConstraintName();
                if (!cname.equals("") && !cname.toUpperCase().startsWith("SYS_") && cname.length() <= columnProxy.getTableProxy().getMaxConstraintNameLength()) {
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "CONSTRAINT");
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, columnProxy.getStorageDesign().getFormatedName(cname));
                }
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "CHECK");
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, '(');
                CSSBCreateRenameTableOraclev10g.appendString(buffer, checkBuffer.toString());
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, ')');
                CSSBCreateRenameTableOraclev10g.appendConstraintState(buffer, columnProxy, prettyPrint);
            }
        }
    }

    public static boolean isApplyColumnConstraint(CompareObjectSelection columnSelection) {
        ColumnComparator comp = (ColumnComparator)columnSelection.getPropertiesComparator();
        EngPropertyHolder ph = comp.getPropertyHolderByName(EngPropertiesComparator.CHECK_CONSTRAINT);
        if (ph != null && ph.isSelected()) {
            return true;
        }
        ph = comp.getPropertyHolderByName(EngPropertiesComparator.RANGE_CONSTRAINT);
        if (ph != null && ph.isSelected()) {
            return true;
        }
        ph = comp.getPropertyHolderByName(EngPropertiesComparator.LOV_CONSTRAINT);
        if (ph != null && ph.isSelected()) {
            return true;
        }
        ph = comp.getPropertyHolderByName(EngPropertiesComparator.CHECK_CONSTRAINT_NAME);
        return ph != null && ph.isSelected();
    }

    private static void appendConstraintState(StringBuffer buffer, ColumnProxyOracle columnProxy, boolean prettyPrint) {
        if (!"NO".equalsIgnoreCase(columnProxy.getDeferrable())) {
            CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "DEFERRABLE");
            if ("DEFERRED".equalsIgnoreCase(columnProxy.getInitially())) {
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "INITIALLY");
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "DEFERRED");
            } else if (columnProxy.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "INITIALLY");
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "IMMEDIATE");
            }
        } else if (columnProxy.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "NOT");
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "DEFERRABLE");
        }
        if (columnProxy.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
            if ("YES".equalsIgnoreCase(columnProxy.getEnable())) {
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "ENABLE");
            } else {
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "DISABLE");
            }
            if ("YES".equalsIgnoreCase(columnProxy.getValidate())) {
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "VALIDATE");
            } else {
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "NOVALIDATE");
            }
        } else {
            if ("NO".equalsIgnoreCase(columnProxy.getEnable())) {
                CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "DISABLE");
                if ("YES".equalsIgnoreCase(columnProxy.getValidate())) {
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "VALIDATE");
                }
            }
            if ("NO".equalsIgnoreCase(columnProxy.getValidate())) {
                CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "NOVALIDATE");
            }
        }
        if (columnProxy.getExceptionsTable() != null) {
            CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "EXCEPTIONS");
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "INTO");
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, columnProxy.getStorageDesign().getFormatedLongNameDDL(columnProxy.getExceptionsTable()));
        }
    }

    private PKProxyOraclev10g getPKProxy(TableProxyOraclev10g tableProxy) {
        KeyObject pk = ((Table)tableProxy.getObject()).getPK();
        if (pk != null) {
            return (PKProxyOraclev10g)((StorageDesignOraclev10g)tableProxy.getStorageDesign()).getPKProxySet().getProxy(pk.getObjectID());
        }
        return null;
    }

    private void appendIndexes(StringBuffer oldbuffer, CompareObjectSelection table, boolean prettyPrint) {
        List chIndexes = table.getChildObjects(1);
        for (CompareObjectSelection index : chIndexes) {
            CSSBIndexOraclev10g cssbIndex;
            StringBuffer columnList;
            Index theIndex;
            if (index.canBeCreate() && !index.isSelected()) continue;
            if (index.isModified() && !index.isSelected()) {
                theIndex = (Index)index.getCorrespondentNode().getObject();
                if (theIndex == null) continue;
                columnList = this.getColumnsForRestore(table.getCorrespondentNode(), theIndex, prettyPrint, true);
                cssbIndex = this.getCSSBIndex();
                cssbIndex.setRenamed(this.isRenamed());
                cssbIndex.setRestoredColumns(columnList);
                cssbIndex.setRestoredExpression(theIndex.getIndexExpression());
                cssbIndex.setTableName(CSSBCreateRenameTableOraclev10g.getFormattedTableName(this.tableObj, this.storageDesign));
                cssbIndex.doAppend(oldbuffer, theIndex, prettyPrint);
                continue;
            }
            theIndex = (Index)index.getObject();
            if (theIndex == null) continue;
            columnList = this.getColumnsForRestore(table, theIndex, prettyPrint, true);
            cssbIndex = this.getCSSBIndex();
            cssbIndex.setRenamed(this.isRenamed());
            cssbIndex.setRestoredColumns(columnList);
            cssbIndex.setRestoredExpression(index.getChoosedPropertyValue(PropertiesComparator.INDEX_FUNCTION_EXPRESSION));
            cssbIndex.setTableName(CSSBCreateRenameTableOraclev10g.getFormattedTableName(this.tableObj, this.storageDesign));
            cssbIndex.doAppend(oldbuffer, theIndex, prettyPrint);
        }
    }

    private void appendPKAndUK(StringBuffer oldbuffer, CompareObjectSelection table, boolean prettyPrint) {
        TableComparator comp = (TableComparator)table.getPropertiesComparator();
        TableProxyOraclev10g sourceTableProxy = (TableProxyOraclev10g)comp.getSourceTableProxy();
        TableProxyOraclev10g targetTableProxy = (TableProxyOraclev10g)comp.getTargetTableProxy();
        List chIndexes = table.getChildObjects(2);
        for (CompareObjectSelection index : chIndexes) {
            CSSBIndexOraclev10g cssbIndex;
            UniqueOraclev10g unique;
            StringBuffer columnList;
            Index theIndex;
            if (index.canBeCreate() && !index.isSelected()) continue;
            Index index2 = theIndex = index.isSelected() || !index.isModified() ? (Index)index.getObject() : (Index)index.getCorrespondentNode().getObject();
            if (theIndex != null && theIndex.isOidKey()) continue;
            if (index.getChoosedPropertyValue(PropertiesComparator.INDEX_STATUS).equals("Primary Constraint")) {
                Table sourceTable = comp.getSourceTable();
                if (sourceTable != null && sourceTable.getBasedOnStructuredType() != null) continue;
                if ((Index)index.getObject() == null) {
                    if (index.isSelected() || !this.isNotEmpty((columnList = this.getColumnsForRestore(table.getCorrespondentNode(), (Index)index.getCorrespondentNode().getObject(), prettyPrint, false)).toString())) continue;
                    this.appendRestorePKDefinition(oldbuffer, targetTableProxy, prettyPrint, columnList, index.getCorrespondentNode());
                    continue;
                }
                if (((Index)index.getObject()).isPK() && (index.isSelected() || !index.isModified())) {
                    columnList = this.getColumnsForRestore(table, (Index)index.getObject(), prettyPrint, false);
                    if (!this.isNotEmpty(columnList.toString())) continue;
                    this.appendPKDefinition(oldbuffer, sourceTableProxy, (Index)index.getObject(), columnList, prettyPrint);
                    continue;
                }
                columnList = this.getColumnsForRestore(table.getCorrespondentNode(), (Index)index.getCorrespondentNode().getObject(), prettyPrint, false);
                if (!this.isNotEmpty(columnList.toString())) continue;
                this.appendPKDefinition(oldbuffer, targetTableProxy, (Index)index.getCorrespondentNode().getObject(), columnList, prettyPrint);
                continue;
            }
            CompareObjectSelection targetObj = index.getCorrespondentNode();
            if ((Index)index.getObject() == null) {
                if (index.isSelected()) continue;
                if (((Index)targetObj.getObject()).isUnique()) {
                    columnList = this.getColumnsForRestore(table.getCorrespondentNode(), (Index)index.getCorrespondentNode().getObject(), prettyPrint, false);
                    if (!this.isNotEmpty(columnList.toString())) continue;
                    unique = (UniqueOraclev10g)targetTableProxy.getUniqueKeys().getObjectByID(targetObj.getObject().getObjectID());
                    this.appendUniqueDefinition(oldbuffer, targetTableProxy, unique, prettyPrint, columnList);
                    continue;
                }
                columnList = this.getColumnsForRestore(table.getCorrespondentNode(), (Index)targetObj.getObject(), prettyPrint, true);
                if (!this.isNotEmpty(columnList.toString()) || !(cssbIndex = this.getCSSBIndex()).canHandle(targetObj.getObject())) continue;
                cssbIndex.setRenamed(this.isRenamed());
                cssbIndex.setRestoredColumns(columnList);
                cssbIndex.setTableName(CSSBCreateRenameTableOraclev10g.getFormattedTableName(this.tableObj, this.storageDesign));
                cssbIndex.doAppend(oldbuffer, targetObj.getObject(), prettyPrint);
                continue;
            }
            if (((Index)index.getObject()).isUnique() && (index.isSelected() || !index.isModified())) {
                columnList = this.getColumnsForRestore(table, (Index)index.getObject(), prettyPrint, false);
                if (!this.isNotEmpty(columnList.toString())) continue;
                unique = (UniqueOraclev10g)sourceTableProxy.getUniqueKeys().getObjectByID(index.getObject().getObjectID());
                this.appendUniqueDefinition(oldbuffer, sourceTableProxy, unique, prettyPrint, columnList);
                continue;
            }
            if (((Index)index.getCorrespondentNode().getObject()).isUnique()) {
                columnList = this.getColumnsForRestore(table.getCorrespondentNode(), (Index)index.getCorrespondentNode().getObject(), prettyPrint, false);
                if (!this.isNotEmpty(columnList.toString())) continue;
                UniqueOraclev10g uniqie = (UniqueOraclev10g)targetTableProxy.getUniqueKeys().getObjectByID(targetObj.getObject().getObjectID());
                this.appendUniqueDefinition(oldbuffer, targetTableProxy, uniqie, prettyPrint, columnList);
                continue;
            }
            columnList = this.getColumnsForRestore(table, (Index)index.getObject(), prettyPrint, true);
            if (!this.isNotEmpty(columnList.toString()) || !(cssbIndex = this.getCSSBIndex()).canHandle(index.getObject())) continue;
            cssbIndex.setRenamed(this.isRenamed());
            cssbIndex.setRestoredColumns(columnList);
            cssbIndex.setTableName(CSSBCreateRenameTableOraclev10g.getFormattedTableName(this.tableObj, this.storageDesign));
            cssbIndex.doAppend(oldbuffer, index.getObject(), prettyPrint);
        }
    }

    private void appendPKDefinition(StringBuffer oldbuffer, TableProxyOraclev10g tableProxy, Index index, StringBuffer columnList, boolean prettyPrint) {
        Index pkInd;
        PKProxyOraclev10g pk;
        StringBuffer buffer = new StringBuffer();
        String advancedComment = "";
        if (tableProxy != null && (pk = this.getPKProxy(tableProxy)) != null && pk.getObject() == index && ((pkInd = pk.getIndex()).shouldBeMerge() || this.isRenamed()) && !this.hasNoMergeColumns(pkInd.getElements()) && !"".equalsIgnoreCase(pk.getColumns())) {
            CSSBCreateRenameTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
            if (pk.isCommentChanged() && !"".equalsIgnoreCase(pk.getComment())) {
                this.appendComment(oldbuffer, pk);
            } else if (!"".equalsIgnoreCase(pk.getObject().getComment())) {
                this.appendComment(oldbuffer, pk.getObject());
            }
            String pkName = pk.getName();
            if (pkName.length() > tableProxy.getMaxNameLength()) {
                CSSBCreateRenameTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(oldbuffer, "--  ERROR: PK name length exceeds maximum allowed length(" + tableProxy.getMaxNameLength() + ")");
                CSSBCreateRenameTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
                CDDLFileMaker.incrementErrors();
            }
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "ALTER");
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "TABLE");
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, CSSBCreateRenameTableOraclev10g.getFormattedTableName(this.tableObj, this.storageDesign));
            CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "ADD");
            if (!pkName.startsWith("SYS_")) {
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "CONSTRAINT");
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(pk));
            }
            advancedComment = buffer.toString();
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "PRIMARY KEY");
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, '(');
            if (!"".equals(pkInd.getIndexExpression())) {
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, pkInd.getIndexExpression());
            } else {
                this.appendStringWithSpace(buffer, columnList);
            }
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, ')');
            if (!"NO".equalsIgnoreCase(pk.getDeferrable())) {
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "DEFERRABLE");
                if ("DEFERRED".equalsIgnoreCase(pk.getInitially())) {
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "INITIALLY");
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "DEFERRED");
                } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "INITIALLY");
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "IMMEDIATE");
                }
            } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "NOT");
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "DEFERRABLE");
            }
            if (!"NO".equalsIgnoreCase(pk.getUsingIndex())) {
                this.appendUsingIndex(buffer, pk, tableProxy, prettyPrint);
            }
            if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                if ("YES".equalsIgnoreCase(pk.getEnable())) {
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "ENABLE");
                } else {
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "DISABLE");
                }
                if ("YES".equalsIgnoreCase(pk.getValidate())) {
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "VALIDATE");
                } else {
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "NOVALIDATE");
                }
            } else {
                if (!"YES".equalsIgnoreCase(pk.getEnable())) {
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "DISABLE");
                    if ("YES".equalsIgnoreCase(pk.getValidate())) {
                        CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "VALIDATE");
                    }
                }
                if (!"YES".equalsIgnoreCase(pk.getValidate())) {
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "NOVALIDATE");
                }
            }
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            CSSBCreateRenameTableOraclev10g.appendLineFinisher(buffer, prettyPrint);
            CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            CDDLFileMaker.incrementAlterTable();
            if (pk.getRely().equals("YES")) {
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "ALTER");
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "TABLE");
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, CSSBCreateRenameTableOraclev10g.getFormattedTableName(this.tableObj, this.storageDesign));
                CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "MODIFY");
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "CONSTRAINT");
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(pk));
                advancedComment = buffer.toString();
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "RELY");
                this.appendToBuffer(oldbuffer, buffer, advancedComment);
                CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                CSSBCreateRenameTableOraclev10g.appendLineFinisher(buffer, prettyPrint);
                CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                this.appendToBuffer(oldbuffer, buffer, advancedComment);
                CDDLFileMaker.incrementAlterTable();
            }
            if (pk.getExceptionsTable() != null && "YES".equalsIgnoreCase(pk.getEnable())) {
                CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "ALTER");
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "TABLE");
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, CSSBCreateRenameTableOraclev10g.getFormattedTableName(this.tableObj, this.storageDesign));
                advancedComment = buffer.toString();
                CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "MODIFY");
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "CONSTRAINT");
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(pk));
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "ENABLE EXCEPTIONS INTO");
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(pk.getExceptionsTable()));
                this.appendToBuffer(oldbuffer, buffer, advancedComment);
                CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                CSSBCreateRenameTableOraclev10g.appendLineFinisher(buffer, prettyPrint);
                this.appendToBuffer(oldbuffer, buffer, advancedComment);
                CDDLFileMaker.incrementAlterTable();
            }
        }
    }

    private void appendPKDefinitionConstraint(StringBuffer buffer, TableProxyOraclev10g tableProxy, boolean prettyPrint) {
        PKProxyOraclev10g pk;
        if (tableProxy != null && (pk = this.getPKProxy(tableProxy)) != null) {
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, ',');
            CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateRenameTableOraclev10g.appendString(buffer, ' ');
            if (!pk.getName().startsWith("SYS_")) {
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "CONSTRAINT");
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(pk));
            }
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "PRIMARY KEY");
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, '(');
            StringBuffer columnList = this.getColumnsForRestore(this.tableObj, (Index)pk.getObject(), prettyPrint, false);
            this.appendStringWithSpace(buffer, columnList);
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, ')');
            if (!("NO".equalsIgnoreCase(pk.getUsingIndex()) || "INDEX".equalsIgnoreCase(tableProxy.getOrganization()) && "BY INDEX NAME".equalsIgnoreCase(pk.getUsingIndex()) && pk.getExistingIndex() != null)) {
                this.appendUsingIndex(buffer, pk, tableProxy, prettyPrint);
            }
            if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                if ("YES".equalsIgnoreCase(pk.getEnable())) {
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "ENABLE");
                } else {
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "DISABLE");
                }
                if ("YES".equalsIgnoreCase(pk.getValidate())) {
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "VALIDATE");
                } else {
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "NOVALIDATE");
                }
            } else {
                if (!"YES".equalsIgnoreCase(pk.getEnable())) {
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "DISABLE");
                    if ("YES".equalsIgnoreCase(pk.getValidate())) {
                        CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "VALIDATE");
                    }
                }
                if (!"YES".equalsIgnoreCase(pk.getValidate())) {
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "NOVALIDATE");
                }
            }
        }
    }

    private void appendRestorePKDefinition(StringBuffer oldbuffer, TableProxyOraclev10g tableProxy, boolean prettyPrint, StringBuffer restoreColumns, CompareObjectSelection indexObj) {
        Index pkInd;
        PKProxyOraclev10g pk;
        StringBuffer buffer = new StringBuffer();
        String advancedComment = "";
        if (tableProxy != null && (pk = this.getPKProxy(tableProxy)) != null && ((pkInd = pk.getIndex()).shouldBeMerge() || this.isRenamed()) && this.isNotEmpty(restoreColumns.toString()) && !"".equalsIgnoreCase(pk.getColumns())) {
            CSSBCreateRenameTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
            if (pk.isCommentChanged() && !"".equalsIgnoreCase(pk.getComment())) {
                this.appendComment(oldbuffer, pk);
            } else if (!"".equalsIgnoreCase(pk.getObject().getComment())) {
                this.appendComment(oldbuffer, pk.getObject());
            }
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "ALTER");
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "TABLE");
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, CSSBCreateRenameTableOraclev10g.getFormattedTableName(this.tableObj, this.storageDesign));
            CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "ADD");
            if (!pk.getName().startsWith("SYS_")) {
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "CONSTRAINT");
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(pk));
            }
            advancedComment = buffer.toString();
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "PRIMARY KEY");
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, '(');
            this.appendStringWithSpace(buffer, restoreColumns);
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, ')');
            if (!"NO".equalsIgnoreCase(pk.getDeferrable())) {
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "DEFERRABLE");
                if ("DEFERRED".equalsIgnoreCase(pk.getInitially())) {
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "INITIALLY");
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "DEFERRED");
                } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "INITIALLY");
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "IMMEDIATE");
                }
            } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "NOT");
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "DEFERRABLE");
            }
            if (!"NO".equalsIgnoreCase(pk.getUsingIndex())) {
                this.appendUsingIndex(buffer, pk, tableProxy, prettyPrint);
            }
            if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                if ("YES".equalsIgnoreCase(pk.getEnable())) {
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "ENABLE");
                } else {
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "DISABLE");
                }
                if ("YES".equalsIgnoreCase(pk.getValidate())) {
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "VALIDATE");
                } else {
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "NOVALIDATE");
                }
            } else {
                if (!"YES".equalsIgnoreCase(pk.getEnable())) {
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "DISABLE");
                    if ("YES".equalsIgnoreCase(pk.getValidate())) {
                        CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "VALIDATE");
                    }
                }
                if (!"YES".equalsIgnoreCase(pk.getValidate())) {
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "NOVALIDATE");
                }
            }
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            CSSBCreateRenameTableOraclev10g.appendLineFinisher(buffer, prettyPrint);
            CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            CDDLFileMaker.incrementAlterTable();
            if (pk.getRely().equals("YES")) {
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "ALTER");
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "TABLE");
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, CSSBCreateRenameTableOraclev10g.getFormattedTableName(this.tableObj, this.storageDesign));
                CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "MODIFY");
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "CONSTRAINT");
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(pk));
                advancedComment = buffer.toString();
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "RELY");
                this.appendToBuffer(oldbuffer, buffer, advancedComment);
                CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                CSSBCreateRenameTableOraclev10g.appendLineFinisher(buffer, prettyPrint);
                CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                this.appendToBuffer(oldbuffer, buffer, advancedComment);
                CDDLFileMaker.incrementAlterTable();
            }
            if (pk.getExceptionsTable() != null && "YES".equalsIgnoreCase(pk.getEnable())) {
                CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "ALTER");
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "TABLE");
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, CSSBCreateRenameTableOraclev10g.getFormattedTableName(this.tableObj, this.storageDesign));
                advancedComment = buffer.toString();
                CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "MODIFY");
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "CONSTRAINT");
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(pk));
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "ENABLE EXCEPTIONS INTO");
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(pk.getExceptionsTable()));
                this.appendToBuffer(oldbuffer, buffer, advancedComment);
                CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                CSSBCreateRenameTableOraclev10g.appendLineFinisher(buffer, prettyPrint);
                this.appendToBuffer(oldbuffer, buffer, advancedComment);
                CDDLFileMaker.incrementAlterTable();
            }
        }
    }

    private void appendSupplementalLoggings(StringBuffer buffer, TableProxyOraclev10g tableProxy, boolean prettyPrint) {
        if (tableProxy != null && !"".equalsIgnoreCase(tableProxy.getSuplementalLogGroupName())) {
            this.appendComma(buffer);
            CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "SUPPLEMENTAL");
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "LOG");
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "GROUP");
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(tableProxy.getSuplementalLogGroupName()));
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, '(');
            Object spp1 = this.storageDesign.getFormatedColumnNamesFromIDs(tableProxy.getSuplementalLogColumns());
            String spp2 = this.storageDesign.getFormatedColumnNamesNoLogFromIDs(tableProxy.getSuplementalLogColumnsNoLog());
            if (!((String)spp1).isEmpty() && !spp2.isEmpty()) {
                spp1 = (String)spp1 + "," + spp2;
            } else if (!spp2.isEmpty()) {
                spp1 = spp2;
            }
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, (String)spp1);
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, ')');
            if (tableProxy.getSuplementalLogConditions().equalsIgnoreCase("ALWAYS")) {
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "ALWAYS");
            }
        }
    }

    @Override
    protected boolean appendTableConstraintsDefinition(StringBuffer buffer, TableProxyOracle tableProxy, boolean prettyPrint, boolean first) {
        return first;
    }

    private void appendUsingIndex(StringBuffer buffer, PKProxyOraclev10g pkProxy, TableProxyOracle tableProxy, boolean prettyPrint) {
        CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
        CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "USING INDEX");
        IndexProxyOracle exIndex = pkProxy.getExistingIndex();
        if ("BY INDEX NAME".equalsIgnoreCase(pkProxy.getUsingIndex()) && pkProxy.getExistingIndex() != null) {
            Index existInd = exIndex.getIndex();
            if (!existInd.isRemoved() && existInd.canSupportConstraint(pkProxy.getIndex(), true)) {
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(pkProxy.getExistingIndex()));
            }
        } else if ("BY CREATE INDEX STATEMENT".equalsIgnoreCase(pkProxy.getUsingIndex())) {
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, '(');
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, pkProxy.getCreateIndexStatement());
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, ')');
        } else {
            boolean temporaryTable = tableProxy.getTemporary().equals("YES");
            if (!temporaryTable) {
                if ("LOCAL".equalsIgnoreCase(pkProxy.getUsingIndex())) {
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "LOCAL");
                    this.getCSSBIndex().appendPartitionList(buffer, pkProxy, tableProxy, prettyPrint);
                } else if (pkProxy.getUsingIndex().equalsIgnoreCase("GLOBAL BY RANGE")) {
                    this.appendGlobalIndex(buffer, pkProxy, prettyPrint);
                } else if (pkProxy.getUsingIndex().equalsIgnoreCase("GLOBAL HASH PARTITIONED BY QUANTITY")) {
                    this.appendGlobalIndexByHashQuantity(buffer, pkProxy, prettyPrint);
                } else if (pkProxy.getUsingIndex().equalsIgnoreCase("GLOBAL HASH PARTITIONED BY LIST")) {
                    this.appendGlobalIndexByHashList(buffer, pkProxy, prettyPrint);
                }
                if (pkProxy.getIndexSegment() != null) {
                    this.appendSegment(buffer, (SegmentOraclev10g)pkProxy.getIndexSegment(), false, prettyPrint, pkProxy.getTableSpace(), pkProxy.getLogging());
                } else {
                    if (pkProxy.getTableSpace() != null && this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
                        CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "TABLESPACE");
                        CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(pkProxy.getTableSpace()));
                        CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                    }
                    if (this.storageDesign.isOpen() && this.storageDesign.getAppView().getSettings().isIncludeLoggingInDDL()) {
                        if ("YES".equalsIgnoreCase(pkProxy.getLogging())) {
                            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "LOGGING");
                            CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                        } else if ("NO".equalsIgnoreCase(pkProxy.getLogging())) {
                            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "NOLOGGING");
                            CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                        }
                    }
                }
            }
            if (this.storageDesign.isOpen()) {
                if (pkProxy.getIndexSort().equalsIgnoreCase("NO")) {
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "NOSORT");
                    CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                } else if (pkProxy.getIndexSort().equalsIgnoreCase("REVERSE")) {
                    if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                        CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "SORT");
                    }
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "REVERSE");
                    CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "SORT");
                    CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                }
                if (pkProxy.getComputeStatistics().equalsIgnoreCase("YES")) {
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "COMPUTE STATISTICS");
                    CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                }
                if (this.storageDesign instanceof StorageDesignOraclev11g) {
                    if (pkProxy.getCompress() > 0) {
                        CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "COMPRESS");
                        CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, pkProxy.getCompress());
                        CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                    } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                        CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "NOCOMPRESS");
                        CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                    }
                }
            }
        }
    }

    private void appendUniqueUsingIndex(StringBuffer buffer, UniqueOraclev10g unique, TableProxyOracle tableProxy, boolean prettyPrint) {
        CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
        CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "USING INDEX");
        IndexProxyOracle exIndex = unique.getExistingIndex();
        if ("BY INDEX NAME".equalsIgnoreCase(unique.getUsingIndex()) && unique.getExistingIndex() != null) {
            Index existInd = exIndex.getIndex();
            if (!existInd.isRemoved() && existInd.canSupportConstraint(unique.getIndex(), true)) {
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(unique.getExistingIndex()));
            }
        } else if ("BY CREATE INDEX STATEMENT".equalsIgnoreCase(unique.getUsingIndex())) {
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, '(');
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, unique.getCreateIndexStatement());
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, ')');
        } else {
            boolean temporaryTable = tableProxy.getTemporary().equals("YES");
            if (!temporaryTable) {
                if ("LOCAL".equalsIgnoreCase(unique.getUsingIndex())) {
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "LOCAL");
                    this.getCSSBIndex().appendPartitionList(buffer, unique, tableProxy, prettyPrint);
                } else if (unique.getUsingIndex().equalsIgnoreCase("GLOBAL BY RANGE")) {
                    this.appendUniqueGlobalIndex(buffer, unique, prettyPrint);
                } else if (unique.getUsingIndex().equalsIgnoreCase("GLOBAL HASH PARTITIONED BY QUANTITY")) {
                    this.appendGlobalIndexByHashQuantity(buffer, unique, prettyPrint);
                } else if (unique.getUsingIndex().equalsIgnoreCase("GLOBAL HASH PARTITIONED BY LIST")) {
                    this.appendGlobalIndexByHashList(buffer, unique, prettyPrint);
                }
                if (unique.getIndexSegment() != null) {
                    this.appendSegment(buffer, (SegmentOraclev10g)unique.getIndexSegment(), false, prettyPrint, unique.getTableSpace(), unique.getLogging());
                } else {
                    if (unique.getTableSpace() != null && this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
                        CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "TABLESPACE");
                        CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(unique.getTableSpace()));
                        CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                    }
                    if (this.storageDesign.isOpen() && this.storageDesign.getAppView().getSettings().isIncludeLoggingInDDL()) {
                        if ("YES".equalsIgnoreCase(unique.getLogging())) {
                            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "LOGGING");
                            CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                        } else if ("NO".equalsIgnoreCase(unique.getLogging())) {
                            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "NOLOGGING");
                            CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                        }
                    }
                }
            }
            if (this.storageDesign.isOpen()) {
                if (unique.getIndexSort().equalsIgnoreCase("NO")) {
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "NOSORT");
                    CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                } else if (unique.getIndexSort().equalsIgnoreCase("REVERSE")) {
                    if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                        CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "SORT");
                    }
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "REVERSE");
                    CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "SORT");
                    CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                }
                if (unique.getComputeStatistics().equalsIgnoreCase("YES")) {
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "COMPUTE STATISTICS");
                    CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                }
                if (this.storageDesign instanceof StorageDesignOraclev11g) {
                    if (unique.getCompress() > 0) {
                        CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "COMPRESS");
                        CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, unique.getCompress());
                        CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                    } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                        CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "NOCOMPRESS");
                        CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                    }
                }
            }
        }
    }

    private void appendUniqueGlobalIndex(StringBuffer buffer, UniqueOraclev10g unique, boolean prettyPrint) {
        if (unique.getUsingIndexGlobalPL() != null) {
            CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "GLOBAL");
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "PARTITION");
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "BY");
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "RANGE");
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, '(');
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedColumnNamesFromIDs(unique.getUsingIndexGlobalPL().getGlobalPartColumns()));
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, ')');
            this.appendGlobalPartitions(buffer, (IndexGlobalPartitionsListOraclev10g)unique.getUsingIndexGlobalPL(), prettyPrint);
        }
    }

    private void appendGlobalIndexByHashQuantity(StringBuffer buffer, UniqueOraclev10g unique, boolean prettyPrint) {
        if (unique.getUsingIndexGlobalPL() != null) {
            IndexGlobalPartitionsListOraclev10g partList = (IndexGlobalPartitionsListOraclev10g)unique.getUsingIndexGlobalPL();
            CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "GLOBAL");
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "PARTITION");
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "BY");
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "HASH");
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, '(');
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedColumnNamesFromIDs(partList.getGlobalPartColumns()));
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, ')');
            CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "PARTITIONS");
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, partList.getHashPQuantity());
            if (!"".equals(partList.getHashPTableSpaces())) {
                CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "STORE IN");
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, '(');
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedTablespaceNamesFromIDs(partList.getHashPTableSpaces()));
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, ')');
            }
            if (!"".equals(partList.getIOTOverflowHashPTS())) {
                CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "OVERFLOW");
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "STORE IN");
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, '(');
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedTablespaceNamesFromIDs(partList.getIOTOverflowHashPTS()));
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, ')');
            }
        }
    }

    private void appendGlobalIndexByHashList(StringBuffer buffer, UniqueOraclev10g unique, boolean prettyPrint) {
        if (unique.getUsingIndexGlobalPL() != null) {
            CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "GLOBAL");
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "PARTITION");
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "BY");
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "HASH");
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, '(');
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedColumnNamesFromIDs(unique.getUsingIndexGlobalPL().getGlobalPartColumns()));
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, ')');
            this.appendHashPartitions(buffer, (IndexGlobalPartitionsListOraclev10g)unique.getUsingIndexGlobalPL(), prettyPrint);
        }
    }

    private void appendGlobalIndex(StringBuffer buffer, PKProxyOraclev10g pkProxy, boolean prettyPrint) {
        if (pkProxy.getIndexGlobalPL() != null) {
            CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "GLOBAL");
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "PARTITION");
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "BY");
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "RANGE");
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, '(');
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedColumnNamesFromIDs(pkProxy.getIndexGlobalPL().getGlobalPartColumns()));
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, ')');
            this.appendGlobalPartitions(buffer, (IndexGlobalPartitionsListOraclev10g)pkProxy.getIndexGlobalPL(), prettyPrint);
        }
    }

    private void appendGlobalIndexByHashQuantity(StringBuffer buffer, PKProxyOraclev10g pkProxy, boolean prettyPrint) {
        if (pkProxy.getIndexGlobalPL() != null) {
            IndexGlobalPartitionsListOraclev10g partList = (IndexGlobalPartitionsListOraclev10g)pkProxy.getIndexGlobalPL();
            CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "GLOBAL");
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "PARTITION");
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "BY");
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "HASH");
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, '(');
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedColumnNamesFromIDs(partList.getGlobalPartColumns()));
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, ')');
            CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "PARTITIONS");
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, partList.getHashPQuantity());
            if (!"".equals(partList.getHashPTableSpaces())) {
                CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "STORE IN");
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, '(');
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedTablespaceNamesFromIDs(partList.getHashPTableSpaces()));
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, ')');
            }
            if (!"".equals(partList.getIOTOverflowHashPTS())) {
                CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "OVERFLOW");
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "STORE IN");
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, '(');
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedTablespaceNamesFromIDs(partList.getIOTOverflowHashPTS()));
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, ')');
            }
        }
    }

    private void appendGlobalIndexByHashList(StringBuffer buffer, PKProxyOraclev10g pkProxy, boolean prettyPrint) {
        if (pkProxy.getIndexGlobalPL() != null) {
            CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "GLOBAL");
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "PARTITION");
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "BY");
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "HASH");
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, '(');
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedColumnNamesFromIDs(pkProxy.getIndexGlobalPL().getGlobalPartColumns()));
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, ')');
            this.appendHashPartitions(buffer, (IndexGlobalPartitionsListOraclev10g)pkProxy.getIndexGlobalPL(), prettyPrint);
        }
    }

    private boolean appendHashPartitions(StringBuffer buffer, IndexGlobalPartitionsListOraclev10g partitionList, boolean prettyPrint) {
        boolean result = false;
        IndexHashPartitionSetOraclev10g hashPartitionSet = (IndexHashPartitionSetOraclev10g)((StorageDesignOraclev10g)partitionList.getStorageDesign()).getIndexHashPartitionSet();
        Iterator setIt = hashPartitionSet.iterator();
        boolean first = true;
        while (setIt.hasNext()) {
            IndexHashPartitionOraclev10g hashPartition = (IndexHashPartitionOraclev10g)setIt.next();
            if (hashPartition.getIndexGlobalPartList() == null || !hashPartition.getIndexGlobalPartList().toString().equalsIgnoreCase(partitionList.toString())) continue;
            if (first) {
                CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, '(');
                CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                first = false;
                result = true;
            } else {
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, ',');
                CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            }
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "PARTITION");
            if (!hashPartition.getName().toUpperCase().startsWith("SYS_")) {
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(hashPartition));
            }
            if (hashPartition.getTableSpace() != null && this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "TABLESPACE");
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(hashPartition.getTableSpace()));
            }
            if (hashPartition.getOverflowTableSpace() != null && this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "OVERFLOW");
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "TABLESPACE");
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(hashPartition.getOverflowTableSpace()));
            }
            this.appendHashPLobItems(buffer, hashPartition, prettyPrint);
        }
        if (!first) {
            CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, ')');
        }
        return result;
    }

    private void appendHashPLobItems(StringBuffer buffer, IndexHashPartitionOraclev10g hashPartition, boolean prettyPrint) {
        IndexHashPartitionLobItemSetOraclev10g hashPLobItemSet = (IndexHashPartitionLobItemSetOraclev10g)((StorageDesignOraclev10g)hashPartition.getStorageDesign()).getIndexHashPartitionLobItemSet();
        for (IndexHashPartitionLobItemOraclev10g hashPLobItem : hashPLobItemSet) {
            if (hashPLobItem.getIndexHashPartition() == null || !hashPLobItem.getIndexHashPartition().toString().equalsIgnoreCase(hashPartition.toString())) continue;
            CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
            this.appendLobPartitioningStorage(buffer, hashPLobItem, hashPLobItem.getLobColumn(), "", hashPLobItem.getTableSpace(), prettyPrint);
        }
    }

    private void appendGlobalPartitions(StringBuffer buffer, IndexGlobalPartitionsListOraclev10g globalPartitionList, boolean prettyPrint) {
        IndexGlobalPartitionSetOraclev10g globalPartitionSet = (IndexGlobalPartitionSetOraclev10g)((StorageDesignOraclev10g)globalPartitionList.getStorageDesign()).getIndexGlobalPartitionSet();
        Object[] globalPartitionsList = globalPartitionSet.toArray();
        Arrays.sort(globalPartitionsList, new GlobalPossitionComparator());
        ArrayList<Object> sortedList = new ArrayList<Object>();
        for (int i = 0; i < globalPartitionsList.length; ++i) {
            sortedList.add(globalPartitionsList[i]);
        }
        Iterator setIt = sortedList.iterator();
        boolean first = true;
        while (setIt.hasNext()) {
            IndexGlobalPartitionOraclev10g globalPartition = (IndexGlobalPartitionOraclev10g)setIt.next();
            if (globalPartition.getIndexGlobalPartList() == null || !globalPartition.getIndexGlobalPartList().toString().equalsIgnoreCase(globalPartitionList.toString())) continue;
            if (first) {
                CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, '(');
                CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                first = false;
            } else {
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, ',');
                CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            }
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "PARTITION");
            if (!globalPartition.getName().toUpperCase().startsWith("SYS_")) {
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(globalPartition));
            }
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "VALUES LESS THAN");
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, '(');
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, globalPartition.getValueList());
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, ')');
            if (globalPartition.getSegment() != null) {
                this.appendSegment(buffer, (SegmentOraclev10g)globalPartition.getSegment(), false, prettyPrint, globalPartition.getTableSpace(), globalPartition.getLogging());
                continue;
            }
            if (globalPartition.getTableSpace() != null && this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "TABLESPACE");
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(globalPartition.getTableSpace()));
            }
            if (!this.storageDesign.isOpen() || !this.storageDesign.getAppView().getSettings().isIncludeLoggingInDDL()) continue;
            if ("YES".equalsIgnoreCase(globalPartition.getLogging())) {
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "LOGGING");
                continue;
            }
            if (!"NO".equalsIgnoreCase(globalPartition.getLogging())) continue;
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "NOLOGGING");
        }
        if (!first) {
            CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, ')');
        }
    }

    protected void appendPartitionList(StringBuffer buffer, TableProxyOraclev10g tableProxy, boolean prettyPrint) {
        PartitionListOraclev10g partitionList = (PartitionListOraclev10g)tableProxy.getPartitionList();
        if (partitionList != null) {
            String partitionType = partitionList.getPartitionType();
            String subpartitionType = partitionList.getSubpartitionType();
            CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            if ("RANGE".equalsIgnoreCase(partitionType) || "COMPOSITE BY HASH".equalsIgnoreCase(partitionType) || "COMPOSITE BY LIST".equalsIgnoreCase(partitionType)) {
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "PARTITION");
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "BY");
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "RANGE");
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, '(');
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedColumnNamesFromIDs(partitionList.getColumnIDs()));
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, ')');
                if (subpartitionType.equalsIgnoreCase("HASH")) {
                    CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "SUBPARTITION");
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "BY");
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "HASH");
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, '(');
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedColumnNamesFromIDs(partitionList.getSubPartitionsColumnIDs()));
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, ')');
                    if ("NO".equals(partitionList.getUseSubpartStorageTemplate())) {
                        if (partitionList.getSubPartitionsQuantity() > 1 || !"".equals(partitionList.getSubPartitionsTableSpaces())) {
                            CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "SUBPARTITIONS");
                            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, partitionList.getSubPartitionsQuantity());
                            if (!"".equals(partitionList.getSubPartitionsTableSpaces())) {
                                CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "STORE IN");
                                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, '(');
                                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedTablespaceNamesFromIDs(partitionList.getSubPartitionsTableSpaces()));
                                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, ')');
                            }
                        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                            CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "SUBPARTITIONS");
                            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "1");
                        }
                    } else {
                        this.appendHashSubPartitionTemplates(buffer, tableProxy, prettyPrint);
                    }
                } else if (subpartitionType.equalsIgnoreCase("LIST")) {
                    CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "SUBPARTITION");
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "BY");
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "LIST");
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, '(');
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedColumnNamesFromIDs(partitionList.getSubPartitionsColumnIDs()));
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, ')');
                    this.appendListSubPartitionTemplates(buffer, tableProxy, prettyPrint);
                }
                boolean composite = !subpartitionType.equalsIgnoreCase("");
                this.appendPartitions(buffer, partitionList, true, composite, prettyPrint);
            } else if ("HASH BY QUANTITY".equalsIgnoreCase(partitionType)) {
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "PARTITION");
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "BY");
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "HASH");
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, '(');
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedColumnNamesFromIDs(partitionList.getColumnIDs()));
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, ')');
                CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "PARTITIONS");
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, partitionList.getHashPQuantity());
                if (!"".equals(partitionList.getHashPTableSpaces())) {
                    CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "STORE IN");
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, '(');
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedTablespaceNamesFromIDs(partitionList.getHashPTableSpaces()));
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, ')');
                }
                if (!"".equals(partitionList.getIOTOverflowHashPTS())) {
                    CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "OVERFLOW");
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "STORE IN");
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, '(');
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedTablespaceNamesFromIDs(partitionList.getIOTOverflowHashPTS()));
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, ')');
                }
            } else if ("HASH BY LIST OF PARTITIONS".equalsIgnoreCase(partitionType)) {
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "PARTITION");
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "BY");
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "HASH");
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, '(');
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedColumnNamesFromIDs(partitionList.getColumnIDs()));
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, ')');
                this.appendHashPartitions(buffer, tableProxy, prettyPrint);
            } else if ("LIST".equalsIgnoreCase(partitionType)) {
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "PARTITION");
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "BY");
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "LIST");
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, '(');
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedColumnNamesFromIDs(partitionList.getColumnIDs()));
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, ')');
                this.appendListPartitions(buffer, tableProxy, partitionList, prettyPrint);
            }
        }
    }

    protected void appendListSubPartitionTemplates(StringBuffer buffer, TableProxyOraclev10g tableProxy, boolean prettyPrint) {
        StorageObjectCollection templates = tableProxy.getListStorageTemplates();
        if (templates.size() > 0) {
            CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "SUBPARTITION");
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "TEMPLATE");
            CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, '(');
            for (int i = 0; i < templates.size(); ++i) {
                ListStorageTemplatePartitionOraclev10g temp = (ListStorageTemplatePartitionOraclev10g)templates.getElement(i);
                if (i > 0) {
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, ',');
                }
                CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "SUBPARTITION");
                if (!temp.getName().toUpperCase().startsWith("SYS_")) {
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(temp));
                }
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "VALUES");
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, '(');
                if (!"".equalsIgnoreCase(temp.getValueList())) {
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, temp.getValueList());
                } else {
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "DEFAULT");
                }
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, ')');
                this.appendPartStorage(buffer, temp, prettyPrint);
            }
            CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, ')');
        }
    }

    protected void appendHashSubPartitionTemplates(StringBuffer buffer, TableProxyOraclev10g tableProxy, boolean prettyPrint) {
        if (tableProxy.getListStorageTemplates().size() > 0) {
            CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "SUBPARTITION");
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "TEMPLATE");
            Iterator setIt = tableProxy.getListStorageTemplates().iterator();
            boolean first = true;
            while (setIt.hasNext()) {
                HashPartitionOraclev10g partition = (HashPartitionOraclev10g)setIt.next();
                if (first) {
                    CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, '(');
                    first = false;
                } else {
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, ',');
                }
                CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "SUBPARTITION");
                if (!partition.getName().toUpperCase().startsWith("SYS_")) {
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(partition));
                }
                this.appendPartStorage(buffer, partition, prettyPrint);
            }
            if (!first) {
                CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, ')');
            }
        }
    }

    protected void appendPartStorage(StringBuffer buffer, AbstractStorageObjectOracle template, boolean prettyPrint) {
        TableSpaceOracle tableSpace = null;
        TableSpaceOracle overflowTableSpace = null;
        String dataSegmentCompression = "";
        StorageObjectCollection lobs = null;
        AbstractStorageObjectOracle owningPartition = null;
        if (template instanceof PartitionOraclev11g) {
            tableSpace = ((PartitionOraclev11g)template).getTableSpace();
            dataSegmentCompression = ((PartitionOraclev11g)template).getDataSegmentCompression();
            lobs = ((PartitionOraclev11g)template).getLobs();
            owningPartition = ((PartitionOraclev11g)template).getSubPartitionOf();
        } else if (template instanceof HashPartitionOraclev10g) {
            tableSpace = ((HashPartitionOraclev10g)template).getTableSpace();
            overflowTableSpace = ((HashPartitionOraclev10g)template).getIotOverflowTablespace();
            lobs = ((HashPartitionOraclev10g)template).getLobs();
            owningPartition = ((HashPartitionOraclev10g)template).getSubPartitionOf();
        } else if (template instanceof ListStorageTemplatePartitionOraclev10g) {
            tableSpace = ((ListStorageTemplatePartitionOraclev10g)template).getTablespace();
            dataSegmentCompression = ((ListStorageTemplatePartitionOraclev10g)template).getDataSegmentCompression();
            lobs = ((ListStorageTemplatePartitionOraclev10g)template).getLobs();
            owningPartition = ((ListStorageTemplatePartitionOraclev10g)template).getSubPartitionOf();
        }
        if (this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
            if (tableSpace != null) {
                CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "TABLESPACE");
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(tableSpace));
            }
            if (overflowTableSpace != null) {
                CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "OVERFLOW");
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "TABLESPACE");
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(overflowTableSpace));
            }
        }
        if (this.storageDesign instanceof StorageDesignOraclev11g) {
            if (dataSegmentCompression.equalsIgnoreCase("NO")) {
                CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "NOCOMPRESS");
            } else if (dataSegmentCompression.equalsIgnoreCase("YES")) {
                CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "COMPRESS");
            } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "NOCOMPRESS");
            }
        }
        if (lobs != null) {
            for (Object storageObject : lobs) {
                HashPartitionLobItemOraclev10g lobItem;
                if (storageObject instanceof LobStorageOraclev10g) {
                    LobStorageOraclev10g lobStorage = (LobStorageOraclev10g)storageObject;
                    if (lobStorage.getTableSpace() == null && lobStorage.getLobSegmentName().trim().equals("")) continue;
                    CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                    this.appendLobPartitioningStorage(buffer, lobStorage, lobStorage.getColumn(), lobStorage.getLobSegmentName(), lobStorage.getTableSpace(), prettyPrint);
                    continue;
                }
                if (!(storageObject instanceof HashPartitionLobItemOraclev10g) || (lobItem = (HashPartitionLobItemOraclev10g)storageObject).getTableSpace() == null) continue;
                CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                String lobSegName = lobItem.getName();
                if (owningPartition != null && (lobSegName.startsWith("SYS_LOB") || lobSegName.startsWith(lobItem.getIDPrefix()))) {
                    lobSegName = "";
                }
                this.appendLobPartitioningStorage(buffer, lobItem, lobItem.getLobColumn(), lobSegName, lobItem.getTableSpace(), prettyPrint);
            }
        }
    }

    protected void appendListPartitions(StringBuffer buffer, TableProxyOraclev10g tableProxy, PartitionListOraclev10g partitionList, boolean prettyPrint) {
        Iterator it = tableProxy.getPartitions().iterator();
        boolean first = true;
        while (it.hasNext()) {
            Table table;
            ListPartitionOraclev10g partition = (ListPartitionOraclev10g)it.next();
            if (first) {
                CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, '(');
                CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                first = false;
            } else {
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, ',');
                CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            }
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "PARTITION");
            if (!partition.getName().toUpperCase().startsWith("SYS_")) {
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(partition));
            }
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "VALUES");
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, '(');
            if (!"".equalsIgnoreCase(partition.getColumns())) {
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, partition.getColumns());
            } else {
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "DEFAULT");
            }
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, ')');
            if (partition.getSegment() != null) {
                this.appendSegment(buffer, (SegmentOraclev10g)partition.getSegment(), true, prettyPrint, partition.getTablespace(), partition.getLogging());
            }
            if (partition.getDataSegmentCompression().equalsIgnoreCase("NO")) {
                CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "NOCOMPRESS");
            } else if (partition.getDataSegmentCompression().equalsIgnoreCase("YES")) {
                CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "COMPRESS");
            } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "NOCOMPRESS");
            }
            if (partition.getSegment() == null) {
                if (partition.getTablespace() != null && this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
                    CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "TABLESPACE");
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(partition.getTablespace()));
                }
                if (this.storageDesign.isOpen() && this.storageDesign.getAppView().getSettings().isIncludeLoggingInDDL()) {
                    if (partition.getLogging().equalsIgnoreCase("YES")) {
                        CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                        CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "LOGGING");
                    } else if (partition.getLogging().equalsIgnoreCase("NO")) {
                        CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                        CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "NOLOGGING");
                    }
                }
            }
            if (!(table = (Table)tableProxy.getObject()).isSpatialTable()) {
                for (LobStorageOracle lob : partition.getLobStorages()) {
                    this.appendLobStorage(buffer, (LobStorageOraclev10g)lob, prettyPrint);
                }
            }
            if (partitionList.getSubpartitionType().length() <= 0) continue;
            this.appendSubPartitions(buffer, partition, partitionList, prettyPrint);
        }
        if (!first) {
            CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, ')');
        }
    }

    protected void appendPartitions(StringBuffer buffer, PartitionListOraclev10g partitionList, boolean appendValueList, boolean composite, boolean prettyPrint) {
        TableProxyOraclev10g tableProxy = (TableProxyOraclev10g)partitionList.getTable();
        StorageObjectCollection partitions = tableProxy.getPartitions();
        if (partitions.size() > 0) {
            Object[] partitionsList = partitions.toArray();
            Arrays.sort(partitionsList, new PossitionComparator());
            ArrayList<Object> sortedList = new ArrayList<Object>();
            for (int i = 0; i < partitionsList.length; ++i) {
                sortedList.add(partitionsList[i]);
            }
            Iterator it = sortedList.iterator();
            boolean first = true;
            while (it.hasNext()) {
                Table table;
                Object partitionObj = it.next();
                if (!(partitionObj instanceof PartitionOracle)) continue;
                PartitionOracle partition = (PartitionOracle)partitionObj;
                if (first) {
                    CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, '(');
                    first = false;
                } else {
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, ',');
                }
                CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "PARTITION");
                if (!partition.getName().toUpperCase().startsWith("SYS_")) {
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(partition));
                }
                if (appendValueList) {
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "VALUES LESS THAN");
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, '(');
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, partition.getValueList());
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, ')');
                }
                if (partition.getSegment() != null) {
                    this.appendSegment(buffer, (SegmentOraclev10g)partition.getSegment(), true, prettyPrint, partition.getTableSpace(), partition.getLogging());
                } else {
                    if (partition.getTableSpace() != null && this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
                        CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                        CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "TABLESPACE");
                        CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(partition.getTableSpace()));
                    }
                    if (this.storageDesign.isOpen() && this.storageDesign.getAppView().getSettings().isIncludeLoggingInDDL()) {
                        if (partition.getLogging().equalsIgnoreCase("NO")) {
                            CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "NOLOGGING");
                        } else if (partition.getLogging().equalsIgnoreCase("YES")) {
                            CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "LOGGING");
                        }
                    }
                }
                if (partition.getDataSegmentCompression().equalsIgnoreCase("NO")) {
                    CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "NOCOMPRESS");
                } else if (partition.getDataSegmentCompression().equalsIgnoreCase("YES")) {
                    CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "COMPRESS");
                } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                    CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "NOCOMPRESS");
                }
                SegmentOracle overflowSegment = partition.getIOTOverflowSegment();
                if (overflowSegment != null) {
                    TableSpaceOracle overflowTableSpace = overflowSegment.getTableSpace();
                    if (overflowTableSpace == null) {
                        overflowTableSpace = partition.getTableSpace();
                    }
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "OVERFLOW");
                    this.appendSegment(buffer, (SegmentOraclev10g)overflowSegment, true, prettyPrint, overflowTableSpace, partition.getLogging());
                }
                if (!(table = (Table)this.tableObj.getObject()).isSpatialTable()) {
                    for (LobStorageOracle lob : partition.getLobs()) {
                        this.appendLobStorage(buffer, (LobStorageOraclev10g)lob, prettyPrint);
                    }
                }
                if (!composite) continue;
                this.appendSubPartitions(buffer, partition, partitionList, prettyPrint);
            }
            if (!first) {
                CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, ')');
            }
        }
    }

    protected void appendSubPartitions(StringBuffer buffer, AbstractStorageObjectOracle partition, PartitionListOraclev10g partitionList, boolean prettyPrint) {
        if (partitionList.getSubpartitionType().equalsIgnoreCase("HASH")) {
            PartitionOraclev10g rangePartition;
            if (partition instanceof PartitionOraclev10g && !this.appendHashSubPartitions(buffer, (rangePartition = (PartitionOraclev10g)partition).getPartitions(), partitionList, prettyPrint) && rangePartition.getSubPartitionsQuantity() > 0) {
                CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "SUBPARTITIONS");
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, rangePartition.getSubPartitionsQuantity());
                if (!"".equalsIgnoreCase(rangePartition.getSubPartitionsTableSpaces())) {
                    CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "STORE IN");
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, '(');
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedTablespaceNamesFromIDs(rangePartition.getSubPartitionsTableSpaces()));
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, ')');
                }
            }
        } else if (partitionList.getSubpartitionType().equalsIgnoreCase("LIST") && partition instanceof PartitionOraclev10g) {
            this.appendListSubPartitions(buffer, ((PartitionOraclev10g)partition).getListPartitions(), prettyPrint);
        }
    }

    protected void appendListSubPartitions(StringBuffer buffer, StorageObjectCollection subpartitions, boolean prettyPrint) {
        if (subpartitions.size() > 0) {
            boolean firstListPart = true;
            Iterator listSubpartitions = subpartitions.iterator();
            CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, '(');
            while (listSubpartitions.hasNext()) {
                ListStorageTemplatePartitionOraclev10g listSubpartition = (ListStorageTemplatePartitionOraclev10g)listSubpartitions.next();
                if (!firstListPart) {
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, ',');
                } else {
                    firstListPart = false;
                }
                CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "SUBPARTITION");
                if (!listSubpartition.getName().toUpperCase().startsWith("SYS_")) {
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(listSubpartition));
                }
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "VALUES");
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, '(');
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, listSubpartition.getValueList());
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, ')');
                this.appendPartStorage(buffer, listSubpartition, prettyPrint);
            }
            CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, ')');
        }
    }

    protected boolean appendHashSubPartitions(StringBuffer buffer, StorageObjectCollection subpartitions, PartitionListOraclev10g partitionList, boolean prettyPrint) {
        boolean result = false;
        if (!partitionList.getUseSubpartStorageTemplate().equalsIgnoreCase("YES")) {
            Iterator it = subpartitions.iterator();
            boolean first = true;
            while (it.hasNext()) {
                HashPartitionOraclev10g hashPartition = (HashPartitionOraclev10g)it.next();
                if (first) {
                    CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, '(');
                    first = false;
                    result = true;
                } else {
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, ',');
                    CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, ' ');
                }
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "SUBPARTITION");
                if (!hashPartition.getName().toUpperCase().startsWith("SYS_")) {
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(hashPartition));
                }
                this.appendPartStorage(buffer, hashPartition, prettyPrint);
            }
            if (!first) {
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, ')');
            }
        }
        return result;
    }

    protected boolean appendHashPartitions(StringBuffer buffer, TableProxyOraclev10g tableProxy, boolean prettyPrint) {
        boolean result = false;
        Iterator it = tableProxy.getPartitions().iterator();
        boolean first = true;
        while (it.hasNext()) {
            HashPartitionOraclev10g hashPartition = (HashPartitionOraclev10g)it.next();
            if (first) {
                CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, '(');
                CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                first = false;
                result = true;
            } else {
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, ',');
                CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            }
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "PARTITION");
            if (!hashPartition.getName().toUpperCase().startsWith("SYS_")) {
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(hashPartition));
            }
            if (hashPartition.getTableSpace() != null && this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "TABLESPACE");
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(hashPartition.getTableSpace()));
            }
            this.appendHashPLobItems(buffer, hashPartition, prettyPrint);
        }
        if (!first) {
            CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, ')');
        }
        return result;
    }

    private void appendHashPLobItems(StringBuffer buffer, HashPartitionOraclev10g hashPartition, boolean prettyPrint) {
        HashPartitionLobItemSetOraclev10g hashPLobItemSet = (HashPartitionLobItemSetOraclev10g)((StorageDesignOraclev10g)hashPartition.getStorageDesign()).getHashPartitionLobItemSet();
        for (HashPartitionLobItemOraclev10g hashPLobItem : hashPLobItemSet) {
            if (hashPLobItem.getHashPartition() == null || !hashPLobItem.getHashPartition().toString().equalsIgnoreCase(hashPartition.toString())) continue;
            CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
            this.appendLobPartitioningStorage(buffer, hashPLobItem, hashPLobItem.getLobColumn(), "", hashPLobItem.getTableSpace(), prettyPrint);
        }
    }

    private void appendLobPartitioningStorage(StringBuffer buffer, StorageObject lobObject, Object column, String lobSegName, TableSpaceOracle tableSpace, boolean prettyPrint) {
        CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "LOB");
        CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, '(');
        if (column instanceof ColumnProxy) {
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName((ColumnProxy)column));
        } else {
            String columnName = "";
            if (column != null) {
                columnName = column.toString();
            }
            if (columnName.length() > 0) {
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(columnName));
            } else {
                CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                buffer.append("--  ERROR: Lob ");
                buffer.append(lobObject.getName());
                buffer.append(" has no Column specified");
                CDDLFileMaker.incrementErrors();
            }
        }
        CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, ')');
        CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "STORE AS");
        if (lobObject instanceof LobStorageOraclev11g) {
            String lobStorageType = ((LobStorageOraclev11g)lobObject).getLobStorageType();
            if (lobStorageType.equalsIgnoreCase("SECUREFILE")) {
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "SECUREFILE");
            } else if (lobStorageType.equalsIgnoreCase("BASICFILE")) {
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "BASICFILE");
            }
        }
        if (!lobSegName.equalsIgnoreCase("")) {
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(lobSegName));
        } else if (tableSpace == null) {
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(lobObject));
        }
        if (tableSpace != null && this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, '(');
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "TABLESPACE");
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(tableSpace));
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, ')');
        }
    }

    private void appendLobStorage(StringBuffer buffer, LobStorageOraclev10g lobStorage, boolean prettyPrint) {
        if (lobStorage != null) {
            CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "LOB");
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, '(');
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(lobStorage.getColumn()));
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, ')');
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "STORE AS");
            if (lobStorage instanceof LobStorageOraclev11g) {
                if (lobStorage.getLobStorageType().equalsIgnoreCase("SECUREFILE")) {
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "SECUREFILE");
                } else if (lobStorage.getLobStorageType().equalsIgnoreCase("BASICFILE")) {
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "BASICFILE");
                }
            }
            CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, '(');
            CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
            if (lobStorage.getTableSpace() != null && this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "TABLESPACE");
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(lobStorage.getTableSpace()));
                CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
            }
            if (this.storageDesign.getAppView().getSettings().isIncludeStorageInDDL()) {
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "STORAGE");
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, '(');
                CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 3);
                boolean props = false;
                if (lobStorage.getSCInitialExtent() > 0L && this.storageDesign.getAppView().getSettings().isIncludeInitialExtentInDDL()) {
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "INITIAL");
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, lobStorage.getSCInitialExtent());
                    CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 3);
                    props = true;
                }
                if (lobStorage.getSCNextExtent() > 0L && this.storageDesign.getAppView().getSettings().isIncludeNextExtentInDDL()) {
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "NEXT");
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, lobStorage.getSCNextExtent());
                    CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 3);
                    props = true;
                }
                if (this.storageDesign.getAppView().getSettings().isIncludePctIncreaseInDDL()) {
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "PCTINCREASE");
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, lobStorage.getSCPctIncrease());
                    CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 3);
                    props = true;
                }
                if (this.storageDesign.getAppView().getSettings().isIncludeMinExtentsInDDL()) {
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "MINEXTENTS");
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, lobStorage.getSCMinExtents());
                    CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 3);
                    props = true;
                }
                if (this.storageDesign.getAppView().getSettings().isIncludeMaxExtentsInDDL()) {
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "MAXEXTENTS");
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, lobStorage.getSCMaxExtents());
                    CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 3);
                    props = true;
                }
                if (this.storageDesign.getAppView().getSettings().isIncludeFreeListsInDDL()) {
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "FREELISTS");
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, lobStorage.getSCFreeLists());
                    CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 3);
                    props = true;
                }
                if (this.storageDesign.getAppView().getSettings().isIncludeFreeListGroupsInDDL() && lobStorage.getSCFreelistGroups() > 1) {
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "FREELIST");
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "GROUPS");
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, lobStorage.getSCFreelistGroups());
                    CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 3);
                    props = true;
                }
                if (this.storageDesign.getAppView().getSettings().isIncludeBufferPoolInDDL()) {
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "BUFFER_POOL");
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, lobStorage.getSCBufferPool());
                    CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                    props = true;
                }
                if (props) {
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, ')');
                } else {
                    buffer = buffer.replace(buffer.lastIndexOf("STORAGE ("), buffer.length(), "");
                }
                CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
            }
            if (lobStorage.getChunk() > 0) {
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "CHUNK");
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, lobStorage.getChunk());
                CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
            }
            if (lobStorage.getOldVersions().equalsIgnoreCase("RETENTION")) {
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "RETENTION");
            } else {
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "PCTVERSION");
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, lobStorage.getPCTVersion());
            }
            if (lobStorage.getFreepools() > 0 && lobStorage.getSCFreelistGroups() <= 1) {
                CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "FREEPOOLS");
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, lobStorage.getFreepools());
            }
            CSSBCreateRenameTableOraclev10g.appendStorageInRow(buffer, this.tableProxy, lobStorage.getStorageInRow(), prettyPrint);
            if (CSSBCreateRenameTableOraclev10g.isSecureFile(lobStorage.getLobStorageType(), (StorageDesignOracle)this.tableProxy.getStorageDesign())) {
                if (lobStorage.getCompression().equalsIgnoreCase("YES")) {
                    CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "COMPRESS");
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, lobStorage.getCompressionType());
                }
                if (lobStorage.getDuplication().equalsIgnoreCase("DEDUPLICATE")) {
                    CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "DEDUPLICATE");
                }
            }
            CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, lobStorage.getCache());
            if (this.storageDesign.getAppView().getSettings().isIncludeLoggingInDDL() && (!"CACHE".equalsIgnoreCase(lobStorage.getCache()) || this.storageDesign instanceof StorageDesignOraclev12c)) {
                String logging = lobStorage.getLogging();
                if (logging.equalsIgnoreCase("YES")) {
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "LOGGING");
                } else if (logging.equalsIgnoreCase("NO")) {
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "NOLOGGING");
                } else if (logging.equalsIgnoreCase("FILESYSTEM_LIKE_LOGGING") && CSSBCreateRenameTableOraclev10g.isSecureFile(lobStorage.getLobStorageType(), (StorageDesignOracle)this.tableProxy.getStorageDesign())) {
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "FILESYSTEM_LIKE_LOGGING");
                }
            }
            CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, ')');
        }
    }

    private void appendSegment(StringBuffer buffer, SegmentOraclev10g segment, boolean pctUsed, boolean prettyPrint, TableSpaceOracle tableSpace, String logging) {
        if (segment != null) {
            if (this.storageDesign.getAppView().getSettings().isIncludeStorageInDDL()) {
                if (this.storageDesign.getAppView().getSettings().isIncludePctFreeInDDL()) {
                    CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "PCTFREE");
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, segment.getPCTFree());
                }
                if (pctUsed && this.storageDesign.getAppView().getSettings().isIncludePctUsedInDDL()) {
                    CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "PCTUSED");
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, segment.getPCTUsed());
                }
                if (this.storageDesign.getAppView().getSettings().isIncludeInitransInDDL()) {
                    if (segment.getInitrans() > 1) {
                        CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                        CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "INITRANS");
                        CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, segment.getInitrans());
                    } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                        CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                        CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "INITRANS");
                        CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "1");
                    }
                    if (!(this.storageDesign instanceof StorageDesignOraclev11g)) {
                        if (segment.getMaxTrans() > 1) {
                            CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "MAXTRANS");
                            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, segment.getMaxTrans());
                        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                            CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "MAXTRANS");
                            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "255");
                        }
                    }
                }
            }
            if (this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
                if (tableSpace != null) {
                    CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "TABLESPACE");
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(tableSpace));
                } else if (segment.getTableSpace() != null) {
                    CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "TABLESPACE");
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(segment.getTableSpace()));
                }
            }
            if (this.storageDesign.getAppView().getSettings().isIncludeLoggingInDDL() && !"".equals(logging)) {
                CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                if (logging.equalsIgnoreCase("NO")) {
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "NOLOGGING");
                } else {
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "LOGGING");
                }
            }
            if (this.storageDesign.getAppView().getSettings().isIncludeStorageInDDL()) {
                CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "STORAGE");
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, '(');
                CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                boolean props = false;
                if (segment.getSCInitialExtent() > 0L && this.storageDesign.getAppView().getSettings().isIncludeInitialExtentInDDL()) {
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "INITIAL");
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, segment.getSCInitialExtent());
                    CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                    props = true;
                }
                if (segment.getSCNextExtent() > 0L && this.storageDesign.getAppView().getSettings().isIncludeNextExtentInDDL()) {
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "NEXT");
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, segment.getSCNextExtent());
                    CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                    props = true;
                }
                if (this.storageDesign.getAppView().getSettings().isIncludePctIncreaseInDDL()) {
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "PCTINCREASE");
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, segment.getSCPctIncrease());
                    CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                    props = true;
                }
                if (this.storageDesign.getAppView().getSettings().isIncludeMinExtentsInDDL()) {
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "MINEXTENTS");
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, segment.getSCMinExtents());
                    CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                    props = true;
                }
                if (this.storageDesign.getAppView().getSettings().isIncludeMaxExtentsInDDL()) {
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "MAXEXTENTS");
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, segment.getSCMaxExtents());
                    CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                    props = true;
                }
                if (this.storageDesign.getAppView().getSettings().isIncludeFreeListsInDDL()) {
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "FREELISTS");
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, segment.getSCFreeLists());
                    CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                    props = true;
                }
                if (this.storageDesign.getAppView().getSettings().isIncludeFreeListGroupsInDDL()) {
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "FREELIST");
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "GROUPS");
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, segment.getSCFreelistGroups());
                    CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                    props = true;
                }
                if (this.storageDesign.getAppView().getSettings().isIncludeBufferPoolInDDL()) {
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "BUFFER_POOL");
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, segment.getSCBufferPool());
                    CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                    props = true;
                }
                if (props) {
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, ')');
                } else {
                    buffer = buffer.replace(buffer.lastIndexOf("STORAGE ("), buffer.length(), "");
                }
            }
        }
    }

    private void appendOrganization(StringBuffer buffer, TableProxyOraclev10g tableProxy, boolean prettyPrint) {
        boolean indexOrg = "INDEX".equalsIgnoreCase(tableProxy.getOrganization());
        if (indexOrg) {
            CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "ORGANIZATION");
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "INDEX");
        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL() && !((Table)tableProxy.getObject()).isBST()) {
            CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "ORGANIZATION");
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "HEAP");
        }
        if (tableProxy.getSegment() != null) {
            this.appendSegment(buffer, (SegmentOraclev10g)tableProxy.getSegment(), !indexOrg, prettyPrint, tableProxy.getTableSpace(), tableProxy.getLogging());
        } else {
            TableSpaceOracle tableSpace;
            if (this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL() && (tableSpace = tableProxy.getTableSpace()) != null && !"[NONE]".equalsIgnoreCase(tableSpace.getName())) {
                CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "TABLESPACE");
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(tableSpace));
            }
            if (this.storageDesign.isOpen() && this.storageDesign.getAppView().getSettings().isIncludeLoggingInDDL()) {
                if ("YES".equalsIgnoreCase(tableProxy.getLogging())) {
                    CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "LOGGING");
                } else if ("NO".equalsIgnoreCase(tableProxy.getLogging())) {
                    CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "NOLOGGING");
                }
            }
        }
        if (indexOrg) {
            if (tableProxy.getIOTMappingTable().equalsIgnoreCase("YES")) {
                CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "MAPPING TABLE");
            }
            if (tableProxy.getIotPctThreshold() > 0) {
                CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "PCTTHRESHOLD");
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, tableProxy.getIotPctThreshold());
            } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "PCTTHRESHOLD");
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "50");
            }
            if (tableProxy.getIotCompress() > 0) {
                CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "COMPRESS");
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, tableProxy.getIotCompress());
            } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "NOCOMPRESS");
            }
            TableSpaceOracle overflowTableSpace = tableProxy.getIotOverflowTablespace();
            String overflowLogging = tableProxy.getIotOverflowLogging();
            SegmentOraclev10g overflowSegment = (SegmentOraclev10g)tableProxy.getIotOverflowSegment();
            ColumnProxy includingColumn = tableProxy.getIotIncluding();
            if (overflowTableSpace != null || !overflowLogging.equals("") || overflowSegment != null || includingColumn != null) {
                CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                if (includingColumn != null) {
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "INCLUDING");
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(includingColumn));
                    CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                }
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "OVERFLOW");
                if (overflowTableSpace == null) {
                    overflowTableSpace = tableProxy.getTableSpace();
                }
                if (overflowLogging.equals("")) {
                    overflowLogging = tableProxy.getLogging();
                }
                if (overflowSegment != null) {
                    this.appendSegment(buffer, overflowSegment, true, prettyPrint, overflowTableSpace, overflowLogging);
                } else {
                    if (overflowTableSpace != null && this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
                        CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                        CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "TABLESPACE");
                        CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(overflowTableSpace));
                    }
                    if (this.storageDesign.isOpen() && this.storageDesign.getAppView().getSettings().isIncludeLoggingInDDL()) {
                        if ("NO".equalsIgnoreCase(overflowLogging)) {
                            CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "NOLOGGING");
                        } else if ("YES".equalsIgnoreCase(overflowLogging)) {
                            CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "LOGGING");
                        }
                    }
                }
            }
        } else {
            if (tableProxy.getDataSegmentCompression().equalsIgnoreCase("YES")) {
                CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                if (tableProxy instanceof TableProxyOraclev11g) {
                    String compressionType = ((TableProxyOraclev11g)tableProxy).getCompressionType();
                    if (compressionType.length() == 0) {
                        CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "COMPRESS");
                    } else if (this.storageDesign instanceof StorageDesignOraclev12c) {
                        if (compressionType.equals("BASIC") || compressionType.equals("ADVANCED")) {
                            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "ROW");
                            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "STORE");
                            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "COMPRESS");
                        } else {
                            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "COLUMN");
                            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "STORE");
                            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "COMPRESS");
                            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "FOR");
                        }
                        CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, compressionType);
                    } else {
                        CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "COMPRESS");
                        if (!compressionType.equals("BASIC")) {
                            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "FOR");
                            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, compressionType);
                        }
                    }
                }
            } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "NOCOMPRESS");
            }
            if (tableProxy instanceof TableProxyOraclev12c) {
                TableProxyOraclev12c tableProxy12c = (TableProxyOraclev12c)tableProxy;
                String inMemory = tableProxy12c.getInMemory();
                if (inMemory.equals("YES")) {
                    String inMemoryDuplicate;
                    String inMemoryDistribute;
                    String inMemoryPriority;
                    CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "INMEMORY");
                    String inMemoryCompression = tableProxy12c.getInMemoryCompression();
                    if (!inMemoryCompression.isEmpty()) {
                        if (!inMemoryCompression.equals("NO MEMCOMPRESS")) {
                            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "MEMCOMPRESS");
                        }
                        CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, inMemoryCompression);
                    }
                    if (!(inMemoryPriority = tableProxy12c.getInMemoryPriority()).isEmpty()) {
                        CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "PRIORITY");
                        CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, inMemoryPriority);
                    }
                    if (!(inMemoryDistribute = tableProxy12c.getInMemoryDistribute()).isEmpty()) {
                        CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "DISTRIBUTE");
                        CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, inMemoryDistribute);
                    }
                    if (!(inMemoryDuplicate = tableProxy12c.getInMemoryDuplicate()).isEmpty()) {
                        CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, inMemoryDuplicate);
                    }
                } else if (inMemory.equals("NO")) {
                    CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "NO");
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "INMEMORY");
                }
            }
        }
    }

    private void appendCluster(StringBuffer buffer, TableProxyOraclev10g tableProxy, boolean prettyPrint) {
        ClusterOraclev10g cluster = (ClusterOraclev10g)tableProxy.getCluster();
        if (cluster != null) {
            CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "CLUSTER");
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(cluster));
            if (!"".equalsIgnoreCase(tableProxy.getClusterColumns())) {
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, '(');
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedColumnNamesFromIDs(tableProxy.getClusterColumns()));
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, ')');
            }
        } else {
            this.appendOrganization(buffer, tableProxy, prettyPrint);
            Table table = (Table)this.tableObj.getObject();
            if (!table.isSpatialTable()) {
                for (int i = 0; i < tableProxy.getLobStorages().size(); ++i) {
                    this.appendLobStorage(buffer, (LobStorageOraclev10g)tableProxy.getLobStorages().getElement(i), prettyPrint);
                }
            }
        }
    }

    private void appendUniqueDefinition(StringBuffer oldbuffer, TableProxyOracle tableProxy, UniqueOraclev10g unique, boolean prettyPrint, StringBuffer columnList) {
        StringBuffer buffer = new StringBuffer();
        String advancedComment = "";
        CSSBCreateRenameTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
        if (unique.isCommentChanged() && !"".equalsIgnoreCase(unique.getComment())) {
            this.appendComment(oldbuffer, unique);
        } else if (!"".equalsIgnoreCase(unique.getObject().getComment())) {
            this.appendComment(oldbuffer, unique.getObject());
        }
        String uniqueName = unique.getName();
        if (uniqueName.length() > tableProxy.getMaxNameLength()) {
            CSSBCreateRenameTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(oldbuffer, "--  ERROR: UK name length exceeds maximum allowed length(" + tableProxy.getMaxNameLength() + ")");
            CSSBCreateRenameTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
            CDDLFileMaker.incrementErrors();
        }
        CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "ALTER");
        CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "TABLE");
        CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, CSSBCreateRenameTableOraclev10g.getFormattedTableName(this.tableObj, this.storageDesign));
        CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
        CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "ADD");
        if (!uniqueName.startsWith("SYS_")) {
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "CONSTRAINT");
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(unique));
        }
        advancedComment = buffer.toString();
        CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "UNIQUE");
        CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, '(');
        this.appendString(buffer, columnList);
        CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, ')');
        if (!"NO".equalsIgnoreCase(unique.getDeferrable())) {
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "DEFERRABLE");
            if ("DEFERRED".equalsIgnoreCase(unique.getInitially())) {
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "INITIALLY");
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "DEFERRED");
            } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "INITIALLY");
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "IMMEDIATE");
            }
        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "NOT");
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "DEFERRABLE");
        }
        if (!"NO".equalsIgnoreCase(unique.getUsingIndex())) {
            this.appendUniqueUsingIndex(buffer, unique, tableProxy, prettyPrint);
        }
        if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            if ("YES".equalsIgnoreCase(unique.getEnable())) {
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "ENABLE");
            } else {
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "DISABLE");
            }
            if ("YES".equalsIgnoreCase(unique.getValidate())) {
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "VALIDATE");
            } else {
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "NOVALIDATE");
            }
        } else {
            if (!"YES".equalsIgnoreCase(unique.getEnable())) {
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "DISABLE");
                if ("YES".equalsIgnoreCase(unique.getValidate())) {
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "VALIDATE");
                }
            }
            if (!"YES".equalsIgnoreCase(unique.getValidate())) {
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "NOVALIDATE");
            }
        }
        this.appendToBuffer(oldbuffer, buffer, advancedComment);
        CSSBCreateRenameTableOraclev10g.appendLineFinisher(buffer, prettyPrint);
        CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 0);
        this.appendToBuffer(oldbuffer, buffer, advancedComment);
        CDDLFileMaker.incrementAlterTable();
        if (unique.getRely().equals("YES")) {
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "ALTER");
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "TABLE");
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, CSSBCreateRenameTableOraclev10g.getFormattedTableName(this.tableObj, this.storageDesign));
            CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "MODIFY");
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "CONSTRAINT");
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(unique));
            advancedComment = buffer.toString();
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "RELY");
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            CSSBCreateRenameTableOraclev10g.appendLineFinisher(buffer, prettyPrint);
            CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            CDDLFileMaker.incrementAlterTable();
        }
        if (unique.getExceptionsTable() != null && "YES".equalsIgnoreCase(unique.getEnable())) {
            CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "ALTER");
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "TABLE");
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, CSSBCreateRenameTableOraclev10g.getFormattedTableName(this.tableObj, this.storageDesign));
            advancedComment = buffer.toString();
            CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "MODIFY");
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "CONSTRAINT");
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(unique));
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "ENABLE EXCEPTIONS INTO");
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(unique.getExceptionsTable()));
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            CSSBCreateRenameTableOraclev10g.appendLineFinisher(buffer, prettyPrint);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            CDDLFileMaker.incrementAlterTable();
        }
    }

    private void appendPermissions(StringBuffer oldbuffer, TableProxyOracle tableProxy, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        Object advancedComments = "";
        PermissionsSetOracle permissionsSet = ((StorageDesignOracle)tableProxy.getStorageDesign()).getPermissionsSet();
        for (PermissionsOraclev10g permissions : permissionsSet) {
            if (permissions.getTable() != null && permissions.getTable().equals(tableProxy)) {
                if (!permissions.getPrivileges().equalsIgnoreCase("")) {
                    CSSBCreateRenameTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
                    CSSBCreateRenameTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
                    this.appendComment(oldbuffer, permissions);
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "GRANT");
                    this.appendPrivileges(buffer, permissions);
                    this.appendObject(buffer, permissions, prettyPrint);
                    this.appendTo(buffer, permissions, this.storageDesign);
                    this.appendHierrarchyOption(buffer, permissions, prettyPrint);
                    advancedComments = "GRANT ON " + this.getPermissionsON(permissions) + " TO " + this.getPermissionsTO(permissions);
                    this.appendToBuffer(oldbuffer, buffer, (String)advancedComments);
                    CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                    buffer.append(';');
                    CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                    this.appendToBuffer(oldbuffer, buffer, (String)advancedComments);
                }
                if (!permissions.getPrivilegesWithGrantOption().equalsIgnoreCase("")) {
                    CSSBCreateRenameTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
                    CSSBCreateRenameTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
                    this.appendComment(oldbuffer, permissions);
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "GRANT");
                    this.appendPrivilegesWithGrantOption(buffer, permissions);
                    this.appendObject(buffer, permissions, prettyPrint);
                    this.appendTo(buffer, permissions, this.storageDesign);
                    this.appendGrantOption(buffer, permissions);
                    this.appendHierrarchyOption(buffer, permissions, prettyPrint);
                    advancedComments = "GRANT ON " + this.getPermissionsON(permissions) + " TO " + this.getPermissionsTO(permissions);
                    this.appendToBuffer(oldbuffer, buffer, (String)advancedComments);
                    CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                    buffer.append(';');
                    CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                    this.appendToBuffer(oldbuffer, buffer, (String)advancedComments);
                }
            }
            if (permissions.getColumnsTable() == null || !permissions.getColumnsTable().equals(tableProxy)) continue;
            for (int i = 0; i < 2; ++i) {
                List<String> colEntries = i == 0 ? permissions.getColumnEntries() : permissions.getColumnWithGrantOptionEntries();
                block2: for (String colEntry : colEntries) {
                    int commaIndex = colEntry.indexOf(44);
                    if (commaIndex <= -1) continue;
                    String colName = colEntry.substring(0, commaIndex).trim();
                    String colPriv = colEntry.substring(commaIndex + 1).trim();
                    if (colName.length() <= 0 || colPriv.length() <= 0) continue;
                    List columns = this.tableObj.getChildObjects(0);
                    for (CompareObjectSelection columnSel : columns) {
                        ModelIDObject column = columnSel.getObject();
                        if (column == null || !column.getName().equals(colName)) continue;
                        if (columnSel.canBeCreate() && !columnSel.isSelected()) continue block2;
                        CSSBCreateRenameTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
                        CSSBCreateRenameTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
                        CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "GRANT");
                        CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, colPriv);
                        CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, '(');
                        CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, CSSBCreateRenameTableOraclev10g.getFormattedSelectedName(columnSel, this.storageDesign));
                        CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, ')');
                        this.appendObject(buffer, permissions, prettyPrint);
                        this.appendTo(buffer, permissions, this.storageDesign);
                        if (i > 0) {
                            this.appendGrantOption(buffer, permissions);
                        }
                        advancedComments = buffer.toString();
                        this.appendToBuffer(oldbuffer, buffer, (String)advancedComments);
                        CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                        buffer.append(';');
                        CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                        this.appendToBuffer(oldbuffer, buffer, (String)advancedComments);
                        continue block2;
                    }
                }
            }
        }
    }

    private String getPermissionsTO(PermissionsOraclev10g permissions) {
        if (permissions.getUser() != null) {
            return permissions.getUser().getName();
        }
        if (permissions.getRole() != null) {
            return permissions.getRole().getName();
        }
        return "";
    }

    private String getPermissionsON(PermissionsOraclev10g permissions) {
        if (permissions.getTable() != null) {
            return permissions.getTable().getLongNameDDL();
        }
        if (permissions.getColumnsTable() != null) {
            return permissions.getColumnsTable().getLongNameDDL();
        }
        return "";
    }

    private void appendPrivileges(StringBuffer buffer, PermissionsOraclev10g permissions) {
        buffer.append(permissions.getPrivileges());
    }

    private void appendPrivilegesWithGrantOption(StringBuffer buffer, PermissionsOraclev10g permissions) {
        buffer.append(permissions.getPrivilegesWithGrantOption());
    }

    private void appendObject(StringBuffer buffer, PermissionsOraclev10g permissions, boolean prettyPrint) {
        if (permissions.getTable() != null || permissions.getColumnsTable() != null) {
            CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "ON");
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, CSSBCreateRenameTableOraclev10g.getFormattedTableName(this.tableObj, this.storageDesign));
        }
    }

    private void appendGrantOption(StringBuffer buffer, PermissionsOraclev10g permissions) {
        if (permissions.getRole() == null) {
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "WITH GRANT OPTION");
        }
    }

    private void appendHierrarchyOption(StringBuffer buffer, PermissionsOraclev10g permissions, boolean prettyPrint) {
        if ("YES".equalsIgnoreCase(permissions.getHierarchyOption())) {
            CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "WITH HIERARCHY OPTION");
        }
    }

    private void appendIndexes(StringBuffer oldbuffer, TableProxyOracle tableProxy, CompareObjectSelection engObject, boolean prettyPrint) {
        this.appendIndexes(oldbuffer, engObject, prettyPrint);
        this.appendPKAndUK(oldbuffer, engObject, prettyPrint);
    }

    private void appendTableLevelCheckConstraints(StringBuffer oldbuffer, TableSelection tableSel, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        List tableConstraints = tableSel.getChildObjects(4);
        for (CompareObjectSelection constraintObj : tableConstraints) {
            TableCheckConstraintOracle constraint;
            String rule;
            TableLevelConstraint tlc;
            TableProxyOracle tableProxy;
            TableComparator tableComp = (TableComparator)tableSel.getPropertiesComparator();
            if (!constraintObj.isSelected()) {
                constraintObj = constraintObj.getCorrespondentNode();
                tableProxy = (TableProxyOracle)tableComp.getTargetTableProxy();
            } else {
                tableProxy = (TableProxyOracle)tableComp.getSourceTableProxy();
            }
            if ((tlc = (TableLevelConstraint)constraintObj.getObject()) == null || tableProxy == null || !tlc.isGenerateInDDL() || "".equals(rule = tlc.getRule()) || (constraint = tableProxy.getTableConstraint(tlc)) == null) continue;
            String cname = constraint.getName().toUpperCase();
            if (cname.startsWith("SYS_") || cname.startsWith("NULL SET GENERATED_")) {
                cname = "";
            }
            CSSBCreateRenameTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
            CSSBCreateRenameTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
            if (cname.length() > constraint.getMaxNameLength()) {
                CSSBCreateRenameTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(oldbuffer, "--  ERROR: Table constraint name length exceeds maximum allowed length(" + constraint.getMaxNameLength() + ")");
                CSSBCreateRenameTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
                CDDLFileMaker.incrementErrors();
            }
            String formatedConstraintName = this.storageDesign.getFormatedName(constraint);
            String formattedLongName = CSSBCreateRenameTableOraclev10g.getFormattedTableName(this.tableObj, this.storageDesign);
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "ALTER");
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "TABLE");
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, formattedLongName);
            CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "ADD");
            if (!"".equals(cname)) {
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "CONSTRAINT");
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, formatedConstraintName);
            }
            CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "CHECK");
            CSSBCreateRenameTableOraclev10g.appendString(buffer, '(');
            CSSBCreateRenameTableOraclev10g.appendString(buffer, constraint.getTableConstraint().getRule());
            CSSBCreateRenameTableOraclev10g.appendString(buffer, ')');
            this.appendTableConstraintState(buffer, constraint, prettyPrint);
            String advancedComments = "Alter Table " + formattedLongName + " Add Constraint " + formatedConstraintName;
            this.appendToBuffer(oldbuffer, buffer, advancedComments);
            CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            buffer.append(';');
            CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            this.appendToBuffer(oldbuffer, buffer, "");
            CDDLFileMaker.incrementAlterTable();
        }
    }

    private void appendColumnCheckConstraints(StringBuffer oldbuffer, TableProxyOracle tableProxy, boolean prettyPrint) {
        if (!this.storageDesign.getAppView().getSettings().isGenerateInlineColumnCC()) {
            TableComparator tableComp = (TableComparator)this.tableObj.getPropertiesComparator();
            TableProxyOraclev10g sourceTableProxy = (TableProxyOraclev10g)tableComp.getSourceTableProxy();
            TableProxyOraclev10g targetTableProxy = (TableProxyOraclev10g)tableComp.getTargetTableProxy();
            List columns = this.tableObj.getChildObjects(0);
            for (CompareObjectSelection columnSelection : columns) {
                if (columnSelection.canBeCreate() && !columnSelection.isSelected() || columnSelection.canBeDrop() && columnSelection.isSelected()) continue;
                Column column = (Column)columnSelection.getObject();
                ColumnProxyOraclev10g columnProxy = null;
                boolean targetSelected = false;
                if (column == null || !columnSelection.isSelected()) {
                    column = (Column)columnSelection.getCorrespondentNode().getObject();
                    if (column == null) continue;
                    targetSelected = true;
                    columnProxy = (ColumnProxyOraclev10g)targetTableProxy.getColumnProxy(column.getObjectID());
                } else {
                    columnProxy = (ColumnProxyOraclev10g)sourceTableProxy.getColumnProxy(column.getObjectID());
                }
                StringBuffer tempBuffer = new StringBuffer();
                CSSBCreateRenameTableOraclev10g.appendColumnConstraints(tempBuffer, column, columnProxy, prettyPrint, columnSelection);
                if (tempBuffer.length() <= 0) continue;
                StringBuffer buffer = new StringBuffer();
                String formattedLongName = CSSBCreateRenameTableOraclev10g.getFormattedTableName(this.tableObj, this.storageDesign);
                CSSBCreateRenameTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
                CSSBCreateRenameTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "ALTER");
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "TABLE");
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, formattedLongName);
                CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "ADD");
                this.appendString(buffer, tempBuffer);
                String advancedComments = "Alter Table " + formattedLongName + " Add Constraint";
                this.appendToBuffer(oldbuffer, buffer, advancedComments);
                CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                buffer.append(';');
                CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                this.appendToBuffer(oldbuffer, buffer, "");
                CDDLFileMaker.incrementAlterTable();
            }
        }
    }

    private StringBuffer getColumnsForRestore(CompareObjectSelection engObject, Index index, boolean prettyPrint, boolean getColumnSortOrder) {
        StringBuffer columnList = new StringBuffer();
        boolean notFirst = false;
        List sourceColumns = engObject.getChildObjects(0);
        block0: for (Column indexCol : index.getElementsCollection()) {
            for (CompareObjectSelection tableCol : sourceColumns) {
                ModelIDObject column = tableCol.getObject();
                if (column == null || !column.equals(indexCol)) continue;
                if (tableCol.canBeCreate() && !tableCol.isSelected() || tableCol.canBeDrop() && tableCol.getCorrespondentNode().isSelected()) continue block0;
                if (notFirst) {
                    columnList.append(',');
                    CSSBCreateRenameTableOraclev10g.appendNewLine(columnList, prettyPrint, 1);
                    columnList.append(' ');
                }
                String formattedColumnName = tableCol.isSelected() ? CSSBCreateRenameTableOraclev10g.getFormattedSelectedName(tableCol, this.storageDesign) : this.storageDesign.getFormatedName(tableCol.getCorrespondentNode().getObject());
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(columnList, formattedColumnName);
                if (getColumnSortOrder) {
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(columnList, index.getColumnSortOrder(tableCol.getObject()));
                }
                notFirst = true;
                continue block0;
            }
        }
        return columnList;
    }

    public boolean isRenamed() {
        return this.isRenamed;
    }

    public void setRenamed(boolean isRenamed) {
        this.isRenamed = isRenamed;
    }

    protected String getFormattedColumnName(CompareObjectSelection columnSelection) {
        if (!columnSelection.isSelected()) {
            StorageDesign targetStorageDesign;
            Design targetDesign;
            Column targetColumn;
            ColumnComparator comp = (ColumnComparator)columnSelection.getPropertiesComparator();
            ColumnProxy targetColumnProxy = comp.getTargetColumnProxy();
            if (targetColumnProxy == null && (targetColumn = comp.getTargetColumn()) != null && (targetDesign = targetColumn.getDesign()) != null && (targetStorageDesign = targetDesign.getStorageDesign(targetDesign.getSelectedRDBMSSite())) != null) {
                targetColumnProxy = (ColumnProxyOracle)targetStorageDesign.getColumnProxySet().getObjectByID(targetColumn.getObjectID());
            }
            if (targetColumnProxy != null) {
                return this.storageDesign.getFormatedName(targetColumnProxy);
            }
        }
        return CSSBCreateRenameTableOraclev10g.getFormattedSelectedName(columnSelection, this.storageDesign);
    }

    private void createExtDirectory(StringBuffer oldbuffer, TableSelection object, boolean prettyPrint) {
        Design design;
        StringBuffer buffer = new StringBuffer();
        Table table = null;
        TableProxyOracle tableProxy = null;
        if (object == null) {
            return;
        }
        if (object.getObject() instanceof Table) {
            table = (Table)object.getObject();
            design = table.getDesign();
            RDBMSSite site = design.getSelectedRDBMSSite();
            this.storageDesign = (StorageDesignOracle)design.getStorageDesign(site, table);
            tableProxy = (TableProxyOraclev10g)this.storageDesign.getTableProxySet().getProxy(table.getObjectID());
        } else if (object.getObject() instanceof TableProxyOracle) {
            tableProxy = (TableProxyOracle)object.getObject();
            table = (Table)tableProxy.getObject();
            design = table.getDesign();
            this.storageDesign = (StorageDesignOraclev10g)design.getStorageDesign(design.getSelectedRDBMSSite(), table);
        } else {
            return;
        }
        TableSelection other = (TableSelection)object.getCorrespondentNode();
        String unloadDir = other.getUnloadDirectory();
        if ("".equals(unloadDir)) {
            unloadDir = other.getObject().getDesign().getUnloadDirectory();
        }
        CSSBCreateRenameTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
        CSSBCreateRenameTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
        CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "CREATE OR REPLACE DIRECTORY");
        this.directoryName = table.getName() + "_dir";
        if (this.directoryName.length() > 30) {
            this.directoryName = table.getName();
        }
        CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(this.directoryName));
        CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
        CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "AS");
        CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "'" + unloadDir + "'");
        this.appendToBuffer(oldbuffer, buffer, buffer.toString());
        CSSBCreateRenameTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
        CSSBCreateRenameTableOraclev10g.appendLineFinisher(buffer, prettyPrint);
    }

    private String newline() {
        return SQLStatementBuilder.NEWLINE;
    }

    public String newTab() {
        return "    ";
    }

    private String getColumnAndTypePresentation(String name, String type, Design design) {
        String u_type = type.toUpperCase();
        if (u_type.indexOf("CHAR") > -1) {
            String betweenBrackets = Token.getValBetweenBrackets(u_type);
            if (betweenBrackets.length() > 0) {
                return name + " CHAR (" + Token.getFirstToken(betweenBrackets) + ")";
            }
            if ((u_type.equals("CHAR") || u_type.equals("NCHAR")) && design.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                return name + " CHAR (1)";
            }
        } else {
            if (u_type.indexOf("DATE") > -1) {
                return name + " CHAR DATE_FORMAT DATE MASK '" + design.getEngDateFormat() + "'";
            }
            if (u_type.indexOf("TIMESTAMP") > -1) {
                if (u_type.indexOf("ZONE") == -1) {
                    return name + " CHAR DATE_FORMAT TIMESTAMP MASK '" + design.getEngTimestampFormat() + "'";
                }
                if (u_type.indexOf("LOCAL") == -1) {
                    return name + " CHAR DATE_FORMAT TIMESTAMP WITH TIMEZONE MASK '" + design.getEngTimestampWTZFormat() + "'";
                }
                return name + " CHAR DATE_FORMAT TIMESTAMP WITH LOCAL TIMEZONE MASK '" + design.getEngTimestampFormat() + "'";
            }
        }
        return name;
    }

    private void addColumnsAndTransforms(StringBuffer buffer, TableProxy tableproxy, TableSelection object) {
        List columns = object.getChildObjects(0);
        Design design = tableproxy.getDesign();
        if (columns.size() > 0) {
            boolean first = true;
            StringBuffer transformBuffer = new StringBuffer();
            for (CompareObjectSelection column : columns) {
                CompareObjectSelection targetColumn;
                if (column.canBeCreate() || column.canBeDrop() && column.isSelected() || this.isVirtualColumn(targetColumn = column.getCorrespondentNode())) continue;
                Object name = CSSBCreateRenameTableOraclev10g.getFormattedSelectedName(column, this.storageDesign);
                if (!((String)name).startsWith("\"")) {
                    name = "\"" + ((String)name).toUpperCase() + "\"";
                }
                Object ndata_type = "";
                Column col = (Column)targetColumn.getObject();
                if (col != null) {
                    ndata_type = col.getDatatypeString(tableproxy.getStorageDesign().getRDBMSType().getName());
                    if ((((String)ndata_type).equals("CHAR") || ((String)ndata_type).equals("NCHAR")) && this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                        ndata_type = (String)ndata_type + " (1)";
                    } else if (((String)ndata_type).equals("UROWID") && this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                        ndata_type = (String)ndata_type + " (4000)";
                    }
                }
                if (first) {
                    buffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab());
                    buffer.append('(');
                    first = false;
                } else {
                    buffer.append(',');
                }
                buffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
                if (((String)ndata_type).equals("BLOB") || ((String)ndata_type).equals("CLOB") || ((String)ndata_type).equals("NCLOB") || ((String)ndata_type).equals("XMLTYPE")) {
                    Object lobFileField = name;
                    if (((String)lobFileField).startsWith("\"")) {
                        lobFileField = ((String)lobFileField).substring(1, ((String)lobFileField).length() - 1);
                    }
                    lobFileField = (String)lobFileField + "_fil";
                    buffer.append((String)lobFileField);
                    if (transformBuffer.length() > 0) {
                        transformBuffer.append(',');
                    }
                    transformBuffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
                    transformBuffer.append((String)name).append(" FROM LOBFILE ");
                    transformBuffer.append('(').append((String)lobFileField).append(')');
                    if (!((String)ndata_type).equals("BLOB") && !((String)ndata_type).equals("LONG RAW")) continue;
                    transformBuffer.append(" BLOB");
                    continue;
                }
                buffer.append(this.getColumnAndTypePresentation((String)name, (String)ndata_type, design));
            }
            if (!first) {
                buffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab());
                buffer.append(')');
                if (transformBuffer.length() > 0) {
                    buffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab());
                    buffer.append("COLUMN TRANSFORMS");
                    buffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab());
                    buffer.append('(');
                    buffer.append(transformBuffer);
                    buffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab());
                    buffer.append(')');
                }
            }
        }
    }

    private void createExtTable(StringBuffer oldbuffer, String extTableName, TableSelection object, String fileName, boolean prettyPrint) {
        Design design;
        StringBuffer buffer = new StringBuffer();
        Table table = null;
        TableProxyOracle tableProxy = null;
        if (object == null) {
            return;
        }
        if (object.getObject() instanceof Table) {
            table = (Table)object.getObject();
            design = table.getDesign();
            RDBMSSite site = design.getSelectedRDBMSSite();
            this.storageDesign = (StorageDesignOracle)design.getStorageDesign(site, table);
            tableProxy = (TableProxyOraclev10g)this.storageDesign.getTableProxySet().getProxy(table.getObjectID());
        } else if (object.getObject() instanceof TableProxyOracle) {
            tableProxy = (TableProxyOracle)object.getObject();
            table = (Table)tableProxy.getObject();
            design = table.getDesign();
            this.storageDesign = (StorageDesignOraclev10g)design.getStorageDesign(design.getSelectedRDBMSSite(), table);
        }
        CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "CREATE");
        CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "TABLE");
        CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, extTableName);
        String advancedcomment = buffer.toString();
        this.appendElementListExt(buffer, tableProxy, object, prettyPrint);
        CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
        CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "ORGANIZATION");
        CSSBCreateRenameTableOraclev10g.appendString(buffer, "EXTERNAL");
        CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
        CSSBCreateRenameTableOraclev10g.appendString(buffer, '(');
        CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
        CSSBCreateRenameTableOraclev10g.appendString(buffer, "TYPE oracle_loader");
        CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
        CSSBCreateRenameTableOraclev10g.appendString(buffer, "DEFAULT DIRECTORY " + this.storageDesign.getFormatedName(this.directoryName));
        CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
        CSSBCreateRenameTableOraclev10g.appendString(buffer, "ACCESS PARAMETERS");
        CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
        CSSBCreateRenameTableOraclev10g.appendString(buffer, '(');
        CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 3);
        CSSBCreateRenameTableOraclev10g.appendString(buffer, "RECORDS DELIMITED BY '|@*|\\r\\n'");
        CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 3);
        CSSBCreateRenameTableOraclev10g.appendString(buffer, "FIELDS TERMINATED BY '|' OPTIONALLY ENCLOSED BY '\"' NOTRIM");
        this.addColumnsAndTransforms(buffer, tableProxy, object);
        CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
        CSSBCreateRenameTableOraclev10g.appendString(buffer, ')');
        CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
        CSSBCreateRenameTableOraclev10g.appendString(buffer, "LOCATION");
        CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
        CSSBCreateRenameTableOraclev10g.appendString(buffer, '(');
        CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 3);
        CSSBCreateRenameTableOraclev10g.appendString(buffer, "'" + fileName + ".txt'");
        CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
        CSSBCreateRenameTableOraclev10g.appendString(buffer, ')');
        CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
        CSSBCreateRenameTableOraclev10g.appendString(buffer, ") REJECT LIMIT 0");
        this.appendToBuffer(oldbuffer, buffer, advancedcomment);
        CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 0);
        CSSBCreateRenameTableOraclev10g.appendLineFinisher(buffer, prettyPrint);
        this.appendToBuffer(oldbuffer, buffer, buffer.toString());
        CDDLFileMaker.incrementCreateTable();
    }

    private void dropExtTable(StringBuffer oldbuffer, String extTableName, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        CSSBCreateRenameTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
        CSSBCreateRenameTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
        CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "DROP");
        CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "TABLE");
        CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, extTableName);
        this.appendToBuffer(oldbuffer, buffer, buffer.toString());
        CSSBCreateRenameTableOraclev10g.appendLineFinisher(buffer, prettyPrint);
        this.appendToBuffer(oldbuffer, buffer, buffer.toString());
        CDDLFileMaker.incrementDropTable();
    }

    private void dropExtDir(StringBuffer oldbuffer, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        CSSBCreateRenameTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
        CSSBCreateRenameTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
        CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, "DROP DIRECTORY");
        CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(this.directoryName));
        this.appendToBuffer(oldbuffer, buffer, buffer.toString());
        CSSBCreateRenameTableOraclev10g.appendLineFinisher(buffer, prettyPrint);
        this.appendToBuffer(oldbuffer, buffer, buffer.toString());
    }

    private void appendElementListExt(StringBuffer buffer, TableProxyOracle tableProxy, TableSelection object, boolean prettyPrint) {
        List columns = object.getChildObjects(0);
        if (columns.size() > 0) {
            boolean first = true;
            for (CompareObjectSelection column : columns) {
                Object dataType;
                CompareObjectSelection targetColumn;
                if (column.canBeCreate() || column.canBeDrop() && column.isSelected() || this.isVirtualColumn(targetColumn = column.getCorrespondentNode())) continue;
                if (first) {
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, '(');
                    first = false;
                } else {
                    CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, ',');
                }
                CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                CSSBCreateRenameTableOraclev10g.appendString(buffer, ' ');
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, CSSBCreateRenameTableOraclev10g.getFormattedSelectedName(column, this.storageDesign));
                Column col = (Column)targetColumn.getObject();
                if (col == null) {
                    dataType = targetColumn.getChoosedPropertyValue(PropertiesComparator.DATA_TYPE);
                } else {
                    dataType = col.getDatatypeString(tableProxy.getStorageDesign().getRDBMSType().getName());
                    if ((((String)dataType).equals("CHAR") || ((String)dataType).equals("NCHAR")) && this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                        dataType = (String)dataType + " (1)";
                    } else if (((String)dataType).equals("UROWID") && this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                        dataType = (String)dataType + " (4000)";
                    }
                }
                if (((String)dataType).equalsIgnoreCase("XMLTYPE")) {
                    dataType = "CLOB";
                } else if (((String)dataType).equalsIgnoreCase("BFILE")) {
                    dataType = "VARCHAR2 (255 BYTE)";
                }
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, (String)dataType);
            }
            if (!first) {
                CSSBCreateRenameTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                CSSBCreateRenameTableOraclev10g.appendStringWithSpace(buffer, ')');
            }
        }
    }

    private void appendBitmapJoinIndexes(StringBuffer oldbuffer, TableProxyOraclev10g sourceProxy, boolean prettyPrint) {
        for (Object object : sourceProxy.getBjIndexes()) {
            BitmapJoinIndexOraclev10g index;
            if (this.ssbBJIndex == null) {
                this.ssbBJIndex = new SSBCreateBitmapJoinIndexOraclev10g();
            }
            if ((index = (BitmapJoinIndexOraclev10g)object).getIndexColumnSet().size() <= 0 || !this.ssbBJIndex.canHandle(object)) continue;
            this.ssbBJIndex.doAppendBJIndex(oldbuffer, object, prettyPrint);
        }
    }

    private void appendAutoIncTriggers(StringBuffer oldbuffer, TableProxyOraclev10g sourceProxy, boolean prettyPrint) {
        Table table = (Table)sourceProxy.getObject();
        for (Column column : table.getElementsCollection()) {
            if (!column.isAutoIncrementColumn()) continue;
            if (this.ssbAutoIncCol == null) {
                this.ssbAutoIncCol = new SSBAutoIncrementColumnOracle(this.storageDesign);
            }
            this.ssbAutoIncCol.appendAutoIncrementSequenceAndTrigger(oldbuffer, column, prettyPrint);
        }
    }

    private void appendTriggers(StringBuffer oldbuffer, boolean prettyPrint) {
        int triggersIndex = this.tableObj.getChildIndex(ModelIdObjectSelection.TRIGGERS);
        if (triggersIndex > -1) {
            Iterator trgIt = this.tableObj.getChildObjects(triggersIndex).iterator();
            while (trgIt.hasNext()) {
                if (this.cssbTriggerOracle == null) {
                    this.cssbTriggerOracle = new CSSBTriggerOracle();
                }
                CompareObjectSelection chobj = (CompareObjectSelection)trgIt.next();
                this.cssbTriggerOracle.forceAppendTrigger(oldbuffer, chobj, prettyPrint);
            }
        }
    }

    protected CSSBIndexOraclev10g getCSSBIndex() {
        if (this.cssbIndex == null) {
            this.cssbIndex = new CSSBIndexOraclev10g();
            this.cssbIndex.setStorageDesign((StorageDesignOraclev10g)this.storageDesign);
        }
        return this.cssbIndex;
    }

    static class PossitionComparator
    implements Comparator {
        PossitionComparator() {
        }

        public int compare(Object one, Object two) {
            if (((PartitionOraclev10g)one).getPosition() > ((PartitionOraclev10g)two).getPosition()) {
                return 1;
            }
            if (((PartitionOraclev10g)one).getPosition() < ((PartitionOraclev10g)two).getPosition()) {
                return -1;
            }
            return 0;
        }
    }

    static class GlobalPossitionComparator
    implements Comparator {
        GlobalPossitionComparator() {
        }

        public int compare(Object one, Object two) {
            if (((IndexGlobalPartitionOraclev10g)one).getPosition() > ((IndexGlobalPartitionOraclev10g)two).getPosition()) {
                return 1;
            }
            if (((IndexGlobalPartitionOraclev10g)one).getPosition() < ((IndexGlobalPartitionOraclev10g)two).getPosition()) {
                return -1;
            }
            return 0;
        }
    }
}

