/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.engineering;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.model.xtdmapping.ExtendedMapBase;
import oracle.dbtools.crest.model.xtdmapping.XtdMapping;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;

public abstract class AbstractEngineering {
    public static boolean useSameOptionForAll = false;
    public static boolean keepExistingValues = true;
    private static Map stringMapF = new TreeMap();
    private static Map stringMapR = new TreeMap();
    protected Design design;
    protected ExtendedMapBase xmap;
    protected DesignPartView processedDPV;
    protected String targetDesPartID;
    protected Map comparatorsMap;

    public AbstractEngineering(Design design) {
        this.design = design;
        this.xmap = design.getExtendedMap();
    }

    public abstract void execute(Map var1);

    public DesignObject[] getProcessedObjects(DesignObjectSet set) {
        if (this.processedDPV == null || this.processedDPV == this.processedDPV.getDesignPart().getMainView()) {
            return (DesignObject[])set.toArray();
        }
        ArrayList<DesignObject> col = new ArrayList<DesignObject>();
        Iterator it = set.iterator();
        while (it.hasNext()) {
            DesignObject dobj = (DesignObject)it.next();
            if (!dobj.hasRepresentationInDPV(this.processedDPV)) continue;
            col.add(dobj);
        }
        return col.toArray(set.getProtoArray());
    }

    public void setGraphicalPropertiesOnNewObject(ContainerObject oldObject, ContainerObject newObject) {
        ApplicationView view = oldObject.getAppView();
        if (view != null) {
            view.setGraphicalPropsFor(newObject, view.getGraphicalPropsFor(oldObject));
        }
    }

    public String transformFromLogical(String logicalName) {
        StringBuffer buf = new StringBuffer();
        StringTokenizer stok = new StringTokenizer(this.tranformName(logicalName.trim()), "_", true);
        while (stok.hasMoreTokens()) {
            String tok = stok.nextToken().trim();
            if (stringMapF.containsKey(tok)) {
                buf.append(stringMapF.get(tok));
                continue;
            }
            buf.append(tok);
        }
        return buf.toString();
    }

    public String transformFromRelational(String relationalName) {
        StringBuffer buf = new StringBuffer();
        StringTokenizer stok = new StringTokenizer(this.tranformName(relationalName.trim()), "_", true);
        while (stok.hasMoreTokens()) {
            String tok = stok.nextToken().trim();
            if (stringMapR.containsKey(tok)) {
                buf.append(stringMapR.get(tok));
                continue;
            }
            buf.append(tok);
        }
        return buf.toString();
    }

    public static String transformFromLogicalDefault(String logicalName) {
        StringBuffer buf = new StringBuffer();
        StringTokenizer stok = new StringTokenizer(AbstractEngineering.tranformName(logicalName.trim().replaceAll(" ", "_"), true, true), "_", true);
        while (stok.hasMoreTokens()) {
            String tok = stok.nextToken().trim();
            if (stringMapF.containsKey(tok)) {
                buf.append(stringMapF.get(tok));
                continue;
            }
            buf.append(tok);
        }
        return buf.toString();
    }

    public static String transformFromLogicalDefault(String logicalName, boolean upperCase, char logSeparator, char relSeparator) {
        StringBuffer buf = new StringBuffer();
        StringTokenizer stok = logSeparator != '\u0000' && relSeparator != '\u0000' ? new StringTokenizer(AbstractEngineering.tranformName(logicalName.trim().replaceAll(String.valueOf(logSeparator), String.valueOf(relSeparator)), upperCase, true), "_", true) : new StringTokenizer(AbstractEngineering.tranformName(logicalName.trim().replaceAll(" ", "_"), upperCase, true), "_", true);
        while (stok.hasMoreTokens()) {
            String tok = stok.nextToken().trim();
            if (stringMapF.containsKey(tok)) {
                buf.append(stringMapF.get(tok));
                continue;
            }
            buf.append(tok);
        }
        return buf.toString();
    }

    public static String transformSeparatorFromLogical(String logicalName, char currSeparator, char newSeparator) {
        if (currSeparator != '\u0000' && newSeparator != '\u0000') {
            String name = logicalName.trim().replaceAll(String.valueOf(currSeparator), String.valueOf(newSeparator));
            if (newSeparator != ' ') {
                return name.trim().replaceAll(" ", "_");
            }
            return name;
        }
        return logicalName.trim().replaceAll(" ", "_");
    }

    public static String transformSeparatorFromRelational(String logicalName, char currSeparator, char newSeparator) {
        if (currSeparator != '\u0000' && newSeparator != '\u0000') {
            String name = logicalName.trim().replaceAll(String.valueOf(currSeparator), String.valueOf(newSeparator));
            if (newSeparator != '_') {
                return name.trim().replaceAll("_", " ");
            }
            return name;
        }
        return AbstractEngineering.tranformName(logicalName.trim().replaceAll("_", " "), false, true);
    }

    public static String transformFromRelationalDefault(String relationalName) {
        StringBuffer buf = new StringBuffer();
        StringTokenizer stok = new StringTokenizer(AbstractEngineering.tranformName(relationalName.trim(), false, false), "_", true);
        while (stok.hasMoreTokens()) {
            String tok = stok.nextToken().trim();
            if (stringMapR.containsKey(tok)) {
                buf.append(stringMapR.get(tok));
                continue;
            }
            buf.append(tok);
        }
        return buf.toString();
    }

    private String tranformName(String name) {
        if (this.design.isCapitalNames()) {
            name = name.toUpperCase();
        }
        if (this.design.isReplaceSpaces()) {
            name = name.trim().replaceAll(" ", "_");
        }
        return name;
    }

    private static String tranformName(String name, boolean capitalNames, boolean replaceSpace) {
        if (capitalNames) {
            name = name.toUpperCase();
        }
        if (replaceSpace) {
            name = name.trim().replaceAll(" ", "_");
        }
        return name;
    }

    public boolean isModified(XtdMapping mapping, DesignObject object) {
        return mapping.getOwnerObject().getChange().getTime() > mapping.getCreationTime();
    }

    public boolean isModified(XtdMapping mapping) {
        long delta = 2000L;
        DesignObject owner = mapping.getOwnerObject();
        DesignObject target = mapping.getTargetObject();
        return target != null && target.getChange().getTime() > mapping.getCreationTime() + delta || owner != null && owner.getChange().getTime() > mapping.getCreationTime() + delta;
    }

    public Map getComparatorsMap() {
        return this.comparatorsMap;
    }

    public Design getDesign() {
        return this.design;
    }

    static {
        stringMapF.put("ENTITY", "TABLE");
        stringMapF.put("ATTRIBUTE", "COLUMN");
        stringMapF.put("KEY", "INDEX");
        stringMapF.put("Entity", "Table");
        stringMapF.put("Attribute", "Column");
        stringMapF.put("Key", "Index");
        stringMapF.put("entity", "table");
        stringMapF.put("attribute", "column");
        stringMapF.put("key", "index");
        stringMapR.put("TABLE", "ENTITY");
        stringMapR.put("COLUMN", "ATTRIBUTE");
        stringMapR.put("INDEX", "KEY");
        stringMapR.put("Table", "Entity");
        stringMapR.put("Column", "Attribute");
        stringMapR.put("Index", "Key");
        stringMapR.put("table", "entity");
        stringMapR.put("column", "column");
        stringMapR.put("index", "key");
    }
}

