/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.multidimensional;

import java.awt.Dialog;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.multidimensional.AbstractMDObject;
import oracle.dbtools.crest.model.design.multidimensional.Cube;
import oracle.dbtools.crest.model.design.multidimensional.Dimension;
import oracle.dbtools.crest.model.design.multidimensional.Hierarchy;
import oracle.dbtools.crest.model.design.multidimensional.Level;
import oracle.dbtools.crest.model.design.multidimensional.MultidimensionalDesign;
import oracle.dbtools.crest.model.metadata.ID_ObjectPropertyTranslator;
import oracle.dbtools.crest.swingui.editor.multidimensional.MeasurePropertiesDialogEx;

public class Measure
extends AbstractMDObject {
    private boolean isFormula;
    private List attributes = new ArrayList();
    private String formula = "";
    private AggregateFunction aggregationFunction;
    private String aggregationFunctionID = "";
    private Cube cube;
    public static String FULLY_ADDITIVE = "Fully-Additive";
    public static String SEMI_ADDITIVE = "Semi-Additive";
    public static String NON_ADDITIVE = "Non-Additive";
    public static String AW_BASE_FORMULA = "Base Formila";
    public static String AW_OLAP_FORMULA = "OLAP Formula";
    public static String MS_COMPUTED_FORMULA = "MS Computed";
    public static String AW_NONE = "NO";
    public static String TD_OP_AVERAGE = "AVERAGE";
    public static String TD_OP_LARGEST = "LARGEST";
    public static String TD_OP_SMALLEST = "SMALLEST";
    public static String TD_OP_TOTAL = "TOTAL";
    public static String[] ADDITIVITY_TYPES = new String[]{FULLY_ADDITIVE, SEMI_ADDITIVE, NON_ADDITIVE};
    public static String[] AW_FORMULA_TYPES = new String[]{AW_NONE, AW_BASE_FORMULA, AW_OLAP_FORMULA, MS_COMPUTED_FORMULA};
    public static String[] PERIOD_TO_DATE_OPERATIONS = new String[]{TD_OP_AVERAGE, TD_OP_LARGEST, TD_OP_SMALLEST, TD_OP_TOTAL};
    private String additivity = FULLY_ADDITIVE;
    private int aggrFuncID = 1;
    private List aggregateFunctions = new ArrayList();
    private ContainedObject measureFact;
    private boolean actAsFactDimension = false;
    private String oracleAWFormulaType = AW_NONE;
    private boolean customFormula;
    private Dimension oLAPDimension;
    private Hierarchy oLAPHierarchy;
    private static String rankDirectionCodeHL = "HL";
    private static String rankDirectionCodeLH = "LH";
    private String rankDirectionCode = rankDirectionCodeHL;
    public static String rankDirNameHL = "Highest To Lowest";
    public static String rankDirNameLH = "Lowest To Highest";
    public static String[] rankDirectionNames = new String[]{rankDirNameHL, rankDirNameLH};
    public static String CUMULATIVE_TOTAL_PARENT = "Cumulative Total Parent";
    public static String CUMULATIVE_TOTAL_TOTAL = "Cumulative Total Total";
    public static String LAG = "Lag";
    public static String LEAD = "Lead";
    public static String MOVINGAVERAGE = "MovingAverage";
    public static String MOVINGMAX = "MovingMax";
    public static String MOVINGMIN = "MovingMin";
    public static String MOVINGTOTAL = "MovingTotal";
    public static String PERIOD_TO_DATE = "Period To Date";
    public static String FUTURE_PERIOD = "Future Period";
    public static String PRIOR_PERIOD = "Prior Period";
    public static String PRIOR_PERIOD_VARIANCE = "Prior Period Variance";
    public static String PRIOR_PERIOD_VARIANCE_PERCENTAGE = "Prior Period Variance Percent";
    public static String RANK_LEVEL = "Rank Level";
    public static String RANK_PARENT = "Rank Parent";
    public static String RANK_TOTAL = "Rank Total";
    public static String SAME_PERIOD_ANCESTORS_AGO = "Same Period Ancestors Ago";
    public static String SAME_PERIOD_ANCESTORS_AGO_VARIANCE = "Same Period Ancestors Ago Variance";
    public static String SAME_PERIOD_ANCESTORS_AGO_VARIANCE_PERCENT = "Same Period Ancestors Ago Variance Percent";
    public static String SAME_PERIOD_ANCESTORS_AGO_FVD = "Same Period Ancestors Ago FVD";
    public static String SHARE_TO_LEVEL = "Share to Level";
    public static String SHARE_TO_PARENT = "Share to Parent";
    public static String SHARE_TO_TOTAL = "Share to Total";
    public static String YEAR_TO_DATE = "Year To Date";
    public static String[] OLAP_OPERATORS = new String[]{CUMULATIVE_TOTAL_PARENT, CUMULATIVE_TOTAL_TOTAL, LAG, LEAD, MOVINGAVERAGE, MOVINGMAX, MOVINGMIN, MOVINGTOTAL, PERIOD_TO_DATE, FUTURE_PERIOD, PRIOR_PERIOD, PRIOR_PERIOD_VARIANCE, PRIOR_PERIOD_VARIANCE_PERCENTAGE, RANK_LEVEL, RANK_PARENT, RANK_TOTAL, SAME_PERIOD_ANCESTORS_AGO, SAME_PERIOD_ANCESTORS_AGO_VARIANCE, SAME_PERIOD_ANCESTORS_AGO_VARIANCE_PERCENT, SAME_PERIOD_ANCESTORS_AGO_FVD, SHARE_TO_LEVEL, SHARE_TO_PARENT, SHARE_TO_TOTAL, YEAR_TO_DATE};
    private String oLAPOperator = LAG;
    private Level oLAPLevel;
    private int oLAPOffset;
    private int oLAPStart = 0;
    private int oLAPStop = 1;
    private int oLAPStep = 1;
    private String oLAPPeriodToDateOperation = TD_OP_AVERAGE;
    private Measure usedOLAPMeasure;
    private String usedOLAPMeasureID;
    private String olapHierarchyID;
    private String whereClause = "";
    public static final String TYPE_NAME = "Measure";

    public Measure(DesignPart designPart) {
        super(designPart);
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public boolean isDesignLevelAccessibleObject() {
        return true;
    }

    @Override
    public String getIDPrefix() {
        return TYPE_NAME;
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            MeasurePropertiesDialogEx dialog = new MeasurePropertiesDialogEx(this.getDesign().getAppView(), this);
            dialog.initProperties(this);
            dialog.show();
        }
    }

    @Override
    public void showPropertyDialog(Dialog owner) {
        if (!this.isDialogVisible()) {
            MeasurePropertiesDialogEx dialog = owner == null ? new MeasurePropertiesDialogEx(this.getDesign().getAppView(), this) : new MeasurePropertiesDialogEx(owner, this.getDesign().getAppView(), this);
            dialog.initProperties(this);
            dialog.show();
        }
    }

    public String getFormula() {
        return this.formula;
    }

    public void setFormula(String formula) {
        this.formula = formula;
    }

    public boolean isFormula() {
        return this.isFormula;
    }

    public void setFormula(boolean isFormula) {
        this.isFormula = isFormula;
    }

    public boolean isNonAdditive() {
        return this.additivity.equalsIgnoreCase(NON_ADDITIVE);
    }

    public boolean isAdditive() {
        return this.additivity.equalsIgnoreCase(FULLY_ADDITIVE);
    }

    public boolean isSemiAdditive() {
        return this.additivity.equalsIgnoreCase(SEMI_ADDITIVE);
    }

    public boolean isFactDimension() {
        return this.additivity.equalsIgnoreCase(NON_ADDITIVE) && this.actAsFactDimension;
    }

    public List getAttributes() {
        return this.attributes;
    }

    public void addAttribute(ContainedObject attribute) {
        this.attributes.add(attribute);
    }

    public void removeAttribute(ContainedObject attribute) {
        this.attributes.remove(attribute);
    }

    public AggregateFunction getDefaultAggregationFunction() {
        if (this.aggregationFunction == null && !"".equals(this.aggregationFunctionID)) {
            this.aggregationFunction = this.getAggregateFunctionById(this.aggregationFunctionID);
        }
        if (this.aggregationFunction == null) {
            this.aggregationFunction = new AggregateFunction();
        }
        if (FULLY_ADDITIVE.equalsIgnoreCase(this.getAdditivity()) || SEMI_ADDITIVE.equalsIgnoreCase(this.getAdditivity())) {
            if (!"".equalsIgnoreCase(this.aggregationFunction.name) || this.aggregateFunctions.size() == 0) {
                return this.aggregationFunction;
            }
            return (AggregateFunction)this.aggregateFunctions.get(0);
        }
        return this.aggregationFunction;
    }

    public void setDefaultAggregationFunction(AggregateFunction aggregationFunction) {
        this.aggregationFunction = aggregationFunction;
    }

    public Cube getCube() {
        return this.cube;
    }

    public void setCube(Cube cube) {
        this.cube = cube;
    }

    public String getAdditivity() {
        return this.additivity;
    }

    public void setAdditivity(String additivity) {
        this.additivity = additivity;
    }

    public List getAggregateFunctions() {
        return this.aggregateFunctions;
    }

    public void addAggregateFunction(AggregateFunction af) {
        this.aggregateFunctions.add(af);
        String id = af.getObjectID();
        int idint = Integer.valueOf(id);
        if (idint > this.aggrFuncID) {
            this.aggrFuncID = idint;
        }
    }

    public AggregateFunction addAggregateFunction(String name, String id) {
        AggregateFunction ca = this.createAggregateFunction(name, id);
        this.aggregateFunctions.add(ca);
        return ca;
    }

    public AggregateFunction createAggregateFunction() {
        String name = "SUM";
        if (this.isDefinedAsOracleAWCalculated()) {
            name = "OLAP";
        }
        return this.createAggregateFunction(name);
    }

    public AggregateFunction createAggregateFunction(String name) {
        AggregateFunction ca = new AggregateFunction();
        ca.measure = this;
        ca.name = name;
        ca.measureAlias = this.getName();
        String caid = Integer.toString(this.aggrFuncID);
        ++this.aggrFuncID;
        ca.setObjectID(caid);
        return ca;
    }

    public AggregateFunction createAggregateFunction(String name, String id) {
        int idint = Integer.valueOf(id);
        if (idint > this.aggrFuncID) {
            this.aggrFuncID = idint;
        }
        AggregateFunction ca = this.createAggregateFunction(name);
        ca.setObjectID(id);
        return ca;
    }

    public AggregateFunction getAggregateFunctionById(String id) {
        for (AggregateFunction dobj : this.aggregateFunctions) {
            if (!dobj.getObjectID().equalsIgnoreCase(id)) continue;
            return dobj;
        }
        return null;
    }

    public ContainedObject getMeasureFact() {
        return this.measureFact;
    }

    public void setMeasureFact(ContainedObject measureFact) {
        this.measureFact = measureFact;
    }

    public List getCandidateFactsAndNull() {
        ArrayList<ContainedObject> list = new ArrayList<ContainedObject>();
        list.add(null);
        if (this.getCube() != null && this.getCube().getFactEntities().size() > 0) {
            for (ContainerObject ent : this.getCube().getFactEntities()) {
                for (ContainedObject attr : ent.getElementsCollection()) {
                    if (attr.isFKElement()) continue;
                    list.add(attr);
                }
            }
        }
        return list;
    }

    private ModelIDObject getCorrespondentObject(ModelIDObject obj) {
        return obj;
    }

    public String getMeasureExpression(Measure measure) {
        String quoteStr = "";
        boolean usePrefix = false;
        String factPref = "";
        Cube cube = measure.getCube();
        String func = measure.getFormula();
        if (!measure.isFormula()) {
            if (measure.getMeasureFact() != null) {
                ContainedObject attr = measure.getMeasureFact();
                ModelIDObject con = this.getCorrespondentObject(attr);
                if (usePrefix) {
                    return factPref + "." + quoteStr + con.getName() + quoteStr;
                }
                return quoteStr + con.getName() + quoteStr;
            }
            return "";
        }
        if (cube.getFactEntities().size() > 0) {
            String temp;
            ModelIDObject con;
            for (ContainerObject entity : cube.getFactEntities()) {
                Collection list = entity.getElementsCollection();
                for (DesignObject obj : list) {
                    if (obj == measure) continue;
                    String obname = "\"" + obj.getLongName().trim() + "\"";
                    if (func.indexOf(obname) > -1) {
                        con = this.getCorrespondentObject(obj);
                        temp = usePrefix ? factPref + "." + quoteStr + con.getName().trim() + quoteStr : (cube.getFactEntities().size() > 1 ? quoteStr + entity.getName().trim() + quoteStr + "." + quoteStr + con.getName().trim() + quoteStr : quoteStr + con.getName().trim() + quoteStr);
                        func = this.replace(func, obname, temp);
                        continue;
                    }
                    obname = "\"" + obj.getName().trim() + "\"";
                    if (func.indexOf(obname) <= -1) continue;
                    con = this.getCorrespondentObject(obj);
                    temp = usePrefix ? factPref + "." + quoteStr + con.getName().trim() + quoteStr : (cube.getFactEntities().size() > 1 ? quoteStr + entity.getName().trim() + quoteStr + "." + quoteStr + con.getName().trim() + quoteStr : quoteStr + con.getName().trim() + quoteStr);
                    func = this.replace(func, obname, temp);
                }
            }
            for (Measure obj : cube.getMeasures()) {
                String obname;
                if (obj == measure || func.indexOf(obname = "\"" + obj.getName().trim() + "\"") <= -1) continue;
                if (!obj.isFormula()) {
                    if (obj.getMeasureFact() == null) continue;
                    ContainedObject attr = obj.getMeasureFact();
                    ContainerObject ent = attr.getContainer();
                    con = this.getCorrespondentObject(attr);
                    temp = usePrefix ? factPref + "." + quoteStr + con.getName().trim() + quoteStr : (cube.getFactEntities().size() > 1 ? quoteStr + ent.getName().trim() + quoteStr + "." + quoteStr + con.getName().trim() + quoteStr : quoteStr + con.getName().trim() + quoteStr);
                    func = this.replace(func, obname, temp);
                    continue;
                }
                String mexpression = "(" + this.getMeasureExpression(obj) + ")";
                func = this.replace(func, obname, mexpression);
            }
        }
        return func;
    }

    private String replace(String origin, String str1, String str2) {
        String temp = str1.trim();
        Object result = origin;
        int ind = ((String)result).indexOf(temp);
        int lstr1 = temp.length();
        while (ind > -1) {
            String tresult = ind == 0 ? "" : ((String)result).substring(0, ind);
            int k = tresult.length() + str2.length();
            result = tresult + str2 + ((String)result).substring(ind + lstr1);
            ind = ((String)result).indexOf(temp, k);
        }
        return result;
    }

    public ContainerObject getFactEntity() {
        Cube cube = this.getCube();
        if (cube.getFactEntities().size() == 1) {
            ContainerObject ent = (ContainerObject)cube.getFactEntities().get(0);
            return ent;
        }
        if (!this.isFormula) {
            ContainerObject ent;
            ContainedObject attr;
            if (this.getMeasureFact() != null && (attr = this.getMeasureFact()).getContainer() != null && (ent = (ContainerObject)this.getDesign().getDesignObject(attr.getContainer().getObjectID())) != null && (attr = ent.getElementByName(attr.getName())) != null) {
                this.measureFact = attr;
                return ent;
            }
        } else {
            List list = this.getFactEntities();
            if (list.size() > 0) {
                return (ContainerObject)list.get(0);
            }
        }
        return null;
    }

    public List getFactEntities() {
        ArrayList list = new ArrayList();
        this.fillFactEntities(this, list);
        return list;
    }

    private void fillFactEntities(Measure measure, List entities) {
        Cube cube = measure.getCube();
        if (cube.getFactEntities().size() == 1) {
            ContainerObject ent = (ContainerObject)cube.getFactEntities().get(0);
            if (!entities.contains(ent)) {
                entities.add(ent);
            }
            return;
        }
        String func = measure.getFormula();
        if (!measure.isFormula()) {
            ContainerObject ent;
            if (measure.getMeasureFact() != null && !entities.contains(ent = measure.getMeasureFact().getContainer())) {
                entities.add(ent);
            }
            return;
        }
        if (cube.getFactEntities().size() > 0 && entities.size() < cube.getFactEntities().size()) {
            for (ContainerObject entity : cube.getFactEntities()) {
                Collection list = entity.getElementsCollection();
                for (ContainedObject obj : list) {
                    ContainerObject ent;
                    String obname = "\"" + obj.getLongName().trim() + "\"";
                    if (func.indexOf(obname) > -1) {
                        ent = obj.getContainer();
                        if (entities.contains(ent)) continue;
                        entities.add(ent);
                        continue;
                    }
                    obname = "\"" + obj.getName().trim() + "\"";
                    if (func.indexOf(obname) <= -1 || entities.contains(ent = obj.getContainer())) continue;
                    entities.add(ent);
                }
            }
            for (Measure obj : cube.getMeasures()) {
                String obname;
                if (obj == measure || func.indexOf(obname = "\"" + obj.getName().trim() + "\"") <= -1) continue;
                if (!obj.isFormula()) {
                    ContainedObject attr;
                    ContainerObject ent;
                    if (obj.getMeasureFact() == null || entities.contains(ent = (attr = obj.getMeasureFact()).getContainer())) continue;
                    entities.add(ent);
                    continue;
                }
                this.fillFactEntities(obj, entities);
            }
        }
    }

    public String getOracleAWFormulaType() {
        return this.oracleAWFormulaType;
    }

    public void setOracleAWFormulaType(String oracleAWFormulaType) {
        this.oracleAWFormulaType = oracleAWFormulaType;
    }

    public boolean isActAsFactDimension() {
        return this.actAsFactDimension;
    }

    public void setActAsFactDimension(boolean actAsFactDimension) {
        this.actAsFactDimension = actAsFactDimension;
    }

    public boolean isCustomFormula() {
        return this.customFormula;
    }

    public void setCustomFormula(boolean customFormula) {
        this.customFormula = customFormula;
    }

    public Dimension getOLAPDimension() {
        return this.oLAPDimension;
    }

    public void setOLAPDimension(Dimension dimension) {
        this.oLAPDimension = dimension;
    }

    public Hierarchy getOLAPHierarchy() {
        if (this.oLAPHierarchy == null && this.olapHierarchyID != null) {
            this.oLAPHierarchy = (Hierarchy)((MultidimensionalDesign)this.getDesignPart()).getHierarchySet().getObjectByID(this.olapHierarchyID);
        }
        return this.oLAPHierarchy;
    }

    public void setOLAPHierarchy(Hierarchy hierarchy) {
        this.oLAPHierarchy = hierarchy;
    }

    public Level getOLAPLevel() {
        return this.oLAPLevel;
    }

    public void setOLAPLevel(Level level) {
        this.oLAPLevel = level;
    }

    public int getOLAPOffset() {
        return this.oLAPOffset;
    }

    public void setOLAPOffset(int offset) {
        this.oLAPOffset = offset;
    }

    public String getOLAPPeriodToDateOperation() {
        return this.oLAPPeriodToDateOperation;
    }

    public void setOLAPPeriodToDateOperation(String periodToDateOperation) {
        this.oLAPPeriodToDateOperation = periodToDateOperation;
    }

    public int getOLAPStart() {
        return this.oLAPStart;
    }

    public void setOLAPStart(int start) {
        this.oLAPStart = start;
    }

    public int getOLAPStep() {
        return this.oLAPStep;
    }

    public void setOLAPStep(int step) {
        this.oLAPStep = step;
    }

    public int getOLAPStop() {
        return this.oLAPStop;
    }

    public void setOLAPStop(int stop) {
        this.oLAPStop = stop;
    }

    public String getRankDirectionCode() {
        return this.rankDirectionCode;
    }

    public void setRankDirectionCode(String rankDirectionCode) {
        this.rankDirectionCode = rankDirectionCode;
    }

    public String getRankDirectionName() {
        if (this.rankDirectionCode.equalsIgnoreCase(rankDirectionCodeLH)) {
            return rankDirNameLH;
        }
        return rankDirNameHL;
    }

    public void setRankDirectionName(String rankDirectionName) {
        if (rankDirNameLH.equalsIgnoreCase(rankDirectionName)) {
            this.rankDirectionCode = rankDirectionCodeLH;
        }
        this.rankDirectionCode = rankDirectionCodeHL;
    }

    public String getOLAPOperator() {
        return this.oLAPOperator;
    }

    public void setOLAPOperator(String operator) {
        this.oLAPOperator = operator;
    }

    public Measure getUsedOLAPMeasure() {
        if (this.usedOLAPMeasure == null && this.usedOLAPMeasureID != null) {
            this.usedOLAPMeasure = (Measure)((MultidimensionalDesign)this.getDesignPart()).getMeasureSet().getObjectByID(this.usedOLAPMeasureID);
        }
        return this.usedOLAPMeasure;
    }

    public void setUsedOLAPMeasure(Measure usedOLAPMeasure) {
        this.usedOLAPMeasure = usedOLAPMeasure;
    }

    public void setUsedOLAPMeasureID(String usedOLAPMeasureID) {
        this.usedOLAPMeasureID = usedOLAPMeasureID;
    }

    public void setOlapHierarchyID(String olapHierarchyID) {
        this.olapHierarchyID = olapHierarchyID;
    }

    public boolean isDefinedAsOracleAWCalculated() {
        return !AW_NONE.equalsIgnoreCase(this.oracleAWFormulaType);
    }

    public String getWhereClause() {
        return this.whereClause;
    }

    public void setWhereClause(String whereClause) {
        this.whereClause = whereClause;
    }

    @Override
    public String toString() {
        if (this.cube == null) {
            return this.getName();
        }
        return this.getCube().getName() + "." + this.getName();
    }

    @Override
    public String getStorageName() {
        try {
            return new File(this.getDesignPart().getStoragePath(), "measure" + File.separatorChar + this.getObjectID() + ".xml").getCanonicalPath();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public String getAggregationFunctionID() {
        if (this.aggregationFunction != null) {
            return this.aggregationFunction.getObjectID();
        }
        return this.aggregationFunctionID;
    }

    public void setAggregationFunctionID(String aggregationFunctionID) {
        this.aggregationFunctionID = aggregationFunctionID;
    }

    public List getFunctionsSumLevelAsStrings() {
        ArrayList<String> list = new ArrayList<String>();
        for (AggregateFunction af : this.getAggregateFunctions()) {
            Object s = af.getName();
            if (af.getLevels().size() > 0) {
                s = (String)s + "/";
                boolean first = true;
                for (DesignObject ob : af.getLevels()) {
                    if (first) {
                        s = (String)s + ob.getName();
                        first = false;
                        continue;
                    }
                    s = (String)s + "," + ob.getName();
                }
            }
            list.add((String)s);
        }
        return list;
    }

    public List getFunctionsAggregateDimensionsAsStrings() {
        ArrayList<String> list = new ArrayList<String>();
        for (AggregateFunction af : this.getAggregateFunctions()) {
            Object s = af.getName();
            if (af.getDimensions().size() > 0) {
                s = (String)s + "/";
                boolean first = true;
                for (DesignObject ob : af.getDimensions()) {
                    if (first) {
                        s = (String)s + ob.getName();
                        first = false;
                        continue;
                    }
                    s = (String)s + "," + ob.getName();
                }
            }
            list.add((String)s);
        }
        return list;
    }

    @Override
    public void copy(DesignObject desObject) {
        Measure measure = (Measure)desObject;
        measure.setFormula(this.isFormula);
        measure.setCustomFormula(this.isCustomFormula());
        measure.setFormula(this.getFormula());
        measure.setOracleAWFormulaType(this.getOracleAWFormulaType());
        measure.setMeasureFact(this.getMeasureFact());
        measure.setAdditivity(this.getAdditivity());
        measure.setActAsFactDimension(this.isActAsFactDimension());
        measure.setDefaultAggregationFunction(this.getDefaultAggregationFunction());
        measure.setWhereClause(this.getWhereClause());
        measure.getAggregateFunctions().addAll(this.getAggregateFunctions());
        measure.setOLAPOperator(this.getOLAPOperator());
        measure.setUsedOLAPMeasure(this.getUsedOLAPMeasure());
        measure.setOLAPDimension(this.getOLAPDimension());
        measure.setOLAPHierarchy(this.getOLAPHierarchy());
        measure.setOLAPLevel(this.getOLAPLevel());
        measure.setOLAPOffset(this.getOLAPOffset());
        measure.setOLAPStart(this.getOLAPStart());
        measure.setOLAPStop(this.getOLAPStop());
        measure.setOLAPStep(this.getOLAPStep());
        measure.setOLAPPeriodToDateOperation(this.getOLAPPeriodToDateOperation());
        measure.setRankDirectionCode(this.getRankDirectionCode());
        measure.setRankDirectionName(this.getRankDirectionName());
        measure.setOracleShortName(this.getOracleShortName());
        measure.setOracleLongName(this.getOracleLongName());
        measure.setOraclePluralName(this.getOraclePluralName());
    }

    public class AggregateFunction
    implements ID_ObjectPropertyTranslator {
        public String name = "";
        public String measureAlias = "";
        public List dimensions = new ArrayList();
        public List levels = new ArrayList();
        String objectId;
        Measure measure;

        public String toString() {
            return this.name;
        }

        public String getObjectID() {
            if (this.objectId == null) {
                this.objectId = Integer.toString(Measure.this.aggrFuncID);
                ++Measure.this.aggrFuncID;
            }
            return this.objectId;
        }

        public void setObjectID(String objectId) {
            this.objectId = objectId;
        }

        public boolean isDefinedOnDimension(Dimension dim) {
            return this.dimensions.contains(dim);
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getMeasureAlias() {
            return this.measureAlias;
        }

        public void setMeasureAlias(String measureAlias) {
            this.measureAlias = measureAlias;
        }

        public List getDimensions() {
            return this.dimensions;
        }

        public List getLevels() {
            return this.levels;
        }

        @Override
        public Object translateIdToObject(String propertyName, String id) {
            return this.measure.translateIdToObject(propertyName, id);
        }

        @Override
        public String translateObjectToID(String propertyName, Object object) {
            return this.measure.translateObjectToID(propertyName, object);
        }
    }
}

